/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.core.utils.SortedProperties;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.Filterable;
import pcgen.gui.utils.Utility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class SettingsHandler {
    private static boolean abilitiesShownAsTab = false;
    private static boolean autoFeatsRefundable = false;
    private static boolean useFeatBenefits = true;
    private static boolean autogenExoticMaterial = false;
    private static boolean autogenMagic = false;
    private static boolean autogenMasterwork = false;
    private static boolean autogenRacial = false;
    private static boolean validateBonuses = false;
    private static int maxPotionSpellLevel = 3;
    private static int maxWandSpellLevel = 4;
    private static boolean allowMetamagicInCustomizer = false;
    private static boolean spellMarketPriceAdjusted = false;
    private static Map<String, String> ruleCheckMap = new HashMap<String, String>();
    private static String browserPath = null;
    private static int chaTabPlacement = 1;
    private static Dimension customizerDimension = null;
    private static Point customizerLeftUpperCorner = null;
    private static int customizerSplit1 = -1;
    private static int customizerSplit2 = -1;
    private static String dmNotes = "";
    private static boolean enforceSpendingBeforeLevelUp = false;
    private static int featAutoColor = 0xB2B200;
    private static int featVirtualColor = 0xFF00FF;
    private static final Properties filterSettings = new Properties();
    private static GameMode game = new GameMode("default");
    private static boolean grimHPMode = false;
    private static boolean grittyACMode = false;
    private static Dimension kitSelectorDimension = null;
    private static Point kitSelectorLeftUpperCorner = null;
    private static boolean useWaitCursor = true;
    private static boolean showD20InfoAtStart = true;
    private static boolean loadURLs = false;
    private static boolean showOGLOnLoad = true;
    private static boolean showMatureOnLoad = true;
    private static boolean showSponsorsOnLoad = true;
    private static boolean hpMaxAtFirstLevel = true;
    private static boolean hpMaxAtFirstClassLevel = true;
    private static int hpRollMethod = 0;
    private static int hpPct = 100;
    private static boolean ignoreMonsterHDCap = false;
    private static boolean debugFeats = false;
    public static final int INCLUDE_SKILLS_NONE = 0;
    public static final int INCLUDE_SKILLS_UNTRAINED = 1;
    public static final int INCLUDE_SKILLS_ALL = 2;
    public static final int INCLUDE_SKILLS_SKILLS_TAB = 3;
    private static int includeSkills = 3;
    private static int skillsTab_IncludeSkills = 1;
    private static String invalidDmgText;
    private static String invalidToHitText;
    private static boolean gearTab_IgnoreCost;
    private static boolean gearTab_AutoResize;
    private static boolean gearTab_AllowDebt;
    private static int gearTab_SellRate;
    private static int gearTab_BuyRate;
    private static boolean isROG;
    private static Point leftUpperCorner;
    private static int windowState;
    private static boolean loadCampaignsAtStart;
    private static boolean loadCampaignsWithPC;
    private static int looknFeel;
    private static boolean expertGUI;
    private static boolean optionAllowedInSources;
    private static final SortedProperties options;
    private static final Properties filepaths;
    private static final String fileLocation;
    private static File pcgenFilesDir;
    private static File pccFilesLocation;
    private static File pcgPath;
    private static File lastUsedPcgPath;
    private static File backupPcgPath;
    private static boolean createPcgBackup;
    private static File portraitsPath;
    private static File pcgenCustomDir;
    private static File pcgenVendorDataDir;
    private static File pcgenSponsorDir;
    private static File pcgenDocsDir;
    private static File pcgenSystemDir;
    private static File pcgenThemePackDir;
    private static File pcgenOutputSheetDir;
    private static File gmgenPluginDir;
    private static int prereqQualifyColor;
    private static int prereqFailColor;
    private static boolean previewTabShown;
    private static File pcgenPreviewDir;
    private static boolean ranStartingWizard;
    private static boolean saveCustomInLst;
    private static String selectedCharacterHTMLOutputSheet;
    private static String selectedCharacterPDFOutputSheet;
    private static boolean saveOutputSheetWithPC;
    private static boolean printSpellsWithPC;
    private static String selectedPartyHTMLOutputSheet;
    private static String selectedPartyPDFOutputSheet;
    private static String selectedEqSetTemplate;
    private static String selectedSpellSheet;
    private static boolean showFeatDialogAtLevelUp;
    private static boolean showHPDialogAtLevelUp;
    private static boolean showStatDialogAtLevelUp;
    private static boolean showToolBar;
    private static boolean showSkillModifier;
    private static boolean showSkillRanks;
    private static boolean showWarningAtFirstLevelUp;
    private static String skinLFThemePack;
    private static boolean summaryTabShown;
    private static int classTab_AvailableListMode;
    private static int classTab_SelectedListMode;
    private static int domainTab_ListMode;
    private static int equipTab_AvailableListMode;
    private static int equipTab_SelectedListMode;
    private static int featTab_AvailableListMode;
    private static int featTab_SelectedListMode;
    private static int gearTab_AvailableListMode;
    private static int gearTab_SelectedListMode;
    private static int raceTab_ListMode;
    private static int templateTab_ListMode;
    private static int templateSelTab_ListMode;
    private static int skillsTab_AvailableListMode;
    private static int skillsTab_SelectedListMode;
    private static int spellsTab_AvailableListMode;
    private static int spellsTab_SelectedListMode;
    private static boolean cleanupTempFiles;
    private static boolean alwaysOverwrite;
    private static boolean allowOverride;
    private static int tabPlacement;
    private static final String tmpPath;
    private static final File tempPath;
    private static boolean toolTipTextShown;
    private static boolean useHigherLevelSlotsDefault;
    private static boolean wantToLoadMasterworkAndMagic;
    private static int nameDisplayStyle;
    private static boolean weaponProfPrintout;
    private static String postExportCommandStandard;
    private static String postExportCommandPDF;
    private static boolean hideMonsterClasses;
    private static boolean guiUsesOutputNameEquipment;
    private static boolean guiUsesOutputNameSpells;
    private static int singleChoicePreference;
    private static int lastTipShown;
    private static boolean showMemoryArea;
    private static boolean showImagePreview;
    private static boolean showTipOfTheDay;
    private static boolean isGMGen;
    private static boolean showSingleBoxPerBundle;
    private static boolean useAdvancedSourceSelect;
    private static boolean showNatWeaponTab;
    private static String hiddenSources;
    private static String quickLaunchSources;
    private static boolean outputDeprecationMessages;
    private static boolean inputUnconstructedMessages;

    public static void setAbilitiesShownAsATab(boolean bl) {
        abilitiesShownAsTab = bl;
    }

    public static boolean isAbilitiesShownAsATab() {
        return abilitiesShownAsTab;
    }

    public static void setAllowOverride(boolean bl) {
        allowOverride = bl;
    }

    public static boolean isAllowOverride() {
        return allowOverride;
    }

    public static void setAlwaysOverwrite(boolean bl) {
        alwaysOverwrite = bl;
    }

    public static boolean getAlwaysOverwrite() {
        return alwaysOverwrite;
    }

    public static void setAutogen(int n, boolean bl) {
        switch (n) {
            case 1: {
                SettingsHandler.setAutogenRacial(bl);
                break;
            }
            case 2: {
                SettingsHandler.setAutogenMasterwork(bl);
                break;
            }
            case 3: {
                SettingsHandler.setAutogenMagic(bl);
                break;
            }
            case 4: {
                SettingsHandler.setAutogenExoticMaterial(bl);
                break;
            }
        }
    }

    public static boolean getAutogen(int n) {
        if (!SettingsHandler.wantToLoadMasterworkAndMagic()) {
            switch (n) {
                case 1: {
                    return SettingsHandler.isAutogenRacial();
                }
                case 2: {
                    return SettingsHandler.isAutogenMasterwork();
                }
                case 3: {
                    return SettingsHandler.isAutogenMagic();
                }
                case 4: {
                    return SettingsHandler.isAutogenExoticMaterial();
                }
            }
        }
        return false;
    }

    public static void setBackupPcgPath(File file) {
        backupPcgPath = file;
    }

    public static File getBackupPcgPath() {
        return backupPcgPath;
    }

    public static void setBrowserPath(String string) {
        browserPath = string;
    }

    public static String getBrowserPath() {
        return browserPath;
    }

    public static void setChaTabPlacement(int n) {
        chaTabPlacement = n;
    }

    public static int getChaTabPlacement() {
        return chaTabPlacement;
    }

    public static void setClassTab_AvailableListMode(int n) {
        classTab_AvailableListMode = n;
    }

    public static int getClassTab_AvailableListMode() {
        return classTab_AvailableListMode;
    }

    public static void setClassTab_SelectedListMode(int n) {
        classTab_SelectedListMode = n;
    }

    public static int getClassTab_SelectedListMode() {
        return classTab_SelectedListMode;
    }

    public static void setCleanupTempFiles(boolean bl) {
        cleanupTempFiles = bl;
    }

    public static boolean getCleanupTempFiles() {
        return cleanupTempFiles;
    }

    public static void setCreatePcgBackup(boolean bl) {
        createPcgBackup = bl;
    }

    public static boolean getCreatePcgBackup() {
        return createPcgBackup;
    }

    public static void setCustomizerDimension(Dimension dimension) {
        customizerDimension = dimension;
    }

    public static Dimension getCustomizerDimension() {
        return customizerDimension;
    }

    public static void setCustomizerLeftUpperCorner(Point point) {
        customizerLeftUpperCorner = point;
    }

    public static Point getCustomizerLeftUpperCorner() {
        return customizerLeftUpperCorner;
    }

    public static void setCustomizerSplit1(int n) {
        customizerSplit1 = n;
    }

    public static int getCustomizerSplit1() {
        return customizerSplit1;
    }

    public static void setCustomizerSplit2(int n) {
        customizerSplit2 = n;
    }

    public static int getCustomizerSplit2() {
        return customizerSplit2;
    }

    public static void setDmNotes(String string) {
        dmNotes = string;
    }

    public static String getDmNotes() {
        return dmNotes;
    }

    public static void setDomainTab_ListMode(int n) {
        domainTab_ListMode = n;
    }

    public static int getDomainTab_ListMode() {
        return domainTab_ListMode;
    }

    public static void setEnforceSpendingBeforeLevelUp(boolean bl) {
        enforceSpendingBeforeLevelUp = bl;
    }

    public static boolean getEnforceSpendingBeforeLevelUp() {
        return enforceSpendingBeforeLevelUp;
    }

    public static void setEquipTab_AvailableListMode(int n) {
        equipTab_AvailableListMode = n;
    }

    public static int getEquipTab_AvailableListMode() {
        return equipTab_AvailableListMode;
    }

    public static void setEquipTab_SelectedListMode(int n) {
        equipTab_SelectedListMode = n;
    }

    public static int getEquipTab_SelectedListMode() {
        return equipTab_SelectedListMode;
    }

    public static void setExpertGUI(boolean bl) {
        expertGUI = bl;
    }

    public static boolean isExpertGUI() {
        return expertGUI;
    }

    public static void setFeatAutoColor(int n) {
        featAutoColor = n & 0xFFFFFF;
    }

    public static int getFeatAutoColor() {
        return featAutoColor;
    }

    public static void setFeatTab_AvailableListMode(int n) {
        featTab_AvailableListMode = n;
    }

    public static int getFeatTab_AvailableListMode() {
        return featTab_AvailableListMode;
    }

    public static void setFeatTab_SelectedListMode(int n) {
        featTab_SelectedListMode = n;
    }

    public static int getFeatTab_SelectedListMode() {
        return featTab_SelectedListMode;
    }

    public static void setFeatVirtualColor(int n) {
        featVirtualColor = n & 0xFFFFFF;
    }

    public static int getFeatVirtualColor() {
        return featVirtualColor;
    }

    public static void setFilePaths(String string) {
        SettingsHandler.getFilepathProp().setProperty("pcgen.filepaths", string);
    }

    public static String getFilePaths() {
        String string = "user";
        if (Globals.isMacPlatform) {
            string = "mac_user";
        }
        return SettingsHandler.getFilepathProp().getProperty("pcgen.filepaths", string);
    }

    public static Properties getFilepathProp() {
        return filepaths;
    }

    public static boolean getFirstRun() {
        File file = new File(fileLocation);
        return !file.exists();
    }

    public static boolean isGMGen() {
        return isGMGen;
    }

    public static void setGMGenOption(String string, boolean bl) {
        SettingsHandler.setGMGenOption(string, bl ? "true" : "false");
    }

    public static void setGMGenOption(String string, int n) {
        SettingsHandler.setGMGenOption(string, String.valueOf(n));
    }

    public static void setGMGenOption(String string, double d) {
        SettingsHandler.setGMGenOption(string, String.valueOf(d));
    }

    public static void setGMGenOption(String string, String string2) {
        SettingsHandler.getOptions().setProperty("gmgen.options." + string, string2);
    }

    public static boolean getGMGenOption(String string, boolean bl) {
        String string2 = SettingsHandler.getGMGenOption(string, bl ? "true" : "false");
        return "true".equalsIgnoreCase(string2);
    }

    public static int getGMGenOption(String string, int n) {
        return Integer.decode(SettingsHandler.getGMGenOption(string, String.valueOf(n)));
    }

    public static Double getGMGenOption(String string, double d) {
        return new Double(SettingsHandler.getGMGenOption(string, Double.toString(d)));
    }

    public static String getGMGenOption(String string, String string2) {
        return SettingsHandler.getOptions().getProperty("gmgen.options." + string, string2);
    }

    public static void setGUIUsesOutputNameEquipment(boolean bl) {
        guiUsesOutputNameEquipment = bl;
    }

    public static void setGUIUsesOutputNameSpells(boolean bl) {
        guiUsesOutputNameSpells = bl;
    }

    public static void setGame(String string) {
        GameMode gameMode = SystemCollections.getGameModeNamed(string);
        if (gameMode != null) {
            game = gameMode;
        }
        String string2 = string;
        String string3 = SettingsHandler.getOptions().getProperty("pcgen.options.gameMode." + string2 + ".unitSetName", SettingsHandler.getOptions().getProperty("pcgen.options.unitSetName." + string2, game.getDefaultUnitSet()));
        if (!game.selectUnitSet(string3) && !game.selectDefaultUnitSet()) {
            game.selectUnitSet("Imperial");
        }
        game.setRollMethodExpressionByName(SettingsHandler.getPCGenOption("gameMode." + string2 + ".rollMethodExpression", ""));
        game.setPurchaseMethodName(SettingsHandler.getPCGenOption("gameMode." + string2 + ".purchaseMethodName", ""));
        game.setAllStatsValue(SettingsHandler.getPCGenOption("gameMode." + string2 + ".allStatsValue", 10));
        game.setRollMethod(SettingsHandler.getPCGenOption("gameMode." + string2 + ".rollMethod", 0));
        game.setXpTableName(SettingsHandler.getPCGenOption("gameMode." + string2 + ".xpTableName", ""));
        SettingsHandler.getChosenCampaignFiles(game);
    }

    public static GameMode getGame() {
        return game;
    }

    public static void setGearTab_AllowDebt(boolean bl) {
        gearTab_AllowDebt = bl;
    }

    public static boolean getGearTab_AllowDebt() {
        return gearTab_AllowDebt;
    }

    public static void setGearTab_AutoResize(boolean bl) {
        gearTab_AutoResize = bl;
    }

    public static boolean getGearTab_AutoResize() {
        return gearTab_AutoResize;
    }

    public static void setGearTab_AvailableListMode(int n) {
        gearTab_AvailableListMode = n;
    }

    public static int getGearTab_AvailableListMode() {
        return gearTab_AvailableListMode;
    }

    public static void setGearTab_BuyRate(int n) {
        gearTab_BuyRate = n;
    }

    public static int getGearTab_BuyRate() {
        return gearTab_BuyRate;
    }

    public static void setGearTab_IgnoreCost(boolean bl) {
        gearTab_IgnoreCost = bl;
    }

    public static boolean getGearTab_IgnoreCost() {
        return gearTab_IgnoreCost;
    }

    public static void setGearTab_SelectedListMode(int n) {
        gearTab_SelectedListMode = n;
    }

    public static int getGearTab_SelectedListMode() {
        return gearTab_SelectedListMode;
    }

    public static void setGearTab_SellRate(int n) {
        gearTab_SellRate = n;
    }

    public static int getGearTab_SellRate() {
        return gearTab_SellRate;
    }

    public static void setGmgenPluginDir(File file) {
        gmgenPluginDir = file;
    }

    public static File getGmgenPluginDir() {
        return gmgenPluginDir;
    }

    public static void setHPMaxAtFirstLevel(boolean bl) {
        hpMaxAtFirstLevel = bl;
    }

    public static boolean isHPMaxAtFirstLevel() {
        return hpMaxAtFirstLevel;
    }

    public static void setHPMaxAtFirstClassLevel(boolean bl) {
        hpMaxAtFirstClassLevel = bl;
    }

    public static boolean isHPMaxAtFirstClassLevel() {
        return hpMaxAtFirstClassLevel;
    }

    public static void setHPPct(int n) {
        hpPct = n;
    }

    public static int getHPPct() {
        return hpPct;
    }

    public static void setHPRollMethod(int n) {
        hpRollMethod = n;
    }

    public static int getHPRollMethod() {
        return hpRollMethod;
    }

    public static String getHTMLOutputSheetPath() {
        if ("".equals(selectedCharacterHTMLOutputSheet)) {
            return SettingsHandler.getPcgenOutputSheetDir().toString();
        }
        return new File(selectedCharacterHTMLOutputSheet).getParentFile().getAbsolutePath();
    }

    public static void setHideMonsterClasses(boolean bl) {
        hideMonsterClasses = bl;
    }

    public static void setIgnoreMonsterHDCap(boolean bl) {
        ignoreMonsterHDCap = bl;
    }

    public static boolean isIgnoreMonsterHDCap() {
        return ignoreMonsterHDCap;
    }

    public static void setIncludeSkills(int n) {
        includeSkills = n;
    }

    public static int getIncludeSkills() {
        return includeSkills;
    }

    public static final void setInvalidDmgText(String string) {
        invalidDmgText = string;
    }

    public static String getInvalidDmgText() {
        return invalidDmgText;
    }

    public static final void setInvalidToHitText(String string) {
        invalidToHitText = string;
    }

    public static String getInvalidToHitText() {
        return invalidToHitText;
    }

    public static void setIsGMGen(boolean bl) {
        isGMGen = bl;
    }

    public static void setKitSelectorDimension(Dimension dimension) {
        kitSelectorDimension = dimension;
    }

    public static Dimension getKitSelectorDimension() {
        return kitSelectorDimension;
    }

    public static void setKitSelectorLeftUpperCorner(Point point) {
        kitSelectorLeftUpperCorner = point;
    }

    public static Point getKitSelectorLeftUpperCorner() {
        return kitSelectorLeftUpperCorner;
    }

    public static void setLastTipShown(int n) {
        lastTipShown = n;
    }

    public static int getLastTipShown() {
        return lastTipShown;
    }

    public static void setLeftUpperCorner(Point point) {
        leftUpperCorner = point;
    }

    public static Point getLeftUpperCorner() {
        return leftUpperCorner;
    }

    public static void setLoadCampaignsAtStart(boolean bl) {
        loadCampaignsAtStart = bl;
    }

    public static boolean isLoadCampaignsAtStart() {
        return loadCampaignsAtStart;
    }

    public static void setLoadCampaignsWithPC(boolean bl) {
        loadCampaignsWithPC = bl;
    }

    public static boolean isLoadCampaignsWithPC() {
        return loadCampaignsWithPC;
    }

    public static void setLoadURLs(boolean bl) {
        loadURLs = bl;
    }

    public static boolean isLoadURLs() {
        return loadURLs;
    }

    public static void setLookAndFeel(int n) {
        looknFeel = n;
    }

    public static int getLookAndFeel() {
        return looknFeel;
    }

    public static void setMaxPotionSpellLevel(int n) {
        maxPotionSpellLevel = n;
    }

    public static int getMaxPotionSpellLevel() {
        return maxPotionSpellLevel;
    }

    public static void setMaxWandSpellLevel(int n) {
        maxWandSpellLevel = n;
    }

    public static int getMaxWandSpellLevel() {
        return maxWandSpellLevel;
    }

    public static void setMetamagicAllowedInEqBuilder(boolean bl) {
        allowMetamagicInCustomizer = bl;
    }

    public static boolean isMetamagicAllowedInEqBuilder() {
        return allowMetamagicInCustomizer;
    }

    public static void setNameDisplayStyle(int n) {
        nameDisplayStyle = n;
        PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getInst();
        if (pCGen_Frame1 != null) {
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
    }

    public static int getNameDisplayStyle() {
        return nameDisplayStyle;
    }

    public static void setOptionAllowedInSources(boolean bl) {
        optionAllowedInSources = bl;
    }

    public static boolean isOptionAllowedInSources() {
        return optionAllowedInSources;
    }

    public static SortedProperties getOptions() {
        return options;
    }

    public static Dimension getOptionsFromProperties(PlayerCharacter playerCharacter) {
        int n;
        int n2;
        Dimension dimension = new Dimension(0, 0);
        String string = SettingsHandler.getPCGenOption("browserPath", "");
        if (!"".equals(string)) {
            SettingsHandler.setBrowserPath(string);
        } else {
            SettingsHandler.setBrowserPath(null);
        }
        SettingsHandler.setLeftUpperCorner(new Point(SettingsHandler.getPCGenOption("windowLeftUpperCorner.X", -1.0).intValue(), SettingsHandler.getPCGenOption("windowLeftUpperCorner.Y", -1.0).intValue()));
        SettingsHandler.setWindowState(SettingsHandler.getPCGenOption("windowState", 0));
        Double d = SettingsHandler.getPCGenOption("windowWidth", 0.0);
        Double d2 = SettingsHandler.getPCGenOption("windowHeight", 0.0);
        if (!CoreUtility.doublesEqual(d, 0.0) && !CoreUtility.doublesEqual(d2, 0.0)) {
            n2 = Integer.parseInt(d.toString().substring(0, Math.min(d.toString().length(), d.toString().lastIndexOf("."))));
            n = Integer.parseInt(d2.toString().substring(0, Math.min(d2.toString().length(), d2.toString().lastIndexOf("."))));
            dimension = new Dimension(n2, n);
        }
        SettingsHandler.setCustomizerLeftUpperCorner(new Point(SettingsHandler.getPCGenOption("customizer.windowLeftUpperCorner.X", -1.0).intValue(), SettingsHandler.getPCGenOption("customizer.windowLeftUpperCorner.Y", -1.0).intValue()));
        d = SettingsHandler.getPCGenOption("customizer.windowWidth", 0.0);
        d2 = SettingsHandler.getPCGenOption("customizer.windowHeight", 0.0);
        if (!CoreUtility.doublesEqual(d, 0.0) && !CoreUtility.doublesEqual(d2, 0.0)) {
            SettingsHandler.setCustomizerDimension(new Dimension(d.intValue(), d2.intValue()));
        }
        SettingsHandler.setKitSelectorLeftUpperCorner(new Point(SettingsHandler.getPCGenOption("kitSelector.windowLeftUpperCorner.X", -1.0).intValue(), SettingsHandler.getPCGenOption("kitSelector.windowLeftUpperCorner.Y", -1.0).intValue()));
        d = SettingsHandler.getPCGenOption("kitSelector.windowWidth", 0.0);
        d2 = SettingsHandler.getPCGenOption("kitSelector.windowHeight", 0.0);
        if (!CoreUtility.doublesEqual(d, 0.0) && !CoreUtility.doublesEqual(d2, 0.0)) {
            SettingsHandler.setKitSelectorDimension(new Dimension(d.intValue(), d2.intValue()));
        }
        n2 = SettingsHandler.getPCGenOption("GearTab.buyRate", -1);
        n = SettingsHandler.getPCGenOption("GearTab.sellRate", -1);
        if (n2 < 0 || n < 0) {
            if (SettingsHandler.getPCGenOption("GearTab.ignoreCost", false)) {
                n2 = 0;
                n = 0;
            } else {
                n2 = 100;
                n = 50;
            }
        }
        Globals.initCustColumnWidth(CoreUtility.split(SettingsHandler.getOptions().getProperty("pcgen.options.custColumnWidth", ""), ','));
        showD20InfoAtStart = SettingsHandler.getPCGenOption("showD20InfoAtStart", true);
        loadURLs = SettingsHandler.getPCGenOption("loadURLs", false);
        allowOverride = SettingsHandler.getPCGenOption("allowOverride", false);
        showOGLOnLoad = SettingsHandler.getPCGenOption("showOGLOnLoad", true);
        showMatureOnLoad = SettingsHandler.getPCGenOption("showMatureOnLoad", true);
        showSponsorsOnLoad = SettingsHandler.getPCGenOption("showSponsorsOnLoad", true);
        Globals.setSourceDisplay(SourceFormat.values()[SettingsHandler.getPCGenOption("sourceDisplay", SourceFormat.LONG.ordinal())]);
        Globals.setLanguage(SettingsHandler.getPCGenOption("language", null));
        Globals.setCountry(SettingsHandler.getPCGenOption("country", null));
        SettingsHandler.setAbilitiesShownAsATab(SettingsHandler.getPCGenOption("abilitiesShownAsTab", false));
        SettingsHandler.setAlwaysOverwrite(SettingsHandler.getPCGenOption("alwaysOverwrite", false));
        SettingsHandler.setAutoFeatsRefundable(SettingsHandler.getPCGenOption("autoFeatsRefundable", false));
        SettingsHandler.setUseFeatBenefits(SettingsHandler.getPCGenOption("useFeatBenefits", true));
        SettingsHandler.setAutogenExoticMaterial(SettingsHandler.getPCGenOption("autoGenerateExoticMaterial", false));
        SettingsHandler.setAutogenMagic(SettingsHandler.getPCGenOption("autoGenerateMagic", false));
        SettingsHandler.setAutogenMasterwork(SettingsHandler.getPCGenOption("autoGenerateMasterwork", false));
        SettingsHandler.setAutogenRacial(SettingsHandler.getPCGenOption("autoGenerateRacial", false));
        SettingsHandler.setChaTabPlacement(SettingsHandler.getOptionTabPlacement("chaTabPlacement", 1));
        SettingsHandler.setClassTab_AvailableListMode(SettingsHandler.getPCGenOption("ClassTab.availableListMode", 0));
        SettingsHandler.setClassTab_SelectedListMode(SettingsHandler.getPCGenOption("ClassTab.selectedListMode", 0));
        SettingsHandler.setCreatePcgBackup(SettingsHandler.getPCGenOption("createPcgBackup", true));
        SettingsHandler.setCleanupTempFiles(SettingsHandler.getPCGenOption("cleanupTempFiles", false));
        SettingsHandler.setCustomizerSplit1(SettingsHandler.getPCGenOption("customizer.split1", -1));
        SettingsHandler.setCustomizerSplit2(SettingsHandler.getPCGenOption("customizer.split2", -1));
        SettingsHandler.setDmNotes(SettingsHandler.getPCGenOption("dmnotes", ""));
        SettingsHandler.setDomainTab_ListMode(SettingsHandler.getPCGenOption("DomainTab.ListMode", 0));
        SettingsHandler.setEnforceSpendingBeforeLevelUp(SettingsHandler.getPCGenOption("enforceSpendingBeforeLevelUp", false));
        SettingsHandler.setEquipTab_AvailableListMode(SettingsHandler.getPCGenOption("EquipTab.availableListMode", 2));
        SettingsHandler.setEquipTab_SelectedListMode(SettingsHandler.getPCGenOption("EquipTab.selectedListMode", 0));
        SettingsHandler.setExpertGUI(SettingsHandler.getPCGenOption("expertGUI", false));
        SettingsHandler.setFeatAutoColor(SettingsHandler.getPCGenOption("featAutoColor", Color.yellow.darker().getRGB()));
        SettingsHandler.setFeatTab_AvailableListMode(SettingsHandler.getPCGenOption("FeatTab.availableListMode", 2));
        SettingsHandler.setFeatTab_SelectedListMode(SettingsHandler.getPCGenOption("FeatTab.selectedListMode", 1));
        SettingsHandler.setFeatVirtualColor(SettingsHandler.getPCGenOption("featVirtualColor", Color.magenta.getRGB()));
        SettingsHandler.setGearTab_AllowDebt(SettingsHandler.getPCGenOption("GearTab.allowDebt", false));
        SettingsHandler.setGearTab_AutoResize(SettingsHandler.getPCGenOption("GearTab.autoResize", false));
        SettingsHandler.setGearTab_AvailableListMode(SettingsHandler.getPCGenOption("GearTab.availableListMode", 1));
        SettingsHandler.setGearTab_BuyRate(n2);
        SettingsHandler.setGearTab_IgnoreCost(SettingsHandler.getPCGenOption("GearTab.ignoreCost", false));
        SettingsHandler.setGearTab_SelectedListMode(SettingsHandler.getPCGenOption("GearTab.selectedListMode", 2));
        SettingsHandler.setGearTab_SellRate(n);
        SettingsHandler.setGrimHPMode(SettingsHandler.getPCGenOption("grimHPMode", false));
        SettingsHandler.setGrittyACMode(SettingsHandler.getPCGenOption("grittyACMode", false));
        SettingsHandler.setGUIUsesOutputNameEquipment(SettingsHandler.getPCGenOption("GUIUsesOutputNameEquipment", false));
        SettingsHandler.setGUIUsesOutputNameSpells(SettingsHandler.getPCGenOption("GUIUsesOutputNameSpells", false));
        SettingsHandler.setHiddenSources(SettingsHandler.getPCGenOption("hiddenSources", ""));
        SettingsHandler.setHideMonsterClasses(SettingsHandler.getPCGenOption("hideMonsterClasses", false));
        SettingsHandler.setHPMaxAtFirstLevel(SettingsHandler.getPCGenOption("hpMaxAtFirstLevel", true));
        SettingsHandler.setHPMaxAtFirstClassLevel(SettingsHandler.getPCGenOption("hpMaxAtFirstClassLevel", false));
        SettingsHandler.setHPPct(SettingsHandler.getPCGenOption("hpPct", 100));
        SettingsHandler.setHPRollMethod(SettingsHandler.getPCGenOption("hpRollMethod", 0));
        SettingsHandler.setIgnoreMonsterHDCap(SettingsHandler.getPCGenOption("ignoreMonsterHDCap", false));
        SettingsHandler.setIncludeSkills(SettingsHandler.getPCGenOption("includeSkills", 3));
        SettingsHandler.setSkillsTab_IncludeSkills(SettingsHandler.getPCGenOption("skillsTab_IncludeSkills", 1));
        SettingsHandler.setInvalidDmgText(SettingsHandler.getPCGenOption("invalidDmgText", PropertyFactory.getString("SettingsHandler.114")));
        SettingsHandler.setInvalidToHitText(SettingsHandler.getPCGenOption("invalidToHitText", PropertyFactory.getString("SettingsHandler.114")));
        SettingsHandler.setLastTipShown(SettingsHandler.getPCGenOption("lastTipOfTheDayTipShown", -1));
        SettingsHandler.setLoadCampaignsAtStart(SettingsHandler.getPCGenOption("loadCampaignsAtStart", false));
        SettingsHandler.setLoadCampaignsWithPC(SettingsHandler.getPCGenOption("loadCampaignsWithPC", false));
        SettingsHandler.setLookAndFeel(SettingsHandler.getPCGenOption("looknFeel", 1));
        SettingsHandler.setMaxPotionSpellLevel(SettingsHandler.getPCGenOption("maxPotionSpellLevel", 3));
        SettingsHandler.setMaxWandSpellLevel(SettingsHandler.getPCGenOption("maxWandSpellLevel", 4));
        SettingsHandler.setMetamagicAllowedInEqBuilder(SettingsHandler.getPCGenOption("allowMetamagicInCustomizer", false));
        SettingsHandler.setOptionAllowedInSources(SettingsHandler.getPCGenOption("optionAllowedInSources", true));
        SettingsHandler.setPccFilesLocation(new File(SettingsHandler.expandRelativePath(SettingsHandler.getPCGenOption("pccFilesLocation", System.getProperty("user.dir") + File.separator + "data"))));
        SettingsHandler.setPcgenCustomDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenCustomDir", Globals.getUserFilesPath() + File.separator + "customsources"))));
        SettingsHandler.setPcgenVendorDataDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenVendorDataDir", Globals.getUserFilesPath() + File.separator + "vendordata"))));
        SettingsHandler.setPcgenDocsDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenDocsDir", System.getProperty("user.dir") + File.separator + "docs"))));
        SettingsHandler.setPcgenSystemDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenSystemDir", System.getProperty("user.dir") + File.separator + "system"))));
        SettingsHandler.setPcgenThemePackDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenThemePackDir", System.getProperty("user.dir") + File.separator + "lib" + File.separator + "themes"))));
        SettingsHandler.setPcgenOutputSheetDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenOutputSheetDir", System.getProperty("user.dir") + File.separator + "outputsheets"))));
        SettingsHandler.setPcgenPreviewDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.pcgenPreviewDir", System.getProperty("user.dir") + File.separator + "preview"))));
        SettingsHandler.setGmgenPluginDir(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("gmgen.files.gmgenPluginDir", System.getProperty("user.dir") + File.separator + "plugins"))));
        SettingsHandler.setPcgPath(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.characters", Globals.getDefaultPcgPath()))));
        SettingsHandler.setBackupPcgPath(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.characters.backup", ""))));
        SettingsHandler.setPortraitsPath(new File(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.portraits", Globals.getDefaultPcgPath()))));
        SettingsHandler.setPostExportCommandStandard(SettingsHandler.getPCGenOption("postExportCommandStandard", ""));
        SettingsHandler.setPostExportCommandPDF(SettingsHandler.getPCGenOption("postExportCommandPDF", ""));
        SettingsHandler.setPrereqFailColor(SettingsHandler.getPCGenOption("prereqFailColor", Color.red.getRGB()));
        SettingsHandler.setPrereqQualifyColor(SettingsHandler.getPCGenOption("prereqQualifyColor", Color.black.getRGB()));
        SettingsHandler.setPreviewTabShown(SettingsHandler.getPCGenOption("previewTabShown", true));
        SettingsHandler.setQuickLaunchSources(SettingsHandler.getPCGenOption("quickLaunchSources", ""));
        SettingsHandler.setRaceTab_ListMode(SettingsHandler.getPCGenOption("RaceTab.ListMode", 0));
        SettingsHandler.setRanStartingWizard(SettingsHandler.getPCGenOption("ranStartingWizard", false));
        SettingsHandler.setROG(SettingsHandler.getPCGenOption("isROG", false));
        SettingsHandler.setSaveCustomInLst(SettingsHandler.getPCGenOption("saveCustomInLst", false));
        SettingsHandler.setSaveOutputSheetWithPC(SettingsHandler.getPCGenOption("saveOutputSheetWithPC", false));
        SettingsHandler.setPrintSpellsWithPC(SettingsHandler.getPCGenOption("printSpellsWithPC", true));
        SettingsHandler.setSelectedSpellSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedSpellOutputSheet", "")));
        SettingsHandler.setSelectedCharacterHTMLOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedCharacterHTMLOutputSheet", "")), playerCharacter);
        SettingsHandler.setSelectedCharacterPDFOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedCharacterPDFOutputSheet", "")), playerCharacter);
        SettingsHandler.setSelectedEqSetTemplate(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedEqSetTemplate", "")));
        SettingsHandler.setSelectedPartyHTMLOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedPartyHTMLOutputSheet", "")));
        SettingsHandler.setSelectedPartyPDFOutputSheet(SettingsHandler.expandRelativePath(SettingsHandler.getOptions().getProperty("pcgen.files.selectedPartyPDFOutputSheet", "")));
        SettingsHandler.setShowFeatDialogAtLevelUp(SettingsHandler.getPCGenOption("showFeatDialogAtLevelUp", true));
        SettingsHandler.setShowHPDialogAtLevelUp(SettingsHandler.getPCGenOption("showHPDialogAtLevelUp", true));
        SettingsHandler.setShowMemoryArea(SettingsHandler.getPCGenOption("showMemoryArea", false));
        SettingsHandler.setShowImagePreview(SettingsHandler.getPCGenOption("showImagePreview", true));
        SettingsHandler.setShowSingleBoxPerBundle(SettingsHandler.getPCGenOption("showSingleBoxPerBundle", false));
        SettingsHandler.setOutputDeprecationMessages(SettingsHandler.getPCGenOption("outputDeprecationMessages", true));
        SettingsHandler.setInputUnconstructedMessages(SettingsHandler.getPCGenOption("inputUnconstructedMessages", false));
        SettingsHandler.setShowStatDialogAtLevelUp(SettingsHandler.getPCGenOption("showStatDialogAtLevelUp", true));
        SettingsHandler.setShowTipOfTheDay(SettingsHandler.getPCGenOption("showTipOfTheDay", true));
        SettingsHandler.setShowToolBar(SettingsHandler.getPCGenOption("showToolBar", true));
        SettingsHandler.setShowSkillModifier(SettingsHandler.getPCGenOption("showSkillModifier", true));
        SettingsHandler.setShowSkillRanks(SettingsHandler.getPCGenOption("showSkillRanks", true));
        SettingsHandler.setShowWarningAtFirstLevelUp(SettingsHandler.getPCGenOption("showWarningAtFirstLevelUp", true));
        SettingsHandler.setSingleChoicePreference(SettingsHandler.getPCGenOption("ChooserSingleChoiceMethod", 0));
        SettingsHandler.setSkillsTab_AvailableListMode(SettingsHandler.getPCGenOption("SkillsTab.availableListMode", 2));
        SettingsHandler.setSkillsTab_SelectedListMode(SettingsHandler.getPCGenOption("SkillsTab.selectedListMode", 5));
        SettingsHandler.setSkinLFThemePack(SettingsHandler.getPCGenOption("skinLFThemePack", ""));
        SettingsHandler.setSpellMarketPriceAdjusted(SettingsHandler.getPCGenOption("spellMarketPriceAdjusted", false));
        SettingsHandler.setSpellsTab_AvailableListMode(SettingsHandler.getPCGenOption("SpellsTab.availableListMode", 0));
        SettingsHandler.setSpellsTab_SelectedListMode(SettingsHandler.getPCGenOption("SpellsTab.selectedListMode", 0));
        SettingsHandler.setSummaryTabShown(SettingsHandler.getPCGenOption("summaryTabShown", true));
        SettingsHandler.setTabPlacement(SettingsHandler.getOptionTabPlacement("tabPlacement", 3));
        SettingsHandler.setTemplateSelTab_ListMode(SettingsHandler.getPCGenOption("TemplateTab.selectedListMode", 0));
        SettingsHandler.setTemplateTab_ListMode(SettingsHandler.getPCGenOption("TemplateTab.availableListMode", 0));
        SettingsHandler.setToolTipTextShown(SettingsHandler.getPCGenOption("toolTipTextShown", true));
        SettingsHandler.setUseHigherLevelSlotsDefault(SettingsHandler.getPCGenOption("useHigherLevelSlotsDefault", false));
        SettingsHandler.setUseAdvancedSourceSelect(SettingsHandler.getPCGenOption("useAdvancedSourceSelect", false));
        SettingsHandler.setUseWaitCursor(SettingsHandler.getPCGenOption("useWaitCursor", true));
        SettingsHandler.setWantToLoadMasterworkAndMagic(SettingsHandler.getPCGenOption("loadMasterworkAndMagicFromLst", false));
        SettingsHandler.setWeaponProfPrintout(SettingsHandler.getPCGenOption("weaponProfPrintout", true));
        SettingsHandler.parseRuleChecksFromOptions(SettingsHandler.getPCGenOption("ruleChecks", ""));
        return dimension;
    }

    private static void getChosenCampaignFiles(GameMode gameMode) {
        List<String> list = CoreUtility.split(SettingsHandler.getOptions().getProperty("pcgen.files.chosenCampaignSourcefiles." + gameMode.getName(), ""), ',');
        ArrayList<URI> arrayList = new ArrayList<URI>(list.size());
        for (String string : list) {
            try {
                arrayList.add(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                Logging.errorPrint("Settings error: Unable to convert " + string + " to a URI: " + uRISyntaxException.getLocalizedMessage());
            }
        }
        PersistenceManager.getInstance().setChosenCampaignSourcefiles(arrayList, gameMode);
    }

    public static void initGameModes() {
        try {
            PersistenceManager.getInstance().initialize();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            ShowMessageDelegate.showMessageDialog(persistenceLayerException.getMessage(), "PCGen", MessageType.INFORMATION);
        }
        SettingsHandler.setGame(SettingsHandler.getPCGenOption("game", "35e"));
        Globals.createEmptyRace();
        showNatWeaponTab = SettingsHandler.getPCGenOption("showNatWeaponTab", false);
        validateBonuses = SettingsHandler.getPCGenOption("validateBonuses", false);
        debugFeats = SettingsHandler.getPCGenOption("debugFeats", false);
    }

    public static void setOptionsProperties(PlayerCharacter playerCharacter) {
        String string;
        if (SettingsHandler.getPcgPath() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.characters", SettingsHandler.retractRelativePath(SettingsHandler.getPcgPath().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.characters", SettingsHandler.retractRelativePath(Globals.getDefaultPath()));
        }
        if (!SettingsHandler.getBackupPcgPath().getPath().equals("")) {
            SettingsHandler.getOptions().setProperty("pcgen.files.characters.backup", SettingsHandler.retractRelativePath(SettingsHandler.getBackupPcgPath().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.characters.backup", "");
        }
        SettingsHandler.getOptions().setProperty("pcgen.files.portraits", SettingsHandler.retractRelativePath(SettingsHandler.getPortraitsPath().getAbsolutePath()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedSpellOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedSpellSheet()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedCharacterHTMLOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedCharacterHTMLOutputSheet(playerCharacter)));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedCharacterPDFOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedCharacterPDFOutputSheet(playerCharacter)));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedPartyHTMLOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedPartyHTMLOutputSheet()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedPartyPDFOutputSheet", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedPartyPDFOutputSheet()));
        SettingsHandler.getOptions().setProperty("pcgen.files.selectedEqSetTemplate", SettingsHandler.retractRelativePath(SettingsHandler.getSelectedEqSetTemplate()));
        SettingsHandler.getOptions().setProperty("pcgen.files.chosenCampaignSourcefiles", StringUtil.join(PersistenceManager.getInstance().getChosenCampaignSourcefiles(), ", "));
        SettingsHandler.getOptions().setProperty("pcgen.options.custColumnWidth", StringUtil.join(Globals.getCustColumnWidth(), ", "));
        if (SettingsHandler.getPcgenCustomDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenCustomDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenCustomDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenCustomDir", "");
        }
        if (SettingsHandler.getPcgenVendorDataDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenVendorDataDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenVendorDataDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenVendorDataDir", "");
        }
        if (SettingsHandler.getPcgenDocsDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenDocsDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenDocsDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenDocsDir", "");
        }
        if (SettingsHandler.getPcgenSystemDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenSystemDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenSystemDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenSystemDir", "");
        }
        if (SettingsHandler.getPcgenOutputSheetDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenOutputSheetDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenOutputSheetDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenOutputSheetDir", "");
        }
        if (SettingsHandler.getPcgenPreviewDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenPreviewDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenPreviewDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenPreviewDir", "");
        }
        if (SettingsHandler.getGmgenPluginDir() != null) {
            SettingsHandler.getOptions().setProperty("gmgen.files.gmgenPluginDir", SettingsHandler.retractRelativePath(SettingsHandler.getGmgenPluginDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("gmgen.files.gmgenPluginDir", "");
        }
        if (SettingsHandler.getPcgenThemePackDir() != null) {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenThemePackDir", SettingsHandler.retractRelativePath(SettingsHandler.getPcgenThemePackDir().getAbsolutePath()));
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.files.pcgenThemePackDir", "");
        }
        if (SettingsHandler.getBrowserPath() != null) {
            SettingsHandler.setPCGenOption("browserPath", SettingsHandler.getBrowserPath());
        } else {
            SettingsHandler.setPCGenOption("browserPath", "");
        }
        if (Globals.getRootFrame() != null) {
            SettingsHandler.setOpenRecentOption("openRecentPCs", PCGen_Frame1.getInst().getOpenRecentPCs());
            SettingsHandler.setOpenRecentOption("openRecentParties", PCGen_Frame1.getInst().getOpenRecentParties());
        }
        if (SettingsHandler.getGame() != null) {
            SettingsHandler.setPCGenOption("game", SettingsHandler.getGame().getName());
        } else {
            SettingsHandler.setPCGenOption("game", "");
        }
        try {
            SettingsHandler.setPCGenOption("skinLFThemePack", SettingsHandler.getSkinLFThemePack());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (SettingsHandler.getPccFilesLocation() != null) {
            SettingsHandler.setPCGenOption("pccFilesLocation", SettingsHandler.retractRelativePath(SettingsHandler.getPccFilesLocation().getAbsolutePath()));
        } else {
            SettingsHandler.setPCGenOption("pccFilesLocation", "");
        }
        if (SettingsHandler.getLeftUpperCorner() != null) {
            SettingsHandler.setPCGenOption("windowLeftUpperCorner.X", SettingsHandler.getLeftUpperCorner().getX());
            SettingsHandler.setPCGenOption("windowLeftUpperCorner.Y", SettingsHandler.getLeftUpperCorner().getY());
        }
        SettingsHandler.setPCGenOption("windowState", SettingsHandler.getWindowState());
        if (Globals.getRootFrame() != null) {
            SettingsHandler.setPCGenOption("windowWidth", Globals.getRootFrame().getSize().getWidth());
            SettingsHandler.setPCGenOption("windowHeight", Globals.getRootFrame().getSize().getHeight());
        }
        if (SettingsHandler.getCustomizerLeftUpperCorner() != null) {
            SettingsHandler.setPCGenOption("customizer.windowLeftUpperCorner.X", SettingsHandler.getCustomizerLeftUpperCorner().getX());
            SettingsHandler.setPCGenOption("customizer.windowLeftUpperCorner.Y", SettingsHandler.getCustomizerLeftUpperCorner().getY());
        }
        if (SettingsHandler.getCustomizerDimension() != null) {
            SettingsHandler.setPCGenOption("customizer.windowWidth", SettingsHandler.getCustomizerDimension().getWidth());
            SettingsHandler.setPCGenOption("customizer.windowHeight", SettingsHandler.getCustomizerDimension().getHeight());
        }
        if (SettingsHandler.getKitSelectorLeftUpperCorner() != null) {
            SettingsHandler.setPCGenOption("kitSelector.windowLeftUpperCorner.X", SettingsHandler.getKitSelectorLeftUpperCorner().getX());
            SettingsHandler.setPCGenOption("kitSelector.windowLeftUpperCorner.Y", SettingsHandler.getKitSelectorLeftUpperCorner().getY());
        }
        if (SettingsHandler.getKitSelectorDimension() != null) {
            SettingsHandler.setPCGenOption("kitSelector.windowWidth", SettingsHandler.getKitSelectorDimension().getWidth());
            SettingsHandler.setPCGenOption("kitSelector.windowHeight", SettingsHandler.getKitSelectorDimension().getHeight());
        }
        if ((string = Globals.getPaperInfo(0)) != null) {
            SettingsHandler.setPCGenOption("paperName", string);
        }
        SettingsHandler.setPCGenOption("allStatsValue", null);
        SettingsHandler.setPCGenOption("purchaseMethodName", null);
        SettingsHandler.setPCGenOption("rollMethod", null);
        SettingsHandler.setPCGenOption("rollMethodExpression", null);
        for (int i = 0; i < SystemCollections.getUnmodifiableGameModeList().size(); ++i) {
            GameMode gameMode = SystemCollections.getUnmodifiableGameModeList().get(i);
            String string2 = gameMode.getName();
            if (gameMode.getUnitSet() != null && gameMode.getUnitSet().getName() != null) {
                SettingsHandler.setPCGenOption("gameMode." + string2 + ".unitSetName", gameMode.getUnitSet().getName());
            }
            SettingsHandler.setPCGenOption("gameMode." + string2 + ".purchaseMethodName", gameMode.getPurchaseModeMethodName());
            SettingsHandler.setPCGenOption("gameMode." + string2 + ".rollMethod", gameMode.getRollMethod());
            SettingsHandler.setPCGenOption("gameMode." + string2 + ".rollMethodExpression", gameMode.getRollMethodExpressionName());
            SettingsHandler.setPCGenOption("gameMode." + string2 + ".allStatsValue", gameMode.getAllStatsValue());
            SettingsHandler.setPCGenOption("gameMode." + string2 + ".xpTableName", gameMode.getXpTableName());
        }
        SettingsHandler.setRuleChecksInOptions("ruleChecks");
        SettingsHandler.setPCGenOption("abilitiesShownAsTab", SettingsHandler.isAbilitiesShownAsATab());
        SettingsHandler.setPCGenOption("allowMetamagicInCustomizer", SettingsHandler.isMetamagicAllowedInEqBuilder());
        SettingsHandler.setPCGenOption("allowOverride", allowOverride);
        SettingsHandler.setPCGenOption("alwaysOverwrite", SettingsHandler.getAlwaysOverwrite());
        SettingsHandler.setPCGenOption("autoFeatsRefundable", SettingsHandler.isAutoFeatsRefundable());
        SettingsHandler.setPCGenOption("useFeatBenefits", SettingsHandler.useFeatBenefits());
        SettingsHandler.setPCGenOption("autoGenerateExoticMaterial", SettingsHandler.isAutogenExoticMaterial());
        SettingsHandler.setPCGenOption("autoGenerateMagic", SettingsHandler.isAutogenMagic());
        SettingsHandler.setPCGenOption("autoGenerateMasterwork", SettingsHandler.isAutogenMasterwork());
        SettingsHandler.setPCGenOption("autoGenerateRacial", SettingsHandler.isAutogenRacial());
        SettingsHandler.setPCGenOption("chaTabPlacement", SettingsHandler.convertTabPlacementToString(chaTabPlacement));
        SettingsHandler.setPCGenOption("ChooserSingleChoiceMethod", SettingsHandler.getSingleChoicePreference());
        SettingsHandler.setPCGenOption("ClassTab.availableListMode", SettingsHandler.getClassTab_AvailableListMode());
        SettingsHandler.setPCGenOption("ClassTab.selectedListMode", SettingsHandler.getClassTab_SelectedListMode());
        SettingsHandler.setPCGenOption("cleanupTempFiles", SettingsHandler.getCleanupTempFiles());
        SettingsHandler.setPCGenOption("country", Globals.getCountry());
        SettingsHandler.setPCGenOption("createPcgBackup", SettingsHandler.getCreatePcgBackup());
        SettingsHandler.setPCGenOption("customizer.split1", SettingsHandler.getCustomizerSplit1());
        SettingsHandler.setPCGenOption("customizer.split2", SettingsHandler.getCustomizerSplit2());
        SettingsHandler.setPCGenOption("dmnotes", SettingsHandler.getDmNotes());
        SettingsHandler.setPCGenOption("DomainTab.ListMode", SettingsHandler.getDomainTab_ListMode());
        SettingsHandler.setPCGenOption("EquipTab.availableListMode", SettingsHandler.getEquipTab_AvailableListMode());
        SettingsHandler.setPCGenOption("EquipTab.selectedListMode", SettingsHandler.getEquipTab_SelectedListMode());
        SettingsHandler.setPCGenOption("expertGUI", SettingsHandler.isExpertGUI());
        SettingsHandler.setPCGenOption("featAutoColor", "0x" + Integer.toHexString(SettingsHandler.getFeatAutoColor()));
        SettingsHandler.setPCGenOption("FeatTab.availableListMode", SettingsHandler.getFeatTab_AvailableListMode());
        SettingsHandler.setPCGenOption("FeatTab.selectedListMode", SettingsHandler.getFeatTab_SelectedListMode());
        SettingsHandler.setPCGenOption("featVirtualColor", "0x" + Integer.toHexString(SettingsHandler.getFeatVirtualColor()));
        SettingsHandler.setPCGenOption("GearTab.allowDebt", SettingsHandler.getGearTab_AllowDebt());
        SettingsHandler.setPCGenOption("GearTab.autoResize", SettingsHandler.getGearTab_AutoResize());
        SettingsHandler.setPCGenOption("GearTab.availableListMode", SettingsHandler.getGearTab_AvailableListMode());
        SettingsHandler.setPCGenOption("GearTab.buyRate", SettingsHandler.getGearTab_BuyRate());
        SettingsHandler.setPCGenOption("GearTab.ignoreCost", SettingsHandler.getGearTab_IgnoreCost());
        SettingsHandler.setPCGenOption("GearTab.selectedListMode", SettingsHandler.getGearTab_SelectedListMode());
        SettingsHandler.setPCGenOption("GearTab.sellRate", SettingsHandler.getGearTab_SellRate());
        SettingsHandler.setPCGenOption("grimHPMode", SettingsHandler.isGrimHPMode());
        SettingsHandler.setPCGenOption("grittyACMode", SettingsHandler.isGrittyACMode());
        SettingsHandler.setPCGenOption("GUIUsesOutputNameEquipment", SettingsHandler.guiUsesOutputNameEquipment());
        SettingsHandler.setPCGenOption("GUIUsesOutputNameSpells", SettingsHandler.guiUsesOutputNameSpells());
        SettingsHandler.setPCGenOption("hideMonsterClasses", SettingsHandler.hideMonsterClasses());
        SettingsHandler.setPCGenOption("hpMaxAtFirstLevel", SettingsHandler.isHPMaxAtFirstLevel());
        SettingsHandler.setPCGenOption("hpMaxAtFirstClassLevel", SettingsHandler.isHPMaxAtFirstClassLevel());
        SettingsHandler.setPCGenOption("hpPct", SettingsHandler.getHPPct());
        SettingsHandler.setPCGenOption("hpRollMethod", SettingsHandler.getHPRollMethod());
        SettingsHandler.setPCGenOption("ignoreMonsterHDCap", SettingsHandler.isIgnoreMonsterHDCap());
        SettingsHandler.setPCGenOption("includeSkills", SettingsHandler.getIncludeSkills());
        SettingsHandler.setPCGenOption("skillsTab_IncludeSkills", SettingsHandler.getSkillsTab_IncludeSkills());
        SettingsHandler.setPCGenOption("invalidDmgText", SettingsHandler.getInvalidDmgText());
        SettingsHandler.setPCGenOption("invalidToHitText", SettingsHandler.getInvalidToHitText());
        SettingsHandler.setPCGenOption("language", Globals.getLanguage());
        SettingsHandler.setPCGenOption("lastTipOfTheDayTipShown", SettingsHandler.getLastTipShown());
        SettingsHandler.setPCGenOption("loadCampaignsAtStart", SettingsHandler.isLoadCampaignsAtStart());
        SettingsHandler.setPCGenOption("loadCampaignsWithPC", SettingsHandler.isLoadCampaignsWithPC());
        SettingsHandler.setPCGenOption("loadMasterworkAndMagicFromLst", SettingsHandler.wantToLoadMasterworkAndMagic());
        SettingsHandler.setPCGenOption("loadURLs", loadURLs);
        SettingsHandler.setPCGenOption("looknFeel", SettingsHandler.getLookAndFeel());
        SettingsHandler.setPCGenOption("maxPotionSpellLevel", SettingsHandler.getMaxPotionSpellLevel());
        SettingsHandler.setPCGenOption("maxWandSpellLevel", SettingsHandler.getMaxWandSpellLevel());
        SettingsHandler.setPCGenOption("nameDisplayStyle", SettingsHandler.getNameDisplayStyle());
        SettingsHandler.setPCGenOption("optionAllowedInSources", SettingsHandler.isOptionAllowedInSources());
        SettingsHandler.setPCGenOption("postExportCommandStandard", SettingsHandler.getPostExportCommandStandard());
        SettingsHandler.setPCGenOption("postExportCommandPDF", SettingsHandler.getPostExportCommandPDF());
        SettingsHandler.setPCGenOption("prereqFailColor", "0x" + Integer.toHexString(SettingsHandler.getPrereqFailColor()));
        SettingsHandler.setPCGenOption("prereqQualifyColor", "0x" + Integer.toHexString(SettingsHandler.getPrereqQualifyColor()));
        SettingsHandler.setPCGenOption("previewTabShown", SettingsHandler.isPreviewTabShown());
        SettingsHandler.setPCGenOption("RaceTab.ListMode", SettingsHandler.getRaceTab_ListMode());
        SettingsHandler.setPCGenOption("ranStartingWizard", ranStartingWizard);
        SettingsHandler.setPCGenOption("saveCustomInLst", SettingsHandler.isSaveCustomInLst());
        SettingsHandler.setPCGenOption("saveOutputSheetWithPC", SettingsHandler.getSaveOutputSheetWithPC());
        SettingsHandler.setPCGenOption("printSpellsWithPC", SettingsHandler.getPrintSpellsWithPC());
        SettingsHandler.setPCGenOption("showD20InfoAtStart", showD20InfoAtStart);
        SettingsHandler.setPCGenOption("showFeatDialogAtLevelUp", SettingsHandler.getShowFeatDialogAtLevelUp());
        SettingsHandler.setPCGenOption("enforceSpendingBeforeLevelUp", SettingsHandler.getEnforceSpendingBeforeLevelUp());
        SettingsHandler.setPCGenOption("showHPDialogAtLevelUp", SettingsHandler.getShowHPDialogAtLevelUp());
        SettingsHandler.setPCGenOption("showMemoryArea", SettingsHandler.isShowMemoryArea());
        SettingsHandler.setPCGenOption("showImagePreview", SettingsHandler.isShowImagePreview());
        SettingsHandler.setPCGenOption("showNatWeaponTab", showNatWeaponTab);
        SettingsHandler.setPCGenOption("showOGLOnLoad", showOGLOnLoad);
        SettingsHandler.setPCGenOption("showMatureOnLoad", showMatureOnLoad);
        SettingsHandler.setPCGenOption("showSponsorsOnLoad", showSponsorsOnLoad);
        SettingsHandler.setPCGenOption("showStatDialogAtLevelUp", SettingsHandler.getShowStatDialogAtLevelUp());
        SettingsHandler.setPCGenOption("showTipOfTheDay", SettingsHandler.getShowTipOfTheDay());
        SettingsHandler.setPCGenOption("showToolBar", SettingsHandler.isShowToolBar());
        SettingsHandler.setPCGenOption("showSkillModifier", SettingsHandler.getShowSkillModifier());
        SettingsHandler.setPCGenOption("showSkillRanks", SettingsHandler.getShowSkillRanks());
        SettingsHandler.setPCGenOption("showSingleBoxPerBundle", SettingsHandler.getShowSingleBoxPerBundle());
        SettingsHandler.setPCGenOption("showWarningAtFirstLevelUp", SettingsHandler.isShowWarningAtFirstLevelUp());
        SettingsHandler.setPCGenOption("SkillsTab.availableListMode", SettingsHandler.getSkillsTab_AvailableListMode());
        SettingsHandler.setPCGenOption("SkillsTab.selectedListMode", SettingsHandler.getSkillsTab_SelectedListMode());
        SettingsHandler.setPCGenOption("sourceDisplay", Globals.getSourceDisplay().ordinal());
        SettingsHandler.setPCGenOption("spellMarketPriceAdjusted", SettingsHandler.isSpellMarketPriceAdjusted());
        SettingsHandler.setPCGenOption("SpellsTab.availableListMode", SettingsHandler.getSpellsTab_AvailableListMode());
        SettingsHandler.setPCGenOption("SpellsTab.selectedListMode", SettingsHandler.getSpellsTab_SelectedListMode());
        SettingsHandler.setPCGenOption("summaryTabShown", SettingsHandler.isSummaryTabShown());
        SettingsHandler.setPCGenOption("tabPlacement", SettingsHandler.convertTabPlacementToString(tabPlacement));
        SettingsHandler.setPCGenOption("TemplateTab.availableListMode", SettingsHandler.getTemplateTab_ListMode());
        SettingsHandler.setPCGenOption("TemplateTab.selectedListMode", SettingsHandler.getTemplateSelTab_ListMode());
        SettingsHandler.setPCGenOption("toolTipTextShown", SettingsHandler.isToolTipTextShown());
        SettingsHandler.setPCGenOption("useHigherLevelSlotsDefault", SettingsHandler.isUseHigherLevelSlotsDefault());
        SettingsHandler.setPCGenOption("useWaitCursor", SettingsHandler.getUseWaitCursor());
        SettingsHandler.setPCGenOption("validateBonuses", validateBonuses);
        SettingsHandler.setPCGenOption("weaponProfPrintout", SettingsHandler.getWeaponProfPrintout());
        SettingsHandler.setPCGenOption("debugFeats", debugFeats);
        SettingsHandler.setPCGenOption("outputDeprecationMessages", SettingsHandler.outputDeprecationMessages());
        SettingsHandler.setPCGenOption("inputUnconstructedMessages", SettingsHandler.inputUnconstructedMessages());
        SettingsHandler.setPCGenOption("hiddenSources", SettingsHandler.getHiddenSources());
        SettingsHandler.setPCGenOption("quickLaunchSources", SettingsHandler.getQuickLaunchSources());
        SettingsHandler.setPCGenOption("useAdvancedSourceSelect", SettingsHandler.useAdvancedSourceSelect());
    }

    public static void setPCGenOption(String string, int n) {
        SettingsHandler.setPCGenOption(string, String.valueOf(n));
    }

    public static void setPCGenOption(String string, String string2) {
        if (string2 == null) {
            SettingsHandler.getOptions().remove("pcgen.options." + string);
        } else {
            SettingsHandler.getOptions().setProperty("pcgen.options." + string, string2);
        }
    }

    public static int getPCGenOption(String string, int n) {
        return Integer.decode(SettingsHandler.getPCGenOption(string, String.valueOf(n)));
    }

    public static String getPCGenOption(String string, String string2) {
        return SettingsHandler.getOptions().getProperty("pcgen.options." + string, string2);
    }

    public static boolean hasPCGenOption(String string) {
        return SettingsHandler.getOptions().containsKey("pcgen.options." + string);
    }

    public static String getPDFOutputSheetPath() {
        if ("".equals(selectedCharacterPDFOutputSheet)) {
            return SettingsHandler.getPcgenOutputSheetDir().toString();
        }
        return new File(selectedCharacterPDFOutputSheet).getParentFile().getAbsolutePath();
    }

    public static void setPccFilesLocation(File file) {
        pccFilesLocation = file;
    }

    public static File getPccFilesLocation() {
        return pccFilesLocation;
    }

    public static void setPcgPath(File file) {
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        pcgPath = file;
    }

    public static void ensurePathExists(File file) {
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
    }

    public static File getPcgPath() {
        return pcgPath;
    }

    public static void setLastUsedPcgPath(File file) {
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        lastUsedPcgPath = file;
    }

    public static File getLastUsedPcgPath() {
        if (lastUsedPcgPath == null) {
            return pcgPath;
        }
        return lastUsedPcgPath;
    }

    public static void setPcgenCustomDir(File file) {
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        pcgenCustomDir = file;
    }

    public static File getPcgenCustomDir() {
        return pcgenCustomDir;
    }

    public static void setPcgenVendorDataDir(File file) {
        if (file != null && !file.exists()) {
            file.mkdirs();
        }
        pcgenVendorDataDir = file;
    }

    public static File getPcgenVendorDataDir() {
        return pcgenVendorDataDir;
    }

    public static void setPcgenSponsorDir(File file) {
        pcgenSponsorDir = file;
    }

    public static File getPcgenSponsorDir() {
        return pcgenSponsorDir;
    }

    public static void setPcgenDocsDir(File file) {
        pcgenDocsDir = file;
    }

    public static File getPcgenDocsDir() {
        return pcgenDocsDir;
    }

    public static void setPcgenFilesDir(File file) {
        if (file != null) {
            pcgenFilesDir = file;
        }
    }

    public static File getPcgenFilesDir() {
        return pcgenFilesDir;
    }

    public static File getDecodedPCGenFilesDir() {
        String string = SettingsHandler.getFilePaths();
        if (string == null || string.length() < 1) {
            string = Globals.isMacPlatform ? "mac_user" : "pcgen";
        }
        if (string.equals("pcgen")) {
            return new File(System.getProperty("user.dir"));
        }
        if (string.equals("user")) {
            return new File(System.getProperty("user.home") + File.separator + ".pcgen");
        }
        if (string.equals("mac_user")) {
            return new File(Globals.defaultMacOptionsPath);
        }
        return SettingsHandler.getPcgenFilesDir();
    }

    public static void setPcgenOutputSheetDir(File file) {
        pcgenOutputSheetDir = file;
    }

    public static File getPcgenOutputSheetDir() {
        return pcgenOutputSheetDir;
    }

    public static void setPcgenSystemDir(File file) {
        pcgenSystemDir = file;
    }

    public static File getPcgenSystemDir() {
        return pcgenSystemDir;
    }

    public static File getPcgenThemePackDir() {
        return pcgenThemePackDir;
    }

    public static void setPcgenPreviewDir(File file) {
        pcgenPreviewDir = file;
    }

    public static File getPcgenPreviewDir() {
        return pcgenPreviewDir;
    }

    public static void setPortraitsPath(File file) {
        portraitsPath = file;
    }

    public static File getPortraitsPath() {
        return portraitsPath;
    }

    public static void setPostExportCommandStandard(String string) {
        postExportCommandStandard = string;
    }

    public static void setPostExportCommandPDF(String string) {
        postExportCommandPDF = string;
    }

    public static String getPostExportCommandStandard() {
        return postExportCommandStandard;
    }

    public static String getPostExportCommandPDF() {
        return postExportCommandPDF;
    }

    public static void setPrereqFailColor(int n) {
        prereqFailColor = n & 0xFFFFFF;
    }

    public static int getPrereqFailColor() {
        return prereqFailColor;
    }

    public static String getPrereqFailColorAsHtmlStart() {
        StringBuffer stringBuffer = new StringBuffer("<font color=");
        if (SettingsHandler.getPrereqFailColor() != 0) {
            stringBuffer.append("\"#").append(Integer.toHexString(SettingsHandler.getPrereqFailColor())).append("\"");
        } else {
            stringBuffer.append("red");
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String getPrereqFailColorAsHtmlEnd() {
        return "</font>";
    }

    public static void setPrereqQualifyColor(int n) {
        prereqQualifyColor = n & 0xFFFFFF;
    }

    public static int getPrereqQualifyColor() {
        return prereqQualifyColor;
    }

    public static void setPrintSpellsWithPC(boolean bl) {
        printSpellsWithPC = bl;
    }

    public static boolean getPrintSpellsWithPC() {
        return printSpellsWithPC;
    }

    public static boolean isROG() {
        return isROG;
    }

    public static void setRaceTab_ListMode(int n) {
        raceTab_ListMode = n;
    }

    public static int getRaceTab_ListMode() {
        return raceTab_ListMode;
    }

    public static void setTemplateTab_ListMode(int n) {
        templateTab_ListMode = n;
    }

    public static int getTemplateTab_ListMode() {
        return templateTab_ListMode;
    }

    public static void setTemplateSelTab_ListMode(int n) {
        templateSelTab_ListMode = n;
    }

    public static int getTemplateSelTab_ListMode() {
        return templateSelTab_ListMode;
    }

    public static void setRuleCheck(String string, boolean bl) {
        String string2 = "N";
        if (bl) {
            string2 = "Y";
        }
        ruleCheckMap.put(string, string2);
    }

    public static boolean getRuleCheck(String string) {
        String string2;
        return ruleCheckMap.containsKey(string) && (string2 = ruleCheckMap.get(string)).equals("Y");
    }

    public static void setSaveCustomEquipment(boolean bl) {
        SettingsHandler.setSaveCustomInLst(bl);
    }

    public static boolean getSaveCustomEquipment() {
        return SettingsHandler.isSaveCustomInLst();
    }

    public static void setSaveOutputSheetWithPC(boolean bl) {
        saveOutputSheetWithPC = bl;
    }

    public static boolean getSaveOutputSheetWithPC() {
        return saveOutputSheetWithPC;
    }

    public static void setSelectedCharacterHTMLOutputSheet(String string, PlayerCharacter playerCharacter) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && playerCharacter != null) {
            playerCharacter.setSelectedCharacterHTMLOutputSheet(string);
        }
        selectedCharacterHTMLOutputSheet = string;
    }

    public static String getSelectedCharacterHTMLOutputSheet(PlayerCharacter playerCharacter) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && playerCharacter != null && playerCharacter.getSelectedCharacterHTMLOutputSheet().length() > 0) {
            return playerCharacter.getSelectedCharacterHTMLOutputSheet();
        }
        return selectedCharacterHTMLOutputSheet;
    }

    public static void setSelectedCharacterPDFOutputSheet(String string, PlayerCharacter playerCharacter) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && playerCharacter != null) {
            playerCharacter.setSelectedCharacterPDFOutputSheet(string);
        }
        selectedCharacterPDFOutputSheet = string;
    }

    public static String getSelectedCharacterPDFOutputSheet(PlayerCharacter playerCharacter) {
        if (SettingsHandler.getSaveOutputSheetWithPC() && playerCharacter != null && playerCharacter.getSelectedCharacterPDFOutputSheet().length() > 0) {
            return playerCharacter.getSelectedCharacterPDFOutputSheet();
        }
        return selectedCharacterPDFOutputSheet;
    }

    public static void setSelectedEqSetTemplate(String string) {
        selectedEqSetTemplate = string;
    }

    public static String getSelectedEqSetTemplate() {
        return selectedEqSetTemplate;
    }

    public static String getSelectedEqSetTemplateName() {
        if (selectedEqSetTemplate.length() > 0) {
            int n = selectedEqSetTemplate.lastIndexOf("\\");
            return selectedEqSetTemplate.substring(n + 1);
        }
        return selectedEqSetTemplate;
    }

    public static void setSelectedPartyHTMLOutputSheet(String string) {
        selectedPartyHTMLOutputSheet = string;
    }

    public static String getSelectedPartyHTMLOutputSheet() {
        return selectedPartyHTMLOutputSheet;
    }

    public static void setSelectedPartyPDFOutputSheet(String string) {
        selectedPartyPDFOutputSheet = string;
    }

    public static String getSelectedPartyPDFOutputSheet() {
        return selectedPartyPDFOutputSheet;
    }

    public static void setSelectedSpellSheet(String string) {
        selectedSpellSheet = string;
    }

    public static String getSelectedSpellSheet() {
        return selectedSpellSheet;
    }

    public static String getSelectedSpellSheetName() {
        if (selectedSpellSheet.length() > 0) {
            int n = selectedSpellSheet.lastIndexOf("\\");
            return selectedSpellSheet.substring(n + 1);
        }
        return selectedSpellSheet;
    }

    public static void setShowD20Info(boolean bl) {
        showD20InfoAtStart = bl;
    }

    public static void setShowFeatDialogAtLevelUp(boolean bl) {
        showFeatDialogAtLevelUp = true;
    }

    public static boolean getShowFeatDialogAtLevelUp() {
        return showFeatDialogAtLevelUp;
    }

    public static void setShowHPDialogAtLevelUp(boolean bl) {
        showHPDialogAtLevelUp = bl;
    }

    public static boolean getShowHPDialogAtLevelUp() {
        return showHPDialogAtLevelUp;
    }

    public static void setShowLicense(boolean bl) {
        showOGLOnLoad = bl;
    }

    public static void setShowMature(boolean bl) {
        showMatureOnLoad = bl;
    }

    public static void setShowSponsors(boolean bl) {
        showSponsorsOnLoad = bl;
    }

    public static void setShowStatDialogAtLevelUp(boolean bl) {
        showStatDialogAtLevelUp = bl;
    }

    public static boolean getShowStatDialogAtLevelUp() {
        return showStatDialogAtLevelUp;
    }

    public static void setShowTipOfTheDay(boolean bl) {
        showTipOfTheDay = bl;
    }

    public static boolean getShowTipOfTheDay() {
        return showTipOfTheDay;
    }

    public static void setShowWarningAtFirstLevelUp(boolean bl) {
        showWarningAtFirstLevelUp = bl;
    }

    public static boolean isShowWarningAtFirstLevelUp() {
        return showWarningAtFirstLevelUp;
    }

    public static void setSingleChoicePreference(int n) {
        singleChoicePreference = n;
    }

    public static int getSingleChoicePreference() {
        return singleChoicePreference;
    }

    public static void setSkillsTab_AvailableListMode(int n) {
        skillsTab_AvailableListMode = n;
    }

    public static int getSkillsTab_AvailableListMode() {
        return skillsTab_AvailableListMode;
    }

    public static void setSkillsTab_IncludeSkills(int n) {
        skillsTab_IncludeSkills = n;
    }

    public static int getSkillsTab_IncludeSkills() {
        return skillsTab_IncludeSkills;
    }

    public static void setSkillsTab_SelectedListMode(int n) {
        skillsTab_SelectedListMode = n;
    }

    public static int getSkillsTab_SelectedListMode() {
        return skillsTab_SelectedListMode;
    }

    public static void setSkinLFThemePack(String string) {
        skinLFThemePack = string;
    }

    public static String getSkinLFThemePack() {
        return skinLFThemePack;
    }

    public static void setSpellsTab_AvailableListMode(int n) {
        spellsTab_AvailableListMode = n;
    }

    public static int getSpellsTab_AvailableListMode() {
        return spellsTab_AvailableListMode;
    }

    public static void setSpellsTab_SelectedListMode(int n) {
        spellsTab_SelectedListMode = n;
    }

    public static int getSpellsTab_SelectedListMode() {
        return spellsTab_SelectedListMode;
    }

    public static void setTabPlacement(int n) {
        tabPlacement = n;
    }

    public static int getTabPlacement() {
        return tabPlacement;
    }

    public static UnitSet getGameModeUnitSet() {
        return game.getUnitSet();
    }

    public static File getTempPath() {
        return tempPath;
    }

    public static void setToolBarShown(boolean bl) {
        SettingsHandler.setShowToolBar(bl);
    }

    public static boolean isToolBarShown() {
        return SettingsHandler.isShowToolBar();
    }

    public static void setToolTipTextShown(boolean bl) {
        toolTipTextShown = bl;
        PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getInst();
        if (pCGen_Frame1 != null) {
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
        Utility.handleToolTipShownStateChange();
    }

    public static boolean isToolTipTextShown() {
        return toolTipTextShown;
    }

    public static void setUseFeatBenefits(boolean bl) {
        useFeatBenefits = bl;
    }

    public static final boolean isUseHigherLevelSlotsDefault() {
        return useHigherLevelSlotsDefault;
    }

    public static final void setUseHigherLevelSlotsDefault(boolean bl) {
        useHigherLevelSlotsDefault = bl;
    }

    public static void setUseWaitCursor(boolean bl) {
        useWaitCursor = bl;
        PCGen_Frame1.useWaitCursor(bl);
    }

    public static boolean getUseWaitCursor() {
        return useWaitCursor;
    }

    public static void setWantToLoadMasterworkAndMagic(boolean bl) {
        wantToLoadMasterworkAndMagic = bl;
    }

    public static void setWeaponProfPrintout(boolean bl) {
        weaponProfPrintout = bl;
    }

    public static boolean getWeaponProfPrintout() {
        return weaponProfPrintout;
    }

    public static boolean guiUsesOutputNameEquipment() {
        return guiUsesOutputNameEquipment;
    }

    public static boolean guiUsesOutputNameSpells() {
        return guiUsesOutputNameSpells;
    }

    public static boolean hasRuleCheck(String string) {
        return ruleCheckMap.containsKey(string);
    }

    public static boolean hideMonsterClasses() {
        return hideMonsterClasses;
    }

    public static void readGUIOptionsProperties() {
        SettingsHandler.setNameDisplayStyle(SettingsHandler.getPCGenOption("nameDisplayStyle", 0));
        if (Globals.javaVersionMajor >= 1 && Globals.javaVersionMinor >= 4 || !System.getProperty("os.name").substring(0, 3).equalsIgnoreCase("MAC")) {
            SettingsHandler.setToolTipTextShown(SettingsHandler.getPCGenOption("toolTipTextShown", SettingsHandler.isToolTipTextShown()));
        } else {
            SettingsHandler.setToolTipTextShown(SettingsHandler.getPCGenOption("toolTipTextShown", false));
        }
        SettingsHandler.setOpenRecentPCs(SettingsHandler.getOpenRecentOption("openRecentPCs"));
        SettingsHandler.setOpenRecentParties(SettingsHandler.getOpenRecentOption("openRecentParties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readOptionsProperties() {
        SettingsHandler.readFilePaths();
        SettingsHandler.readFilterSettings();
        String string = Globals.getOptionsPath();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            SettingsHandler.getOptions().load(fileInputStream);
        }
        catch (IOException iOException) {
            Logging.debugPrint(PropertyFactory.getString("SettingsHandler.no.options.file"));
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Logging.errorPrint(PropertyFactory.getString("SettingsHandler.can.not.close.options.file"), iOException);
            }
        }
    }

    public static String retrieveFilterSettings(String string) {
        return SettingsHandler.getFilterSettings().getProperty("pcgen.filters." + string, SettingsHandler.getOptions().getProperty("pcgen.filters." + string, ""));
    }

    public static boolean showD20Info() {
        return showD20InfoAtStart;
    }

    public static boolean allowFeatDebugging() {
        return debugFeats;
    }

    public static boolean showLicense() {
        return showOGLOnLoad;
    }

    public static boolean showMature() {
        return showMatureOnLoad;
    }

    public static boolean showSponsors() {
        return showSponsorsOnLoad;
    }

    public static boolean showNaturalWeaponTab() {
        return showNatWeaponTab;
    }

    public static void storeFilterSettings(Filterable filterable) {
        String string = filterable.getName();
        if (string == null) {
            return;
        }
        SettingsHandler.getFilterSettings().setProperty("pcgen.filters." + string + ".mode", Integer.toString(filterable.getFilterMode()));
        SettingsHandler.getFilterSettings().setProperty("pcgen.filters." + string + ".available", FilterFactory.filterListToString(filterable.getAvailableFilters()));
        SettingsHandler.getFilterSettings().setProperty("pcgen.filters." + string + ".selected", FilterFactory.filterListToString(filterable.getSelectedFilters()));
        SettingsHandler.getFilterSettings().setProperty("pcgen.filters." + string + ".removed", FilterFactory.filterListToString(filterable.getRemovedFilters()));
    }

    public static boolean useFeatBenefits() {
        return useFeatBenefits;
    }

    public static boolean wantToLoadMasterworkAndMagic() {
        return wantToLoadMasterworkAndMagic;
    }

    private static String getPropertiesFileHeader(String string) {
        return "# Emacs, this is -*- java-properties-generic -*- mode." + Constants.s_LINE_SEP + "#" + Constants.s_LINE_SEP + string + Constants.s_LINE_SEP + "# Do not edit this file manually." + Constants.s_LINE_SEP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFilePaths() {
        File file;
        Object object;
        String string = SettingsHandler.getFilePaths();
        String string2 = SettingsHandler.getPropertiesFileHeader("# filepaths.ini -- location of other .ini files set in pcgen");
        if (!(string.equals("pcgen") || string.equals("user") || string.equals("mac_user"))) {
            if (string != null) {
                SettingsHandler.setFilePaths(string);
            } else if (SettingsHandler.getPcgenFilesDir() != null) {
                SettingsHandler.setFilePaths(SettingsHandler.getPcgenFilesDir().getAbsolutePath());
            }
        }
        if (string.equals("user")) {
            object = System.getProperty("user.home") + File.separator + ".pcgen";
            file = new File((String)object);
            if (!file.exists()) {
                file.mkdir();
                Logging.errorPrint(PropertyFactory.getFormattedString("SettingsHandler.dir.does.not.exist", object));
            } else if (!file.isDirectory()) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("SettingsHandler.is.not.a.directory", object), "PCGen", MessageType.ERROR);
            }
        }
        if (string.equals("mac_user")) {
            object = Globals.defaultMacOptionsPath;
            file = new File((String)object);
            if (!file.exists()) {
                file.mkdir();
                Logging.errorPrint(PropertyFactory.getFormattedString("SettingsHandler.dir.does.not.exist", object));
            } else if (!file.isDirectory()) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("SettingsHandler.is.not.a.directory", object), "PCGen", MessageType.ERROR);
            }
        }
        object = null;
        try {
            object = new FileOutputStream(fileLocation);
            SettingsHandler.getFilepathProp().store((OutputStream)object, string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file2 = new File(fileLocation);
            if (!file2.canWrite()) {
                Logging.errorPrint(PropertyFactory.getFormattedString("SettingsHandler.filepaths.readonly", fileLocation));
            } else {
                Logging.errorPrint(PropertyFactory.getString("SettingsHandler.filepaths.write"), fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint(PropertyFactory.getString("SettingsHandler.filepaths.write"), iOException);
        }
        finally {
            try {
                if (object != null) {
                    ((FileOutputStream)object).close();
                }
            }
            catch (IOException iOException) {
                Logging.errorPrint(PropertyFactory.getString("SettingsHandler.can.not.close.filepaths.ini.write"), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOptionsProperties(PlayerCharacter playerCharacter) {
        SettingsHandler.writeFilePaths();
        SettingsHandler.writeFilterSettings();
        String string = Globals.getOptionsPath();
        String string2 = SettingsHandler.getPropertiesFileHeader("# options.ini -- options set in pcgen");
        SettingsHandler.setOptionsProperties(playerCharacter);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            SettingsHandler.getOptions().mystore(fileOutputStream, string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = new File(fileLocation);
            if (!file.canWrite()) {
                Logging.errorPrint(PropertyFactory.getFormattedString("SettingsHandler.options.ini.read.only", string));
            } else {
                Logging.errorPrint(PropertyFactory.getString("SettingsHandler.can.not.write.options.ini"), fileNotFoundException);
            }
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                Logging.errorPrint(PropertyFactory.getString("SettingsHandler.can.not.close.options.ini.write"), iOException);
            }
        }
    }

    static boolean isAutogenExoticMaterial() {
        return autogenExoticMaterial;
    }

    static boolean isAutogenMagic() {
        return autogenMagic;
    }

    static boolean isAutogenMasterwork() {
        return autogenMasterwork;
    }

    static boolean isAutogenRacial() {
        return autogenRacial;
    }

    static void setPreviewTabShown(boolean bl) {
        previewTabShown = bl;
    }

    static boolean isPreviewTabShown() {
        return previewTabShown;
    }

    private static void setAutoFeatsRefundable(boolean bl) {
        autoFeatsRefundable = bl;
    }

    private static boolean isAutoFeatsRefundable() {
        return autoFeatsRefundable;
    }

    private static void setAutogenExoticMaterial(boolean bl) {
        autogenExoticMaterial = bl;
    }

    private static void setAutogenMagic(boolean bl) {
        autogenMagic = bl;
    }

    private static void setAutogenMasterwork(boolean bl) {
        autogenMasterwork = bl;
    }

    private static void setAutogenRacial(boolean bl) {
        autogenRacial = bl;
    }

    private static Properties getFilterSettings() {
        return filterSettings;
    }

    private static void setGrimHPMode(boolean bl) {
        grimHPMode = bl;
    }

    private static boolean isGrimHPMode() {
        return grimHPMode;
    }

    private static void setGrittyACMode(boolean bl) {
        grittyACMode = bl;
    }

    private static boolean isGrittyACMode() {
        return grittyACMode;
    }

    private static void setOpenRecentOption(String string, String[] stringArray) {
        String string2 = "";
        if (stringArray.length > 0) {
            string2 = string2 + stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string2 = string2 + "|" + stringArray[i];
            }
        }
        SettingsHandler.setPCGenOption(string, string2);
    }

    private static String[] getOpenRecentOption(String string) {
        String string2 = SettingsHandler.getPCGenOption(string, "");
        if (string2 == null) {
            return Globals.EMPTY_STRING_ARRAY;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void setOpenRecentPCs(String[] stringArray) {
        PCGen_Frame1.getInst().setOpenRecentPCs(stringArray);
    }

    private static void setOpenRecentParties(String[] stringArray) {
        PCGen_Frame1.getInst().setOpenRecentParties(stringArray);
    }

    private static int getOptionTabPlacement(String string, int n) {
        int n2;
        String string2 = SettingsHandler.getPCGenOption(string, SettingsHandler.convertTabPlacementToString(n));
        try {
            n2 = Integer.parseInt(string2);
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    n2 = n;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            n2 = "TOP".equals(string2) ? 1 : ("LEFT".equals(string2) ? 2 : ("BOTTOM".equals(string2) ? 3 : ("RIGHT".equals(string2) ? 4 : n)));
        }
        return n2;
    }

    public static void setPCGenOption(String string, boolean bl) {
        SettingsHandler.setPCGenOption(string, bl ? "true" : "false");
    }

    public static void setPCGenOption(String string, double d) {
        SettingsHandler.setPCGenOption(string, String.valueOf(d));
    }

    public static boolean getPCGenOption(String string, boolean bl) {
        String string2 = SettingsHandler.getPCGenOption(string, bl ? "true" : "false");
        return "true".equalsIgnoreCase(string2);
    }

    private static Double getPCGenOption(String string, double d) {
        return new Double(SettingsHandler.getPCGenOption(string, Double.toString(d)));
    }

    private static void setPcgenThemePackDir(File file) {
        pcgenThemePackDir = file;
    }

    private static void setROG(boolean bl) {
        isROG = bl;
    }

    private static void setRanStartingWizard(boolean bl) {
        ranStartingWizard = bl;
    }

    private static void setRuleChecksInOptions(String string) {
        String string2 = "";
        for (String string3 : ruleCheckMap.keySet()) {
            String string4 = ruleCheckMap.get(string3);
            if (string2.length() == 0) {
                string2 = string3 + "|" + string4;
                continue;
            }
            string2 = string2 + "," + string3 + "|" + string4;
        }
        SettingsHandler.getOptions().setProperty("pcgen.options." + string, string2);
    }

    private static void setSaveCustomInLst(boolean bl) {
        saveCustomInLst = bl;
    }

    private static boolean isSaveCustomInLst() {
        return saveCustomInLst;
    }

    private static void setShowToolBar(boolean bl) {
        showToolBar = bl;
    }

    private static boolean isShowToolBar() {
        return showToolBar;
    }

    public static void setShowSkillModifier(boolean bl) {
        showSkillModifier = bl;
    }

    public static boolean getShowSkillModifier() {
        return showSkillModifier;
    }

    public static void setShowSkillRanks(boolean bl) {
        showSkillRanks = bl;
    }

    public static boolean getShowSkillRanks() {
        return showSkillRanks;
    }

    private static void setSpellMarketPriceAdjusted(boolean bl) {
        spellMarketPriceAdjusted = bl;
    }

    private static boolean isSpellMarketPriceAdjusted() {
        return spellMarketPriceAdjusted;
    }

    private static void setSummaryTabShown(boolean bl) {
        summaryTabShown = bl;
    }

    private static boolean isSummaryTabShown() {
        return summaryTabShown;
    }

    private static String getTmpPath() {
        return tmpPath;
    }

    private static String convertTabPlacementToString(int n) {
        switch (n) {
            case 3: {
                return "BOTTOM";
            }
            case 2: {
                return "LEFT";
            }
            case 4: {
                return "RIGHT";
            }
        }
        return "TOP";
    }

    private static String expandRelativePath(String string) {
        if (string.startsWith("@")) {
            string = System.getProperty("user.dir") + string.substring(1);
        }
        return string;
    }

    private static void parseRuleChecksFromOptions(String string) {
        if (string.length() <= 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "|");
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            ruleCheckMap.put(string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFilePaths() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileLocation);
            SettingsHandler.getFilepathProp().load(fileInputStream);
            String string = SettingsHandler.getFilePaths();
            if (string == null || string.length() < 1) {
                string = Globals.isMacPlatform ? "mac_user" : "user";
            }
            if (string.equals("pcgen")) {
                SettingsHandler.setPcgenFilesDir(new File(System.getProperty("user.dir")));
            } else if (string.equals("user")) {
                SettingsHandler.setPcgenFilesDir(new File(System.getProperty("user.home") + File.separator + ".pcgen"));
            } else if (string.equals("mac_user")) {
                SettingsHandler.setPcgenFilesDir(new File(Globals.defaultMacOptionsPath));
            } else {
                SettingsHandler.setPcgenFilesDir(new File(string));
            }
        }
        catch (IOException iOException) {
            Logging.debugPrint(PropertyFactory.getString("SettingsHandler.will.create.filepaths.ini"));
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Logging.errorPrint(PropertyFactory.getString("SettingsHandler.can.not.close.filepaths.ini"), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFilterSettings() {
        String string = Globals.getFilterPath();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            SettingsHandler.getFilterSettings().load(fileInputStream);
        }
        catch (IOException iOException) {
            Logging.debugPrint(PropertyFactory.getString("SettingsHandler.will.create.filter.ini"));
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Logging.errorPrint(PropertyFactory.getString("SettingsHandler.can.not.close.filter.ini"), iOException);
            }
        }
    }

    private static String retractRelativePath(String string) {
        File file = new File(System.getProperty("user.dir"));
        if (string.startsWith(file.getAbsolutePath())) {
            string = "@" + string.substring(file.getAbsolutePath().length());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFilterSettings() {
        String string = Globals.getFilterPath();
        String string2 = SettingsHandler.getPropertiesFileHeader("# filter.ini -- filters set in pcgen");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            SettingsHandler.getFilterSettings().store(fileOutputStream, string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = new File(fileLocation);
            if (!file.canWrite()) {
                Logging.errorPrint(PropertyFactory.getFormattedString("SettingsHandler.filter.ini.readonly", string));
            } else {
                Logging.errorPrint(PropertyFactory.getString("SettingsHandler.can.not.write.filter.ini"), fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint(PropertyFactory.getString("SettingsHandler.can.not.write.filter.ini"), iOException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                Logging.errorPrint(PropertyFactory.getString("SettingsHandler.can.not.close.filter.ini.write"), iOException);
            }
        }
        Iterator<Object> iterator = SettingsHandler.getOptions().keySet().iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).startsWith("pcgen.filters.")) continue;
            iterator.remove();
        }
    }

    public static int getWindowState() {
        return windowState;
    }

    public static void setWindowState(int n) {
        windowState = n;
    }

    public static boolean isShowMemoryArea() {
        return showMemoryArea;
    }

    public static void setShowMemoryArea(boolean bl) {
        showMemoryArea = bl;
        PCGen_Frame1.showMemoryArea(showMemoryArea);
    }

    public static boolean isShowImagePreview() {
        return showImagePreview;
    }

    public static void setShowImagePreview(boolean bl) {
        showImagePreview = bl;
    }

    public static boolean getShowSingleBoxPerBundle() {
        return showSingleBoxPerBundle;
    }

    public static void setShowSingleBoxPerBundle(boolean bl) {
        showSingleBoxPerBundle = bl;
    }

    public static boolean outputDeprecationMessages() {
        return outputDeprecationMessages;
    }

    public static void setOutputDeprecationMessages(boolean bl) {
        outputDeprecationMessages = bl;
    }

    public static boolean inputUnconstructedMessages() {
        return inputUnconstructedMessages;
    }

    public static void setInputUnconstructedMessages(boolean bl) {
        inputUnconstructedMessages = bl;
    }

    public static String getHiddenSources() {
        return hiddenSources;
    }

    public static void setHiddenSources(String string) {
        hiddenSources = string;
    }

    public static String getQuickLaunchSources() {
        return quickLaunchSources;
    }

    public static void setQuickLaunchSources(String string) {
        quickLaunchSources = string;
    }

    public static boolean useAdvancedSourceSelect() {
        return useAdvancedSourceSelect;
    }

    public static void setUseAdvancedSourceSelect(boolean bl) {
        useAdvancedSourceSelect = bl;
    }

    static {
        gearTab_IgnoreCost = false;
        gearTab_AutoResize = false;
        gearTab_AllowDebt = false;
        gearTab_SellRate = 50;
        gearTab_BuyRate = 100;
        isROG = false;
        leftUpperCorner = null;
        windowState = 0;
        loadCampaignsAtStart = false;
        loadCampaignsWithPC = false;
        looknFeel = 1;
        expertGUI = false;
        optionAllowedInSources = true;
        options = new SortedProperties();
        filepaths = new Properties();
        fileLocation = Globals.getFilepathsPath();
        pcgenFilesDir = new File(System.getProperty("user.dir"));
        pccFilesLocation = null;
        pcgPath = new File(Globals.getDefaultPath());
        lastUsedPcgPath = null;
        backupPcgPath = null;
        createPcgBackup = true;
        portraitsPath = new File(Globals.getDefaultPath());
        pcgenCustomDir = new File(Globals.getDefaultPath() + File.separator + "data" + File.separator + "customsources");
        pcgenVendorDataDir = new File(Globals.getDefaultPath() + File.separator + "vendordata");
        pcgenSponsorDir = new File(Globals.getDefaultPath() + File.separator + "system" + File.separator + "sponsors");
        pcgenDocsDir = null;
        pcgenSystemDir = new File(Globals.getDefaultPath() + File.separator + "system");
        pcgenThemePackDir = new File(Globals.getDefaultPath() + File.separator + "lib" + File.separator + "themes");
        pcgenOutputSheetDir = new File(Globals.getDefaultPath() + File.separator + "outputsheets");
        gmgenPluginDir = new File(Globals.getDefaultPath() + File.separator + "plugins");
        prereqQualifyColor = 0;
        prereqFailColor = 0xFF0000;
        previewTabShown = false;
        pcgenPreviewDir = new File(Globals.getDefaultPath() + File.separator + "preview");
        ranStartingWizard = false;
        saveCustomInLst = false;
        selectedCharacterHTMLOutputSheet = "";
        selectedCharacterPDFOutputSheet = "";
        saveOutputSheetWithPC = false;
        printSpellsWithPC = true;
        selectedPartyHTMLOutputSheet = "";
        selectedPartyPDFOutputSheet = "";
        selectedEqSetTemplate = "";
        selectedSpellSheet = "";
        showFeatDialogAtLevelUp = true;
        showHPDialogAtLevelUp = true;
        showStatDialogAtLevelUp = true;
        showToolBar = true;
        showSkillModifier = false;
        showSkillRanks = false;
        showWarningAtFirstLevelUp = true;
        skinLFThemePack = null;
        summaryTabShown = false;
        classTab_AvailableListMode = 0;
        classTab_SelectedListMode = 0;
        domainTab_ListMode = 0;
        equipTab_AvailableListMode = 2;
        equipTab_SelectedListMode = 0;
        featTab_AvailableListMode = 2;
        featTab_SelectedListMode = 1;
        gearTab_AvailableListMode = 1;
        gearTab_SelectedListMode = 2;
        raceTab_ListMode = 0;
        templateTab_ListMode = 0;
        templateSelTab_ListMode = 0;
        skillsTab_AvailableListMode = 2;
        skillsTab_SelectedListMode = 5;
        spellsTab_AvailableListMode = 0;
        spellsTab_SelectedListMode = 0;
        cleanupTempFiles = false;
        alwaysOverwrite = false;
        allowOverride = false;
        tabPlacement = 3;
        tmpPath = System.getProperty("java.io.tmpdir");
        tempPath = new File(SettingsHandler.getTmpPath());
        toolTipTextShown = true;
        useHigherLevelSlotsDefault = false;
        wantToLoadMasterworkAndMagic = false;
        nameDisplayStyle = 0;
        weaponProfPrintout = true;
        postExportCommandStandard = "";
        postExportCommandPDF = "";
        hideMonsterClasses = false;
        guiUsesOutputNameEquipment = false;
        guiUsesOutputNameSpells = false;
        singleChoicePreference = 0;
        lastTipShown = -1;
        showMemoryArea = false;
        showImagePreview = true;
        showTipOfTheDay = true;
        isGMGen = false;
        showSingleBoxPerBundle = false;
        useAdvancedSourceSelect = false;
        showNatWeaponTab = false;
        hiddenSources = "";
        quickLaunchSources = "";
        outputDeprecationMessages = true;
        inputUnconstructedMessages = true;
    }
}

