/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.util.List;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;

public final class Race
extends PObject {
    public boolean isAdvancementUnlimited() {
        List<Integer> list = this.getListFor(ListKey.HITDICE_ADVANCEMENT);
        return list == null || Integer.MAX_VALUE == list.get(list.size() - 1);
    }

    public Point2D.Double getFace() {
        BigDecimal bigDecimal = this.get(ObjectKey.FACE_WIDTH);
        BigDecimal bigDecimal2 = this.get(ObjectKey.FACE_HEIGHT);
        if (bigDecimal == null && bigDecimal2 == null) {
            return null;
        }
        return new Point2D.Double(bigDecimal.doubleValue(), bigDecimal2.doubleValue());
    }

    public String getUdam(PlayerCharacter playerCharacter) {
        int n = this.getSafe(FormulaKey.SIZE).resolve(playerCharacter, "").intValue();
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getDefaultSizeAdjustment();
        SizeAdjustment sizeAdjustment2 = SettingsHandler.getGame().getSizeAdjustmentAtIndex(n);
        if (sizeAdjustment != null && sizeAdjustment2 != null) {
            return Globals.adjustDamage("1d3", sizeAdjustment.getAbbreviation(), sizeAdjustment2.getAbbreviation());
        }
        return "1d3";
    }

    public Race clone() {
        Race race = null;
        try {
            race = (Race)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return race;
    }

    public int hashCode() {
        return this.getKeyName().hashCode();
    }

    int maxHitDiceAdvancement() {
        List<Integer> list = this.getListFor(ListKey.HITDICE_ADVANCEMENT);
        return list == null ? 0 : list.get(list.size() - 1);
    }

    int sizesAdvanced(int n) {
        List<Integer> list = this.getListFor(ListKey.HITDICE_ADVANCEMENT);
        int n2 = 0;
        if (list != null) {
            int n3 = this.maxHitDiceAdvancement();
            for (Integer n4 : list) {
                if (n <= n4) break;
                if (n4 >= n3) continue;
                ++n2;
            }
        }
        return n2;
    }

    public PObject getActiveEquivalent(PlayerCharacter playerCharacter) {
        if (playerCharacter.getRace().getKeyName().equals(this.getKeyName())) {
            return playerCharacter.getRace();
        }
        return this;
    }
}

