/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import pcgen.base.formula.Formula;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.FixedStringList;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.NamedValue;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ChooseResultActor;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.Constants;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.content.ChallengeRating;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.Gender;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.cdom.helper.AbilitySelection;
import pcgen.cdom.helper.ArmorProfProvider;
import pcgen.cdom.helper.FollowerLimit;
import pcgen.cdom.helper.ProfProvider;
import pcgen.cdom.helper.Qualifier;
import pcgen.cdom.helper.ShieldProfProvider;
import pcgen.cdom.helper.StatLock;
import pcgen.cdom.helper.WeaponProfProvider;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.inst.ObjectCache;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.AbilityList;
import pcgen.cdom.list.CompanionList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.ArmorProf;
import pcgen.core.AssociationStore;
import pcgen.core.AssociationSupport;
import pcgen.core.Campaign;
import pcgen.core.Categorisable;
import pcgen.core.CharacterDomain;
import pcgen.core.DamageReduction;
import pcgen.core.Deity;
import pcgen.core.Description;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.EquipmentUtilities;
import pcgen.core.FollowerOption;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.Movement;
import pcgen.core.NoteItem;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacterUtilities;
import pcgen.core.PointBuyMethod;
import pcgen.core.QualifiedObject;
import pcgen.core.Race;
import pcgen.core.RollingMethods;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SkillComparator;
import pcgen.core.SkillUtilities;
import pcgen.core.SpecialAbility;
import pcgen.core.StatList;
import pcgen.core.SystemCollections;
import pcgen.core.VariableContainer;
import pcgen.core.VariableProcessor;
import pcgen.core.VariableProcessorPC;
import pcgen.core.Vision;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.analysis.RaceAlignment;
import pcgen.core.analysis.RaceStat;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.analysis.SpecialAbilityResolution;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.analysis.SpellPoint;
import pcgen.core.analysis.TemplateSR;
import pcgen.core.analysis.TemplateSelect;
import pcgen.core.analysis.TemplateStat;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.util.MissingObject;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.CompanionMod;
import pcgen.core.character.EquipSet;
import pcgen.core.character.EquipSlot;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.spell.Spell;
import pcgen.core.system.GameModeRollMethod;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.ExportHandler;
import pcgen.io.PCGFile;
import pcgen.io.exporttoken.BonusToken;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.AttackType;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlayerCharacter
extends Observable
implements Cloneable,
VariableContainer,
AssociationStore {
    private static final Class<Language> LANGUAGE_CLASS = Language.class;
    public static final int ATTACKBONUS = 0;
    public static final int MONKBONUS = 4;
    private static String lastVariable = null;
    private ObjectCache cache = new ObjectCache();
    private AssociationSupport assocSupt = new AssociationSupport();
    private final ArrayList<String> miscList = new ArrayList(4);
    private final ArrayList<NoteItem> notesList = new ArrayList();
    private final ArrayList<Equipment> primaryWeapons = new ArrayList();
    private final ArrayList<Equipment> secondaryWeapons = new ArrayList();
    private final ArrayList<Skill> skillList = new ArrayList();
    private final ArrayList<SpecialAbility> specialAbilityList = new ArrayList();
    private final ArrayList<PCTemplate> templateList = new ArrayList();
    private final ArrayList<String> variableList = new ArrayList();
    private BigDecimal gold = new BigDecimal(0);
    private Deity deity = null;
    private HashMap<String, String> domainSourceMap = new HashMap();
    private List<BonusObj> activeBonusList = new ArrayList<BonusObj>();
    private final List<CharacterDomain> characterDomainList = new ArrayList<CharacterDomain>();
    private ArrayList<PCClass> classList = new ArrayList();
    private final ArrayList<CompanionMod> companionModList = new ArrayList();
    private final List<Follower> followerList = new ArrayList<Follower>();
    private HashMapToList<Class, String> qualifyArrayMap = new HashMapToList();
    private Follower followerMaster = null;
    private final List<EquipSet> equipSetList = new ArrayList<EquipSet>();
    private List<Equipment> equipmentList = new ArrayList<Equipment>();
    private List<Equipment> equipmentMasterList = new ArrayList<Equipment>();
    private Map<String, Integer> autoEquipOutputOrderCache = new HashMap<String, Integer>();
    private List<PCLevelInfo> pcLevelInfo = new ArrayList<PCLevelInfo>();
    private final List<String> spellBooks = new ArrayList<String>();
    private Map<String, SpellBook> spellBookMap = new HashMap<String, SpellBook>();
    private List<Equipment> tempBonusItemList = new ArrayList<Equipment>();
    private List<BonusObj> tempBonusList = new ArrayList<BonusObj>();
    private Set<String> tempBonusFilters = new TreeSet<String>();
    private Map<String, String> activeBonusMap = new ConcurrentHashMap<String, String>();
    private Race race = null;
    private PCClass selectedFavoredClass = null;
    private final StatList statList = new StatList(this);
    private List<Kit> kitList = null;
    private final List<Language> templateAutoLanguages = new ArrayList<Language>();
    private final SortedSet<Language> templateLanguages = new TreeSet<Language>();
    private final SortedSet<Language> languages = new TreeSet<Language>();
    private Map<StringKey, String> stringChar = new HashMap<StringKey, String>();
    private String calcEquipSetId = "0.1";
    private String descriptionLst = "EMPTY";
    private String tabName = "";
    private String gender = Globals.getAllGenders().get(0);
    private TreeSet<String> variableSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private Double[] movementMult = Globals.EMPTY_DOUBLE_ARRAY;
    private String[] movementMultOp = Globals.EMPTY_STRING_ARRAY;
    private String[] movementTypes = Globals.EMPTY_STRING_ARRAY;
    private Double[] movements = Globals.EMPTY_DOUBLE_ARRAY;
    private boolean autoKnownSpells = true;
    private boolean useHigherKnownSlots = SettingsHandler.isUseHigherLevelSlotsDefault();
    private boolean useHigherPreppedSlots = SettingsHandler.isUseHigherLevelSlotsDefault();
    private boolean autoLoadCompanion = false;
    private boolean autoSortGear = true;
    private boolean ignoreCost = SettingsHandler.getGearTab_IgnoreCost();
    private boolean allowDebt = SettingsHandler.getGearTab_AllowDebt();
    private boolean autoResize = SettingsHandler.getGearTab_AutoResize();
    private String outputSheetHTML = "";
    private String outputSheetPDF = "";
    private boolean[] ageSetKitSelections = new boolean[10];
    private boolean dirtyFlag = false;
    private int serial = 0;
    private boolean displayUpdate = false;
    private boolean importing = false;
    private boolean useTempMods = true;
    private int age = 0;
    private int alignment = 9;
    private int costPool = 0;
    private int currentEquipSetNumber = 0;
    private int earnedXP = 0;
    private int equipOutputOrder = 0;
    private int freeLangs = 0;
    private int heightInInches = 0;
    private int poolAmount = 0;
    private int skillsOutputOrder = 0;
    private int spellLevelTemp = 0;
    private int weightInPounds = 0;
    private VariableProcessor variableProcessor;
    private int pointBuyPoints = -1;
    private boolean processLevelAbilities = true;
    private DoubleKeyMap<Category<Ability>, Ability.Nature, List<Ability>> theAbilities = new DoubleKeyMap();
    private Map<Category<Ability>, List<Ability>> realAbilities = new HashMap<Category<Ability>, List<Ability>>();
    private Map<AbilityCategory, List<Ability>> virtualAbilities = new HashMap<AbilityCategory, List<Ability>>();
    private Map<AbilityCategory, BigDecimal> theUserPoolBonuses = null;
    private Set<WeaponProf> theWeaponProfs = null;
    private Map<String, WeaponProf> cachedWeaponProfs = null;
    Integer epicBAB = null;
    HashMap<Integer, Integer> epicCheckMap = new HashMap();
    private HashMapToList<CDOMObject, PCTemplate> templatesAdded = new HashMapToList();
    private Map<String, String> checkpointMap;
    private int cablInt = 1;
    private int lastCablInt = 0;
    private List<Ability> stableAggregateFeatList = null;
    private boolean aggregateFeatsStable = false;
    private boolean virtualFeatsStable = false;
    private boolean allowFeatPoolAdjustment = true;
    private double feats = 0.0;
    private boolean rebuildingAbilities = false;

    public PlayerCharacter() {
        int n;
        this.variableProcessor = new VariableProcessorPC(this);
        for (n = 0; n < 10; ++n) {
            this.ageSetKitSelections[n] = false;
        }
        Globals.setCurrentPC(this);
        int n2 = SettingsHandler.getGame().s_ATTRIBLONG.length;
        for (n = 0; n < n2; ++n) {
            PCStat pCStat = SettingsHandler.getGame().getUnmodifiableStatList().get(n);
            this.statList.addStat(pCStat.clone());
        }
        this.setRace(Globals.s_EMPTYRACE);
        this.setName("");
        this.setFeats(0.0);
        this.rollStats(SettingsHandler.getGame().getRollMethod());
        this.miscList.add("");
        this.miscList.add("");
        this.miscList.add("");
        this.miscList.add("");
        this.addSpellBook(new SpellBook(Globals.getDefaultSpellBook(), 1));
        this.addSpellBook(new SpellBook("Innate", 4));
        this.populateSkills(SettingsHandler.getSkillsTab_IncludeSkills());
        this.setStringFor(StringKey.HANDED, PropertyFactory.getString("in_right"));
    }

    public Map<String, String> getActiveBonusMap() {
        return this.activeBonusMap;
    }

    public void setAge(int n) {
        this.age = n;
        this.setDirty(true);
        this.calcActiveBonuses();
        if (!this.isImporting()) {
            Globals.getBioSet().makeKitSelectionFor(this);
        }
    }

    public int getAge() {
        return this.age;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public ArrayList<Skill> getAllSkillList(boolean bl) {
        if (!bl) {
            return this.skillList;
        }
        for (Skill skill : Globals.getContext().ref.getConstructedCDOMObjects(Skill.class)) {
            if (this.hasSkill(skill.getKeyName()) || CoreUtility.doublesEqual(skill.getSkillRankBonusTo(this), 0.0)) continue;
            this.addSkill(skill);
        }
        return this.skillList;
    }

    public List<Skill> getPartialSkillList(Visibility visibility) {
        return Globals.getObjectsOfVisibility(this.skillList, visibility);
    }

    public List<ProfProvider<ArmorProf>> getArmorProfList() {
        List<ProfProvider<ArmorProf>> list = this.cache.getListFor(ListKey.ARMORPROF_CACHE);
        if (list == null) {
            list = this.getAutoArmorProfList();
            this.cache.addAllToListFor(ListKey.ARMORPROF_CACHE, list);
        }
        return list;
    }

    public int getBaseSpellStatBonus(PCClass pCClass) {
        if (pCClass == null) {
            return 0;
        }
        int n = 0;
        PCStat pCStat = pCClass.get(ObjectKey.SPELL_STAT);
        if (pCStat != null) {
            String string = pCStat.getAbb();
            int n2 = this.getStatList().getIndexOfStatFor(string);
            if (n2 >= 0) {
                n = this.getStatList().getTotalStatFor(string);
                n += (int)this.getTotalBonusTo("STAT", "BASESPELLSTAT");
                n += (int)this.getTotalBonusTo("STAT", "BASESPELLSTAT;CLASS." + pCClass.getKeyName());
                n += (int)this.getTotalBonusTo("STAT", "CAST." + string);
                n = this.getStatList().getModForNumber(n, n2);
            }
        }
        return n;
    }

    public void setBio(String string) {
        this.setStringFor(StringKey.BIO, string);
    }

    public String getBio() {
        return this.getSafeStringFor(StringKey.BIO);
    }

    public void setBirthday(String string) {
        this.setStringFor(StringKey.BIRTHDAY, string);
    }

    public String getBirthday() {
        return this.getSafeStringFor(StringKey.BIRTHDAY);
    }

    public void setBirthplace(String string) {
        this.setStringFor(StringKey.BIRTHPLACE, string);
    }

    public String getBirthplace() {
        return this.getSafeStringFor(StringKey.BIRTHPLACE);
    }

    public void setCalcEquipSetId(String string) {
        this.calcEquipSetId = string;
        this.setDirty(true);
    }

    public String getCalcEquipSetId() {
        if (this.equipSetList.isEmpty()) {
            return this.calcEquipSetId;
        }
        if (this.getEquipSetByIdPath(this.calcEquipSetId) == null) {
            for (EquipSet equipSet : this.equipSetList) {
                if (!equipSet.getParentIdPath().equals("0")) continue;
                this.calcEquipSetId = equipSet.getIdPath();
                return this.calcEquipSetId;
            }
        }
        return this.calcEquipSetId;
    }

    public void setCalcEquipmentList() {
        this.setCalcEquipmentList(false);
    }

    public void setCalcEquipmentList(boolean bl) {
        Object object;
        String string = this.getCalcEquipSetId();
        EquipSet equipSet = this.getEquipSetByIdPath(string);
        if (equipSet == null) {
            Logging.debugPrint("No EquipSet has been selected for calculations yet.");
            return;
        }
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        this.setEquipmentList(arrayList);
        List<EquipSet> list = this.getEquipSet();
        if (list.isEmpty()) {
            return;
        }
        Collections.sort(list);
        for (EquipSet comparable : list) {
            Equipment equipment;
            object = string + ".";
            String string2 = comparable.getParentIdPath() + ".";
            if (!string2.startsWith((String)object) || (equipment = comparable.getItem()) == null) continue;
            Equipment equipment2 = comparable.getItem();
            String string3 = comparable.getName();
            String string4 = comparable.getNote();
            Float f = comparable.getQty();
            StringTokenizer stringTokenizer = new StringTokenizer(comparable.getIdPath(), ".");
            if (stringTokenizer.countTokens() > 3) {
                equipment2.setLocation(7);
                equipment2.setIsEquipped(false, this);
                equipment2.setNumberCarried(f);
                equipment2.setQty(f);
            } else if (string3.startsWith("Carried")) {
                equipment2.setLocation(6);
                equipment2.setIsEquipped(false, this);
                equipment2.setNumberCarried(f);
                equipment2.setQty(f);
            } else if (string3.startsWith("Not Carried")) {
                equipment2.setLocation(8);
                equipment2.setIsEquipped(false, this);
                equipment2.setNumberCarried(Float.valueOf(0.0f));
                equipment2.setQty(f);
            } else if (equipment2.isWeapon()) {
                if (string3.equals("Primary Hand") || string3.equals("Natural-Primary")) {
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(f.intValue());
                    equipment2.setLocation(1);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.startsWith("Secondary Hand") || string3.equals("Natural-Secondary")) {
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(f.intValue());
                    equipment2.setLocation(2);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.equals("Both Hands")) {
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(f.intValue());
                    equipment2.setLocation(3);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.equals("Double Weapon")) {
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(2);
                    equipment2.setLocation(4);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.equals("Unarmed")) {
                    equipment2.setLocation(0);
                    equipment2.setNumberEquipped(f.intValue());
                } else if (string3.equals("Two Weapons")) {
                    if (f.doubleValue() < 2.0) {
                        f = new Float(2.0);
                    }
                    comparable.setQty(f);
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    equipment2.setNumberEquipped(2);
                    equipment2.setLocation(4);
                    equipment2.setIsEquipped(true, this);
                } else if (string3.equals("Shield")) {
                    equipment2.setLocation(0);
                    equipment2.setNumberEquipped(f.intValue());
                }
            } else {
                equipment2.setLocation(0);
                equipment2.setIsEquipped(true, this);
                equipment2.setNumberCarried(f);
                equipment2.setQty(f);
            }
            if (string4 != null && string4.length() > 0) {
                equipment2.setNote(string4);
            }
            this.addLocalEquipment(equipment2);
        }
        for (Equipment equipment : this.getEquipmentList()) {
            if (equipment.isContainer()) {
                equipment.updateContainerContentsString(this);
            }
            if ((object = this.getEquipmentNamed(equipment.getName())) == null) continue;
            equipment.setOutputIndex(((Equipment)object).getOutputIndex());
        }
        if (bl) {
            for (Equipment equipment : this.getTempBonusItemList()) {
                object = this.getEquipmentNamed(equipment.getName(), this.getEquipmentList());
                if (object == null) continue;
                equipment.setQty(((Equipment)object).getQty());
                equipment.setNumberCarried(((Equipment)object).getCarried());
                if (((Equipment)object).isEquipped()) {
                    if (equipment.isWeapon()) {
                        equipment.put(IntegerKey.SLOTS, 0);
                        equipment.put(ObjectKey.CURRENT_COST, BigDecimal.ZERO);
                        equipment.put(ObjectKey.WEIGHT, BigDecimal.ZERO);
                        equipment.setLocation(((Equipment)object).getLocation());
                    } else {
                        equipment.setLocation(((Equipment)object).getLocation());
                        this.removeLocalEquipment((Equipment)object);
                        ((Equipment)object).setIsEquipped(false, this);
                        ((Equipment)object).setLocation(8);
                        ((Equipment)object).setNumberCarried(Float.valueOf(0.0f));
                    }
                    equipment.setIsEquipped(true, this);
                    equipment.setNumberEquipped(1);
                } else {
                    equipment.put(ObjectKey.CURRENT_COST, BigDecimal.ZERO);
                    equipment.put(ObjectKey.WEIGHT, BigDecimal.ZERO);
                    equipment.setLocation(5);
                    equipment.setIsEquipped(false, this);
                }
                equipment.addType(Type.TEMPORARY);
                this.addLocalEquipment(equipment);
            }
        }
    }

    public void setCalcFollowerBonus(PlayerCharacter playerCharacter) {
        this.setDirty(true);
        for (Follower follower : this.getFollowerList()) {
            CompanionList companionList = follower.getType();
            String string = companionList.getKeyName();
            String string2 = follower.getRace().toUpperCase();
            for (CompanionMod companionMod : Globals.getCompanionMods(companionList)) {
                String string3 = companionMod.getType();
                int n = companionMod.getLevel(string2);
                if (!string3.equalsIgnoreCase(string) || n != 1) continue;
                this.addCompanionMod(companionMod);
                companionMod.activateBonuses(playerCharacter);
            }
        }
    }

    public void addCompanionMod(CompanionMod companionMod) {
        this.companionModList.add(companionMod);
    }

    public void setCatchPhrase(String string) {
        this.setStringFor(StringKey.CATCH_PHRASE, string);
    }

    public String getCatchPhrase() {
        return this.getSafeStringFor(StringKey.CATCH_PHRASE);
    }

    public PCClass getClassKeyed(String string) {
        if (string == null || string.equals("None")) {
            return null;
        }
        for (PCClass pCClass : this.classList) {
            if (!pCClass.getKeyName().equalsIgnoreCase(string) && !pCClass.getSubClassKey().equalsIgnoreCase(string)) continue;
            return pCClass;
        }
        return null;
    }

    public ArrayList<PCClass> getClassList() {
        return this.classList;
    }

    public void setCostPool(int n) {
        this.costPool = n;
    }

    public int getCostPool() {
        return this.costPool;
    }

    @Deprecated
    public List<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.race != null) {
            arrayList.add(this.race.getType());
        } else {
            arrayList.add("Humanoid");
        }
        for (PCTemplate pCTemplate : this.templateList) {
            arrayList.add(pCTemplate.getType());
        }
        return arrayList;
    }

    @Deprecated
    public String getCritterType() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.race != null) {
            stringBuffer.append(this.race.getType());
        } else {
            stringBuffer.append("Humanoid");
        }
        if (!this.templateList.isEmpty()) {
            for (PCTemplate pCTemplate : this.templateList) {
                String string = pCTemplate.getType();
                if ("".equals(string)) continue;
                stringBuffer.append('|').append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getRaceType() {
        RaceType raceType;
        Iterator<PCTemplate> iterator;
        String string = "None";
        if (this.race != null && (iterator = this.race.get(ObjectKey.RACETYPE)) != null) {
            string = ((RaceType)((Object)iterator)).toString();
        }
        if (!this.companionModList.isEmpty()) {
            for (CompanionMod pObject : this.companionModList) {
                raceType = pObject.get(ObjectKey.RACETYPE);
                if (raceType == null) continue;
                string = raceType.toString();
            }
        }
        if (!this.templateList.isEmpty()) {
            for (PCTemplate pCTemplate : this.templateList) {
                raceType = pCTemplate.get(ObjectKey.RACETYPE);
                if (raceType == null) continue;
                string = raceType.toString();
            }
        }
        return string;
    }

    public Collection<String> getRacialSubTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (RaceSubType object2 : this.race.getSafeListFor(ListKey.RACESUBTYPE)) {
            arrayList.add(object2.toString());
        }
        if (!this.templateList.isEmpty()) {
            ArrayList arrayList2 = new ArrayList();
            ArrayList<RaceSubType> arrayList3 = new ArrayList<RaceSubType>();
            for (PCTemplate pCTemplate : this.templateList) {
                arrayList2.addAll(pCTemplate.getSafeListFor(ListKey.RACESUBTYPE));
                arrayList3.addAll(pCTemplate.getSafeListFor(ListKey.REMOVED_RACESUBTYPE));
            }
            Iterator<PCTemplate> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                RaceSubType raceSubType = (RaceSubType)((Object)iterator.next());
                arrayList.add(raceSubType.toString());
            }
            for (RaceSubType raceSubType : arrayList3) {
                arrayList.remove(raceSubType.toString());
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setCurrentEquipSetName(String string) {
        this.setStringFor(StringKey.CURRENT_EQUIP_SET_NAME, string);
    }

    public String getCurrentEquipSetName() {
        return this.getSafeStringFor(StringKey.CURRENT_EQUIP_SET_NAME);
    }

    public Deity getDeity() {
        return this.deity;
    }

    public void setDescription(String string) {
        this.setStringFor(StringKey.DESCRIPTION, string);
    }

    public String getDescription() {
        return this.getSafeStringFor(StringKey.DESCRIPTION);
    }

    public String getDescriptionLst() {
        return this.descriptionLst;
    }

    public void setDirty(boolean bl) {
        if (bl) {
            this.cachedWeaponProfs = null;
            ++this.serial;
            this.cache = new ObjectCache();
            this.getVariableProcessor().setSerial(this.serial);
            this.setAggregateAbilitiesStable(null, false);
        }
        if (this.dirtyFlag != bl) {
            this.dirtyFlag = bl;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public int getSerial() {
        return this.serial;
    }

    public String getDisplayName() {
        String string = this.getTabName();
        if (!"".equals(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer().append(this.getName());
        switch (SettingsHandler.getNameDisplayStyle()) {
            case 0: {
                break;
            }
            case 1: {
                stringBuffer.append(" the ").append(this.getDisplayClassName());
                break;
            }
            case 2: {
                stringBuffer.append(" the ").append(this.getDisplayRaceName());
                break;
            }
            case 3: {
                stringBuffer.append(" the ").append(this.getDisplayRaceName()).append(' ').append(this.getDisplayClassName());
                break;
            }
            case 4: {
                return this.getFullDisplayName();
            }
        }
        return stringBuffer.toString();
    }

    public void setDisplayUpdate(boolean bl) {
        this.displayUpdate = bl;
    }

    public boolean isDisplayUpdate() {
        return this.displayUpdate;
    }

    public List<EquipSet> getEquipSet() {
        return this.equipSetList;
    }

    public EquipSet getEquipSetByIdPath(String string) {
        if (this.equipSetList.isEmpty()) {
            return null;
        }
        for (EquipSet equipSet : this.equipSetList) {
            if (!equipSet.getIdPath().equals(string)) continue;
            return equipSet;
        }
        return null;
    }

    public EquipSet getEquipSetByName(String string) {
        if (this.equipSetList.isEmpty()) {
            return null;
        }
        for (EquipSet equipSet : this.equipSetList) {
            if (!equipSet.getName().equals(string)) continue;
            return equipSet;
        }
        return null;
    }

    public void setEquipSetNumber(int n) {
        this.currentEquipSetNumber = n;
        this.setDirty(true);
    }

    public int getEquipSetNumber() {
        return this.currentEquipSetNumber;
    }

    public double getEquipSetWeightDouble(String string) {
        if (this.equipSetList.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (EquipSet equipSet : this.equipSetList) {
            Equipment equipment;
            String string2 = string + ".";
            String string3 = equipSet.getIdPath() + ".";
            if (!string3.startsWith(string2) || (equipment = equipSet.getItem()) == null || !(equipment.getCarried().floatValue() > 0.0f) || equipment.getParent() != null) continue;
            if (equipment.getChildCount() > 0) {
                d += equipment.getWeightAsDouble(this) + (double)equipment.getContainedWeight(this).floatValue();
                continue;
            }
            d += equipment.getWeightAsDouble(this) * (double)equipment.getCarried().floatValue();
        }
        return d;
    }

    public Float getEquipSetCount(String string, String string2) {
        float f = 0.0f;
        for (EquipSet equipSet : this.getEquipSet()) {
            String string3;
            String string4 = equipSet.getIdPath() + ".";
            if (!string4.startsWith(string3 = string + ".") || !equipSet.getValue().equals(string2)) continue;
            f += equipSet.getQty().floatValue();
        }
        return Float.valueOf(f);
    }

    public void setEquipmentList(List<Equipment> list) {
        this.equipmentList = list;
    }

    public List<Equipment> getEquipmentList() {
        return this.equipmentList;
    }

    public List<Equipment> getEquipmentListInOutputOrder() {
        return this.sortEquipmentList(this.getEquipmentList());
    }

    public List<Equipment> getEquipmentListInOutputOrder(int n) {
        return this.sortEquipmentList(this.getEquipmentList(), n);
    }

    private List<Equipment> getAutoEquipmentList() {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            Object object;
            for (CDOMObject cDOMObject2 : this.getCDOMObjectList()) {
                object = this.getAssocList(cDOMObject2, AssociationListKey.EQUIPMENT);
                if (object == null) continue;
                arrayList.addAll((Collection<Equipment>)object);
            }
            List<QualifiedObject<CDOMReference<Equipment>>> list = cDOMObject.getSafeListFor(ListKey.EQUIPMENT);
            Iterator object22 = list.iterator();
            while (object22.hasNext()) {
                object = (QualifiedObject)object22.next();
                CDOMReference cDOMReference = (CDOMReference)((QualifiedObject)object).getObject(this);
                if (cDOMReference == null) continue;
                for (Equipment equipment : cDOMReference.getContainedObjects()) {
                    equipment = equipment.clone();
                    equipment.setQty(1.0);
                    equipment.setAutomatic(true);
                    arrayList.add(equipment);
                }
            }
        }
        return arrayList;
    }

    public List<Equipment> getEquipmentMasterList() {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>(this.equipmentMasterList);
        arrayList.addAll(this.getAutoEquipmentList());
        return arrayList;
    }

    public List<Equipment> getEquipmentMasterListInOutputOrder() {
        List<Equipment> list = this.getEquipmentMasterList();
        Collections.sort(list, CoreUtility.equipmentComparator);
        return list;
    }

    public Equipment getEquipmentNamed(String string, List<Equipment> list) {
        Equipment equipment = null;
        for (Equipment equipment2 : list) {
            if (!string.equalsIgnoreCase(equipment2.getName())) continue;
            equipment = equipment2;
        }
        return equipment;
    }

    public void setEyeColor(String string) {
        this.setStringFor(StringKey.EYE_COLOR, string);
    }

    public String getEyeColor() {
        return this.getSafeStringFor(StringKey.EYE_COLOR);
    }

    private double getBonusFeatPool() {
        String string = Globals.getBonusFeatString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        double d = this.getTotalBonusTo("FEAT", "POOL");
        double d2 = this.getTotalBonusTo("FEAT", "PCPOOL");
        double d3 = this.getTotalBonusTo("FEAT", "MONSTERPOOL");
        double d4 = this.getTotalBonusTo("ABILITYPOOL", "FEAT");
        double d5 = this.getNumFeatsFromLevels();
        Logging.debugPrint("");
        Logging.debugPrint("==============");
        Logging.debugPrint("level " + this.getTotalPlayerLevels());
        Logging.debugPrint("POOL:   " + d);
        Logging.debugPrint("PCPOOL: " + d2);
        Logging.debugPrint("MPOOL:  " + d3);
        Logging.debugPrint("APOOL:  " + d4);
        Logging.debugPrint("LVLBONUS:  " + d5);
        double d6 = n2 == 0 ? 0.0 : (double)(n / n2);
        d += Math.floor(this.getTotalCharacterLevel() >= n ? 1.0 + d2 - d6 + 1.0E-4 : d2 + 1.0E-4);
        d += Math.floor(d3 + 1.0E-4);
        d += Math.floor(d4 + 1.0E-4);
        Logging.debugPrint("");
        Logging.debugPrint("Total Bonus: " + (d += Math.floor(d5 + 1.0E-4)));
        Logging.debugPrint("==============");
        Logging.debugPrint("");
        return d;
    }

    double getNumFeatsFromLevels() {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (PCClass pCClass : this.getClassList()) {
            int n = pCClass.getSafe(IntegerKey.LEVELS_PER_FEAT);
            if (n == 0) continue;
            double d = (double)pCClass.getLevel() / (double)n;
            Double d2 = (Double)hashMap.get(pCClass.get(StringKey.LEVEL_TYPE));
            if (d2 == null) {
                d2 = 0.0;
            }
            d2 = d2 + d;
            hashMap.put(pCClass.get(StringKey.LEVEL_TYPE), d2);
        }
        double d = 0.0;
        for (String string : hashMap.keySet()) {
            Double d3 = (Double)hashMap.get(string);
            d += Math.floor(d3 + 1.0E-4);
        }
        return d;
    }

    public boolean canLevelUp() {
        return !SettingsHandler.getEnforceSpendingBeforeLevelUp() || this.getSkillPoints() <= 0 && !(this.getFeats() > 0.0);
    }

    public void setFileName(String string) {
        this.setStringFor(StringKey.FILE_NAME, string);
    }

    public String getFileName() {
        return this.getSafeStringFor(StringKey.FILE_NAME);
    }

    public List<Follower> getFollowerList() {
        return this.followerList;
    }

    public String getFullDisplayName() {
        int n = this.getTotalLevels();
        return new StringBuffer().append(this.getName()).append(" the ").append(n).append(this.getOrdinal(n)).append(" level ").append(this.getDisplayRaceName()).append(' ').append(this.classList.size() < 2 ? this.getDisplayClassName() : this.getFullDisplayClassName()).toString();
    }

    public String getFullRegion() {
        String string = this.getSubRegion();
        StringBuffer stringBuffer = new StringBuffer().append(this.getRegion());
        if (!string.equals("None")) {
            stringBuffer.append(" (").append(string).append(')');
        }
        return stringBuffer.toString();
    }

    public void setGender(String string) {
        Gender gender = this.findTemplateGender();
        this.gender = gender == null ? string : gender.toString();
        this.setDirty(true);
    }

    public String getGender() {
        Gender gender = this.findTemplateGender();
        return gender == null ? this.gender : gender.toString();
    }

    public boolean canSetGender() {
        return this.findTemplateGender() == null;
    }

    public void setGold(String string) {
        this.gold = new BigDecimal(string);
        this.setDirty(true);
    }

    public BigDecimal getGold() {
        return this.gold;
    }

    public void setHairColor(String string) {
        this.setStringFor(StringKey.HAIR_COLOR, string);
    }

    public String getHairColor() {
        return this.getSafeStringFor(StringKey.HAIR_COLOR);
    }

    public void setHairStyle(String string) {
        this.setStringFor(StringKey.HAIR_STYLE, string);
    }

    public String getHairStyle() {
        return this.getSafeStringFor(StringKey.HAIR_STYLE);
    }

    public void setHanded(String string) {
        this.setStringFor(StringKey.HANDED, string);
    }

    public String getHanded() {
        return this.getSafeStringFor(StringKey.HANDED);
    }

    public void setHeight(int n) {
        this.heightInInches = n;
        this.setDirty(true);
    }

    public int getHeight() {
        return this.heightInInches;
    }

    public void setImporting(boolean bl) {
        this.importing = bl;
    }

    public void setInterests(String string) {
        this.setStringFor(StringKey.INTERESTS, string);
    }

    public String getInterests() {
        return this.getSafeStringFor(StringKey.INTERESTS);
    }

    public SortedSet<Language> getLanguagesList() {
        return Collections.unmodifiableSortedSet(this.languages);
    }

    public void clearLanguages() {
        this.languages.clear();
    }

    public void addLanguages(Collection<Language> collection) {
        this.languages.addAll(collection);
    }

    public String getLanguagesListNames() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Language language : this.languages) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(language.toString());
        }
        return stringBuffer.toString();
    }

    public void setLocation(String string) {
        this.setStringFor(StringKey.LOCATION, string);
    }

    public String getLocation() {
        return this.getSafeStringFor(StringKey.LOCATION);
    }

    public int getEffectiveCompanionLevel(CompanionList companionList) {
        Collection<CompanionMod> collection = Globals.getCompanionMods(companionList);
        for (CompanionMod companionMod : collection) {
            Map<String, Integer> map = companionMod.getMapFor(MapKey.APPLIED_VARIABLE);
            for (String string : map.keySet()) {
                int n = this.getVariableValue(string, "").intValue();
                if (n <= 0) continue;
                return n;
            }
            Map<CDOMSingleRef<? extends PCClass>, Integer> map2 = companionMod.getMapFor(MapKey.APPLIED_CLASS);
            for (Map.Entry entry : map2.entrySet()) {
                PCClass pCClass = (PCClass)((CDOMSingleRef)entry.getKey()).resolvesTo();
                String string = pCClass.getKeyName();
                int n = this.getClassKeyed(string).getLevel();
                if (n <= 0) continue;
                return n;
            }
        }
        return 0;
    }

    public void clearCompanionMods() {
        this.companionModList.clear();
    }

    public void setMaster(Follower follower) {
        this.followerMaster = follower;
        PlayerCharacter playerCharacter = this.getMasterPC();
        if (playerCharacter == null) {
            return;
        }
        if (!follower.getFileName().equals(playerCharacter.getFileName())) {
            follower.setFileName(playerCharacter.getFileName());
            this.setDirty(true);
        }
        if (!follower.getName().equals(playerCharacter.getName())) {
            follower.setName(playerCharacter.getName());
            this.setDirty(true);
        }
        int n = 0;
        int n2 = 0;
        for (PCClass cloneable22 : playerCharacter.getClassList()) {
            boolean levelCommandFactory = false;
            for (CompanionMod companionMod : Globals.getCompanionMods(follower.getType())) {
                if (companionMod.getLevel(cloneable22.getKeyName()) <= 0 || levelCommandFactory) continue;
                n += cloneable22.getLevel();
                levelCommandFactory = true;
            }
        }
        ArrayList<CompanionMod> arrayList = new ArrayList<CompanionMod>(this.companionModList);
        ArrayList<CompanionMod> arrayList2 = new ArrayList<CompanionMod>();
        this.clearCompanionMods();
        for (CompanionMod companionMod : Globals.getCompanionMods(follower.getType())) {
            int n3;
            for (PCClass pCClass : playerCharacter.getClassList()) {
                int n4 = pCClass.getLevel() + follower.getAdjustment();
                n3 = companionMod.getLevel(pCClass.getKeyName());
                if (n3 < 0 || n3 > n4 && n3 > n || !PrereqHandler.passesAll(companionMod.getPrerequisiteList(), this, companionMod)) continue;
                if (!arrayList.contains(companionMod)) {
                    arrayList2.add(companionMod);
                }
                this.addCompanionMod(companionMod);
                n2 += companionMod.getSafe(IntegerKey.HIT_DIE);
            }
            Map<String, Integer> map = companionMod.getMapFor(MapKey.APPLIED_VARIABLE);
            for (String string : map.keySet()) {
                n3 = playerCharacter.getVariableValue(string, "").intValue() + follower.getAdjustment();
                if (n3 < companionMod.getLevel(string) || !PrereqHandler.passesAll(companionMod.getPrerequisiteList(), this, companionMod)) continue;
                if (!arrayList.contains(companionMod)) {
                    arrayList2.add(companionMod);
                }
                this.addCompanionMod(companionMod);
                n2 += companionMod.getSafe(IntegerKey.HIT_DIE);
            }
        }
        LevelCommandFactory levelCommandFactory = this.race.get(ObjectKey.MONSTER_CLASS);
        int n5 = this.followerMaster.getUsedHD();
        if (levelCommandFactory != null && (n2 -= n5) != 0) {
            this.incrementClassLevel(n2, levelCommandFactory.getPCClass(), true);
            this.followerMaster.setUsedHD(n2 + n5);
            this.setDirty(true);
        }
        if (this.getUseMasterSkill()) {
            ArrayList<Skill> arrayList3 = playerCharacter.getSkillList();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            for (Skill skill : this.getAllSkillList(true)) {
                for (Skill skill2 : arrayList3) {
                    if (skill2.getKeyName().equals(skill.getKeyName()) && SkillRankControl.getRank(playerCharacter, skill2).intValue() > SkillRankControl.getRank(this, skill).intValue()) {
                        SkillRankControl.setZeroRanks(levelCommandFactory == null ? null : levelCommandFactory.getPCClass(), this, skill);
                        SkillRankControl.modRanks(SkillRankControl.getRank(playerCharacter, skill2).doubleValue(), null, true, this, skill);
                    }
                    if (this.hasSkill(skill2.getKeyName()) || arrayList4.contains(skill2.getKeyName())) continue;
                    arrayList4.add(skill2.getKeyName());
                }
            }
            for (String string : arrayList4) {
                Iterator<PCTemplate> iterator = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string).clone();
                double d = SkillRankControl.getRank(playerCharacter, playerCharacter.getSkillKeyed(string)).doubleValue();
                if (((CDOMObject)((Object)iterator)).getSafe(StringKey.CHOICE_STRING) != null && ((CDOMObject)((Object)iterator)).getSafe(StringKey.CHOICE_STRING).length() > 0) continue;
                SkillRankControl.modRanks(d, null, true, this, iterator);
                this.getSkillList().add((Skill)((Object)iterator));
            }
        }
        if (this.getEquipSet().size() == 0) {
            String string = this.getNewIdPath(null);
            EquipSet equipSet = new EquipSet(string, PropertyFactory.getString("in_ieDefault"));
            this.addEquipSet(equipSet);
        }
        arrayList.removeAll(this.companionModList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CompanionMod companionMod = (CompanionMod)iterator.next();
            companionMod.removeAdds(this);
        }
        for (CompanionMod companionMod : arrayList2) {
            companionMod.addAdds(this);
            for (CDOMReference<PCTemplate> cDOMReference : companionMod.getSafeListFor(ListKey.TEMPLATE)) {
                for (PCTemplate pCTemplate : cDOMReference.getContainedObjects()) {
                    this.addTemplate(pCTemplate);
                }
            }
            for (CDOMReference<PCTemplate> cDOMReference : companionMod.getSafeListFor(ListKey.REMOVE_TEMPLATES)) {
                for (PCTemplate pCTemplate : cDOMReference.getContainedObjects()) {
                    this.removeTemplate(pCTemplate);
                }
            }
            for (TransitionChoice transitionChoice : companionMod.getSafeListFor(ListKey.KIT_CHOICE)) {
                transitionChoice.act(transitionChoice.driveChoice(this), companionMod, this);
            }
        }
        this.setDirty(true);
    }

    public int getMaxFollowers(CompanionList companionList) {
        int n = -1;
        List<? extends CDOMObject> list = this.getCDOMObjectList();
        for (CDOMObject object : list) {
            List<FollowerLimit> list2 = object.getListFor(ListKey.FOLLOWERS);
            if (list2 == null) continue;
            for (FollowerLimit followerLimit : list2) {
                if (!followerLimit.getCompanionList().resolvesTo().equals(companionList)) continue;
                int n2 = followerLimit.getValue().resolve(this, "").intValue();
                n = Math.max(n, n2);
            }
        }
        String string = companionList.getKeyName();
        if (n == -1) {
            for (CompanionMod companionMod : Globals.getCompanionMods(companionList)) {
                Object object2;
                Map<String, Integer> map = companionMod.getMapFor(MapKey.APPLIED_VARIABLE);
                for (Object object2 : map.keySet()) {
                    if (this.getVariableValue((String)object2, "").intValue() <= 0) continue;
                    return -1;
                }
                Map<CDOMSingleRef<? extends PCClass>, Integer> map2 = companionMod.getMapFor(MapKey.APPLIED_CLASS);
                object2 = map2.entrySet().iterator();
                while (object2.hasNext()) {
                    Map.Entry entry = (Map.Entry)object2.next();
                    PCClass pCClass = (PCClass)((CDOMSingleRef)entry.getKey()).resolvesTo();
                    String string2 = pCClass.getKeyName();
                    for (PCClass pCClass2 : this.getClassList()) {
                        if (!pCClass2.getKeyName().equals(string2)) continue;
                        return (Integer)entry.getValue();
                    }
                }
            }
            return 0;
        }
        n = (int)((double)n + this.getTotalBonusTo("FOLLOWERS", string.toUpperCase()));
        return n;
    }

    public List<FollowerOption> getAvailableFollowers(String string) {
        ArrayList<FollowerOption> arrayList = new ArrayList<FollowerOption>();
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            List<FollowerOption> list = cDOMObject.getListFor(ListKey.COMPANIONLIST);
            if (list == null) continue;
            for (FollowerOption followerOption : list) {
                if (!followerOption.getListRef().getName().equalsIgnoreCase(string)) continue;
                arrayList.addAll(followerOption.getExpandedOptions());
            }
        }
        return arrayList;
    }

    public Follower getMaster() {
        return this.followerMaster;
    }

    public PlayerCharacter getMasterPC() {
        if (this.followerMaster == null) {
            return null;
        }
        for (PlayerCharacter playerCharacter : Globals.getPCList()) {
            if (!this.followerMaster.getFileName().equals(playerCharacter.getFileName())) continue;
            return playerCharacter;
        }
        for (PlayerCharacter playerCharacter : Globals.getPCList()) {
            if (!this.followerMaster.getName().equals(playerCharacter.getName())) continue;
            return playerCharacter;
        }
        return null;
    }

    public void setName(String string) {
        this.setStringFor(StringKey.NAME, string);
    }

    public String getName() {
        return this.getSafeStringFor(StringKey.NAME);
    }

    public List<String> getNamedTempBonusList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BonusObj bonusObj : this.getTempBonusList()) {
            String string;
            CDOMObject cDOMObject;
            if (bonusObj == null || !bonusObj.isApplied() || (cDOMObject = (CDOMObject)bonusObj.getCreatorObject()) == null || arrayList.contains(string = cDOMObject.getKeyName())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getNamedTempBonusDescList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BonusObj bonusObj : this.getTempBonusList()) {
            String string;
            CDOMObject cDOMObject;
            if (bonusObj == null || !bonusObj.isApplied() || (cDOMObject = (CDOMObject)bonusObj.getCreatorObject()) == null || arrayList.contains(string = cDOMObject.getSafe(StringKey.DESCRIPTION))) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public int getNonProficiencyPenalty() {
        int n = Globals.getGameModeNonProfPenalty();
        for (PCTemplate pCTemplate : this.templateList) {
            Integer n2 = pCTemplate.get(IntegerKey.NONPP);
            if (n2 == null) continue;
            n = n2;
        }
        return n;
    }

    public ArrayList<NoteItem> getNotesList() {
        return this.notesList;
    }

    public void setPhobias(String string) {
        this.setStringFor(StringKey.PHOBIAS, string);
    }

    public String getPhobias() {
        return this.getSafeStringFor(StringKey.PHOBIAS);
    }

    public void setPlayersName(String string) {
        this.setStringFor(StringKey.PLAYERS_NAME, string);
    }

    public String getPlayersName() {
        return this.getSafeStringFor(StringKey.PLAYERS_NAME);
    }

    public void setPoolAmount(int n) {
        this.poolAmount = n;
    }

    public int getPoolAmount() {
        return this.poolAmount;
    }

    public void setPortraitPath(String string) {
        this.setStringFor(StringKey.PORTRAIT_PATH, string);
    }

    public String getPortraitPath() {
        return this.getSafeStringFor(StringKey.PORTRAIT_PATH);
    }

    public List<Equipment> getPrimaryWeapons() {
        return this.primaryWeapons;
    }

    public Race getRace() {
        return this.race;
    }

    public void setRegion(String string) {
        this.setStringFor(StringKey.REGION, string);
    }

    public void setSubRegion(String string) {
        this.setStringFor(StringKey.SUB_REGION, string);
    }

    public String getRegion() {
        return this.getRegion(true);
    }

    public String getRegion(boolean bl) {
        String string = this.getStringFor(StringKey.REGION);
        if (string != null || !bl) {
            return string;
        }
        String string2 = "None";
        int n = this.templateList.size();
        for (int i = 0; i < n; ++i) {
            PCTemplate pCTemplate = this.templateList.get(i);
            String string3 = pCTemplate.getRegion();
            if (string3.equals("None")) continue;
            string2 = string3;
        }
        return string2;
    }

    public void setResidence(String string) {
        this.setStringFor(StringKey.RESIDENCE, string);
    }

    public String getResidence() {
        return this.getSafeStringFor(StringKey.RESIDENCE);
    }

    public List<Equipment> getSecondaryWeapons() {
        return this.secondaryWeapons;
    }

    public void setSelectedCharacterHTMLOutputSheet(String string) {
        this.outputSheetHTML = string;
    }

    public String getSelectedCharacterHTMLOutputSheet() {
        return this.outputSheetHTML;
    }

    public void setSelectedCharacterPDFOutputSheet(String string) {
        this.outputSheetPDF = string;
    }

    public String getSelectedCharacterPDFOutputSheet() {
        return this.outputSheetPDF;
    }

    public List<ProfProvider<ShieldProf>> getShieldProfList() {
        List<ProfProvider<ShieldProf>> list = this.cache.getListFor(ListKey.SHIELDPROF_CACHE);
        if (list == null) {
            list = this.getAutoShieldProfList();
            this.cache.addAllToListFor(ListKey.SHIELDPROF_CACHE, list);
        }
        return list;
    }

    public String getSize() {
        SizeAdjustment sizeAdjustment = this.getSizeAdjustment();
        if (sizeAdjustment != null) {
            return sizeAdjustment.getAbbreviation();
        }
        return " ";
    }

    public ArrayList<Skill> getSkillList() {
        return this.getAllSkillList(false);
    }

    public List<Skill> getSkillListInOutputOrder() {
        return this.getSkillListInOutputOrder(new ArrayList<Skill>(this.getSkillList()));
    }

    public List<Skill> getSkillListInOutputOrder(List<Skill> list) {
        final PlayerCharacter playerCharacter = this;
        Collections.sort(list, new Comparator<Skill>(){

            @Override
            public int compare(Skill skill, Skill skill2) {
                Integer n = playerCharacter.getAssoc(skill, AssociationKey.OUTPUT_INDEX);
                Integer n2 = playerCharacter.getAssoc(skill2, AssociationKey.OUTPUT_INDEX);
                if (n == null || n == 0) {
                    n = 999;
                }
                if (n2 == null || n2 == 0) {
                    n2 = 999;
                }
                if (n > n2) {
                    return 1;
                }
                if (n < n2) {
                    return -1;
                }
                return skill.getOutputName().compareToIgnoreCase(skill2.getOutputName());
            }
        });
        Iterator<Skill> iterator = list.iterator();
        while (iterator.hasNext()) {
            Skill skill = iterator.next();
            Visibility visibility = skill.getSafe(ObjectKey.VISIBILITY);
            Integer n = this.getAssoc(skill, AssociationKey.OUTPUT_INDEX);
            if ((n == null || n != -1) && !visibility.equals((Object)Visibility.HIDDEN) && !visibility.equals((Object)Visibility.DISPLAY_ONLY)) continue;
            iterator.remove();
        }
        return list;
    }

    public void setSkillPoints(int n) {
        this.setDirty(true);
    }

    public int getSkillPoints() {
        int n = 0;
        for (PCLevelInfo object2 : this.getLevelInfo()) {
            n += object2.getSkillPointsGained();
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            List<NamedValue> list = this.getAssocList(skill, AssociationListKey.SKILL_RANK);
            if (list == null) continue;
            for (NamedValue namedValue : list) {
                PCClass pCClass = this.getClassKeyed(namedValue.name);
                if (pCClass == null) continue;
                double d = namedValue.getWeight();
                int n2 = this.getSkillCostForClass(skill, pCClass).getCost();
                n -= (int)((double)n2 * d);
            }
        }
        if (Globals.getGameModeHasPointPool()) {
            n += (int)this.getRawFeats(false);
        }
        return n;
    }

    public void setSkinColor(String string) {
        this.setStringFor(StringKey.SKIN_COLOR, string);
    }

    public String getSkinColor() {
        return this.getSafeStringFor(StringKey.SKIN_COLOR);
    }

    public List<SpecialAbility> getSpecialAbilityList() {
        ArrayList<SpecialAbility> arrayList = new ArrayList<SpecialAbility>(this.specialAbilityList);
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null) continue;
            pObject.addSpecialAbilitiesToList(arrayList, this);
            SpecialAbilityResolution.addSABToList(arrayList, this, pObject);
        }
        for (PObject pObject : this.getConditionalTemplateObjects()) {
            SpecialAbilityResolution.addSABToList(arrayList, this, pObject);
        }
        for (PCClass pCClass : this.classList) {
            for (int i = 1; i <= pCClass.getLevel(); ++i) {
                PCClassLevel pCClassLevel = pCClass.getClassLevel(i);
                SpecialAbilityResolution.addSABToList(arrayList, this, pCClassLevel);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<String> getSpecialAbilityListStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SpecialAbility specialAbility : this.getSpecialAbilityList()) {
            String string;
            if (!PrereqHandler.passesAll(specialAbility.getPrerequisiteList(), this, specialAbility) || (string = specialAbility.getParsedText(this, this)) == null || string.equals("")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public ArrayList<String> getSpecialAbilityTimesList() {
        List<String> list = this.getSpecialAbilityListStrings();
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                nArray[i] = 1;
                continue;
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                String string2 = (String)arrayList.get(j);
                if (!string2.equals(string)) continue;
                int n = j;
                nArray[n] = nArray[n] + 1;
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (nArray[i] > 1) {
                string = string + " (" + nArray[i] + ")";
            }
            arrayList2.add(string);
        }
        return arrayList2;
    }

    public void setSpeechTendency(String string) {
        this.setStringFor(StringKey.SPEECH_TENDENCY, string);
    }

    public String getSpeechTendency() {
        return this.getSafeStringFor(StringKey.SPEECH_TENDENCY);
    }

    public void setSpellBookNameToAutoAddKnown(String string) {
        this.setStringFor(StringKey.SPELLBOOK_AUTO_ADD_KNOWN, string);
    }

    public String getSpellBookNameToAutoAddKnown() {
        return this.getSafeStringFor(StringKey.SPELLBOOK_AUTO_ADD_KNOWN);
    }

    public SpellBook getSpellBookByName(String string) {
        return this.spellBookMap.get(string);
    }

    public List<String> getSpellBooks() {
        return this.spellBooks;
    }

    public PObject getSpellClassAtIndex(int n) {
        List<? extends PObject> list = this.getSpellClassList();
        if (n >= 0 && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    public void setSpellLevelTemp(int n) {
        this.spellLevelTemp = n;
    }

    public int getSpellLevelTemp() {
        return this.spellLevelTemp;
    }

    public StatList getStatList() {
        return this.statList;
    }

    public String getSubRace() {
        String string = "None";
        int n = this.templateList.size();
        for (int i = 0; i < n; ++i) {
            PCTemplate pCTemplate = this.templateList.get(i);
            String string2 = pCTemplate.getSubRace();
            if (string2.equals("None")) continue;
            string = string2;
        }
        return string;
    }

    public String getSubRegion() {
        return this.getSubRegion(true);
    }

    public void setTabName(String string) {
        this.tabName = string;
        this.setDirty(true);
        this.setChanged();
        this.notifyObservers("TabName");
    }

    public String getTabName() {
        return this.tabName;
    }

    private List<Equipment> getTempBonusItemList() {
        return this.tempBonusItemList;
    }

    public void setTempBonusList(List<BonusObj> list) {
        this.tempBonusList = list;
        this.setDirty(true);
    }

    public List<BonusObj> getTempBonusList() {
        return this.tempBonusList;
    }

    public List<BonusObj> getFilteredTempBonusList() {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getTempBonusList()) {
            if (this.tempBonusFilters.contains(bonusObj.getName())) continue;
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    public Set<String> getTempBonusFilters() {
        return this.tempBonusFilters;
    }

    public void setTempBonusFilter(String string) {
        this.tempBonusFilters.add(string);
        this.calcActiveBonuses();
    }

    public void unsetTempBonusFilter(String string) {
        this.tempBonusFilters.remove(string);
        this.calcActiveBonuses();
    }

    public List<BonusObj> getTempBonusList(String string, String string2) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getTempBonusList()) {
            Object object = bonusObj.getTargetObject();
            Object object2 = bonusObj.getCreatorObject();
            String string3 = "";
            String string4 = "";
            if (object2 instanceof CDOMObject) {
                string4 = ((CDOMObject)object2).getKeyName();
            }
            if (object instanceof PlayerCharacter) {
                string3 = this.getName();
            } else if (object instanceof PObject) {
                string3 = ((PObject)object).getKeyName();
            }
            if (!string4.equals(string) || !string3.equals(string2)) continue;
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    public ArrayList<PCTemplate> getTemplateList() {
        return this.templateList;
    }

    public List<PCTemplate> getOutputVisibleTemplateList() {
        ArrayList<PCTemplate> arrayList = new ArrayList<PCTemplate>();
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            if (pCTemplate.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT && pCTemplate.getSafe(ObjectKey.VISIBILITY) != Visibility.OUTPUT_ONLY) continue;
            arrayList.add(pCTemplate);
        }
        return arrayList;
    }

    public PCTemplate getTemplateKeyed(String string) {
        for (PCTemplate pCTemplate : this.templateList) {
            if (!pCTemplate.getKeyName().equalsIgnoreCase(string)) continue;
            return pCTemplate;
        }
        return null;
    }

    public void setTrait1(String string) {
        this.setStringFor(StringKey.TRAIT1, string);
    }

    public String getTrait1() {
        return this.getSafeStringFor(StringKey.TRAIT1);
    }

    public void setTrait2(String string) {
        this.setStringFor(StringKey.TRAIT2, string);
    }

    public String getTrait2() {
        return this.getSafeStringFor(StringKey.TRAIT2);
    }

    public Float getVariable(String string) {
        return this.getVariable(string, true, true, "", "", true);
    }

    public Float getVariable(String string, boolean bl, String string2, String string3) {
        return this.getVariable(string, bl, true, string2, string3, true);
    }

    private double getMinMaxFirstValue(boolean bl, boolean bl2, double d, double d2) {
        if (!bl) {
            return d2;
        }
        if (bl2) {
            return Math.max(d, d2);
        }
        return Math.min(d, d2);
    }

    public Float getVariable(String string, boolean bl, boolean bl2, String string2, String string3, boolean bl3) {
        String string4;
        Object object;
        double d = 0.0;
        boolean bl4 = false;
        if (lastVariable != null && lastVariable.equals(string)) {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("This is a deliberate warning message, not an error - ");
            stringBuffer.append("Avoiding infinite loop in getVariable: repeated lookup ");
            stringBuffer.append("of \"").append(lastVariable).append("\" at ").append(d);
            Logging.debugPrint(stringBuffer.toString());
            lastVariable = null;
            return new Float(d);
        }
        for (String arrayList2 : this.variableList) {
            Iterator<PObject> iterator;
            object = new StringTokenizer(arrayList2, "|");
            String string5 = ((StringTokenizer)object).nextToken();
            if (string2.length() > 0 && !string5.equals(string2)) continue;
            string4 = ((StringTokenizer)object).nextToken();
            if (string3.length() > 0 && !string4.equals(string3) || !((String)((Object)(iterator = ((StringTokenizer)object).nextToken()))).equalsIgnoreCase(string)) continue;
            String string6 = ((StringTokenizer)object).nextToken();
            double d2 = this.getVariableValue(string6, string5).doubleValue();
            d = this.getMinMaxFirstValue(bl4, bl, d, d2);
            bl4 = true;
        }
        Set<Ability> set = this.getFullAbilitySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (Ability)iterator.next();
            String string7 = this.checkForVariableInList((PObject)object, string, bl, bl4, d);
            if (string7.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string7));
            bl4 = true;
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        for (Skill skill : arrayList) {
            string4 = this.checkForVariableInList(skill, string, bl, bl4, d);
            if (string4.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string4));
            bl4 = true;
        }
        for (Equipment equipment : this.equipmentList) {
            String string8;
            string4 = this.checkForVariableInList(equipment, string, bl, bl4, d);
            if (string4.length() > 0) {
                d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string4));
                bl4 = true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                string8 = this.checkForVariableInList(equipmentModifier, string, bl, bl4, d);
                if (string8.length() <= 0) continue;
                d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string8));
                bl4 = true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                string8 = this.checkForVariableInList(equipmentModifier, string, bl, bl4, d);
                if (string8.length() <= 0) continue;
                d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string8));
                bl4 = true;
            }
        }
        for (PCTemplate pCTemplate : this.templateList) {
            string4 = this.checkForVariableInList(pCTemplate, string, bl, bl4, d);
            if (string4.length() > 0) {
                d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string4));
                bl4 = true;
            }
            for (PCTemplate pCTemplate2 : pCTemplate.getConditionalTemplates(this.getTotalLevels(), this.totalHitDice())) {
                String string9 = this.checkForVariableInList(pCTemplate2, string, bl, bl4, d);
                if (string9.length() <= 0) continue;
                d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string9));
                bl4 = true;
            }
        }
        object = this.companionModList.iterator();
        while (object.hasNext()) {
            CompanionMod companionMod = (CompanionMod)object.next();
            string4 = this.checkForVariableInList(companionMod, string, bl, bl4, d);
            if (string4.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string4));
            bl4 = true;
        }
        if (this.race != null && ((String)(object = this.checkForVariableInList(this.race, string, bl, bl4, d))).length() > 0) {
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(object));
            bl4 = true;
        }
        if (this.deity != null && ((String)(object = this.checkForVariableInList(this.deity, string, bl, bl4, d))).length() > 0) {
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(object));
            bl4 = true;
        }
        for (CharacterDomain characterDomain : this.characterDomainList) {
            if (characterDomain.getDomain() == null || (string4 = this.checkForVariableInList(characterDomain.getDomain(), string, bl, bl4, d)).length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string4));
            bl4 = true;
        }
        for (PCStat pCStat : this.statList) {
            string4 = this.checkForVariableInList(pCStat, string, bl, bl4, d);
            if (string4.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string4));
            bl4 = true;
        }
        for (PCAlignment pCAlignment : SettingsHandler.getGame().getUnmodifiableAlignmentList()) {
            string4 = this.checkForVariableInList(pCAlignment, string, bl, bl4, d);
            if (string4.length() <= 0) continue;
            d = this.getMinMaxFirstValue(bl4, bl, d, Float.parseFloat(string4));
            bl4 = true;
        }
        if (!bl4) {
            if (bl3) {
                lastVariable = string;
                d = this.getVariableValue(string, "").floatValue();
                bl2 = false;
                bl4 = true;
                lastVariable = null;
            } else {
                return null;
            }
        }
        if (bl4 && bl2) {
            d += this.getTotalBonusTo("VAR", string);
        }
        return new Float(d);
    }

    private Map<String, WeaponProf> buildWeaponProfCache() {
        HashMap<String, WeaponProf> hashMap = new HashMap<String, WeaponProf>();
        if (this.theWeaponProfs != null) {
            for (WeaponProf cDOMObject : this.theWeaponProfs) {
                hashMap.put(cDOMObject.getKeyName(), cDOMObject);
            }
        }
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            List<CDOMReference<WeaponProf>> list;
            Object object;
            Object object22;
            List<WeaponProf> list2;
            TreeSet<String> treeSet = new TreeSet<String>(cDOMObject.getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS));
            for (String string : treeSet) {
                list2 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, string);
                if (list2 == null) continue;
                hashMap.put(((CDOMObject)((Object)list2)).getKeyName(), (WeaponProf)((Object)list2));
            }
            List<CDOMSingleRef<WeaponProf>> list3 = cDOMObject.getSafeListFor(ListKey.IMPLIED_WEAPONPROF);
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                list2 = (CDOMSingleRef)iterator.next();
                object22 = (WeaponProf)((CDOMSingleRef)((Object)list2)).resolvesTo();
                hashMap.put(((CDOMObject)object22).getKeyName(), (WeaponProf)object22);
            }
            List<WeaponProfProvider> list4 = cDOMObject.getSafeListFor(ListKey.WEAPONPROF);
            for (Object object22 : list4) {
                if (!((ConcretePrereqObject)object22).qualifies(this)) continue;
                object = ((WeaponProfProvider)object22).getContainedProficiencies(this).iterator();
                while (object.hasNext()) {
                    list = object.next();
                    hashMap.put(((CDOMObject)((Object)list)).getKeyName(), (WeaponProf)((Object)list));
                }
            }
            list2 = this.getAssocList(cDOMObject, AssociationListKey.WEAPONPROF);
            if (list2 != null) {
                object22 = list2.iterator();
                while (object22.hasNext()) {
                    object = (WeaponProf)object22.next();
                    hashMap.put(((CDOMObject)object).getKeyName(), (WeaponProf)object);
                }
            }
            if ((object22 = cDOMObject.getSafe(ObjectKey.HAS_ALL_WEAPONPROF).getObject(this)) != null && ((Boolean)object22).booleanValue()) {
                object = Globals.getContext().ref.getConstructedCDOMObjects(WeaponProf.class);
                list = object.iterator();
                while (list.hasNext()) {
                    WeaponProf weaponProf = (WeaponProf)list.next();
                    hashMap.put(weaponProf.getKeyName(), weaponProf);
                }
            }
            if ((object = cDOMObject.getSafe(ObjectKey.HAS_DEITY_WEAPONPROF).getObject(this)) == null || !((Boolean)object).booleanValue() || this.getDeity() == null || (list = this.getDeity().getListFor(ListKey.DEITYWEAPON)) == null) continue;
            for (CDOMReference cDOMReference : list) {
                for (WeaponProf weaponProf : cDOMReference.getContainedObjects()) {
                    if (weaponProf.isType("Natural")) continue;
                    hashMap.put(weaponProf.getKeyName(), weaponProf);
                }
            }
        }
        return hashMap;
    }

    public SortedSet<WeaponProf> getWeaponProfs() {
        if (this.cachedWeaponProfs == null) {
            this.cachedWeaponProfs = this.buildWeaponProfCache();
        }
        return Collections.unmodifiableSortedSet(new TreeSet<WeaponProf>(this.cachedWeaponProfs.values()));
    }

    public void setWeight(int n) {
        this.weightInPounds = n;
        this.setDirty(true);
    }

    public int getWeight() {
        return this.weightInPounds;
    }

    public void setPointBuyPoints(int n) {
        this.pointBuyPoints = n;
    }

    public int getPointBuyPoints() {
        return this.pointBuyPoints;
    }

    public int getTotalPointBuyPoints() {
        return this.pointBuyPoints + (int)this.getTotalBonusTo("POINTBUY", "POINTS");
    }

    public void setXP(int n) {
        int n2 = n - this.getLAXP();
        if (n2 < 0) {
            Logging.errorPrint("ERROR: too little experience: " + n2);
            n2 = 0;
        }
        this.setEarnedXP(n2);
    }

    public int getXP() {
        return this.earnedXP + this.getLAXP();
    }

    public void addEquipSet(EquipSet equipSet) {
        this.equipSetList.add(equipSet);
        this.setDirty(true);
    }

    public void addEquipment(Equipment equipment) {
        this.equipmentList.add(equipment);
        if (!this.equipmentMasterList.contains(equipment)) {
            this.equipmentMasterList.add(equipment);
        }
        if (equipment.isType("SPELLBOOK")) {
            String string = equipment.getName();
            String string2 = equipment.getName();
            int n = (int)equipment.qty();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    string2 = string + " #" + (i + 1);
                }
                SpellBook spellBook = new SpellBook(string2, 3);
                spellBook.setEquip(equipment);
                this.addSpellBook(spellBook);
            }
        }
        this.setDirty(true);
    }

    public void cacheOutputIndex(Equipment equipment) {
        if (equipment.isAutomatic()) {
            Logging.debugPrint("Caching " + equipment.getKeyName() + " - " + equipment.getOutputIndex() + " item");
            this.autoEquipOutputOrderCache.put(equipment.getKeyName(), equipment.getOutputIndex());
        }
    }

    public int getCachedOutputIndex(String string) {
        Integer n = this.autoEquipOutputOrderCache.get(string);
        return n != null ? n : -1;
    }

    public void updateEquipmentQty(Equipment equipment, double d, double d2) {
        if (equipment.isType("SPELLBOOK")) {
            int n;
            String string = equipment.getName();
            String string2 = equipment.getName();
            int n2 = (int)d;
            int n3 = (int)d2;
            for (n = n2; n < n3; ++n) {
                if (n > 0) {
                    string2 = string + " #" + (n + 1);
                }
                SpellBook spellBook = new SpellBook(string2, 3);
                spellBook.setEquip(equipment);
                this.addSpellBook(spellBook);
            }
            for (n = n2; n > n3; --n) {
                if (n > 0) {
                    string2 = string + " #" + n;
                }
                this.delSpellBook(string2);
            }
        }
        this.setDirty(true);
    }

    public void addFollower(Follower follower) {
        this.followerList.add(follower);
        this.setDirty(true);
    }

    public void addLocalEquipment(Equipment equipment) {
        this.equipmentList.add(equipment);
    }

    public void addNotesItem(NoteItem noteItem) {
        this.notesList.add(noteItem);
        this.setDirty(true);
    }

    public void addTempBonus(BonusObj bonusObj) {
        this.getTempBonusList().add(bonusObj);
        this.setDirty(true);
    }

    public void addTempBonusItemList(Equipment equipment) {
        this.getTempBonusItemList().add(equipment);
        this.setDirty(true);
    }

    public double calcBonusFromList(List<BonusObj> list) {
        double d = 0.0;
        for (BonusObj bonusObj : list) {
            d += bonusObj.resolve(this, "").doubleValue();
        }
        return d;
    }

    public boolean checkQualifyList(CDOMObject cDOMObject) {
        for (CDOMObject cDOMObject2 : this.getCDOMObjectList()) {
            if (!this.grantsQualify(cDOMObject2, cDOMObject)) continue;
            return true;
        }
        return false;
    }

    public final boolean grantsQualify(CDOMObject cDOMObject, CDOMObject cDOMObject2) {
        List<Qualifier> list = cDOMObject.getListFor(ListKey.QUALIFY);
        if (list == null) {
            return false;
        }
        Class<?> clazz = cDOMObject2.getClass();
        for (Qualifier qualifier : list) {
            CDOMSingleRef<? extends CDOMObject> cDOMSingleRef;
            if (!clazz.equals(qualifier.getQualifiedClass()) || !this.checkRef(cDOMSingleRef = qualifier.getQualifiedReference(), cDOMObject2)) continue;
            return true;
        }
        return false;
    }

    private <T extends CDOMObject> boolean checkRef(CDOMReference<T> cDOMReference, T t) {
        return cDOMReference.contains(t);
    }

    public boolean hasWeaponProfKeyed(String string) {
        if (this.cachedWeaponProfs == null) {
            this.cachedWeaponProfs = this.buildWeaponProfCache();
        }
        for (WeaponProf weaponProf : this.cachedWeaponProfs.values()) {
            if (weaponProf == null || !weaponProf.getKeyName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWeaponProf(WeaponProf weaponProf) {
        if (this.cachedWeaponProfs == null) {
            this.cachedWeaponProfs = this.buildWeaponProfCache();
        }
        return this.cachedWeaponProfs.get(weaponProf.getKeyName()) != null;
    }

    public Equipment getEquipmentNamed(String string) {
        return this.getEquipmentNamed(string, this.getEquipmentMasterList());
    }

    public List<String> getMiscList() {
        return this.miscList;
    }

    public void buildVariableSet() {
        List<? extends CDOMObject> list = this.getCDOMObjectList();
        this.variableSet.clear();
        for (CDOMObject cDOMObject : list) {
            for (VariableKey variableKey : cDOMObject.getVariableKeys()) {
                this.variableSet.add(variableKey.toString());
            }
        }
        this.setVirtualFeatsStable(false);
    }

    public boolean delEquipSet(EquipSet equipSet) {
        if (this.equipSetList.isEmpty()) {
            return false;
        }
        boolean bl = false;
        String string = equipSet.getIdPath();
        this.equipSetList.remove(equipSet);
        Iterator<EquipSet> iterator = this.equipSetList.iterator();
        while (iterator.hasNext()) {
            String string2;
            EquipSet equipSet2 = iterator.next();
            String string3 = equipSet2.getParentIdPath() + ".";
            if (!string3.startsWith(string2 = string + ".")) continue;
            iterator.remove();
            bl = true;
        }
        this.setDirty(true);
        return bl;
    }

    public void delEquipSetItem(Equipment equipment) {
        if (this.equipSetList.isEmpty()) {
            return;
        }
        ArrayList<EquipSet> arrayList = new ArrayList<EquipSet>();
        for (EquipSet equipSet : this.equipSetList) {
            Equipment equipment2 = equipSet.getItem();
            if (equipment2 == null || !equipment.equals(equipment2)) continue;
            arrayList.add(equipSet);
        }
        for (EquipSet equipSet : arrayList) {
            this.delEquipSet(equipSet);
        }
        this.setDirty(true);
    }

    public void delFollower(Follower follower) {
        this.followerList.remove(follower);
        this.setDirty(true);
    }

    public void equipmentListAddAll(List<Equipment> list) {
        if (list.isEmpty()) {
            return;
        }
        this.equipmentList.addAll(list);
        this.equipmentMasterList.addAll(list);
        this.setDirty(true);
    }

    public boolean hasVariable(String string) {
        for (String string2 : this.variableList) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            if (!stringTokenizer.nextToken().equalsIgnoreCase(string)) continue;
            return true;
        }
        return this.variableSet.contains(string.toUpperCase());
    }

    private void putActiveBonusMap(String string, String string2, Map<String, String> map) {
        if (string.equalsIgnoreCase("SKILL.LIST")) {
            this.displayUpdate = true;
            return;
        }
        map.put(string, string2);
    }

    public int racialSizeInt() {
        int n = 0;
        if (this.race != null) {
            n = this.race.getSafe(FormulaKey.SIZE).resolve(this, "").intValue();
            for (PCTemplate pCTemplate : this.getTemplateList()) {
                Formula formula = pCTemplate.get(FormulaKey.SIZE);
                if (formula == null) continue;
                n = formula.resolve(this, pCTemplate.getKeyName()).intValue();
            }
        }
        return n;
    }

    public void removeEquipment(Equipment equipment) {
        if (equipment.isType("SPELLBOOK")) {
            this.delSpellBook(equipment.getName());
        }
        this.equipmentList.remove(equipment);
        this.equipmentMasterList.remove(equipment);
        this.setDirty(true);
    }

    public void removeLocalEquipment(Equipment equipment) {
        this.equipmentList.remove(equipment);
        this.setDirty(true);
    }

    public int getACTotal() {
        return this.calcACOfType("Total");
    }

    public void setAlignment(int n, boolean bl) {
        this.setAlignment(n, bl, false);
    }

    public void setAlignment(int n, boolean bl, boolean bl2) {
        if (!bl2 && !RaceAlignment.canBeAlignment(this.race, Integer.toString(n))) {
            if (bl && n != SettingsHandler.getGame().getIndexOfAlignment("None")) {
                ShowMessageDelegate.showMessageDialog("Invalid alignment. Setting to <none selected>", "PCGen", MessageType.INFORMATION);
                this.alignment = SettingsHandler.getGame().getIndexOfAlignment("None");
            }
            throw new IllegalArgumentException("Invalid alignment");
        }
        this.alignment = n;
        this.setDirty(true);
    }

    public boolean isAllowDebt() {
        return this.allowDebt;
    }

    public void setAllowDebt(boolean bl) {
        this.allowDebt = bl;
    }

    public String getAttackString(AttackType attackType) {
        return this.getAttackString(attackType, 0);
    }

    public String getAttackString(AttackType attackType, int n) {
        return this.getAttackString(attackType, n, 0);
    }

    public String getAttackString(AttackType attackType, int n, int n2) {
        int n3;
        int n4;
        int n5;
        String string = "AttackString:" + attackType.getIdentifier() + "," + n + "," + n2;
        String string2 = this.getVariableProcessor().getCachedString(string);
        if (string2 != null) {
            return string2;
        }
        int n6 = -9999;
        int n7 = -9999;
        PlayerCharacter playerCharacter = this.getMasterPC();
        if (playerCharacter != null && this.getCopyMasterBAB().length() > 0) {
            n6 = playerCharacter.baseAttackBonus();
            String string3 = this.replaceMasterString(this.getCopyMasterBAB(), n6);
            n6 = this.getVariableValue(string3, "").intValue();
            n7 = n6 + n;
        }
        int n8 = this.baseAttackBonus();
        int n9 = 1;
        int n10 = n8 + n;
        int n11 = n8;
        int n12 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            arrayList.add(0);
        }
        for (PCClass pCClass : this.classList) {
            n5 = pCClass.baseAttackBonus(this);
            n4 = pCClass.attackCycle(attackType);
            if (n4 < arrayList.size()) {
                int n13 = (Integer)arrayList.get(n4) + n5;
                arrayList.set(n4, n13);
            }
            if (n4 == 3) continue;
            n12 += n5;
        }
        for (n3 = 2; n3 < 10; ++n3) {
            int n14 = (Integer)arrayList.get(n3);
            if (n14 / n3 <= (n5 = ((Integer)arrayList.get(n9)).intValue()) / n9) continue;
            n9 = n3;
        }
        n3 = (Integer)arrayList.get(n9);
        int n15 = SettingsHandler.getGame().getBabAttCyc();
        if (n3 == 0) {
            n9 = n15;
        }
        n10 = Math.max(n10, n7);
        n11 = Math.max(n11, n6);
        n12 = Math.max(n12, n6);
        if (n9 != n15) {
            if (n3 / n9 < n11 / n15) {
                n9 = n15;
                n3 = n11;
            } else {
                n10 -= n12;
                n11 -= n12;
            }
        }
        n5 = SettingsHandler.getGame().getBabMaxAtt();
        n4 = SettingsHandler.getGame().getBabMinVal();
        n3 += n2;
        n10 += n2;
        n11 += n2;
        do {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(Delta.toString(n10));
            n10 -= n9;
        } while (((n3 -= n9) >= n4 || (n11 -= n9) >= n4) && --n5 > 0);
        this.getVariableProcessor().addCachedString(string, stringBuffer.toString());
        return stringBuffer.toString();
    }

    public SortedSet<Language> getAutoLanguages() {
        boolean bl = false;
        TreeSet<Language> treeSet = new TreeSet<Language>();
        for (Language pObject : this.templateAutoLanguages) {
            String string = pObject.toString();
            if (".CLEARRACIAL".equals(string)) {
                bl = true;
                List<CDOMReference<Language>> list = this.getRace().getSafeListFor(ListKey.AUTO_LANGUAGES);
                for (CDOMReference<Language> cDOMReference : list) {
                    this.languages.removeAll(cDOMReference.getContainedObjects());
                }
                continue;
            }
            if (".CLEARALL".equals(string) || ".CLEAR".equals(string)) {
                bl = true;
                treeSet.clear();
                this.languages.clear();
                continue;
            }
            if (".CLEARTEMPLATES".equals(string)) {
                treeSet.clear();
                this.languages.removeAll(this.templateAutoLanguages);
                continue;
            }
            treeSet.add(pObject);
        }
        for (PObject pObject : this.getPObjectList()) {
            if (bl && pObject instanceof Race) {
                bl = false;
                continue;
            }
            for (CDOMReference cDOMReference : pObject.getSafeListFor(ListKey.AUTO_LANGUAGES)) {
                treeSet.addAll(cDOMReference.getContainedObjects());
            }
        }
        this.languages.addAll(treeSet);
        return treeSet;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean bl) {
        this.autoResize = bl;
    }

    public void setAutoSortGear(boolean bl) {
        this.autoSortGear = bl;
        this.setDirty(true);
    }

    public boolean isAutoSortGear() {
        return this.autoSortGear;
    }

    public void setAutoSpells(boolean bl) {
        this.autoKnownSpells = bl;
        this.setDirty(true);
    }

    public boolean getAutoSpells() {
        return this.autoKnownSpells;
    }

    public boolean isIgnoreCost() {
        return this.ignoreCost;
    }

    public void setIgnoreCost(boolean bl) {
        this.ignoreCost = bl;
    }

    public boolean getUseHigherKnownSlots() {
        return this.useHigherKnownSlots;
    }

    public void setUseHigherKnownSlots(boolean bl) {
        this.useHigherKnownSlots = bl;
    }

    public boolean getUseHigherPreppedSlots() {
        return this.useHigherPreppedSlots;
    }

    public void setUseHigherPreppedSlots(boolean bl) {
        this.useHigherPreppedSlots = bl;
    }

    public int getBaseCheck(int n) {
        String string = "getBaseCheck:" + n;
        Float f = null;
        f = this.epicCheckMap.containsKey(n) ? Float.valueOf(this.epicCheckMap.get(n).floatValue()) : this.getVariableProcessor().getCachedVariable(string);
        if (f != null) {
            return f.intValue();
        }
        double d = 0.0;
        boolean bl = false;
        HashMap<String, String> hashMap = null;
        if (n >= 0 && n < SettingsHandler.getGame().getUnmodifiableCheckList().size()) {
            Object object;
            int n2 = this.getTotalCharacterLevel();
            if (n2 > SettingsHandler.getGame().getChecksMaxLvl()) {
                bl = true;
                object = this.epicCheckMap.get(n);
                if (object == null) {
                    hashMap = this.getTotalLevelHashMap();
                    Map<String, String> map = this.getCharacterLevelHashMap(SettingsHandler.getGame().getChecksMaxLvl());
                    this.getVariableProcessor().pauseCache();
                    this.setClassLevelsBrazenlyTo(map);
                } else {
                    return (Integer)object;
                }
            }
            object = SettingsHandler.getGame().getUnmodifiableCheckList().get(n).toString();
            d = this.getTotalBonusTo("CHECKS", "BASE." + (String)object);
            PlayerCharacter playerCharacter = this.getMasterPC();
            if (playerCharacter != null && this.getCopyMasterCheck().length() > 0) {
                int n3 = playerCharacter.getBaseCheck(n);
                String string2 = this.replaceMasterString(this.getCopyMasterCheck(), n3);
                n3 = this.getVariableValue(string2, "").intValue();
                d = Math.max(d, (double)n3);
            }
            if (bl) {
                this.epicCheckMap.put(n, (int)d);
            }
            if (hashMap != null) {
                this.setClassLevelsBrazenlyTo(hashMap);
                this.getVariableProcessor().restartCache();
            }
        }
        return (int)d;
    }

    public int getTotalCheck(int n) {
        int n2 = this.getBaseCheck(n);
        return n2 + (int)this.getTotalBonusTo("CHECKS", SettingsHandler.getGame().getCheckKey(n));
    }

    public double getBonusDueToType(String string, String string2, String string3) {
        String string4 = string + "." + string2 + ":" + string3;
        return this.sumActiveBonusMap(string4);
    }

    public CharacterDomain getCharacterDomainForDomain(String string) {
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain = characterDomain.getDomain();
            if (domain == null || !domain.getKeyName().equalsIgnoreCase(string)) continue;
            return characterDomain;
        }
        return null;
    }

    public List<CharacterDomain> getCharacterDomainList() {
        return Collections.unmodifiableList(this.characterDomainList);
    }

    public boolean hasCharacterDomainList() {
        return this.characterDomainList != null && !this.characterDomainList.isEmpty();
    }

    public Domain getCharacterDomainKeyed(String string) {
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain = characterDomain.getDomain();
            if (domain == null || !domain.getKeyName().equalsIgnoreCase(string)) continue;
            return characterDomain.getDomain();
        }
        return null;
    }

    public int getCharacterDomainUsed() {
        return this.characterDomainList.size();
    }

    public List<CompanionMod> getCompanionModList() {
        return Collections.unmodifiableList(this.companionModList);
    }

    public String getCopyMasterBAB() {
        for (CompanionMod companionMod : this.companionModList) {
            String string;
            if (!companionMod.getType().equalsIgnoreCase(this.getMaster().getType().getKeyName()) || (string = companionMod.get(StringKey.MASTER_BAB_FORMULA)) == null) continue;
            return string;
        }
        return "";
    }

    public String getCopyMasterCheck() {
        for (CompanionMod companionMod : this.companionModList) {
            if (!companionMod.getType().equalsIgnoreCase(this.getMaster().getType().getKeyName()) || companionMod.get(StringKey.MASTER_CHECK_FORMULA) == null) continue;
            return companionMod.get(StringKey.MASTER_CHECK_FORMULA);
        }
        return "";
    }

    public String getCopyMasterHP() {
        for (CompanionMod companionMod : this.companionModList) {
            if (!companionMod.getType().equalsIgnoreCase(this.getMaster().getType().getKeyName()) || companionMod.get(StringKey.MASTER_HP_FORMULA) == null) continue;
            return companionMod.get(StringKey.MASTER_HP_FORMULA);
        }
        return "";
    }

    public void setCurrentHP(int n) {
        this.setDirty(true);
    }

    public boolean setDeity(Deity deity) {
        if (!this.canSelectDeity(deity)) {
            return false;
        }
        this.deity = deity;
        if (!this.isImporting()) {
            this.getSpellList();
            this.deity.globalChecks(this);
        }
        this.setDirty(true);
        this.calcActiveBonuses();
        return true;
    }

    public String getDomainSource(String string) {
        for (String string2 : this.domainSourceMap.keySet()) {
            String string3 = this.domainSourceMap.get(string2);
            int n = Integer.parseInt(string3);
            if (string == null && n > 0) {
                return string2;
            }
            if (string2.indexOf(string) < 0) continue;
            return string2;
        }
        return "";
    }

    public int getECL() {
        int n = 0;
        n += this.totalNonMonsterLevels();
        n += this.totalHitDice();
        return n += this.getLevelAdjustment(this);
    }

    public void setEquipOutputOrder(int n) {
        this.equipOutputOrder = n;
        this.setDirty(true);
    }

    public int getEquipOutputOrder() {
        return this.equipOutputOrder;
    }

    public List<Equipment> getEquipmentOfType(String string, int n) {
        return this.getEquipmentOfType(string, "", n);
    }

    public List<Equipment> getEquipmentOfType(String string, String string2, int n) {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.typeStringContains(string) || !"".equals(string2) && !equipment.typeStringContains(string2) || n != 3 && (n != 2 || equipment.isEquipped()) && (n != 1 || !equipment.isEquipped())) continue;
            arrayList.add(equipment);
        }
        return arrayList;
    }

    public List<Equipment> getEquipmentOfTypeInOutputOrder(String string, int n) {
        return this.sortEquipmentList(this.getEquipmentOfType(string, n), 0);
    }

    public List<Equipment> getEquipmentOfTypeInOutputOrder(String string, int n, int n2) {
        return this.sortEquipmentList(this.getEquipmentOfType(string, n), n2);
    }

    public List<Equipment> getEquipmentOfTypeInOutputOrder(String string, String string2, int n, int n2) {
        return this.sortEquipmentList(this.getEquipmentOfType(string, string2, n), 0);
    }

    public List<Equipment> getExpandedWeapons(int n) {
        List<Equipment> list = this.sortEquipmentList(this.getEquipmentOfType("Weapon", 3), n);
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            Equipment equipment;
            int n3;
            Object object;
            Equipment equipment2;
            Equipment equipment3 = list.get(i);
            if (equipment3.isDouble() && equipment3.getLocation() == 4) {
                equipment2 = equipment3.clone();
                equipment2.removeType(Type.DOUBLE);
                equipment2.addType(Type.HEAD1);
                equipment2.setWholeItemName(equipment2.getName());
                equipment2.setName(EquipmentUtilities.appendToName(equipment2.getName(), "Head 1 only"));
                if (equipment2.getOutputName().indexOf("Head 1 only") < 0) {
                    equipment2.put(StringKey.OUTPUT_NAME, EquipmentUtilities.appendToName(equipment2.getOutputName(), "Head 1 only"));
                }
                PlayerCharacterUtilities.setProf(equipment3, equipment2);
                list.add(i + 1, equipment2);
                equipment2 = equipment3.clone();
                String string = equipment2.getType(false);
                if (string.length() != 0) {
                    equipment2.removeListFor(ListKey.TYPE);
                    for (String string2 : string.split("\\.")) {
                        equipment2.addType(Type.getConstant(string2));
                    }
                }
                equipment2.removeType(Type.DOUBLE);
                equipment2.addType(Type.HEAD2);
                EquipmentHead equipmentHead = equipment2.getEquipmentHead(1);
                object = equipment2.getAltDamage(this);
                if (((String)object).length() != 0) {
                    equipmentHead.put(StringKey.DAMAGE, (String)object);
                }
                equipmentHead.put(IntegerKey.CRIT_MULT, equipment2.getAltCritMultiplier());
                equipmentHead.put(IntegerKey.CRIT_RANGE, equipment2.getRawCritRange(false));
                equipmentHead.removeListFor(ListKey.EQMOD);
                equipmentHead.addAllToListFor(ListKey.EQMOD, equipment2.getEqModifierList(false));
                equipment2.setWholeItemName(equipment2.getName());
                equipment2.setName(EquipmentUtilities.appendToName(equipment2.getName(), "Head 2 only"));
                if (equipment2.getOutputName().indexOf("Head 2 only") < 0) {
                    equipment2.put(StringKey.OUTPUT_NAME, EquipmentUtilities.appendToName(equipment2.getOutputName(), "Head 2 only"));
                }
                PlayerCharacterUtilities.setProf(equipment3, equipment2);
                list.add(i + 2, equipment2);
                continue;
            }
            if (!equipment3.isMelee() || !equipment3.isRanged() || equipment3.getRange(this) == 0) continue;
            equipment2 = equipment3.clone();
            equipment2.addType(Type.BOTH);
            equipment2.removeType(Type.RANGED);
            equipment2.removeType(Type.THROWN);
            equipment2.put(IntegerKey.RANGE, 0);
            PlayerCharacterUtilities.setProf(equipment3, equipment2);
            list.set(i, equipment2);
            for (n3 = this.getPrimaryWeapons().size() - 1; n3 >= 0 && (equipment = this.getPrimaryWeapons().get(n3)) != equipment3; --n3) {
            }
            if (n3 >= 0) {
                this.getPrimaryWeapons().set(n3, equipment2);
            }
            for (n2 = this.getSecondaryWeapons().size() - 1; n2 >= 0 && (object = this.getSecondaryWeapons().get(n2)) != equipment3; --n2) {
            }
            if (n2 >= 0) {
                this.getSecondaryWeapons().set(n2, equipment2);
            }
            equipment2 = equipment3.clone();
            equipment2.addType(Type.RANGED);
            equipment2.addType(Type.THROWN);
            equipment2.addType(Type.BOTH);
            equipment2.removeType(Type.MELEE);
            equipment2.setName(EquipmentUtilities.appendToName(equipment2.getName(), "Thrown"));
            if (equipment2.getOutputName().indexOf("Thrown") < 0) {
                equipment2.put(StringKey.OUTPUT_NAME, EquipmentUtilities.appendToName(equipment2.getOutputName(), "Thrown"));
            }
            PlayerCharacterUtilities.setProf(equipment3, equipment2);
            list.add(++i, equipment2);
            if (n3 >= 0) {
                this.getPrimaryWeapons().add(++n3, equipment2);
                continue;
            }
            if (n2 < 0) continue;
            this.getSecondaryWeapons().add(++n2, equipment2);
        }
        return list;
    }

    public SortedSet<PCClass> getFavoredClasses() {
        List<PCClass> list;
        List<CDOMReference<? extends PCClass>> list2;
        TreeSet<CDOMObject> treeSet = new TreeSet<CDOMObject>(CDOMObjectUtilities.CDOM_SORTER);
        if (this.selectedFavoredClass != null) {
            treeSet.add(this.selectedFavoredClass);
        }
        if ((list2 = this.getRace().getListFor(ListKey.FAVORED_CLASS)) != null) {
            list = list2.iterator();
            while (list.hasNext()) {
                Iterator iterator = (CDOMReference)list.next();
                treeSet.addAll(((CDOMReference)((Object)iterator)).getContainedObjects());
            }
        }
        if ((list = this.getAssocList(this.getRace(), AssociationListKey.FAVCLASS)) != null && !list.isEmpty()) {
            for (PCClass pObject : list) {
                treeSet.add(pObject);
            }
        }
        for (PCTemplate pCTemplate : this.templateList) {
            List<CDOMReference<? extends PCClass>> list3 = pCTemplate.getListFor(ListKey.FAVORED_CLASS);
            if (list3 != null) {
                for (CDOMReference<? extends PCClass> cDOMReference : list3) {
                    treeSet.addAll(cDOMReference.getContainedObjects());
                }
            }
            if ((list = this.getAssocList(pCTemplate, AssociationListKey.FAVCLASS)) == null || list.isEmpty()) continue;
            for (PCClass pCClass : list) {
                treeSet.add(pCClass);
            }
        }
        return treeSet;
    }

    public int getFavoredClassLevel() {
        SortedSet<PCClass> sortedSet = this.getFavoredClasses();
        int n = 0;
        int n2 = 0;
        boolean bl = this.getRace().getSafe(ObjectKey.ANY_FAVORED_CLASS);
        block0: for (PCClass pCClass : sortedSet) {
            for (PCClass pCClass2 : this.classList) {
                if (bl) {
                    n2 = Math.max(n2, pCClass2.getLevel());
                }
                if (!pCClass.getKeyName().equals(pCClass2.getKeyName())) continue;
                n += pCClass2.getLevel();
                continue block0;
            }
        }
        return Math.max(n, n2);
    }

    public double getFeatBonusTo(String string, String string2) {
        return this.getPObjectWithCostBonusTo(this.aggregateFeatList(), string.toUpperCase(), string2.toUpperCase());
    }

    public Ability getFeatNamed(String string) {
        return AbilityUtilities.getAbilityFromList(AbilityUtilities.getAggregateAbilitiesListForKey("FEAT", this), "FEAT", string, Ability.Nature.ANY);
    }

    public Ability getAbilityMatching(Ability ability) {
        return AbilityUtilities.getAbilityFromList(new ArrayList<Ability>(this.getFullAbilityList()), ability, ability.getAbilityNature());
    }

    public void setHasMadeKitSelectionForAgeSet(int n, boolean bl) {
        if (n >= 0 && n < 10) {
            this.ageSetKitSelections[n] = bl;
        }
        this.setDirty(true);
    }

    public List<Kit> getKitInfo() {
        List<Kit> list = this.kitList != null ? this.kitList : Collections.emptyList();
        return list;
    }

    public int getLevelAdjustment(PlayerCharacter playerCharacter) {
        int n = this.race.getSafe(FormulaKey.LEVEL_ADJUSTMENT).resolve(playerCharacter, "").intValue();
        for (PCTemplate pCTemplate : this.templateList) {
            n += pCTemplate.getSafe(FormulaKey.LEVEL_ADJUSTMENT).resolve(playerCharacter, "").intValue();
        }
        return n;
    }

    public List<PCLevelInfo> getLevelInfo() {
        return this.pcLevelInfo;
    }

    public String getLevelInfoClassKeyName(int n) {
        if (n >= 0 && n < this.getLevelInfoSize()) {
            return this.pcLevelInfo.get(n).getClassKeyName();
        }
        return "";
    }

    public int getLevelInfoClassLevel(int n) {
        if (n >= 0 && n < this.getLevelInfoSize()) {
            return this.pcLevelInfo.get(n).getLevel();
        }
        return 0;
    }

    public PCLevelInfo getLevelInfoFor(String string, int n) {
        for (PCLevelInfo pCLevelInfo : this.pcLevelInfo) {
            if (pCLevelInfo.getClassKeyName().equals(string)) {
                --n;
            }
            if (n > 0) continue;
            return pCLevelInfo;
        }
        return null;
    }

    public int getLevelInfoSize() {
        return this.pcLevelInfo.size();
    }

    public void setLoadCompanion(boolean bl) {
        this.autoLoadCompanion = bl;
        this.setDirty(true);
    }

    public boolean getLoadCompanion() {
        return this.autoLoadCompanion;
    }

    public int getMaxCharacterDomains() {
        return (int)this.getTotalBonusTo("DOMAIN", "NUMBER");
    }

    public int getMaxCharacterDomains(PCClass pCClass, PlayerCharacter playerCharacter) {
        int n = this.getMaxCharacterDomains();
        if (n == 0 && this.domainSourceMap.size() == 0) {
            n = (int)pCClass.getBonusTo("DOMAIN", "NUMBER", pCClass.getLevel(), playerCharacter);
        }
        return n;
    }

    public Float getMaxRank(String string, PCClass pCClass) {
        BigDecimal bigDecimal;
        int n = this.getTotalLevels();
        Skill skill = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string);
        if (skill == null) {
            return Float.valueOf(0.0f);
        }
        if (skill.getSafe(ObjectKey.EXCLUSIVE).booleanValue()) {
            n = 0;
            for (PCClass pCClass2 : this.classList) {
                if (!this.isClassSkill(skill, pCClass2)) continue;
                n += pCClass2.getLevel();
            }
            if (n == 0) {
                n = this.getTotalLevels();
                bigDecimal = SkillUtilities.maxCrossClassSkillForLevel(n, this);
            } else {
                bigDecimal = SkillUtilities.maxClassSkillForLevel(n, this);
            }
        } else {
            bigDecimal = !this.isClassSkill(skill) && this.getSkillCostForClass(skill, pCClass).equals((Object)SkillCost.CLASS) ? new BigDecimal(SkillUtilities.maxCrossClassSkillForLevel(n, this).intValue()) : (!this.isClassSkill(skill) ? SkillUtilities.maxCrossClassSkillForLevel(n, this) : SkillUtilities.maxClassSkillForLevel(n, this));
        }
        return new Float(bigDecimal.floatValue());
    }

    public Double getMovement(int n) {
        if (this.getMovements() != null && n < this.movements.length) {
            return this.movements[n];
        }
        return 0.0;
    }

    public String getMovementType(int n) {
        if (this.movementTypes != null && n < this.movementTypes.length) {
            return this.movementTypes[n];
        }
        return "";
    }

    public double movementOfType(String string) {
        if (this.movementTypes == null) {
            return 0.0;
        }
        for (int i = 0; i < this.movementTypes.length; ++i) {
            if (!this.movementTypes[i].equalsIgnoreCase(string)) continue;
            return this.movement(i);
        }
        return 0.0;
    }

    public CharacterDomain getNewCharacterDomain() {
        return this.getNewCharacterDomain(null);
    }

    public CharacterDomain getNewCharacterDomain(String string) {
        String string2 = this.getDomainSource(string);
        if (string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            CharacterDomain characterDomain = new CharacterDomain();
            if (string3.equalsIgnoreCase("PCClass")) {
                characterDomain.setFromPCClass(true);
            } else {
                characterDomain.setFromPCClass(false);
            }
            characterDomain.setObjectName(string4);
            characterDomain.setLevel(n);
            return characterDomain;
        }
        return null;
    }

    public boolean isNonAbility(int n) {
        if (RaceStat.isUnlocked(n, this.race)) {
            return false;
        }
        for (PCTemplate pCTemplate : this.templateList) {
            if (!TemplateStat.isUnlocked(pCTemplate, n)) continue;
            return false;
        }
        if (RaceStat.isNonAbility(n, this.race)) {
            return true;
        }
        for (PCTemplate pCTemplate : this.templateList) {
            if (!TemplateStat.isNonAbility(pCTemplate, n)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfMovements() {
        return this.movements != null ? this.movements.length : 0;
    }

    public int getOffHandLightBonus() {
        int n = this.getVariableValue("OFFHANDLIGHTBONUS", "").intValue();
        return n;
    }

    public boolean isPrimaryWeapon(Equipment equipment) {
        if (equipment == null) {
            return false;
        }
        for (Equipment equipment2 : this.primaryWeapons) {
            if (!equipment2.getName().equalsIgnoreCase(equipment.getName()) || equipment2.getLocation() != equipment.getLocation()) continue;
            return true;
        }
        return false;
    }

    public boolean isProficientWith(Equipment equipment) {
        if (equipment.isShield()) {
            for (ProfProvider<ShieldProf> profProvider : this.getShieldProfList()) {
                if (!profProvider.providesProficiencyFor(equipment)) continue;
                return true;
            }
            return false;
        }
        if (equipment.isArmor()) {
            for (ProfProvider<ArmorProf> profProvider : this.getArmorProfList()) {
                if (!profProvider.providesProficiencyFor(equipment)) continue;
                return true;
            }
            return false;
        }
        if (equipment.isWeapon()) {
            return this.isProficientWithWeapon(equipment);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setRace(Race race) {
        List<CDOMReference<Language>> list;
        boolean bl;
        Race race2 = this.getRace();
        boolean bl2 = bl = race2 == null;
        if (!bl) {
            this.removeAllAssocs(race2, AssociationListKey.CHARACTER_SPELLS);
            list = race2.getSafeListFor(ListKey.AUTO_LANGUAGES);
            for (CDOMReference<Language> object2 : list) {
                this.languages.removeAll(object2.getContainedObjects());
            }
            this.cachedWeaponProfs = null;
            this.removeNaturalWeapons(this.race);
            this.removeTemplatesFrom(this.race);
            this.selectedFavoredClass = null;
            LevelCommandFactory levelCommandFactory = this.race.get(ObjectKey.MONSTER_CLASS);
            if (levelCommandFactory != null) {
                PCClass n = levelCommandFactory.getPCClass();
                this.incrementClassLevel(levelCommandFactory.getLevelCount().resolve(this, "").intValue() * -1, n, true);
            }
        }
        this.race = null;
        if (race != null) {
            this.race = race.clone();
        }
        if (this.race != null) {
            LevelCommandFactory levelCommandFactory;
            Object object;
            this.race.activateBonuses(this);
            if (!this.isImporting()) {
                Globals.getBioSet().randomize("AGE.HT.WT", this);
                ChooserUtilities.modChoices(this.race, new ArrayList(), new ArrayList(), true, this, true, null);
            }
            list = new ArrayList<PCClass>(this.classList);
            this.classList.clear();
            for (int i = this.getLevelInfoSize() - 1; i >= 0; --i) {
                String string = this.getLevelInfoClassKeyName(i);
                object = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string);
                if (object != null && !((PCClass)object).isMonster()) continue;
                this.removeLevelInfo(i);
            }
            ArrayList<PCLevelInfo> arrayList = new ArrayList<PCLevelInfo>(this.pcLevelInfo);
            this.pcLevelInfo.clear();
            if (!this.isImporting() && (levelCommandFactory = this.race.get(ObjectKey.MONSTER_CLASS)) != null) {
                object = levelCommandFactory.getPCClass();
                this.incrementClassLevel(levelCommandFactory.getLevelCount().resolve(this, "").intValue(), (PCClass)object, true);
            }
            this.pcLevelInfo.addAll(arrayList);
            if (!this.isImporting() && list.size() != 0) {
                int n = this.getTotalLevels();
                for (PCClass pCClass : list) {
                    if (pCClass.isMonster()) continue;
                    this.classList.add(pCClass);
                    int n2 = pCClass.getLevel();
                    pCClass.setSkillPool(0);
                    int n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        void var6_16;
                        n3 += pCClass.recalcSkillPointMod(this, (int)(++var6_16));
                    }
                    pCClass.setSkillPool(n3);
                }
            }
            this.addNaturalWeapons(this.race.getListFor(ListKey.NATURAL_WEAPON));
            this.getAutoLanguages();
            if (!this.isImporting()) {
                this.selectRacialFavoredClass();
            }
            this.selectTemplates(this.race, this.isImporting());
        }
        this.setAggregateFeatsStable(false);
        this.setAutomaticFeatsStable(false);
        this.setVirtualFeatsStable(false);
        if (!this.isImporting()) {
            this.getSpellList();
            this.race.globalChecks(this);
            this.adjustMoveRates();
            this.calcActiveBonuses();
        }
        this.setDirty(true);
    }

    public double getRaceBonusTo(String string, String string2) {
        if (this.getRace() == null) {
            return 0.0;
        }
        List<BonusObj> list = this.getRace().getBonusListOfType(this, string.toUpperCase(), string2.toUpperCase());
        return this.calcBonusFromList(list);
    }

    public int getSR() {
        return this.calcSR(true);
    }

    public boolean isSecondaryWeapon(Equipment equipment) {
        if (equipment == null) {
            return false;
        }
        for (Equipment equipment2 : this.secondaryWeapons) {
            if (!equipment2.getName().equalsIgnoreCase(equipment.getName()) || equipment2.getLocation() != equipment.getLocation()) continue;
            return true;
        }
        return false;
    }

    public double getSizeAdjustmentBonusTo(String string, String string2) {
        return this.getBonusDueToType(string.toUpperCase(), string2.toUpperCase(), "SIZE");
    }

    public Skill getSkillKeyed(String string) {
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        for (Skill skill : arrayList) {
            if (!skill.getKeyName().equalsIgnoreCase(string)) continue;
            return skill;
        }
        return null;
    }

    public void setSkillsOutputOrder(int n) {
        this.skillsOutputOrder = n;
        this.setDirty(true);
    }

    public int getSkillsOutputOrder() {
        return this.skillsOutputOrder;
    }

    public boolean isSpellCaster(int n) {
        return this.isSpellCaster(n, false) > 0;
    }

    public int isSpellCaster(int n, boolean bl) {
        return this.isSpellCaster(null, n, bl);
    }

    public int isSpellCaster(String string, int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        for (PCClass pCClass : this.classList) {
            if (string != null && !string.equalsIgnoreCase(pCClass.getSpellType())) continue;
            int n4 = (int)this.getTotalBonusTo("CASTERLEVEL", pCClass.getKeyName());
            if (n4 == 0 && (this.canCastSpellTypeLevel(pCClass.getSpellType(), 0, 1) || this.canCastSpellTypeLevel(pCClass.getSpellType(), 1, 1))) {
                n4 = pCClass.getLevel();
            }
            n4 += (int)this.getTotalBonusTo("PCLEVEL", pCClass.getKeyName());
            if (bl) {
                n3 += n4;
                continue;
            }
            if (n4 < n) continue;
            ++n2;
        }
        if (bl) {
            return n3 >= n ? 1 : 0;
        }
        return n2;
    }

    public void getSpellList() {
        if (this.race == null) {
            return;
        }
        this.removeAllAssocs(this.race, AssociationListKey.CHARACTER_SPELLS);
        this.addSpells(this.race);
        if (this.deity != null) {
            this.addSpells(this.deity);
        }
        for (CharacterDomain iterator2 : this.characterDomainList) {
            this.addSpells(iterator2.getDomain());
        }
        for (PCClass pCClass : this.classList) {
            this.addSpells(pCClass);
            int n = pCClass.getLevel();
            for (int i = 0; i <= n; ++i) {
                this.addSpells(pCClass.getClassLevel(i));
            }
        }
        for (Ability ability : this.getFullAbilitySet()) {
            this.addSpells(ability);
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            this.addSpells(skill);
        }
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            this.addSpells(equipment);
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                this.addSpells(equipmentModifier);
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                this.addSpells(equipmentModifier);
            }
        }
        for (PCTemplate pCTemplate : this.templateList) {
            this.addSpells(pCTemplate);
        }
    }

    public String getSpellRange(CharacterSpell characterSpell, PObject pObject, SpellInfo spellInfo) {
        String string = characterSpell.getSpell().getRange();
        String string2 = "CLASS:" + (pObject != null ? pObject.getKeyName() : "");
        int n = 0;
        String string3 = Globals.getGameModeSpellRangeFormula(string.toUpperCase());
        if (string.equalsIgnoreCase("CLOSE") && string3 == null) {
            string3 = "((CASTERLEVEL/2).TRUNC*5)+25";
        } else if (string.equalsIgnoreCase("MEDIUM") && string3 == null) {
            string3 = "(CASTERLEVEL*10)+100";
        } else if (string.equalsIgnoreCase("LONG") && string3 == null) {
            string3 = "(CASTERLEVEL*40)+400";
        }
        if (string3 != null) {
            List<Ability> list = null;
            if (spellInfo != null) {
                list = spellInfo.getFeatList();
            }
            n = this.getVariableValue(characterSpell, string3, string2).intValue();
            if (list != null && !list.isEmpty()) {
                for (Ability ability : list) {
                    n += (int)ability.bonusTo("SPELL", "RANGE", this, this);
                    int n2 = (int)ability.bonusTo("SPELL", "RANGEMULT", this, this);
                    if (n2 <= 0) continue;
                    n *= n2;
                }
            }
            string = string + " (" + Globals.getGameModeUnitSet().displayDistanceInUnitSet(n) + Globals.getGameModeUnitSet().getDistanceUnit() + ")";
        } else {
            string = this.parseSpellString(characterSpell, string, pObject);
        }
        return string;
    }

    public int getCasterLevelForSpell(CharacterSpell characterSpell, String string) {
        String string2 = "CLASS:" + string;
        int n = this.getVariableValue(characterSpell, "CASTERLEVEL", string2).intValue();
        return n;
    }

    public double getStatBonusTo(String string, String string2) {
        List<BonusObj> list = this.statList.getBonusListOfType(string.toUpperCase(), string2.toUpperCase());
        Iterator<BonusObj> iterator = list.iterator();
        while (iterator.hasNext()) {
            BonusObj bonusObj = iterator.next();
            if (bonusObj.qualifies(this)) continue;
            iterator.remove();
        }
        return this.calcBonusFromList(list);
    }

    public double getTemplateBonusTo(String string, String string2) {
        return this.getPObjectWithCostBonusTo(this.templateList, string.toUpperCase(), string2.toUpperCase());
    }

    public double getTotalBonusTo(String string, String string2) {
        String string3 = new StringBuffer(string).append('.').append(string2).toString();
        return this.sumActiveBonusMap(string3);
    }

    public int getTotalLevels() {
        int n = 0;
        n += this.totalNonMonsterLevels();
        return n += this.totalHitDice();
    }

    public int getTotalPlayerLevels() {
        int n = 0;
        return n += this.totalNonMonsterLevels();
    }

    public int getTotalStatAtLevel(String string, int n, boolean bl) {
        int n2;
        int n3 = this.getStatList().getTotalStatFor(string);
        for (n2 = this.getLevelInfoSize() - 1; n2 >= n; --n2) {
            int n4 = this.pcLevelInfo.get(n2).getTotalStatMod(string, true);
            n3 -= n4;
        }
        if (!bl && n > 0) {
            n2 = this.pcLevelInfo.get(n - 1).getTotalStatMod(string, true);
            n3 -= (n2 -= this.pcLevelInfo.get(n - 1).getTotalStatMod(string, false));
        }
        return n3;
    }

    public int getTwoHandDamageDivisor() {
        int n = this.getVariableValue("TWOHANDDAMAGEDIVISOR", "").intValue();
        if (n == 0) {
            n = 2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public String getUnarmedDamageString(boolean bl, boolean bl2) {
        int n;
        int n2;
        void var5_10;
        String string = "2|1d2";
        for (PCClass object2 : this.classList) {
            string = PlayerCharacterUtilities.getBestUDamString(string, object2.getUdamForLevel(object2.getLevel(), this, bl2));
        }
        int n3 = Globals.sizeInt(this.getSize());
        String string2 = null;
        for (PObject pObject : this.getPObjectList()) {
            List<String> list;
            if (pObject == null || pObject instanceof PCClass || (list = pObject.getListFor(ListKey.UNARMED_DAMAGE)) == null) continue;
            String string3 = "";
            string3 = list.size() == 1 ? list.get(0) : list.get(n3);
            string = PlayerCharacterUtilities.getBestUDamString(string, string3);
        }
        if (string2 == null) {
            String string4 = this.getRace().getUdam(this);
        } else {
            String string5 = string2.substring(string2.indexOf(124) + 1);
        }
        string = PlayerCharacterUtilities.getBestUDamString(string, (String)var5_10);
        StringBuilder stringBuilder = new StringBuilder(string.substring(string.indexOf(124) + 1));
        if (bl && (n2 = (n = (int)this.getStatBonusTo("DAMAGE", "TYPE.MELEE")) + (int)this.getStatBonusTo("DAMAGE", "TYPE=MELEE")) != 0) {
            stringBuilder.append(Delta.toString(n2));
        }
        return stringBuilder.toString();
    }

    public boolean getUseMasterSkill() {
        for (CompanionMod companionMod : this.companionModList) {
            if (!companionMod.getType().equalsIgnoreCase(this.getMaster().getType().getKeyName()) || !companionMod.getUseMasterSkill()) continue;
            return true;
        }
        return false;
    }

    public void setUseTempMods(boolean bl) {
        this.useTempMods = bl;
    }

    public boolean getUseTempMods() {
        return this.useTempMods;
    }

    public Float getVariableValue(String string, String string2) {
        return this.getVariableValue(null, string, string2);
    }

    @Override
    public Float getVariableValue(String string, String string2, PlayerCharacter playerCharacter) {
        return this.getVariableValue(null, string, string2);
    }

    private Float getVariableValue(CharacterSpell characterSpell, String string, String string2) {
        VariableProcessor variableProcessor = this.getVariableProcessor();
        return variableProcessor.getVariableValue(characterSpell, string, string2, this.getSpellLevelTemp());
    }

    public VariableProcessor getVariableProcessor() {
        return this.variableProcessor;
    }

    /*
     * WARNING - void declaration
     */
    public int getTotalCasterLevelWithSpellBonus(CharacterSpell characterSpell, Spell spell, String string, String string2, int n) {
        boolean bl;
        void var12_23;
        void var12_20;
        String string3;
        String string4;
        if (spell != null && characterSpell.getFixedCasterLevel() != null) {
            return this.getVariableValue(characterSpell.getFixedCasterLevel(), "").intValue();
        }
        int n3 = n;
        boolean bl2 = false;
        ArrayList<CasterLevelSpellBonus> arrayList = new ArrayList<CasterLevelSpellBonus>();
        if (string2 != null) {
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string2);
            if (n3 > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string2);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if (!string2.startsWith("RACE.") && (n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = "CLASS." + string2)) > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
        }
        if (spell == null) {
            return n3;
        }
        if (!string.equals("None")) {
            string3 = "TYPE." + string;
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
            if (n3 > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) > 0) {
                bl2 = true;
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
        }
        if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = "SPELL." + spell.getKeyName())) > 0) {
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) > 0) {
            bl2 = true;
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        for (String object : new TreeSet<String>(spell.getSafeListFor(ListKey.SPELL_SCHOOL))) {
            string3 = "SCHOOL." + object;
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
            if (n3 != 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) <= 0) continue;
            bl2 = true;
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        for (String string5 : new TreeSet<String>(spell.getSafeListFor(ListKey.SPELL_SUBSCHOOL))) {
            string3 = "SUBSCHOOL." + string5;
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
            if (n3 > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) <= 0) continue;
            bl2 = true;
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        for (String string6 : spell.getSafeListFor(ListKey.SPELL_DESCRIPTOR)) {
            string3 = "DESCRIPTOR." + string6;
            n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
            if (n3 > 0) {
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
            if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) <= 0) continue;
            bl2 = true;
            string4 = this.getSpellBonusType("CASTERLEVEL", string3);
            arrayList.add(new CasterLevelSpellBonus(n3, string4));
        }
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList = this.getLevelInfo(spell);
        if (hashMapToList != null) {
            for (Object object : hashMapToList.getKeySet()) {
                if (!(object instanceof DomainSpellList)) continue;
                string3 = "DOMAIN." + object.getKeyName();
                n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3);
                if (n3 > 0) {
                    string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                    arrayList.add(new CasterLevelSpellBonus(n3, string4));
                }
                if ((n3 = (int)this.getTotalBonusTo("CASTERLEVEL", string3 = string3 + ".RESET")) <= 0) continue;
                bl2 = true;
                string4 = this.getSpellBonusType("CASTERLEVEL", string3);
                arrayList.add(new CasterLevelSpellBonus(n3, string4));
            }
        }
        boolean bl3 = false;
        while (var12_20 < arrayList.size() - 1) {
            Object object;
            object = (CasterLevelSpellBonus)arrayList.get((int)var12_20);
            String string7 = ((CasterLevelSpellBonus)object).getType();
            if (((CasterLevelSpellBonus)object).getBonus() != 0 && !string7.equals("")) {
                boolean bl4 = false;
                boolean bl5 = false;
                if (string7.endsWith(".REPLACE")) {
                    String string8 = string7.substring(0, string7.length() - 8);
                    bl4 = true;
                } else if (string7.endsWith(".STACK")) {
                    String string9 = string7.substring(0, string7.length() - 6);
                    bl5 = true;
                }
                for (void var17_34 = var12_20 + true; var17_34 < arrayList.size(); ++var17_34) {
                    void var14_26;
                    CasterLevelSpellBonus casterLevelSpellBonus = (CasterLevelSpellBonus)arrayList.get((int)var17_34);
                    String string10 = casterLevelSpellBonus.getType();
                    if (casterLevelSpellBonus.getBonus() == 0 || string10.equals("")) continue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    if (string10.endsWith(".REPLACE")) {
                        string10 = string10.substring(0, string10.length() - 8);
                        bl6 = true;
                    } else if (string10.endsWith(".STACK")) {
                        string10 = string10.substring(0, string10.length() - 6);
                        bl7 = true;
                    }
                    if (!var14_26.equals(string10)) continue;
                    if (bl4 && bl6) {
                        casterLevelSpellBonus.setBonus(((CasterLevelSpellBonus)object).getBonus() + casterLevelSpellBonus.getBonus());
                        ((CasterLevelSpellBonus)object).setBonus(0);
                        continue;
                    }
                    if (bl5 || bl7) continue;
                    if (((CasterLevelSpellBonus)object).getBonus() > casterLevelSpellBonus.getBonus()) {
                        casterLevelSpellBonus.setBonus(0);
                        continue;
                    }
                    ((CasterLevelSpellBonus)object).setBonus(0);
                }
            }
            ++var12_20;
        }
        int n2 = 0;
        if (!bl2) {
            int n4 = n2 + n;
        }
        for (CasterLevelSpellBonus casterLevelSpellBonus : arrayList) {
            var12_23 += casterLevelSpellBonus.getBonus();
        }
        if (var12_23 <= 0) {
            bl = true;
        }
        return bl ? 1 : 0;
    }

    private String getSpellBonusType(String string, String string2) {
        String string3 = new StringBuffer(string).append('.').append(string2).toString();
        string3 = string3.toUpperCase();
        Iterator<String> iterator = this.getActiveBonusMap().keySet().iterator();
        while (iterator.hasNext()) {
            String string4;
            String string5 = string4 = iterator.next();
            if (string4.endsWith(".STACK")) {
                string5 = string4.substring(0, string4.length() - 6);
            } else if (string4.endsWith(".REPLACE")) {
                string5 = string4.substring(0, string4.length() - 8);
            }
            if (string5.length() > string3.length() && !string5.startsWith(string3 + ":") || !string5.startsWith(string3)) continue;
            int n = string5.indexOf(":");
            if (n > 0) {
                return string4.substring(n + 1);
            }
            return "";
        }
        return "";
    }

    public List<Vision> getVisionList() {
        ObjectCache objectCache = this.cache;
        if (!objectCache.containsListFor(ListKey.VISION_CACHE)) {
            objectCache.initializeVisionCache(this);
        }
        return objectCache.getListFor(ListKey.VISION_CACHE);
    }

    public String getVision() {
        StringBuffer stringBuffer = new StringBuffer();
        List<Vision> list = this.getVisionList();
        for (Vision vision : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(vision);
        }
        return stringBuffer.toString();
    }

    public int abilityAC() {
        return this.calcACOfType("Ability");
    }

    public void addCharacterDomain(CharacterDomain characterDomain) {
        if (characterDomain != null && !this.characterDomainList.contains(characterDomain) && characterDomain.getDomain() != null) {
            this.characterDomainList.add(characterDomain);
            PCClass pCClass = this.getClassKeyed(characterDomain.getObjectName());
            if (pCClass != null) {
                int n = pCClass.getMaxCastLevel();
                DomainApplication.addSpellsToClassForLevels(this, characterDomain.getDomain(), pCClass, 0, n);
            }
            this.setDirty(true);
        }
    }

    public void addDomainSource(String string, String string2, int n, int n2) {
        String string3 = string + "|" + string2 + "|" + n;
        String string4 = Integer.toString(n2);
        this.domainSourceMap.put(string3, string4);
        this.setDirty(true);
    }

    public List<Equipment> addEqType(List<Equipment> list, String string) {
        for (Equipment equipment : this.getEquipmentList()) {
            if (equipment.typeStringContains(string)) {
                list.add(equipment);
                this.setDirty(true);
                continue;
            }
            if (!string.equalsIgnoreCase("CONTAINED") || equipment.getParent() == null) continue;
            list.add(equipment);
            this.setDirty(true);
        }
        return list;
    }

    public void addKit(Kit kit) {
        if (this.kitList == null) {
            this.kitList = new ArrayList<Kit>();
        }
        this.kitList.add(kit);
        this.setDirty(true);
    }

    public void addLanguage(Language language) {
        this.languages.add(language);
        this.setDirty(true);
    }

    public void addLanguageKeyed(String string) {
        Language language = Globals.getContext().ref.silentlyGetConstructedCDOMObject(LANGUAGE_CLASS, string);
        if (language != null) {
            this.addLanguage(language);
        }
    }

    public void removeLanguage(Language language) {
        this.languages.remove(language);
        this.setDirty(true);
    }

    public void addNaturalWeapons(List<Equipment> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.equipmentListAddAll(list);
        EquipSet equipSet = this.getEquipSetByIdPath("0.1");
        if (equipSet != null) {
            for (Equipment equipment : list) {
                EquipSet equipSet2 = this.addEquipToTarget(equipSet, null, "", equipment, null);
                if (equipSet2 != null) continue;
                this.addEquipToTarget(equipSet, null, "Carried", equipment, null);
            }
        }
        this.setDirty(true);
    }

    public Skill addSkill(Skill skill) {
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        for (Skill skill2 : arrayList) {
            if (!skill2.getKeyName().equals(skill.getKeyName())) continue;
            return skill2;
        }
        Skill skill3 = skill.clone();
        this.getSkillList().add(skill3);
        this.setDirty(true);
        if (!this.isImporting()) {
            skill3.globalChecks(this);
            this.calcActiveBonuses();
        }
        return skill3;
    }

    public String addSpell(CharacterSpell characterSpell, List<Ability> list, String string, String string2, int n, int n2) {
        Object object;
        int n3;
        if (characterSpell == null) {
            return "Invalid parameter to add spell";
        }
        PCClass pCClass = null;
        Spell spell = characterSpell.getSpell();
        if (string2 == null || string2.length() == 0) {
            return "Invalid spell list/book name.";
        }
        SpellBook spellBook = this.getSpellBookByName(string2);
        if (spellBook == null) {
            return "Could not find spell list/book " + string2;
        }
        if (string != null && (pCClass = this.getClassKeyed(string)) == null && string.lastIndexOf(40) >= 0) {
            pCClass = this.getClassKeyed(string.substring(0, string.lastIndexOf(40)).trim());
        }
        if (pCClass == null && spellBook.getType() == 3 && (pCClass = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string)) == null && string.lastIndexOf(40) >= 0) {
            pCClass = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string.substring(0, string.lastIndexOf(40)).trim());
        }
        if (pCClass == null) {
            return "No class keyed " + string;
        }
        if (!pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() && !string2.equals(Globals.getDefaultSpellBook())) {
            return pCClass.getDisplayName() + " can only add to " + Globals.getDefaultSpellBook();
        }
        if (!PrereqHandler.passesAll(spell.getPrerequisiteList(), this, spell)) {
            return "You do not qualify for " + characterSpell.getSpell().getDisplayName() + ".";
        }
        if (spellBook.getType() != 3 && !characterSpell.isSpecialtySpell() && pCClass.isProhibited(spell, this)) {
            return characterSpell.getSpell().getDisplayName() + " is prohibited.";
        }
        int n4 = pCClass.getKnownForLevel(n2, this);
        int n5 = 0;
        int n6 = pCClass.getCastForLevel(n, string2, true, true, this);
        pCClass.memorizedSpellForLevelBook(this, n, string2);
        boolean bl = string2.equals(Globals.getDefaultSpellBook());
        if (bl) {
            n5 = pCClass.getSpecialtyKnownForLevel(n2, this);
        }
        int n7 = 0;
        if (spellBook.getType() == 3) {
            this.setSpellLevelTemp(n2);
            n7 = this.getVariableValue(characterSpell, spellBook.getPageFormula().toString(), "").intValue();
            if (n7 + spellBook.getNumPagesUsed() > spellBook.getNumPages()) {
                return "There are not enough pages left to add this spell to the spell book.";
            }
            spellBook.setNumPagesUsed(n7 + spellBook.getNumPagesUsed());
            spellBook.setNumSpells(spellBook.getNumSpells() + 1);
        } else {
            if (!pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() && !this.availableSpells(n, pCClass, string2, true, characterSpell.isSpecialtySpell())) {
                int n8;
                String string3;
                if (!characterSpell.isSpecialtySpell() && this.availableSpells(n, pCClass, string2, true, true)) {
                    string3 = "Your remaining slot(s) must be filled with your speciality.";
                    n8 = n4;
                } else {
                    string3 = "You can only learn " + (n4 + n5) + " spells for level " + n + "\nand there are no higher-level slots available.";
                    n8 = n4 + n5;
                }
                int n9 = pCClass.memorizedSpellForLevelBook(this, n, string2);
                int n10 = n8 - n9;
                if (n10 > 0) {
                    string3 = string3 + "\n" + n10 + " spells from lower levels are using slots for this level.";
                }
                return string3;
            }
            if (pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() && !bl && !this.availableSpells(n, pCClass, string2, false, characterSpell.isSpecialtySpell())) {
                int n11;
                String string4;
                if (!characterSpell.isSpecialtySpell() && this.availableSpells(n, pCClass, string2, false, true)) {
                    string4 = "Your remaining slot(s) must be filled with your speciality or domain.";
                    n11 = pCClass.getCastForLevel(n, string2, false, true, this);
                } else {
                    string4 = "You can only prepare " + n6 + " spells for level " + n + "\nand there are no higher-level slots available.";
                    n11 = n6;
                }
                int n12 = pCClass.memorizedSpellForLevelBook(this, n, string2);
                int n13 = n11 - n12;
                if (n13 > 0) {
                    string4 = string4 + "\n" + n13 + " spells from lower levels are using slots for this level.";
                }
                return string4;
            }
        }
        SpellInfo spellInfo = null;
        List<CharacterSpell> list2 = this.getCharacterSpells(pCClass, characterSpell.getSpell(), string2, n);
        if (!list2.isEmpty()) {
            for (n3 = list2.size() - 1; n3 >= 0; --n3) {
                object = list2.get(n3);
                if (((CharacterSpell)object).equals(characterSpell)) continue;
                list2.remove(n3);
            }
        }
        if ((n3 = list2.isEmpty()) == 0) {
            if (list2.size() == 1) {
                object = list2.get(0);
                spellInfo = ((CharacterSpell)object).getSpellInfoFor(string2, n, -1, list);
            } else {
                spellInfo = characterSpell.getSpellInfoFor(string2, n, -1, list);
            }
        }
        if (spellInfo != null) {
            if (bl) {
                return "The Known Spells spellbook contains all spells of this level that you know. You cannot place spells in multiple times.";
            }
            spellInfo.setTimes(spellInfo.getTimes() + 1);
        } else {
            if (n3 != 0 && !this.containsAssoc(pCClass, AssociationListKey.CHARACTER_SPELLS, characterSpell)) {
                this.addAssoc(pCClass, AssociationListKey.CHARACTER_SPELLS, characterSpell);
            } else if (n3 != 0) {
                for (CharacterSpell characterSpell2 : this.getSafeAssocList(pCClass, AssociationListKey.CHARACTER_SPELLS)) {
                    if (!characterSpell2.equals(characterSpell)) continue;
                    characterSpell = characterSpell2;
                }
            }
            spellInfo = characterSpell.addInfo(n, 1, string2, list);
            if (Globals.hasSpellPPCost()) {
                object = characterSpell.getSpell();
                int n14 = ((CDOMObject)object).getSafe(IntegerKey.PP_COST);
                for (Ability ability : list) {
                    n14 += (int)ability.bonusTo("PPCOST", ((CDOMObject)object).getKeyName(), this, this);
                }
                spellInfo.setActualPPCost(n14);
            }
            if (Spell.hasSpellPointCost()) {
                object = characterSpell.getSpell();
                int n15 = SpellPoint.getSpellPointCostActual((Spell)object);
                for (Ability ability : list) {
                    n15 += (int)ability.bonusTo("SPELLPOINTCOST", ((CDOMObject)object).getKeyName(), this, this);
                }
                spellInfo.setActualSpellPointCost(n15);
            }
        }
        spellInfo.setNumPages(spellInfo.getNumPages() + n7);
        this.setDirty(true);
        return "";
    }

    public boolean addSpellBook(String string) {
        if (string != null && string.length() > 0 && !this.spellBooks.contains(string)) {
            return this.addSpellBook(new SpellBook(string, 2));
        }
        return false;
    }

    public boolean addSpellBook(SpellBook spellBook) {
        String string;
        if (spellBook != null && !this.spellBooks.contains(string = spellBook.getName())) {
            this.spellBooks.add(string);
            this.spellBookMap.put(string, spellBook);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public PCTemplate addTemplate(PCTemplate pCTemplate) {
        return this.addTemplate(pCTemplate, true);
    }

    public PCTemplate addTemplate(PCTemplate pCTemplate, boolean bl) {
        PCTemplate pCTemplate2;
        if (pCTemplate == null) {
            return null;
        }
        if (this.templateList.contains(pCTemplate)) {
            return null;
        }
        for (PCTemplate object2 : this.templateList) {
            if (!object2.getKeyName().equals(pCTemplate.getKeyName())) continue;
            return null;
        }
        int n = 0;
        for (PCClass n2 : this.classList) {
            if (!n2.isMonster()) continue;
            n = (int)this.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
            break;
        }
        try {
            pCTemplate2 = pCTemplate.clone();
            this.templateList.add(pCTemplate2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        if (!this.isImporting()) {
            for (LevelCommandFactory levelCommandFactory : pCTemplate.getSafeListFor(ListKey.ADD_LEVEL)) {
                levelCommandFactory.add(this);
            }
        }
        this.setDirty(true);
        this.calcActiveBonuses();
        for (CDOMReference<Language> cDOMReference : pCTemplate2.getSafeListFor(ListKey.AUTO_LANGUAGES)) {
            this.templateAutoLanguages.addAll(cDOMReference.getContainedObjects());
        }
        this.addStartingLanguages(pCTemplate2, this.templateLanguages);
        this.getAutoLanguages();
        this.addNaturalWeapons(pCTemplate2.getListFor(ListKey.NATURAL_WEAPON));
        this.setAutomaticAbilitiesStable(null, false);
        if (bl) {
            this.selectTemplates(pCTemplate2, this.isImporting());
        } else {
            Collection<PCTemplate> collection = this.getTemplatesAdded(pCTemplate2);
            for (Object object : collection) {
                this.addTemplate((PCTemplate)object);
            }
        }
        if (!this.isImporting()) {
            ChooserUtilities.modChoices(pCTemplate2, new ArrayList(), new ArrayList(), true, this, true, null);
            this.getSpellList();
            this.feats(pCTemplate2, this.getTotalLevels(), this.totalHitDice(), true);
            pCTemplate2.globalChecks(this);
        }
        this.setAggregateAbilitiesStable(null, false);
        this.getAutomaticAbilityList(AbilityCategory.FEAT);
        this.calcActiveBonuses();
        boolean bl2 = true;
        for (PCClass pCClass : this.classList) {
            boolean bl3;
            Object object;
            int n2;
            if (pCClass.isMonster() && (n2 = (int)this.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER")) != n && n2 > 0) {
                object = this.getLevelInfo().iterator();
                while (object.hasNext()) {
                    PCLevelInfo pCLevelInfo = (PCLevelInfo)object.next();
                    int n3 = pCClass.recalcSkillPointMod(this, pCLevelInfo.getLevel());
                    if (!pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName())) continue;
                    int n4 = pCLevelInfo.getSkillPointsGained();
                    pCLevelInfo.setSkillPointsGained(n3);
                    pCLevelInfo.setSkillPointsRemaining(pCLevelInfo.getSkillPointsRemaining() + n3 - n4);
                    pCClass.setSkillPool(pCClass.getSkillPool(this) + n3 - n4);
                    this.setSkillPoints(this.getSkillPoints() + n3 - n4);
                }
            }
            if (!this.isImporting() && (object = pCTemplate.get(ObjectKey.HITDIE)) != null) {
                for (int i = 1; i <= pCClass.getLevel(); ++i) {
                    HitDie hitDie = pCClass.getSafe(ObjectKey.LEVEL_HITDIE);
                    if (hitDie.equals(pCClass.getLevelHitDie(this, i))) continue;
                    pCClass.rollHP(this, i, bl3);
                }
            }
            bl3 = false;
        }
        this.adjustMoveRates();
        this.setDirty(true);
        return pCTemplate2;
    }

    public void addWeaponProf(String string) {
        WeaponProf weaponProf = Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, string);
        if (weaponProf != null) {
            if (this.theWeaponProfs == null) {
                this.theWeaponProfs = new TreeSet<WeaponProf>();
            }
            this.theWeaponProfs.add(weaponProf);
            this.setDirty(true);
        }
    }

    public void adjustGold(double d) {
        this.gold = new BigDecimal(this.gold.doubleValue() + d).divide(BigDecimal.ONE, 2, 6);
        this.setDirty(true);
    }

    public void adjustMoveRates() {
        this.movements = null;
        this.movementTypes = null;
        this.movementMult = null;
        this.movementMultOp = null;
        if (this.getRace() == null) {
            return;
        }
        List<Movement> list = this.getRace().getListFor(ListKey.MOVEMENT);
        if (list == null || list.isEmpty() || !list.get(0).isInitialized()) {
            return;
        }
        Movement movement = list.get(0);
        this.movements = movement.getMovements();
        this.movementTypes = movement.getMovementTypes();
        this.movementMult = movement.getMovementMult();
        this.movementMultOp = movement.getMovementMultOp();
        this.setMoveFromList(this.getCDOMObjectList());
        for (BonusObj bonusObj : this.getActiveBonusList()) {
            if (!bonusObj.getTypeOfBonus().equals("MOVEADD")) continue;
            List<String> list2 = this.buildMoveTypeList(bonusObj);
            for (String string : list2) {
                string = CoreUtility.capitalizeFirstLetter(string);
                boolean bl = false;
                for (int i = 0; i < this.movements.length; ++i) {
                    if (!string.equals(this.movementTypes[i])) continue;
                    bl = true;
                }
                if (bl) continue;
                this.setMyMoveRates(string, 0.0, 0.0, "", 0);
            }
        }
        this.setDirty(true);
    }

    private List<String> buildMoveTypeList(BonusObj bonusObj) {
        String string = bonusObj.getBonusInfo();
        if (string.startsWith("TYPE")) {
            string = string.substring(5);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.equals("%LIST")) {
            List<BonusObj.BonusPair> list = bonusObj.getStringListFromBonus(this);
            for (BonusObj.BonusPair bonusPair : list) {
                Logging.errorPrint("Got values for %LIST of " + bonusPair.bonusKey);
                String[] stringArray = bonusPair.bonusKey.split("\\.");
                String string2 = stringArray[stringArray.length - 1];
                if (string2.startsWith("TYPE")) {
                    string2 = string2.substring(5);
                }
                arrayList.add(string2);
            }
        } else if (!string.equals("ALL")) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<Spell> aggregateSpellList(String string, String string2, String string3, int n, int n2) {
        ArrayList<Spell> arrayList = new ArrayList<Spell>();
        for (PObject pObject : this.getSpellClassList()) {
            for (int i = n; i <= n2; ++i) {
                List<CharacterSpell> list = this.getCharacterSpells(pObject, null, "", i);
                for (CharacterSpell characterSpell : list) {
                    Spell spell = characterSpell.getSpell();
                    if (string.length() != 0 && !spell.containsInList(ListKey.SPELL_SCHOOL, string) && string2.length() != 0 && !spell.containsInList(ListKey.SPELL_SUBSCHOOL, string2) && string3.length() != 0 && !spell.containsInList(ListKey.SPELL_DESCRIPTOR, string3)) continue;
                    arrayList.add(spell);
                }
            }
        }
        return arrayList;
    }

    public int altHP() {
        int n = (int)this.getTotalBonusTo("HP", "ALTHP");
        return n;
    }

    public int baseAC() {
        return this.calcACOfType("Base");
    }

    public int baseAttackBonus() {
        Float f = this.epicBAB != null ? Float.valueOf(this.epicBAB.floatValue()) : this.getVariableProcessor().getCachedVariable("BaseAttackBonus");
        if (f != null) {
            return f.intValue();
        }
        PlayerCharacter playerCharacter = this.getMasterPC();
        if (playerCharacter != null && this.getCopyMasterBAB().length() > 0) {
            int n = playerCharacter.baseAttackBonus();
            String string = this.replaceMasterString(this.getCopyMasterBAB(), n);
            n = this.getVariableValue(string, "").intValue();
            this.getVariableProcessor().addCachedVariable("BaseAttackBonus", Float.valueOf(n));
            return n;
        }
        int n = this.getTotalCharacterLevel();
        HashMap<String, String> hashMap = null;
        boolean bl = false;
        if (n > SettingsHandler.getGame().getBabMaxLvl()) {
            bl = true;
            if (this.epicBAB == null) {
                hashMap = this.getTotalLevelHashMap();
                Map<String, String> map = this.getCharacterLevelHashMap(SettingsHandler.getGame().getBabMaxLvl());
                this.getVariableProcessor().pauseCache();
                this.setClassLevelsBrazenlyTo(map);
            } else {
                return this.epicBAB;
            }
        }
        int n2 = (int)this.getTotalBonusTo("COMBAT", "BAB");
        if (bl) {
            this.epicBAB = n2;
        }
        if (hashMap != null) {
            this.setClassLevelsBrazenlyTo(hashMap);
            this.getVariableProcessor().restartCache();
        }
        this.getVariableProcessor().addCachedVariable("BaseAttackBonus", Float.valueOf(n2));
        return n2;
    }

    public int basemovement(int n, Load load) {
        int n2 = this.getMovement(n).intValue();
        return n2;
    }

    public int calcACOfType(String string) {
        StringTokenizer stringTokenizer;
        PObject pObject;
        List<String> list = SettingsHandler.getGame().getACTypeAddString(string);
        List<String> list2 = SettingsHandler.getGame().getACTypeRemoveString(string);
        if (list == null && list2 == null) {
            Logging.errorPrint("Invalid ACType: " + string);
            return 0;
        }
        int n = 0;
        if (list != null) {
            for (String string2 : list) {
                pObject = new PObject();
                this.getPreReqFromACType(string2, pObject);
                if (!PrereqHandler.passesAll(pObject.getPrerequisiteList(), this, pObject)) continue;
                stringTokenizer = new StringTokenizer(string2, "|");
                n += this.subCalcACOfType(stringTokenizer);
            }
        }
        if (list2 != null) {
            for (String string2 : list2) {
                pObject = new PObject();
                this.getPreReqFromACType(string2, pObject);
                if (!PrereqHandler.passesAll(pObject.getPrerequisiteList(), this, pObject)) continue;
                stringTokenizer = new StringTokenizer(string2, "|");
                n -= this.subCalcACOfType(stringTokenizer);
            }
        }
        return n;
    }

    public void checkpointBonusMap() {
        this.checkpointMap = this.activeBonusMap;
    }

    public boolean compareToCheckpoint() {
        return this.checkpointMap != null && ((Object)this.checkpointMap).equals(this.activeBonusMap);
    }

    public void calcActiveBonuses() {
        if (this.isImporting() || this.race == null || this.rebuildingAbilities) {
            return;
        }
        this.buildVariableSet();
        do {
            this.checkpointBonusMap();
            this.setDirty(true);
            this.calcActiveBonusLoop();
        } while (!this.compareToCheckpoint());
    }

    private List<BonusObj> getAllActiveBonuses() {
        List<BonusObj> list = new ArrayList<BonusObj>();
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null || pObject instanceof EquipmentModifier || pObject instanceof PCClass && ((PCClass)pObject).getLevel() <= 0) continue;
            pObject.activateBonuses(this);
            list.addAll(pObject.getActiveBonuses(this));
        }
        list.addAll(this.getPurchaseModeBonuses());
        if (this.getUseTempMods()) {
            list.addAll(this.getTempBonuses());
        }
        list = Bonus.sortBonusList(list);
        return list;
    }

    private void calcActiveBonusLoop() {
        if (this.cablInt == this.lastCablInt) {
            return;
        }
        this.lastCablInt = this.cablInt++;
        List<BonusObj> list = this.getAllActiveBonuses();
        this.activeBonusList = list;
        this.buildActiveBonusMap();
    }

    public float calcCR() {
        float f = 0.0f;
        for (PCClass pObject : this.classList) {
            f += pObject.calcCR(this);
        }
        for (PCTemplate pCTemplate : this.templateList) {
            f += pCTemplate.getCR(this.getTotalLevels(), this.totalHitDice());
        }
        ChallengeRating challengeRating = this.race.getSafe(ObjectKey.CHALLENGE_RATING);
        float f2 = challengeRating.getRating().resolve(this, "").floatValue();
        if (f == 0.0f) {
            f += f2;
        } else if (f >= 1.0f && f2 >= 1.0f) {
            f += f2;
        }
        return f += (float)this.getTotalBonusTo("MISC", "CR");
    }

    public List<DamageReduction> getDRList() {
        ArrayList<DamageReduction> arrayList = new ArrayList<DamageReduction>();
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            List<DamageReduction> list = cDOMObject.getListFor(ListKey.DAMAGE_REDUCTION);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return DamageReduction.getDRList(this, arrayList);
    }

    public String calcDR() {
        return DamageReduction.getDRString(this, this.getDRList());
    }

    public double calcMoveMult(double d, int n) {
        double d2 = 0.0;
        if (this.movementMultOp[n].charAt(0) == '*') {
            d2 = d * this.movementMult[n];
        } else if (this.movementMultOp[n].charAt(0) == '/') {
            d2 = d / this.movementMult[n];
        }
        if (d2 > 0.0) {
            return d2;
        }
        return d;
    }

    public int calcSR(boolean bl) {
        int n = this.race.getSafe(ObjectKey.SR).getReduction().resolve(this, this.race.getQualifiedKey()).intValue();
        if (this.deity != null) {
            n = Math.max(n, this.deity.getSafe(ObjectKey.SR).getReduction().resolve(this, this.deity.getQualifiedKey()).intValue());
        }
        for (CompanionMod iterator2 : this.companionModList) {
            n = Math.max(n, iterator2.getSafe(ObjectKey.SR).getReduction().resolve(this, iterator2.getQualifiedKey()).intValue());
        }
        for (PCClass pCClass : this.classList) {
            n = Math.max(n, pCClass.getSafe(ObjectKey.SR).getReduction().resolve(this, pCClass.getQualifiedKey()).intValue());
            int n2 = pCClass.getLevel();
            for (int i = 0; i <= n2; ++i) {
                PCClassLevel pCClassLevel = pCClass.getClassLevel(i);
                n = Math.max(n, pCClassLevel.getSafe(ObjectKey.SR).getReduction().resolve(this, pCClassLevel.getQualifiedKey()).intValue());
            }
        }
        for (Ability ability : this.getFullAbilitySet()) {
            n = Math.max(n, ability.getSafe(ObjectKey.SR).getReduction().resolve(this, ability.getQualifiedKey()).intValue());
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            n = Math.max(n, skill.getSafe(ObjectKey.SR).getReduction().resolve(this, skill.getQualifiedKey()).intValue());
        }
        for (CharacterDomain characterDomain : this.characterDomainList) {
            if (characterDomain.getDomain() == null) continue;
            Domain domain = characterDomain.getDomain();
            n = Math.max(domain.getSafe(ObjectKey.SR).getReduction().resolve(this, domain.getQualifiedKey()).intValue(), n);
        }
        if (bl) {
            for (Equipment equipment : this.equipmentList) {
                if (!equipment.isEquipped()) continue;
                n = Math.max(n, equipment.getSafe(ObjectKey.SR).getReduction().resolve(this, equipment.getQualifiedKey()).intValue());
                for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                    n = Math.max(n, equipmentModifier.getSR(equipment, this));
                }
                for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                    n = Math.max(n, equipmentModifier.getSR(equipment, this));
                }
            }
        }
        int n3 = this.getTotalLevels();
        int n4 = this.totalHitDice();
        for (PCTemplate pCTemplate : this.templateList) {
            n = Math.max(n, TemplateSR.getSR(pCTemplate, n3, n4, this));
        }
        n += (int)this.getTotalBonusTo("MISC", "SR");
        if (!bl) {
            n -= (int)this.getEquipmentBonusTo("MISC", "SR");
        }
        return n;
    }

    public boolean canCastSpellTypeLevel(String string, int n, int n2) {
        for (PCClass pCClass : this.classList) {
            String string2 = pCClass.get(StringKey.SPELLTYPE);
            if (string2 == null || !"Any".equalsIgnoreCase(string) && !string2.equalsIgnoreCase(string)) continue;
            int n3 = pCClass.getKnownForLevel(n, this);
            if ((n3 += pCClass.getSpecialtyKnownForLevel(n, this)) >= n2) {
                return true;
            }
            if (pCClass.getCastForLevel(n, this) >= n2) {
                return true;
            }
            if (pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() || pCClass.hasKnownList() || !pCClass.zeroCastSpells()) continue;
            return true;
        }
        return false;
    }

    public int countSpellCastTypeLevel(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        for (PCClass pCClass : this.classList) {
            String string2 = pCClass.get(StringKey.SPELLTYPE);
            if (string2 == null || !"Any".equalsIgnoreCase(string) && !string2.equalsIgnoreCase(string)) continue;
            n2 += pCClass.getKnownForLevel(n, this);
            n2 += pCClass.getSpecialtyKnownForLevel(n, this);
            n3 += pCClass.getCastForLevel(n, this);
            if (pCClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() || pCClass.hasKnownList() || !pCClass.zeroCastSpells()) continue;
            return Integer.MAX_VALUE;
        }
        return n2 == 0 ? n3 : n2;
    }

    public boolean canSelectDeity(Deity deity) {
        boolean bl;
        if (deity == null) {
            return false;
        }
        if (this.classList.isEmpty()) {
            bl = true;
        } else {
            bl = false;
            block0: for (PCClass pCClass : this.classList) {
                List<CDOMReference<Deity>> list = pCClass.getListFor(ListKey.DEITY);
                if (list == null) {
                    bl = true;
                    break;
                }
                for (CDOMReference<Deity> cDOMReference : list) {
                    if (!cDOMReference.contains(deity)) continue;
                    bl = true;
                    break block0;
                }
            }
        }
        return bl && PrereqHandler.passesAll(deity.getPrerequisiteList(), this, deity);
    }

    public int classAC() {
        return this.calcACOfType("ClassDefense");
    }

    public String delSpell(SpellInfo spellInfo, PCClass pCClass, String string) {
        SpellBook spellBook;
        if (string == null || string.length() == 0) {
            return "Invalid spell book name.";
        }
        if (pCClass == null) {
            return "Error: Class is null";
        }
        CharacterSpell characterSpell = spellInfo.getOwner();
        boolean bl = string.equals(Globals.getDefaultSpellBook());
        if (bl && pCClass.isAutoKnownSpell(characterSpell.getSpell().getKeyName(), spellInfo.getActualLevel(), this)) {
            Logging.errorPrint("Notice: removing " + characterSpell.getSpell().getDisplayName() + " even though it is an auto known spell");
        }
        if ((spellBook = this.getSpellBookByName(string)).getType() == 3) {
            int n = spellInfo.getNumPages() / spellInfo.getTimes();
            spellBook.setNumPagesUsed(spellBook.getNumPagesUsed() - n);
            spellBook.setNumSpells(spellBook.getNumSpells() - 1);
            spellInfo.setNumPages(spellInfo.getNumPages() - n);
        }
        spellInfo.setTimes(spellInfo.getTimes() - 1);
        if (spellInfo.getTimes() <= 0) {
            characterSpell.removeSpellInfo(spellInfo);
        }
        if (characterSpell.getInfoList().isEmpty()) {
            this.removeAssoc(pCClass, AssociationListKey.CHARACTER_SPELLS, characterSpell);
        }
        return "";
    }

    public int calculateSaveBonus(int n, String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = SettingsHandler.getGame().getIndexOfCheck(string);
        int n3 = 0;
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n4] = stringTokenizer.nextToken();
            if ("TOTAL".equals(stringArray[n4])) {
                n3 += this.getTotalCheck(n2);
            } else if ("BASE".equals(stringArray[n4])) {
                n3 += this.getBaseCheck(n2);
            } else if ("MISC".equals(stringArray[n4])) {
                n3 += (int)this.getTotalBonusTo("CHECKS", string);
            }
            if ("EPIC".equals(stringArray[n4])) {
                n3 += (int)this.getBonusDueToType("CHECKS", string, "EPIC");
            }
            if ("MAGIC".equals(stringArray[n4])) {
                n3 += (int)this.getEquipmentBonusTo("CHECKS", string);
            }
            if ("RACE".equals(stringArray[n4])) {
                n3 += this.calculateSaveBonusRace(n);
            }
            if ("FEATS".equals(stringArray[n4])) {
                n3 += (int)this.getFeatBonusTo("CHECKS", string);
            }
            if ("STATMOD".equals(stringArray[n4])) {
                n3 += (int)this.getCheckBonusTo("CHECKS", string);
            }
            if ("NOEPIC".equals(stringArray[n4])) {
                n3 -= (int)this.getBonusDueToType("CHECKS", string, "EPIC");
            }
            if ("NOMAGIC".equals(stringArray[n4])) {
                n3 -= (int)this.getEquipmentBonusTo("CHECKS", string);
            }
            if ("NORACE".equals(stringArray[n4])) {
                n3 -= this.calculateSaveBonusRace(n);
            }
            if ("NOFEATS".equals(stringArray[n4])) {
                n3 -= (int)this.getFeatBonusTo("CHECKS", string);
            }
            if ("NOSTAT".equals(stringArray[n4]) || "NOSTATMOD".equals(stringArray[n4])) {
                n3 -= (int)this.getCheckBonusTo("CHECKS", string);
            }
            ++n4;
        }
        return n3;
    }

    public boolean delSpellBook(String string) {
        if (string.length() > 0 && !string.equals(Globals.getDefaultSpellBook()) && this.spellBooks.contains(string)) {
            return this.delSpellBook(this.spellBookMap.get(string));
        }
        return false;
    }

    public boolean delSpellBook(SpellBook spellBook) {
        String string;
        if (spellBook != null && !(string = spellBook.getName()).equals(Globals.getDefaultSpellBook()) && this.spellBooks.contains(string)) {
            this.spellBooks.remove(string);
            this.spellBookMap.remove(string);
            this.setDirty(true);
            for (PCClass pCClass : this.classList) {
                List<CharacterSpell> list = this.getCharacterSpells(pCClass, null, string, -1);
                for (int i = list.size() - 1; i >= 0; --i) {
                    CharacterSpell characterSpell = list.get(i);
                    characterSpell.removeSpellInfo(characterSpell.getSpellInfoFor(string, -1, -1));
                }
            }
            return true;
        }
        return false;
    }

    public void determinePrimaryOffWeapon() {
        this.primaryWeapons.clear();
        this.secondaryWeapons.clear();
        if (this.equipmentList.isEmpty()) {
            return;
        }
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        ArrayList<Equipment> arrayList2 = new ArrayList<Equipment>();
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isWeapon() || equipment.getSlots(this) < 1) continue;
            boolean bl = equipment.isEquipped();
            if (equipment.getLocation() == 1 || equipment.getLocation() == 3 && this.primaryWeapons.isEmpty() || equipment.getLocation() == 4) {
                if (bl) {
                    this.primaryWeapons.add(equipment);
                } else {
                    arrayList.add(equipment);
                }
            } else if (equipment.getLocation() == 3 && !this.primaryWeapons.isEmpty()) {
                if (bl) {
                    this.secondaryWeapons.add(equipment);
                } else {
                    arrayList2.add(equipment);
                }
            }
            if (equipment.getLocation() == 2) {
                if (bl) {
                    this.secondaryWeapons.add(equipment);
                } else {
                    arrayList2.add(equipment);
                }
            }
            if (equipment.getLocation() != 4) continue;
            for (int i = 0; i < equipment.getNumberEquipped() - 1; ++i) {
                if (bl) {
                    this.secondaryWeapons.add(equipment);
                    continue;
                }
                arrayList2.add(equipment);
            }
        }
        if (Globals.checkRule("EQUIPATTACK")) {
            if (arrayList.size() != 0) {
                this.primaryWeapons.addAll(arrayList);
            }
            if (arrayList2.size() != 0) {
                this.secondaryWeapons.addAll(arrayList2);
            }
        }
    }

    public int dodgeAC() {
        return this.calcACOfType("Dodge");
    }

    public int equipmentAC() {
        return this.calcACOfType("Equipment") + this.calcACOfType("Armor");
    }

    public int flatfootedAC() {
        return this.calcACOfType("Flatfooted");
    }

    public boolean hasDomainSource(String string, String string2, int n) {
        String string3 = string + "|" + string2 + "|" + n;
        return this.domainSourceMap.containsKey(string3);
    }

    public boolean hasFeatAutomatic(String string) {
        return AbilityUtilities.getAbilityFromList(this.featAutoList(), "FEAT", string, Ability.Nature.ANY) != null;
    }

    public boolean hasFeatVirtual(String string) {
        return AbilityUtilities.getAbilityFromList(this.getVirtualFeatList(), "FEAT", string, Ability.Nature.ANY) != null;
    }

    public boolean hasAutomaticAbility(AbilityCategory abilityCategory, Ability ability) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.hasFeatAutomatic(ability.getKeyName());
        }
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.AUTOMATIC);
        if (list == null) {
            return false;
        }
        return list.contains(ability);
    }

    public boolean hasVirtualAbility(AbilityCategory abilityCategory, Ability ability) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return this.hasFeatVirtual(ability.getKeyName());
        }
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.VIRTUAL);
        if (list == null) {
            return false;
        }
        return list.contains(ability);
    }

    public boolean hasMadeKitSelectionForAgeSet(int n) {
        return n >= 0 && n < 10 && this.ageSetKitSelections[n];
    }

    public boolean hasSpecialAbility(String string) {
        for (SpecialAbility specialAbility : this.getSpecialAbilityList()) {
            if (!specialAbility.getKeyName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public int hitPoints() {
        int n = 0;
        String string = Globals.getGameModeHPFormula();
        if (string.length() != 0) {
            int n2;
            int n3;
            while ((n3 = string.indexOf("$$")) >= 0 && (n2 = string.indexOf("$$", n3 + 2)) >= 0) {
                Object object2 = string.substring(n3 + 2, n2);
                object2 = ExportHandler.getTokenString(this, (String)object2);
                string = string.substring(0, n3) + (String)object2 + string.substring(n2 + 2);
            }
            n = this.getVariableValue(string, "").intValue();
        } else {
            double d = this.getStatBonusTo("HP", "BONUS");
            for (PCClass object3 : this.classList) {
                n += object3.hitPoints((int)d);
            }
        }
        n += (int)this.getTotalBonusTo("HP", "CURRENTMAX");
        PlayerCharacter playerCharacter = this.getMasterPC();
        if (playerCharacter == null) {
            return n;
        }
        if (this.getCopyMasterHP().length() == 0) {
            return n;
        }
        PlayerCharacter playerCharacter2 = this;
        Globals.setCurrentPC(playerCharacter);
        int n4 = playerCharacter.hitPoints();
        Globals.setCurrentPC(playerCharacter2);
        String string2 = this.replaceMasterString(this.getCopyMasterHP(), n4);
        n4 = this.getVariableValue(string2, "").intValue();
        return n4;
    }

    public boolean ignoreEncumberedArmorMove(Load load) {
        return this.compareLoad(load, ObjectKey.UNENCUMBERED_ARMOR);
    }

    public boolean ignoreEncumberedLoadMove(Load load) {
        return this.compareLoad(load, ObjectKey.UNENCUMBERED_LOAD);
    }

    private boolean compareLoad(Load load, ObjectKey<Load> objectKey) {
        Load load2 = this.cache.get(objectKey);
        if (load2 == null) {
            Load load3;
            load2 = Load.LIGHT;
            for (PObject pObject : this.getPObjectList()) {
                if (pObject == null || pObject instanceof PCClass || (load3 = pObject.get(objectKey)) == null || load2.compareTo(load3) >= 0) continue;
                load2 = load3;
            }
            for (PObject pObject : this.getConditionalTemplateObjects()) {
                load3 = pObject.get(objectKey);
                if (load3 == null || load2.compareTo(load3) >= 0) continue;
                load2 = load3;
            }
            for (PCClass pCClass : this.classList) {
                load3 = pCClass.getSafe(objectKey);
                for (int i = 0; i < pCClass.getLevel(); ++i) {
                    PCClassLevel pCClassLevel = pCClass.getClassLevel(i);
                    Load load4 = pCClassLevel.get(objectKey);
                    if (load4 == null) continue;
                    load3 = load4;
                }
                if (load2.compareTo(load3) >= 0) continue;
                load2 = load3;
            }
            this.cache.put(objectKey, load2);
        }
        return load2.compareTo(load) >= 0;
    }

    public void incrementClassLevel(int n, PCClass pCClass) {
        this.incrementClassLevel(n, pCClass, false);
        this.setDirty(true);
    }

    public int indexOfFirstEmptyCharacterDomain() {
        for (int i = 0; i < this.characterDomainList.size(); ++i) {
            CharacterDomain characterDomain = this.characterDomainList.get(i);
            if (characterDomain.getDomain() != null) continue;
            return i;
        }
        return -1;
    }

    public int initiativeMod() {
        int n = (int)this.getTotalBonusTo("COMBAT", "Initiative") + this.getVariableValue("INITCOMP", "").intValue();
        return n;
    }

    public int languageNum(boolean bl) {
        int n = (int)this.getStatBonusTo("LANG", "BONUS");
        Race race = this.getRace();
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        if (n < 0) {
            n = 0;
        }
        if (bl) {
            for (Skill cDOMObject : arrayList) {
                if (cDOMObject.getSafe(StringKey.CHOICE_STRING).indexOf("Language") < 0) continue;
                n += SkillRankControl.getTotalRank(this, cDOMObject).intValue();
            }
        }
        if (race != null) {
            n += (int)this.getTotalBonusTo("LANGUAGES", "NUMBER");
        }
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            List<PersistentTransitionChoice<?>> list = cDOMObject.getListFor(ListKey.ADD);
            if (list == null) continue;
            for (PersistentTransitionChoice<?> persistentTransitionChoice : list) {
                ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
                if (!LANGUAGE_CLASS.equals(choiceSet.getChoiceClass())) continue;
                n += persistentTransitionChoice.getCount().resolve(this, null).intValue();
            }
        }
        return n += this.freeLangs;
    }

    public String listBonusesFor(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string3 : this.getActiveBonusMap().keySet()) {
            if (!string3.startsWith(string)) continue;
            treeSet.add(string3);
        }
        for (String string3 : treeSet) {
            int n;
            if (string3.endsWith(".REPLACE")) {
                arrayList.add(string3);
                continue;
            }
            string2 = "";
            if (string3.length() > string.length()) {
                string2 = string3.substring(string.length() + 1);
            }
            if ((n = (int)this.getActiveBonusForMapKey(string3, 0.0)) == 0) continue;
            if (!"NULL".equals(string2) && string2.length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string2).append(' ');
            }
            stringBuffer.append(Delta.toString(n));
        }
        for (String string3 : arrayList) {
            String string4;
            if (string3.length() <= 7) continue;
            string2 = string3.substring(0, string3.length() - 8);
            double d = this.getActiveBonusForMapKey(string3, 0.0);
            double d2 = this.getActiveBonusForMapKey(string2, 0.0);
            int n = (int)Math.max(d2 += this.getActiveBonusForMapKey(string2 + ".STACK", 0.0), d);
            if (n == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            if (!"NULL".equals(string4 = string2.substring(string.length() + 1))) {
                stringBuffer.append(string4).append(' ');
            }
            stringBuffer.append(Delta.toString(n));
        }
        return stringBuffer.toString();
    }

    public boolean loadDescriptionFilesInDirectory(String string) {
        new File(string).list(new FilenameFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                if (PCGFile.isPCGenListFile(file2)) {
                    BufferedReader bufferedReader = null;
                    try {
                        if (!file2.exists()) return false;
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
                        int n = (int)file2.length();
                        char[] cArray = new char[n];
                        bufferedReader.read(cArray, 0, n);
                        PlayerCharacter.this.setDescriptionLst(PlayerCharacter.this.getDescriptionLst() + new String(cArray));
                        return false;
                    }
                    catch (IOException iOException) {
                        Logging.errorPrint("IOException in PlayerCharacter.loadDescriptionFilesInDirectory", iOException);
                        return false;
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException iOException) {
                                Logging.errorPrint("Couldn't close descriptionReader in PlayerCharacter.loadDescriptionFilesInDirectory", iOException);
                            }
                        }
                    }
                }
                if (!file.isDirectory()) return false;
                PlayerCharacter.this.loadDescriptionFilesInDirectory(file.getPath() + File.separator + string);
                return false;
            }
        });
        return false;
    }

    public void makeIntoExClass(PCClass pCClass) {
        CDOMSingleRef<PCClass> cDOMSingleRef = pCClass.get(ObjectKey.EX_CLASS);
        try {
            int n;
            PCClass pCClass2 = cDOMSingleRef.resolvesTo();
            PCClass pCClass3 = this.getClassKeyed(pCClass2.getKeyName());
            if (pCClass3 == null) {
                pCClass3 = pCClass2.clone();
                this.rebuildLists(pCClass3, pCClass, pCClass.getLevel(), this);
                pCClass3.setLevel(pCClass.getLevel(), this);
                pCClass3.setHitPointMap(pCClass.getHitPointMap());
                n = this.classList.indexOf(pCClass);
                this.classList.set(n, pCClass3);
            } else {
                this.rebuildLists(pCClass3, pCClass, pCClass.getLevel(), this);
                pCClass3.setLevel(pCClass3.getLevel() + pCClass.getLevel(), this);
                for (n = 0; n < pCClass.getLevel(); ++n) {
                    pCClass3.setHitPoint(pCClass3.getLevel() + n + 1, pCClass.getHitPoint(n + 1));
                }
                this.classList.remove(pCClass);
            }
            for (n = this.pcLevelInfo.size() - 1; n >= 0; --n) {
                PCLevelInfo cloneable = this.pcLevelInfo.get(n);
                if (!cloneable.getClassKeyName().equals(pCClass.getKeyName())) continue;
                cloneable.setClassKeyName(pCClass3.getKeyName());
            }
            for (Skill skill : this.getSkillList()) {
                SkillRankControl.replaceClassRank(this, skill, pCClass.getKeyName(), pCClass2.getKeyName());
            }
            pCClass3.setSkillPool(pCClass.getSkillPool(this));
        }
        catch (NumberFormatException numberFormatException) {
            ShowMessageDelegate.showMessageDialog(numberFormatException.getMessage(), "PCGen", MessageType.INFORMATION);
        }
    }

    public int minXPForECL() {
        return PlayerCharacterUtilities.minXPForLevel(this.getECL(), this);
    }

    public int minXPForNextECL() {
        return PlayerCharacterUtilities.minXPForLevel(this.getECL() + 1, this);
    }

    public int miscAC() {
        return this.calcACOfType("Misc");
    }

    public int modFromArmorOnWeaponRolls() {
        int n = 0;
        for (Equipment equipment : this.getEquipmentOfType("Armor", 1)) {
            if (equipment == null || this.isProficientWith(equipment)) continue;
            n += equipment.acCheck(this).intValue();
        }
        for (Equipment equipment : this.getEquipmentOfType("Shield", 1)) {
            if (equipment == null || this.isProficientWith(equipment)) continue;
            n += equipment.acCheck(this).intValue();
        }
        return n;
    }

    private Load getLoadType() {
        if (Globals.checkRule("SYS_LDPACSK")) {
            int n = this.getVariableValue("LOADSCORE", "").intValue();
            return Globals.loadTypeForLoadScore(n, this.totalWeight(), this);
        }
        return Load.LIGHT;
    }

    private int modToACFromEquipment() {
        int n = 0;
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            n += equipment.getACMod(this).intValue();
        }
        return n;
    }

    private int modToACCHECKFromEquipment() {
        Load load = this.getLoadType();
        int n = 0;
        int n2 = Load.MEDIUM == load ? -3 : (Load.HEAVY == load ? -6 : 0);
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            n += equipment.acCheck(this).intValue();
        }
        n = Math.min(n, n2);
        return n += (int)this.getTotalBonusTo("MISC", "ACCHECK");
    }

    private int modToSpellFailureFromEquipment() {
        int n = 0;
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            n += equipment.spellFailure(this).intValue();
        }
        return n += (int)this.getTotalBonusTo("MISC", "SPELLFAILURE");
    }

    private int modToMaxDexFromEquipment() {
        int n = (int)this.getStatBonusTo("MISC", "MAXDEX");
        Load load = this.getLoadType();
        int n2 = load == Load.MEDIUM ? 3 : (load == Load.HEAVY ? 1 : (load == Load.OVERLOAD ? 0 : n));
        boolean bl = load == Load.LIGHT;
        for (Equipment equipment : this.equipmentList) {
            int n3;
            if (!equipment.isEquipped() || (n3 = equipment.getMaxDex(this).intValue()) == Constants.MAX_MAXDEX) continue;
            if (bl || n2 > n3) {
                n2 = n3;
            }
            bl = false;
        }
        if (bl) {
            n2 = Constants.MAX_MAXDEX;
        }
        if ((n2 += (int)this.getTotalBonusTo("MISC", "MAXDEX") - n) < 0) {
            n2 = 0;
        } else if (n2 > Constants.MAX_MAXDEX) {
            n2 = Constants.MAX_MAXDEX;
        }
        return n2;
    }

    public int modToFromEquipment(String string) {
        if (string.equals("AC")) {
            return this.modToACFromEquipment();
        }
        if (string.equals("ACCHECK")) {
            return this.modToACCHECKFromEquipment();
        }
        if (string.equals("MAXDEX")) {
            return this.modToMaxDexFromEquipment();
        }
        if (string.equals("SPELLFAILURE")) {
            return this.modToSpellFailureFromEquipment();
        }
        return 0;
    }

    public double movement(int n) {
        double d = this.getMovement(n);
        d += this.getTotalBonusTo("MOVEADD", "TYPE." + this.getMovementType(n).toUpperCase());
        double d2 = d += this.getTotalBonusTo("MOVEADD", "TYPE.ALL");
        if (this.getMovementMult(n) > 0.0) {
            d2 = this.calcMoveMult(d, n);
        }
        double d3 = this.getTotalBonusTo("MOVEMULT", "TYPE." + this.getMovementType(n).toUpperCase());
        if ((d3 += this.getTotalBonusTo("MOVEMULT", "TYPE.ALL")) > 0.0) {
            d2 = (int)(d2 * d3);
        }
        double d4 = d2;
        d4 += this.getTotalBonusTo("POSTMOVEADD", "TYPE." + this.getMovementType(n).toUpperCase());
        d = Math.max(d2, d4 += this.getTotalBonusTo("POSTMOVEADD", "TYPE.ALL"));
        Load load = Load.LIGHT;
        for (Equipment equipment : this.getEquipmentOfType("Armor", 1)) {
            if (equipment.isShield()) continue;
            if (equipment.isHeavy() && !this.ignoreEncumberedArmorMove(Load.HEAVY)) {
                load = load.max(Load.HEAVY);
                continue;
            }
            if (!equipment.isMedium() || this.ignoreEncumberedArmorMove(Load.MEDIUM)) continue;
            load = load.max(Load.MEDIUM);
        }
        double d5 = Globals.calcEncumberedMove(load, d, true, null);
        Load load2 = Globals.loadTypeForLoadScore(this.getVariableValue("LOADSCORE", "").intValue(), this.totalWeight(), this);
        double d6 = Globals.calcEncumberedMove(load2, d, true, this);
        d = Math.min(d5, d6);
        return d;
    }

    public double multiclassXPMultiplier() {
        HashSet<PCClass> hashSet = new HashSet<PCClass>();
        SortedSet<PCClass> sortedSet = this.getFavoredClasses();
        boolean bl = this.hasAnyFavoredClass();
        PCClass pCClass = null;
        PCClass pCClass2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 1.0;
        for (PCClass pCClass3 : this.classList) {
            if (!pCClass3.hasXPPenalty()) continue;
            String string = pCClass3.getSubClassKey();
            PCClass pCClass4 = pCClass3;
            if (!string.equals("None")) {
                pCClass4 = pCClass3.getSubClassKeyed(string);
            }
            if (sortedSet.contains(pCClass4)) continue;
            hashSet.add(pCClass3);
            if (pCClass3.getLevel() > n) {
                if (bl) {
                    n2 = n;
                    pCClass2 = pCClass;
                }
                n = pCClass3.getLevel();
                pCClass = pCClass3;
                continue;
            }
            if (pCClass3.getLevel() <= n2 || !bl) continue;
            n2 = pCClass3.getLevel();
            pCClass2 = pCClass3;
        }
        if (bl && n2 > 0) {
            n = n2;
            hashSet.remove(pCClass);
            pCClass = pCClass2;
        }
        if (n > 0) {
            hashSet.remove(pCClass);
            for (PCClass pCClass3 : hashSet) {
                if (n - pCClass3.getLevel() <= 1) continue;
                ++n3;
            }
            d = 1.0 - (double)n3 * 0.2;
            if (d < 0.0) {
                d = 0.0;
            }
        }
        return d;
    }

    public boolean hasAnyFavoredClass() {
        if (this.getRace().getSafe(ObjectKey.ANY_FAVORED_CLASS).booleanValue()) {
            return true;
        }
        for (PCTemplate pCTemplate : this.templateList) {
            if (!pCTemplate.getSafe(ObjectKey.ANY_FAVORED_CLASS).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public int naturalAC() {
        return this.calcACOfType("NaturalArmor");
    }

    public String parseSpellString(CharacterSpell characterSpell, String string, PObject pObject) {
        String string2 = null;
        if (pObject instanceof Domain) {
            CharacterDomain characterDomain = this.getCharacterDomainForDomain(pObject.getKeyName());
            if (characterDomain != null && characterDomain.isFromPCClass()) {
                string2 = "CLASS:" + this.getClassKeyed(characterDomain.getObjectName());
            }
        } else if (pObject instanceof PCClass) {
            string2 = "CLASS:" + pObject.getKeyName();
        } else if (pObject instanceof Race) {
            string2 = "RACE:" + pObject.getKeyName();
        }
        if (string2 == null) {
            return string;
        }
        while (string.lastIndexOf(40) >= 0) {
            boolean bl = false;
            int n = string.indexOf(40);
            int n2 = 0;
            int n3 = 0;
            for (int i = n; i < string.length(); ++i) {
                if (string.charAt(i) == '(') {
                    ++n3;
                    continue;
                }
                if (string.charAt(i) != ')' || --n3 != 0) continue;
                n2 = i;
                break;
            }
            String string3 = string.substring(n + 1, n2);
            String string4 = "0";
            Float f = this.getVariableValue(characterSpell, string3, string2);
            if (!CoreUtility.doublesEqual(f.floatValue(), 0.0)) {
                bl = true;
                string4 = f.intValue() + "";
            } else if (string3.indexOf("MIN") >= 0 || string3.indexOf("MAX") >= 0) {
                bl = true;
                string4 = f.intValue() + "";
            } else if (string3.toUpperCase().indexOf("MIN(") >= 0 || string3.toUpperCase().indexOf("MAX(") >= 0) {
                bl = true;
                string4 = f.intValue() + "";
            }
            if (bl) {
                string = string.substring(0, n) + string4 + string.substring(n2 + 1);
                continue;
            }
            string = string.substring(0, n) + "[" + string3 + "]" + string.substring(n2 + 1);
        }
        return string;
    }

    public void populateSkills(int n) {
        boolean bl;
        int n2;
        Globals.sortPObjectListByName(this.getSkillList());
        this.removeExcessSkills(n);
        this.addNewSkills(n);
        switch (this.getSkillsOutputOrder()) {
            case 0: {
                n2 = 0;
                bl = true;
                break;
            }
            case 1: {
                n2 = 0;
                bl = false;
                break;
            }
            case 2: {
                n2 = 1;
                bl = true;
                break;
            }
            case 3: {
                n2 = 1;
                bl = false;
                break;
            }
            default: {
                return;
            }
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        SkillComparator skillComparator = new SkillComparator(this, n2, bl);
        int n3 = 1;
        Collections.sort(arrayList, skillComparator);
        for (Skill skill : arrayList) {
            Integer n4 = this.getAssoc(skill, AssociationKey.OUTPUT_INDEX);
            if (n4 != null && n4 < 0) continue;
            this.setAssoc(skill, AssociationKey.OUTPUT_INDEX, n3++);
        }
    }

    public void removeCharacterDomain(CharacterDomain characterDomain) {
        if (!this.characterDomainList.isEmpty()) {
            this.characterDomainList.remove(characterDomain);
            this.setDirty(true);
        }
    }

    public void removeCharacterDomain(String string) {
        CharacterDomain characterDomain = this.getCharacterDomainForDomain(string);
        this.characterDomainList.remove(characterDomain);
    }

    public void removeNaturalWeapons(PObject pObject) {
        for (Equipment equipment : pObject.getSafeListFor(ListKey.NATURAL_WEAPON)) {
            this.removeEquipment(equipment);
            this.delEquipSetItem(equipment);
            this.setDirty(true);
        }
    }

    public void removeTempBonus(BonusObj bonusObj) {
        this.getTempBonusList().remove(bonusObj);
        this.setDirty(true);
    }

    public void removeTempBonusItemList(Equipment equipment) {
        this.getTempBonusItemList().remove(equipment);
        this.setDirty(true);
    }

    public void removeTemplate(PCTemplate pCTemplate) {
        if (pCTemplate == null) {
            return;
        }
        this.cachedWeaponProfs = null;
        List<CDOMReference<Language>> list = pCTemplate.getSafeListFor(ListKey.AUTO_LANGUAGES);
        for (CDOMReference<Language> object22 : list) {
            this.languages.removeAll(object22.getContainedObjects());
        }
        list = pCTemplate.getSafeListFor(ListKey.AUTO_LANGUAGES);
        for (CDOMReference<Language> cDOMReference : list) {
            this.templateAutoLanguages.removeAll(cDOMReference.getContainedObjects());
        }
        Collection collection = pCTemplate.getListMods(Language.STARTING_LIST);
        if (collection != null) {
            for (CDOMReference cDOMReference : collection) {
                this.templateLanguages.removeAll(cDOMReference.getContainedObjects());
            }
        }
        this.removeNaturalWeapons(pCTemplate);
        PCTemplate pCTemplate2 = this.getTemplateKeyed(pCTemplate.getKeyName());
        List<LevelCommandFactory> list2 = pCTemplate2.getSafeListFor(ListKey.ADD_LEVEL);
        Iterator<ConcretePrereqObject> iterator = list2.listIterator(list2.size());
        while (iterator.hasPrevious()) {
            iterator.previous().remove(this);
        }
        this.removeTemplatesFrom(pCTemplate);
        for (PCTemplate pCTemplate3 : this.templateList) {
            if (!pCTemplate3.getKeyName().equals(pCTemplate.getKeyName())) continue;
            this.templateList.remove(pCTemplate3);
            break;
        }
        this.setAutomaticFeatsStable(false);
        this.adjustMoveRates();
        this.getSpellList();
        this.calcActiveBonuses();
        this.setDirty(true);
    }

    public String replaceMasterString(String string, int n) {
        int n2;
        while ((n2 = string.indexOf("MASTER")) != -1) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 6);
            string = string2 + Integer.toString(n) + string3;
        }
        return string;
    }

    public PCLevelInfo saveLevelInfo(String string) {
        PCLevelInfo pCLevelInfo = new PCLevelInfo(this, string);
        this.pcLevelInfo.add(pCLevelInfo);
        return pCLevelInfo;
    }

    public void saveStatIncrease(String string, int n, boolean bl) {
        int n2 = this.getLevelInfoSize() - 1;
        if (n2 >= 0) {
            this.pcLevelInfo.get(n2).addModifiedStat(string, n, bl);
        }
        this.setDirty(true);
    }

    public int getStatIncrease(String string, boolean bl) {
        int n = this.getLevelInfoSize() - 1;
        if (n >= 0) {
            return this.pcLevelInfo.get(n).getTotalStatMod(string, bl);
        }
        return 0;
    }

    public int sizeAC() {
        return this.calcACOfType("Size");
    }

    public int sizeInt() {
        int n = this.racialSizeInt();
        if (this.race != null) {
            n += (int)this.getTotalBonusTo("SIZEMOD", "NUMBER");
            for (int i = 0; i < this.race.sizesAdvanced(this.totalHitDice()); ++i) {
                ++n;
            }
            if (n < 0) {
                n = 0;
            }
            if (n >= SettingsHandler.getGame().getSizeAdjustmentListSize()) {
                n = SettingsHandler.getGame().getSizeAdjustmentListSize() - 1;
            }
        }
        return n;
    }

    public int totalHitDice() {
        return this.totalMonsterLevels();
    }

    public int totalNonMonsterLevels() {
        int n = 0;
        for (PCClass pCClass : this.classList) {
            if (pCClass.isMonster()) continue;
            n += pCClass.getLevel();
        }
        return n;
    }

    public BigDecimal totalValue() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (Equipment equipment : this.getEquipmentMasterList()) {
            bigDecimal = bigDecimal.add(equipment.getCost(this).multiply(new BigDecimal(equipment.qty())));
        }
        return bigDecimal;
    }

    public Float totalWeight() {
        float f = 0.0f;
        Float f2 = Float.valueOf(0.0f);
        boolean bl = true;
        if (this.equipmentList.isEmpty()) {
            return f2;
        }
        for (Equipment equipment : this.equipmentList) {
            if (equipment.getCarried().compareTo(f2) <= 0 || equipment.getParent() != null) continue;
            if (equipment.getChildCount() > 0) {
                f = (float)((double)f + (equipment.getWeightAsDouble(this) + (double)equipment.getContainedWeight(this).floatValue()));
                continue;
            }
            if (bl && equipment.isEquipped() && equipment.isType("CLOTHING")) {
                bl = false;
                f = (float)((double)f + equipment.getWeightAsDouble(this) * (double)Math.max(equipment.getCarried().floatValue() - 1.0f, 0.0f));
                continue;
            }
            f = (float)((double)f + equipment.getWeightAsDouble(this) * (double)equipment.getCarried().floatValue());
        }
        return Float.valueOf(f);
    }

    public int touchAC() {
        return this.calcACOfType("Touch");
    }

    public void updateEquipSetItem(Equipment equipment, Equipment equipment2) {
        if (this.equipSetList.isEmpty()) {
            return;
        }
        ArrayList<EquipSet> arrayList = new ArrayList<EquipSet>();
        for (EquipSet equipSet : this.equipSetList) {
            Equipment equipment3 = equipSet.getItem();
            if (equipment3 == null || !equipment.equals(equipment3)) continue;
            arrayList.add(equipSet);
        }
        for (EquipSet equipSet : arrayList) {
            equipSet.setValue(equipment2.getName());
            equipSet.setItem(equipment2);
        }
        this.setDirty(true);
    }

    public boolean wasEverSaved() {
        return !"".equals(this.getFileName());
    }

    void setActiveBonusStack(double d, String string, Map<String, String> map) {
        String string2;
        if (string != null) {
            if (!((string = string.toUpperCase()).startsWith("ITEMWEIGHT") || string.startsWith("ITEMCOST") || string.startsWith("ACVALUE") || string.startsWith("ITEMCAPACITY") || string.startsWith("LOADMULT") || string.startsWith("FEAT") || string.indexOf("DAMAGEMULT") >= 0)) {
                d = (int)d;
            }
        } else {
            return;
        }
        int n = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() == 2) {
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (string2 != null) {
                n = SettingsHandler.getGame().getUnmodifiableBonusStackList().indexOf(string2);
            }
        } else {
            n = 1;
        }
        if (string.endsWith(".STACK") || string.endsWith(".REPLACE")) {
            n = 1;
        }
        if (d < 0.0) {
            n = 1;
        }
        if (n == -1) {
            string2 = map.get(string);
            if (string2 == null) {
                this.putActiveBonusMap(string, String.valueOf(d), map);
            } else {
                this.putActiveBonusMap(string, String.valueOf(Math.max(d, (double)Float.parseFloat(string2))), map);
            }
        } else {
            string2 = map.get(string);
            if (string2 == null) {
                this.putActiveBonusMap(string, String.valueOf(d), map);
            } else {
                this.putActiveBonusMap(string, String.valueOf(d + (double)Float.parseFloat(string2)), map);
            }
        }
    }

    public List<Ability> getAvailableAbilities(String string, String string2, boolean bl) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator(string);
        while (iterator.hasNext()) {
            Ability ability = (Ability)iterator.next();
            if (!ability.isType(string2) || !this.canSelectAbility(ability, bl)) continue;
            arrayList.add(ability);
        }
        return arrayList;
    }

    public List<String> getAvailableFeatNames(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("FEAT");
        while (iterator.hasNext()) {
            Ability ability = (Ability)iterator.next();
            if (!ability.isType(string) || !this.canSelectAbility(ability, bl)) continue;
            arrayList.add(ability.getKeyName());
        }
        return arrayList;
    }

    public boolean isNotImporting() {
        return !this.importing;
    }

    public boolean isImporting() {
        return this.importing;
    }

    Double getMovementMult(int n) {
        if (this.getMovements() != null && n < this.movementMult.length) {
            return this.movementMult[n];
        }
        return 0.0;
    }

    void addVariable(String string) {
        this.variableList.add(string);
        this.setDirty(true);
    }

    void giveClassesAway(PCClass pCClass, PCClass pCClass2, int n) {
        int n2;
        if (pCClass == null || pCClass2 == null) {
            return;
        }
        if (pCClass.hasMaxLevel() && pCClass.getLevel() + n > pCClass.getSafe(IntegerKey.LEVEL_LIMIT)) {
            n = pCClass.getSafe(IntegerKey.LEVEL_LIMIT) - pCClass.getLevel();
        }
        if (pCClass2.getLevel() <= n || n < 1) {
            return;
        }
        int n3 = pCClass2.getLevel() - n;
        int n4 = pCClass.getLevel();
        pCClass.setLevel(n4 + n, this);
        for (int i = 0; i < n; ++i) {
            pCClass.setHitPoint(n4 + i, pCClass2.getHitPoint(n3 + i));
            pCClass2.setHitPoint(n3 + i, 0);
        }
        this.rebuildLists(pCClass, pCClass2, n, this);
        pCClass2.setLevel(n3, this);
        for (PCLevelInfo pCLevelInfo : this.pcLevelInfo) {
            if (!pCLevelInfo.getClassKeyName().equals(pCClass.getKeyName())) continue;
            n2 = pCLevelInfo.getLevel() + pCClass.getLevel() - n4;
            pCLevelInfo.setLevel(n2);
        }
        for (PCLevelInfo pCLevelInfo : this.pcLevelInfo) {
            if (!pCLevelInfo.getClassKeyName().equals(pCClass2.getKeyName()) || pCLevelInfo.getLevel() <= n3) continue;
            n2 = pCLevelInfo.getLevel() - n3;
            pCLevelInfo.setClassKeyName(pCClass.getKeyName());
            pCLevelInfo.setLevel(n2);
        }
    }

    public boolean containsCharacterDomain(String string) {
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain = characterDomain.getDomain();
            if (!domain.getKeyName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCharacterDomain(String string, String string2) {
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain;
            if (!characterDomain.isFromPCClass(string) || !(domain = characterDomain.getDomain()).getKeyName().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public void addFreeLanguage(Language language) {
        this.languages.add(language);
        ++this.freeLangs;
        this.setDirty(true);
    }

    public void removeFreeLanguage(Language language) {
        this.languages.remove(language);
        --this.freeLangs;
        this.setDirty(true);
    }

    void removeVariable(String string) {
        Iterator<String> iterator = this.variableList.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string)) continue;
            iterator.remove();
            this.setDirty(true);
        }
    }

    void validateCharacterDomains() {
        if (!this.isImporting()) {
            this.getSpellList();
        }
        for (CharacterDomain characterDomain : this.characterDomainList) {
            if (characterDomain.isDomainValidFor(this)) continue;
            this.removeCharacterDomain(characterDomain);
        }
    }

    private double getActiveBonusForMapKey(String string, double d) {
        string = string.toUpperCase();
        String string2 = this.getActiveBonusMap().get(string);
        if (string2 != null) {
            return Double.parseDouble(string2);
        }
        return d;
    }

    public List<BonusObj> getActiveBonusList() {
        return this.activeBonusList;
    }

    private List<ProfProvider<ArmorProf>> getAutoArmorProfList() {
        ArrayList<ProfProvider<ArmorProf>> arrayList = new ArrayList<ProfProvider<ArmorProf>>();
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            for (ArmorProfProvider armorProfProvider : cDOMObject.getSafeListFor(ListKey.AUTO_ARMORPROF)) {
                if (!armorProfProvider.qualifies(this)) continue;
                arrayList.add(armorProfProvider);
            }
        }
        return arrayList;
    }

    private double getCheckBonusTo(String string, String string2) {
        double d = 0.0;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        List<PObject> list = SettingsHandler.getGame().getUnmodifiableCheckList();
        for (PObject pObject : list) {
            List<BonusObj> list2 = pObject.getBonusListOfType(this, string, string2);
            if (list2.isEmpty()) continue;
            d += this.calcBonusFromList(list2);
        }
        return d;
    }

    private synchronized void setClassLevelsBrazenlyTo(Map<String, String> map) {
        for (PCClass pCClass : this.classList) {
            String string = map.get(pCClass.getKeyName());
            if (string == null) {
                string = "0";
            }
            pCClass.setLevelWithoutConsequence(Integer.parseInt(string));
        }
        this.calcActiveBonuses();
    }

    private String getDisplayClassName() {
        return this.classList.isEmpty() ? "Nobody" : this.classList.get(this.classList.size() - 1).getDisplayClassName();
    }

    private String getDisplayRaceName() {
        String string = this.getRace().toString();
        return string.equals("<none selected>") ? "Nothing" : string;
    }

    public double getEquipmentBonusTo(String string, String string2) {
        double d = 0.0;
        if (this.equipmentList.isEmpty()) {
            return d;
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        for (Equipment equipment : this.equipmentList) {
            if (!equipment.isEquipped()) continue;
            List<BonusObj> list = equipment.getBonusListOfType(this, string, string2, true);
            if (equipment.isWeapon() && equipment.isDouble()) {
                list.addAll(equipment.getBonusListOfType(this, string, string2, false));
            }
            d += this.calcBonusFromList(list);
        }
        return d;
    }

    private String getFullDisplayClassName() {
        if (this.classList.isEmpty()) {
            return "Nobody";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (PCClass pCClass : this.classList) {
            if (!bl) {
                stringBuffer.append('/');
                bl = false;
            }
            stringBuffer.append(pCClass.getFullDisplayClassName());
        }
        return stringBuffer.toString();
    }

    private Map<String, String> getCharacterLevelHashMap(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        for (int i = 0; i < this.getLevelInfoSize(); ++i) {
            String string = this.getLevelInfoClassKeyName(i);
            PCClass pCClass = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string);
            if (pCClass.isMonster() || n2 < n) {
                String string2 = (String)hashMap.get(string);
                if (string2 == null) {
                    string2 = "0";
                }
                string2 = String.valueOf(Integer.parseInt(string2) + 1);
                hashMap.put(string, string2);
            }
            if (pCClass.isMonster()) continue;
            ++n2;
        }
        return hashMap;
    }

    private void setMoveFromList(List<? extends CDOMObject> list) {
        for (CDOMObject cDOMObject : list) {
            List<Movement> list2 = cDOMObject.getListFor(ListKey.MOVEMENT);
            if (list2 == null || list2.isEmpty()) continue;
            for (Movement movement : list2) {
                if (movement == null || movement.getNumberOfMovements() < 1) continue;
                for (int i = 0; i < movement.getNumberOfMovements(); ++i) {
                    this.setMyMoveRates(movement.getMovementType(i), movement.getMovement(i), movement.getMovementMult(i), movement.getMovementMultOp(i), movement.getMoveRatesFlag());
                }
            }
        }
    }

    public Double[] getMovements() {
        return this.movements;
    }

    private void setMyMoveRates(String string, double d, Double d2, String string2, int n) {
        if ("ALL".equals(string)) {
            if (n == 0) {
                for (int i = 0; i < this.movements.length; ++i) {
                    Double d3;
                    this.movements[i] = d3 = new Double(d);
                }
            } else {
                for (int i = 0; i < this.movements.length; ++i) {
                    Double d4;
                    this.movements[i] = d4 = new Double(d + this.movements[i]);
                }
            }
        } else if (n == 0) {
            Double d5 = new Double(d);
            for (int i = 0; i < this.movements.length; ++i) {
                if (!string.equals(this.movementTypes[i])) continue;
                if (d5 > this.movements[i]) {
                    this.movements[i] = d5;
                }
                if (string2 != null && (this.movementMultOp[i] == null || string2.length() > 0)) {
                    this.movementMult[i] = d2;
                    this.movementMultOp[i] = string2;
                }
                return;
            }
            this.increaseMoveArray(d5, string, d2, string2);
        } else {
            Double d6 = new Double(d + this.movements[0]);
            for (int i = 0; i < this.movements.length; ++i) {
                if (!string.equals(this.movementTypes[i])) continue;
                this.movements[i] = d6;
                this.movementMult[i] = d2;
                this.movementMultOp[i] = string2;
                return;
            }
            this.increaseMoveArray(d6, string, d2, string2);
        }
        this.setDirty(true);
    }

    public int getNumAttacks() {
        return Math.min(Math.max(this.baseAttackBonus() / 5, 4), 1);
    }

    private String getOrdinal(int n) {
        switch (n) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    private double getPObjectWithCostBonusTo(List<? extends PObject> list, String string, String string2) {
        double d = 0.0;
        if (list.isEmpty()) {
            return d;
        }
        for (PObject pObject : list) {
            List<BonusObj> list2 = pObject.getBonusListOfType(this, string, string2);
            d += this.calcBonusWithCostFromList(list2);
        }
        return d;
    }

    private boolean isProficientWithWeapon(Equipment equipment) {
        if (equipment.isNatural()) {
            return true;
        }
        CDOMSingleRef<WeaponProf> cDOMSingleRef = equipment.get(ObjectKey.WEAPON_PROF);
        if (cDOMSingleRef == null) {
            return false;
        }
        WeaponProf weaponProf = cDOMSingleRef.resolvesTo();
        return this.hasWeaponProfKeyed(weaponProf.getKeyName());
    }

    private void selectRacialFavoredClass() {
        TransitionChoice<PCClass> transitionChoice = this.getRace().get(ObjectKey.FAVCLASS_CHOICE);
        if (transitionChoice != null) {
            this.selectedFavoredClass = transitionChoice.driveChoice(this).iterator().next();
        }
    }

    private String getSubRegion(boolean bl) {
        String string = this.getStringFor(StringKey.SUB_REGION);
        if (string != null || !bl) {
            return string;
        }
        String string2 = "None";
        for (PCTemplate pCTemplate : this.templateList) {
            String string3 = pCTemplate.getSubRegion();
            if (string3.equals("None")) continue;
            string2 = string3;
        }
        return string2;
    }

    private int getTotalCharacterLevel() {
        int n = 0;
        for (PCClass pCClass : this.classList) {
            if (pCClass.isMonster()) continue;
            n += pCClass.getLevel();
        }
        return n;
    }

    private HashMap<String, String> getTotalLevelHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (PCClass pCClass : this.classList) {
            hashMap.put(pCClass.getKeyName(), String.valueOf(pCClass.getLevel()));
        }
        return hashMap;
    }

    private void addSpells(CDOMObject cDOMObject) {
        if (this.race == null || cDOMObject == null) {
            return;
        }
        Collection collection = cDOMObject.getListMods(Spell.SPELLS);
        if (collection == null) {
            return;
        }
        for (CDOMReference cDOMReference : collection) {
            Collection<AssociatedPrereqObject> collection2 = cDOMObject.getListAssociations(Spell.SPELLS, cDOMReference);
            Collection collection3 = cDOMReference.getContainedObjects();
            for (AssociatedPrereqObject associatedPrereqObject : collection2) {
                if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), this, null)) continue;
                for (Spell spell : collection3) {
                    Formula formula = associatedPrereqObject.getAssociation(AssociationKey.TIMES_PER_UNIT);
                    int n = formula.resolve(this, cDOMObject.getQualifiedKey()).intValue();
                    String string = associatedPrereqObject.getAssociation(AssociationKey.TIME_UNIT);
                    if (string == null) {
                        string = "Day";
                    }
                    String string2 = associatedPrereqObject.getAssociation(AssociationKey.SPELLBOOK);
                    Spell spell2 = spell.clone();
                    List<CharacterSpell> list = this.getCharacterSpells(this.race, spell2, string2, -1);
                    if (!list.isEmpty()) continue;
                    CharacterSpell characterSpell = new CharacterSpell(this.race, spell);
                    characterSpell.setFixedCasterLevel(associatedPrereqObject.getAssociation(AssociationKey.CASTER_LEVEL));
                    characterSpell.setFixedDC(associatedPrereqObject.getAssociation(AssociationKey.DC_FORMULA));
                    SpellInfo spellInfo = characterSpell.addInfo(0, n, string2);
                    spellInfo.setTimeUnit(string);
                    this.addSpellBook(new SpellBook(string2, 4));
                    this.addAssoc(this.race, AssociationListKey.CHARACTER_SPELLS, characterSpell);
                }
            }
        }
        this.setDirty(true);
    }

    private void setStableAggregateFeatList(List<Ability> list) {
        this.stableAggregateFeatList = list;
        this.setAggregateFeatsStable(list != null);
    }

    private void addWeaponProfToList(List<Ability> list, String string, boolean bl) {
        LoadContext loadContext = Globals.getContext();
        WeaponProf weaponProf = loadContext.ref.silentlyGetConstructedCDOMObject(WeaponProf.class, string);
        if (weaponProf != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(weaponProf.getType(), ".");
            String string2 = stringTokenizer.nextToken() + " Weapon Proficiency";
            while (stringTokenizer.hasMoreTokens() || string2.length() > 0) {
                Ability ability;
                if ("".equals(string2)) {
                    if (!stringTokenizer.hasMoreTokens()) break;
                    string2 = stringTokenizer.nextToken() + " Weapon Proficiency";
                }
                if ((ability = AbilityUtilities.getAbilityFromList(list, "FEAT", string2, Ability.Nature.ANY)) != null) {
                    if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() && !this.containsAssociated((CDOMObject)ability, string)) {
                        this.addAssociation((CDOMObject)ability, string);
                    }
                } else {
                    ability = Globals.getAbilityKeyed("FEAT", string2);
                    if (ability != null) {
                        if (bl && !ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() && !"PCGENi_WEAPON_PROFICIENCY".equalsIgnoreCase(string2)) {
                            if (this.hasRealFeat(ability)) {
                                string2 = "PCGENi_WEAPON_PROFICIENCY";
                                continue;
                            }
                            string2 = "";
                            continue;
                        }
                        ability = ability.clone();
                        this.addAssociation((CDOMObject)ability, string);
                        if (bl) {
                            ability.setAbilityNature(Ability.Nature.AUTOMATIC);
                        }
                        list.add(ability);
                    }
                }
                if (ability != null) {
                    ability.addSelectedWeaponProfBonus(string);
                }
                string2 = "";
            }
        }
        if (weaponProf != null && this.cachedWeaponProfs != null) {
            this.cachedWeaponProfs.put(weaponProf.getKeyName(), weaponProf);
        }
    }

    private List<ProfProvider<ShieldProf>> getAutoShieldProfList() {
        ArrayList<ProfProvider<ShieldProf>> arrayList = new ArrayList<ProfProvider<ShieldProf>>();
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            for (ShieldProfProvider shieldProfProvider : cDOMObject.getSafeListFor(ListKey.AUTO_SHIELDPROF)) {
                if (!shieldProfProvider.qualifies(this)) continue;
                arrayList.add(shieldProfProvider);
            }
        }
        return arrayList;
    }

    public String getClassLevelString(String string, boolean bl) {
        int n = 0;
        int n2 = string.indexOf(";BEFORELEVEL=");
        if (n2 < 0) {
            n2 = string.indexOf(";BEFORELEVEL.");
        }
        if (n2 > 0) {
            n = Integer.parseInt(string.substring(n2 + 13));
            string = string.substring(0, n2);
        }
        if (bl) {
            string = string.replace('{', '(').replace('}', ')');
        }
        if (string.startsWith("TYPE=") || string.startsWith("TYPE.")) {
            int n3 = 0;
            String[] stringArray = string.substring(5).split("\\.");
            for (PCClass pCClass : this.getClassList()) {
                for (String string2 : stringArray) {
                    if (!pCClass.isType(string2)) break;
                    if (n > 0) {
                        n3 += this.getLevelBefore(pCClass.getKeyName(), n);
                    }
                    n3 += pCClass.getLevel();
                }
            }
            return Integer.toString(n3);
        }
        PCClass pCClass = this.getClassKeyed(string);
        if (pCClass != null) {
            if (n > 0) {
                return Integer.toString(this.getLevelBefore(pCClass.getKeyName(), n));
            }
            return Integer.toString(pCClass.getLevel());
        }
        return "0";
    }

    public int getLevelBefore(String string, int n) {
        String string2;
        int n2 = 0;
        for (int i = 0; i < n && (string2 = this.getLevelInfoClassKeyName(i)).length() != 0; ++i) {
            if (!string2.equals(string)) continue;
            ++n2;
        }
        return n2;
    }

    public List<? extends CDOMObject> getCDOMObjectList() {
        ArrayList<CDOMObject> arrayList = new ArrayList<CDOMObject>();
        for (PObject pObject : this.getPObjectList()) {
            if (pObject == null) continue;
            arrayList.add(pObject);
        }
        for (PCClass pCClass : this.classList) {
            for (int i = 1; i <= pCClass.getLevel(); ++i) {
                PCClassLevel pCClassLevel = pCClass.getClassLevel(i);
                arrayList.add(pCClassLevel);
            }
        }
        arrayList.addAll(this.getConditionalTemplateObjects());
        return arrayList;
    }

    private List<PObject> getConditionalTemplateObjects() {
        ArrayList<PObject> arrayList = new ArrayList<PObject>();
        int n = this.getTotalLevels();
        int n2 = this.totalHitDice();
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            arrayList.addAll(pCTemplate.getConditionalTemplates(n, n2));
        }
        return arrayList;
    }

    private List<? extends PObject> getPObjectList() {
        SizeAdjustment sizeAdjustment;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Campaign> list = Globals.getCampaignList();
        for (Campaign cloneable2 : list) {
            if (cloneable2 == null || !cloneable2.isLoaded()) continue;
            arrayList.add(cloneable2);
            arrayList.addAll(cloneable2.getSubCampaigns());
        }
        PCAlignment pCAlignment = SettingsHandler.getGame().getAlignmentAtIndex(this.getAlignment());
        if (pCAlignment != null) {
            arrayList.add(pCAlignment);
        }
        arrayList.add(Globals.getBioSet());
        arrayList.addAll(SettingsHandler.getGame().getUnmodifiableCheckList());
        arrayList.addAll(this.classList);
        arrayList.addAll(this.companionModList);
        if (this.deity != null) {
            arrayList.add(this.deity);
        }
        for (CharacterDomain characterDomain : this.characterDomainList) {
            Domain domain = characterDomain.getDomain();
            if (domain == null) continue;
            arrayList.add(domain);
        }
        ArrayList<Equipment> arrayList2 = new ArrayList<Equipment>(this.getEquipmentList());
        for (Equipment equipment : arrayList2) {
            if (!equipment.isEquipped() && !equipment.isNatural()) continue;
            arrayList.add(equipment);
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                arrayList.add(equipmentModifier);
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                arrayList.add(equipmentModifier);
            }
        }
        List<Ability> list2 = this.getFullAbilityList();
        arrayList.addAll(list2);
        if (this.getRace() != null) {
            arrayList.add(this.getRace());
        }
        if ((sizeAdjustment = this.getSizeAdjustment()) != null) {
            arrayList.add(sizeAdjustment);
        }
        arrayList.addAll(this.getSkillList());
        arrayList.addAll(this.statList.getStatList());
        arrayList.addAll(this.getTemplateList());
        return arrayList;
    }

    private void getPreReqFromACType(String string, PObject pObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = "|";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (PreParserFactory.isPreReqString(string3)) {
                try {
                    Logging.debugPrint("Why is this prerequisite '" + string3 + "' parsed in '" + this.getClass().getName() + ".getPreReqFromACType()' rather than the persistence layer?");
                    PreParserFactory preParserFactory = PreParserFactory.getInstance();
                    Prerequisite prerequisite = preParserFactory.parse(string3);
                    pObject.addPrerequisite(prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint(persistenceLayerException.getMessage(), persistenceLayerException);
                }
                continue;
            }
            string2 = string2 + string3 + "|";
        }
        string = string2.substring(1);
    }

    private void addNewSkills(int n) {
        ArrayList<Skill> arrayList = new ArrayList<Skill>();
        ArrayList<Skill> arrayList2 = new ArrayList<Skill>(this.getSkillList());
        for (Skill skill : Globals.getContext().ref.getConstructedCDOMObjects(Skill.class)) {
            if (!this.includeSkill(skill, n)) continue;
            boolean bl = false;
            for (Skill skill2 : arrayList2) {
                if (!skill2.getKeyName().equals(skill.getKeyName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(skill.clone());
        }
        this.getSkillList().addAll(arrayList);
    }

    public boolean availableSpells(int n, PCClass pCClass, String string, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        boolean bl3 = false;
        boolean bl4 = "Divine".equalsIgnoreCase(pCClass.get(StringKey.SPELLTYPE));
        boolean bl5 = bl ? this.getUseHigherKnownSlots() : this.getUseHigherPreppedSlots();
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        for (n10 = 0; n10 < n; ++n10) {
            if (bl) {
                n9 = pCClass.getKnownForLevel(n10, string, this);
                n8 = pCClass.getSpecialtyKnownForLevel(n10, this);
                n7 = n9 + n8;
            } else {
                n7 = pCClass.getCastForLevel(n10, string, true, true, this);
                n9 = pCClass.getCastForLevel(n10, string, false, true, this);
                n8 = n7 - n9;
            }
            n6 = pCClass.memorizedSpellForLevelBook(this, n10, string);
            n5 = pCClass.memorizedSpecialtiesForLevelBook(n10, string, this);
            n4 = n6 - n5;
            n3 = n8 - n5;
            for (n2 = n9 - n4; n2 > 0 && n12 < 0; --n2, ++n12) {
            }
            while (n3 > 0 && n11 < 0) {
                --n3;
                ++n11;
            }
            if (!bl4 || bl) {
                while (n2 > 0 && n11 < 0) {
                    --n2;
                    ++n11;
                }
                while (n2 > 0 && n3 < 0) {
                    --n2;
                    ++n3;
                }
            }
            if (n3 < 0) {
                n11 += n3;
            }
            if (n2 >= 0) continue;
            n12 += n2;
        }
        for (n10 = n; n10 <= 25; ++n10) {
            if (bl) {
                n9 = pCClass.getKnownForLevel(n10, string, this);
                n8 = pCClass.getSpecialtyKnownForLevel(n10, this);
                n7 = n9 + n8;
            } else {
                n7 = pCClass.getCastForLevel(n10, string, true, true, this);
                n9 = pCClass.getCastForLevel(n10, string, false, true, this);
                n8 = n7 - n9;
            }
            if (!bl5 && n10 > n) break;
            n6 = pCClass.memorizedSpellForLevelBook(this, n10, string);
            n5 = pCClass.memorizedSpecialtiesForLevelBook(n10, string, this);
            n4 = n6 - n5;
            n3 = n8 - n5;
            for (n2 = n9 - n4; n2 > 0 && n12 < 0; --n2, ++n12) {
            }
            while (n2 > 0 && n14 < 0) {
                --n2;
                ++n14;
            }
            while (n3 > 0 && n11 < 0) {
                --n3;
                ++n11;
            }
            while (n3 > 0 && n13 < 0) {
                --n3;
                ++n13;
            }
            if (!bl4) {
                while (n2 > 0 && n11 < 0) {
                    --n2;
                    ++n11;
                }
                while (n2 > 0 && n13 < 0) {
                    --n2;
                    ++n13;
                }
                while (n2 > 0 && n3 < 0) {
                    --n2;
                    ++n3;
                }
            }
            if (bl4) {
                if (bl2 && n3 > 0) {
                    bl3 = true;
                }
                if (!bl2 && n2 > 0) {
                    bl3 = true;
                }
            } else {
                if (!bl2 && n2 > 0) {
                    bl3 = true;
                }
                if (bl2 && (n2 > 0 || n3 > 0)) {
                    bl3 = true;
                }
            }
            if (bl3) break;
            if (n3 < 0) {
                n13 += n3;
            }
            if (n2 >= 0) continue;
            n14 += n2;
        }
        return bl3;
    }

    private void buildActiveBonusMap() {
        CDOMObject cDOMObject;
        this.activeBonusMap = new ConcurrentHashMap<String, String>();
        WrappedMapSet<BonusObj> wrappedMapSet = new WrappedMapSet<BonusObj>(IdentityHashMap.class);
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        arrayList.addAll(this.getActiveBonusList());
        for (BonusObj bonusObj : arrayList) {
            if (!bonusObj.isValueStatic()) continue;
            cDOMObject = (CDOMObject)bonusObj.getCreatorObject();
            if (cDOMObject == null) {
                Logging.debugPrint("BONUS: " + bonusObj + " ignored due to no creator");
                continue;
            }
            wrappedMapSet.add(bonusObj);
            for (BonusObj.BonusPair bonusPair : bonusObj.getStringListFromBonus(this)) {
                double d = bonusPair.resolve(this).doubleValue();
                this.setActiveBonusStack(d, bonusPair.bonusKey, this.getActiveBonusMap());
                Logging.debugPrint("BONUS: " + cDOMObject.getDisplayName() + " : " + d + " : " + bonusPair.bonusKey);
            }
        }
        arrayList = new ArrayList();
        arrayList.addAll(this.getActiveBonusList());
        for (BonusObj bonusObj : this.getActiveBonusList()) {
            if (wrappedMapSet.contains(bonusObj) || (cDOMObject = (CDOMObject)bonusObj.getCreatorObject()) == null) continue;
            this.processBonus(bonusObj, new WrappedMapSet<BonusObj>(IdentityHashMap.class), wrappedMapSet);
        }
    }

    private double calcBonusWithCostFromList(List<BonusObj> list) {
        double d = 0.0;
        for (BonusObj bonusObj : list) {
            int n;
            CDOMObject cDOMObject = (CDOMObject)bonusObj.getCreatorObject();
            if (cDOMObject == null) continue;
            double d2 = 0.0;
            if (bonusObj.qualifies(this)) {
                d2 = bonusObj.resolve(this, cDOMObject.getQualifiedKey()).doubleValue();
            }
            if (this.hasAssociations(cDOMObject)) {
                n = 0;
                for (String string : this.getAssociationList(cDOMObject)) {
                    if (!string.equalsIgnoreCase(bonusObj.getBonusInfo())) continue;
                    ++n;
                }
            } else {
                n = 1;
            }
            if (n == 0 && !CoreUtility.doublesEqual(d2, 0.0)) {
                d += d2;
                continue;
            }
            d += d2 * (double)n;
        }
        return d;
    }

    private List<BonusObj> getPurchaseModeBonuses() {
        GameMode gameMode = SettingsHandler.getGame();
        String string = gameMode.getPurchaseModeMethodName();
        if (gameMode.isPurchaseStatMode()) {
            PointBuyMethod pointBuyMethod = gameMode.getPurchaseMethodByName(string);
            pointBuyMethod.activateBonuses(this);
            return pointBuyMethod.getActiveBonuses();
        }
        return Collections.emptyList();
    }

    private List<BonusObj> getTempBonuses() {
        List<BonusObj> list = this.getFilteredTempBonusList();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<BonusObj> iterator = list.iterator();
        while (iterator.hasNext()) {
            BonusObj bonusObj = iterator.next();
            bonusObj.setApplied(false);
            if (bonusObj.qualifies(this)) {
                bonusObj.setApplied(true);
            }
            if (bonusObj.isApplied()) continue;
            iterator.remove();
        }
        return list;
    }

    private int calculateSaveBonusRace(int n) {
        if (n - 1 < 0 || n - 1 >= SettingsHandler.getGame().getUnmodifiableCheckList().size()) {
            return 0;
        }
        String string = SettingsHandler.getGame().getUnmodifiableCheckList().get(n - 1).toString();
        int n2 = (int)this.race.bonusTo("CHECKS", "BASE." + string, this, this);
        return n2 += (int)this.race.bonusTo("CHECKS", string, this, this);
    }

    public int countSpellsInBook(String string) {
        PObject pObject;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        if (n2 >= this.getSpellBooks().size()) {
            return 0;
        }
        int n3 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : -1;
        String string2 = Globals.getDefaultSpellBook();
        if (n2 > 0) {
            string2 = this.getSpellBooks().get(n2);
        }
        if ((pObject = this.getSpellClassAtIndex(n)) != null) {
            List<CharacterSpell> list = this.getCharacterSpells(pObject, null, string2, n3);
            return list.size();
        }
        return 0;
    }

    private Gender findTemplateGender() {
        Gender gender = null;
        for (PCTemplate pCTemplate : this.templateList) {
            Gender gender2 = pCTemplate.get(ObjectKey.GENDER_LOCK);
            if (gender2 == null) continue;
            gender = gender2;
        }
        return gender;
    }

    private void setEarnedXP(int n) {
        this.earnedXP = n;
        this.setDirty(true);
    }

    private int getLAXP() {
        return PlayerCharacterUtilities.minXPForLevel(this.getLevelAdjustment(this) + 1, this);
    }

    private SizeAdjustment getSizeAdjustment() {
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.sizeInt());
        return sizeAdjustment;
    }

    public int getSpellClassCount() {
        return this.getSpellClassList().size();
    }

    public List<? extends PObject> getSpellClassList() {
        ArrayList<PObject> arrayList = new ArrayList<PObject>();
        if (!this.getCharacterSpells(this.race, null, "", -1).isEmpty()) {
            arrayList.add(this.race);
        }
        for (PCClass pCClass : this.classList) {
            if (pCClass.get(StringKey.SPELLTYPE) == null) continue;
            arrayList.add(pCClass);
        }
        return arrayList;
    }

    private String checkForVariableInList(PObject pObject, String string, boolean bl, boolean bl2, double d) {
        boolean bl3 = false;
        String string2 = pObject.getVariableSource();
        for (VariableKey variableKey : pObject.getVariableKeys()) {
            String string3 = variableKey.toString();
            if (!string3.equalsIgnoreCase(string)) continue;
            Float f = this.getVariableValue(pObject.get(variableKey).toString(), string2);
            d = !bl2 ? (double)f.floatValue() : (bl ? Math.max(d, f.doubleValue()) : Math.min(d, f.doubleValue()));
            bl2 = true;
            bl3 = true;
        }
        if (bl3) {
            return Double.toString(d);
        }
        return "";
    }

    public boolean hasDeity(String string) {
        Prerequisite prerequisite = new Prerequisite();
        prerequisite.setKind("DEITY");
        prerequisite.setOperand(string);
        prerequisite.setOperator(PrerequisiteOperator.EQ);
        return PrereqHandler.passes(prerequisite, this, null);
    }

    private boolean includeSkill(Skill skill, int n) {
        if (n == 2 || SkillRankControl.getTotalRank(this, skill).floatValue() > 0.0f) {
            return true;
        }
        if (n != 1 || !skill.getSafe(ObjectKey.USE_UNTRAINED).booleanValue()) {
            return false;
        }
        if (skill.getSafe(ObjectKey.EXCLUSIVE).booleanValue()) {
            return this.isClassSkill(skill) || this.isCrossClassSkill(skill);
        }
        return PrereqHandler.passesAll(skill.getPrerequisiteList(), this, skill);
    }

    private void increaseMoveArray(Double d, String string, Double d2, String string2) {
        Double[] doubleArray = this.movements;
        String[] stringArray = this.movementTypes;
        Double[] doubleArray2 = this.movementMult;
        String[] stringArray2 = this.movementMultOp;
        this.movements = new Double[doubleArray.length + 1];
        this.movementTypes = new String[doubleArray.length + 1];
        this.movementMult = new Double[doubleArray.length + 1];
        this.movementMultOp = new String[doubleArray.length + 1];
        System.arraycopy(doubleArray, 0, this.movements, 0, doubleArray.length);
        System.arraycopy(stringArray, 0, this.movementTypes, 0, doubleArray.length);
        System.arraycopy(doubleArray2, 0, this.movementMult, 0, doubleArray.length);
        System.arraycopy(stringArray2, 0, this.movementMultOp, 0, doubleArray.length);
        this.movements[doubleArray.length] = d;
        this.movementTypes[doubleArray.length] = string;
        this.movementMult[doubleArray.length] = d2;
        this.movementMultOp[doubleArray.length] = string2;
    }

    public void incrementClassLevel(int n, PCClass pCClass, boolean bl) {
        this.incrementClassLevel(n, pCClass, bl, false);
    }

    public void incrementClassLevel(int n, PCClass pCClass, boolean bl, boolean bl2) {
        Object object;
        PCClass pCClass2;
        if (!this.isImporting()) {
            this.getSpellList();
        }
        if (n > 0) {
            if (!bl2 && !pCClass.isQualified(this)) {
                return;
            }
            if (pCClass.isMonster() && !SettingsHandler.isIgnoreMonsterHDCap() && !this.race.isAdvancementUnlimited() && this.totalHitDice() + n > this.race.maxHitDiceAdvancement() && !bl) {
                ShowMessageDelegate.showMessageDialog("Cannot increase Monster Hit Dice for this character beyond " + this.race.maxHitDiceAdvancement() + ". This character's current number of Monster Hit Dice is " + this.totalHitDice(), "PCGen", MessageType.INFORMATION);
                return;
            }
        }
        if ((pCClass2 = this.getClassKeyed(pCClass.getKeyName())) == null) {
            if (n >= 0) {
                pCClass2 = pCClass.clone();
                if (pCClass2 == null) {
                    Logging.errorPrint("PlayerCharacter::incrementClassLevel => Clone of class " + pCClass.getKeyName() + " failed!");
                    return;
                }
                if (!this.isImporting() && this.classList.isEmpty()) {
                    this.adjustFeats(pCClass2.getSafe(IntegerKey.START_FEATS));
                }
                this.classList.add(pCClass2);
                if (n > 0) {
                    for (CDOMReference<Language> cDOMReference : pCClass2.getSafeListFor(ListKey.AUTO_LANGUAGES)) {
                        this.languages.addAll(cDOMReference.getContainedObjects());
                    }
                }
            } else {
                return;
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                int n2 = pCClass2.getLevel();
                object = this.saveLevelInfo(pCClass2.getKeyName());
                if (pCClass2.addLevel((PCLevelInfo)object, false, bl, this, bl2)) continue;
                PCClassLevel pCClassLevel = pCClass2.getClassLevel(n2 + 1);
                this.removeLevelInfo(pCClass2.getKeyName());
                this.removeLevelInfo(pCClassLevel);
                return;
            }
        } else if (n < 0) {
            for (int i = 0; i < -n; ++i) {
                int n3 = pCClass2.getLevel();
                pCClass2.subLevel(bl, this);
                this.removeLevelInfo(pCClass2.getKeyName());
                object = pCClass2.getClassLevel(n3);
                this.removeLevelInfo((PCClassLevel)object);
            }
        }
        for (PCTemplate pCTemplate : this.templateList) {
            object = this.feats(pCTemplate, this.getTotalLevels(), this.totalHitDice(), true);
            int n4 = object.size();
            for (int i = 0; i < n4; ++i) {
                AbilityUtilities.modFeatsFromList(this, null, (String)object.get(i), true, false);
            }
        }
        this.setAggregateAbilitiesStable(null, false);
        this.calcActiveBonuses();
    }

    private void removeLevelInfo(PCClassLevel pCClassLevel) {
        List<Ability> list = this.removeAllAssocs(pCClassLevel, AssociationListKey.ADDED_FEAT);
        if (list != null) {
            for (Ability ability : list) {
                Ability ability2;
                Iterator<Ability> iterator = this.getRealAbilitiesList(AbilityCategory.FEAT).iterator();
                while (iterator.hasNext()) {
                    ability2 = iterator.next();
                    if (ability2 != ability) continue;
                    iterator.remove();
                }
                iterator = this.theAbilities.get(AbilityCategory.FEAT, Ability.Nature.VIRTUAL).iterator();
                while (iterator.hasNext()) {
                    ability2 = iterator.next();
                    if (ability2 != ability) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void processBonus(BonusObj bonusObj, Set<BonusObj> set, Set<BonusObj> set2) {
        if (set.contains(bonusObj)) {
            Logging.debugPrint("Ignoring bonus loop for " + bonusObj + " as it was already processed. Bonuses already processed: " + set);
            return;
        }
        set.add(bonusObj);
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj object : this.getActiveBonusList()) {
            if (set2.contains(object) || !bonusObj.getDependsOn(object.getUnparsedBonusInfoList())) continue;
            arrayList.add(object);
        }
        for (BonusObj bonusObj2 : arrayList) {
            this.processBonus(bonusObj2, set, set2);
        }
        if (set2.contains(bonusObj)) {
            return;
        }
        set2.add(bonusObj);
        CDOMObject cDOMObject = (CDOMObject)bonusObj.getCreatorObject();
        if (cDOMObject == null) {
            set.remove(bonusObj);
            return;
        }
        for (BonusObj.BonusPair bonusPair : bonusObj.getStringListFromBonus(this)) {
            double d = bonusPair.resolve(this).doubleValue();
            this.setActiveBonusStack(d, bonusPair.bonusKey, this.getActiveBonusMap());
            Logging.debugPrint("vBONUS: " + cDOMObject.getDisplayName() + " : " + d + " : " + bonusPair.bonusKey);
        }
        set.remove(bonusObj);
    }

    private boolean qualifiesForFeat(Ability ability) {
        return PrereqHandler.passesAll(ability.getPrerequisiteList(), this, ability);
    }

    private boolean hasSkill(String string) {
        return this.getSkillKeyed(string) != null;
    }

    private void rebuildLists(PCClass pCClass, PCClass pCClass2, int n, PlayerCharacter playerCharacter) {
        int n2 = pCClass2.getLevel();
        int n3 = pCClass.getLevel();
        for (int i = 0; i < n; ++i) {
            pCClass2.doMinusLevelMods(this, n2 - i);
            PCLevelInfo pCLevelInfo = playerCharacter.getLevelInfoFor(pCClass.getKeyName(), n3 + i + 1);
            pCClass.doPlusLevelMods(n3 + i + 1, playerCharacter, pCLevelInfo);
        }
    }

    private void removeExcessSkills(int n) {
        ArrayList<Skill> arrayList = this.getSkillList();
        ArrayList<Skill> arrayList2 = new ArrayList<Skill>();
        arrayList2.addAll(arrayList);
        Iterator iterator = arrayList2.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            if (this.includeSkill(skill, n)) continue;
            arrayList.remove(skill);
            bl = true;
        }
        if (bl) {
            this.setDirty(true);
        }
    }

    private boolean removeLevelInfo(String string) {
        for (int i = this.pcLevelInfo.size() - 1; i >= 0; --i) {
            PCLevelInfo pCLevelInfo = this.pcLevelInfo.get(i);
            if (!pCLevelInfo.getClassKeyName().equals(string)) continue;
            this.removeObjectsForLevelInfo(pCLevelInfo);
            this.removeLevelInfo(i);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    private void removeObjectsForLevelInfo(PCLevelInfo pCLevelInfo) {
        for (PObject pObject : pCLevelInfo.getObjects()) {
            for (Ability ability : this.getRealAbilitiesList(AbilityCategory.FEAT)) {
                if (pObject != ability) continue;
                this.removeRealAbility(AbilityCategory.FEAT, ability);
            }
            Iterator<Ability> iterator = this.getDirectVirtualAbilities(AbilityCategory.FEAT).iterator();
            while (iterator.hasNext()) {
                Ability ability;
                ability = iterator.next();
                if (pObject != ability) continue;
                iterator.remove();
            }
        }
    }

    private void removeLevelInfo(int n) {
        this.pcLevelInfo.remove(n);
        this.setDirty(true);
    }

    public void rollStats(int n) {
        int n2 = n;
        if (SettingsHandler.getGame().isPurchaseStatMode()) {
            n2 = 2;
        }
        this.rollStats(n2, this.statList.getStatList(), SettingsHandler.getGame().getCurrentRollingMethod(), false);
    }

    public void rollStats(int n, List<PCStat> list, GameModeRollMethod gameModeRollMethod, boolean bl) {
        int n2;
        int[] nArray = new int[list.size()];
        block5: for (n2 = 0; n2 < nArray.length; ++n2) {
            switch (n) {
                case 2: {
                    nArray[n2] = SettingsHandler.getGame().getPurchaseModeBaseStatScore(this);
                    continue block5;
                }
                case 1: {
                    nArray[n2] = SettingsHandler.getGame().getAllStatsValue();
                    continue block5;
                }
                case 3: {
                    String string = gameModeRollMethod.getMethodRoll();
                    nArray[n2] = RollingMethods.roll(string);
                    continue block5;
                }
                default: {
                    nArray[n2] = 0;
                }
            }
        }
        if (bl) {
            Arrays.sort(nArray);
        }
        n2 = list.size() - 1;
        int n3 = 0;
        while (n2 >= 0) {
            PCStat pCStat = list.get(n2);
            pCStat.setBaseScore(0);
            if (pCStat.isRolled()) {
                int n4 = nArray[n3] + pCStat.getBaseScore();
                if (n4 < pCStat.getMinValue()) {
                    n4 = pCStat.getMinValue();
                }
                if (n4 > pCStat.getMaxValue()) {
                    n4 = pCStat.getMaxValue();
                }
                pCStat.setBaseScore(n4);
            }
            --n2;
            ++n3;
        }
        if (n != 2) {
            this.setPoolAmount(0);
            this.costPool = 0;
        }
        this.languages.clear();
        this.getAutoLanguages();
        if (n != 2) {
            this.setPoolAmount(0);
        }
    }

    private List<Equipment> sortEquipmentList(List<Equipment> list) {
        return this.sortEquipmentList(list, 0);
    }

    private List<Equipment> sortEquipmentList(List<Equipment> list, int n) {
        if (list.isEmpty()) {
            return list;
        }
        List<Equipment> list2 = CoreUtility.mergeEquipmentList(list, n);
        Iterator<Equipment> iterator = list2.iterator();
        while (iterator.hasNext()) {
            Equipment equipment = iterator.next();
            if (equipment.getOutputIndex() != -1) continue;
            iterator.remove();
        }
        return list2;
    }

    private int subCalcACOfType(StringTokenizer stringTokenizer) {
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            n += Integer.parseInt(BonusToken.getBonusToken("BONUS.COMBAT.AC." + string, this));
        }
        return n;
    }

    private double sumActiveBonusMap(String string) {
        double d = 0.0;
        string = string.toUpperCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.activeBonusMap.keySet()) {
            if (arrayList.contains(string2)) continue;
            String string3 = string2;
            if (string3.endsWith(".STACK")) {
                string3 = string3.substring(0, string3.length() - 6);
            } else if (string3.endsWith(".REPLACE")) {
                string3 = string3.substring(0, string3.length() - 8);
            }
            if (string3.length() > string.length() && !string3.startsWith(string + ":") || !string3.startsWith(string)) continue;
            arrayList.add(string3);
            arrayList.add(string3 + ".STACK");
            arrayList.add(string3 + ".REPLACE");
            double d2 = this.getActiveBonusForMapKey(string3, Double.NaN);
            double d3 = this.getActiveBonusForMapKey(string3 + ".REPLACE", Double.NaN);
            double d4 = this.getActiveBonusForMapKey(string3 + ".STACK", 0.0);
            if (Double.isNaN(d2)) {
                if (!Double.isNaN(d3)) {
                    d += d3;
                }
            } else {
                d = Double.isNaN(d3) ? (d += d2) : (d += Math.max(d2, d3));
            }
            d += d4;
        }
        return d;
    }

    private int totalMonsterLevels() {
        int n = 0;
        for (PCClass pCClass : this.classList) {
            if (!pCClass.isMonster()) continue;
            n += pCClass.getLevel();
        }
        return n;
    }

    private void setDescriptionLst(String string) {
        this.descriptionLst = string;
    }

    public void preparePCForOutput() {
        this.setCalcEquipmentList(this.getUseTempMods());
        this.getSpellList();
        this.getAllSkillList(true);
        int n = SettingsHandler.getIncludeSkills();
        if (n == 3) {
            n = SettingsHandler.getSkillsTab_IncludeSkills();
        }
        this.populateSkills(n);
        for (PCClass pCClass : this.getClassList()) {
            this.sortAssocList(pCClass, AssociationListKey.CHARACTER_SPELLS);
        }
        this.determinePrimaryOffWeapon();
        this.modFromArmorOnWeaponRolls();
        this.adjustMoveRates();
        this.calcActiveBonuses();
    }

    public int getCharacterLevel(PCLevelInfo pCLevelInfo) {
        int n = 1;
        for (PCLevelInfo pCLevelInfo2 : this.pcLevelInfo) {
            if (pCLevelInfo == pCLevelInfo2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Set<Language> getLanguageBonusSelectionList() {
        HashSet<Language> hashSet = new HashSet<Language>();
        this.addStartingLanguages(this.race, hashSet);
        for (PCTemplate pObject : this.templateList) {
            this.addStartingLanguages(pObject, hashSet);
        }
        for (PCClass pCClass : this.classList) {
            this.addStartingLanguages(pCClass, hashSet);
        }
        return hashSet;
    }

    private void addStartingLanguages(CDOMObject cDOMObject, Set<Language> set) {
        Collection collection = cDOMObject.getListMods(Language.STARTING_LIST);
        if (collection != null) {
            for (CDOMReference cDOMReference : collection) {
                set.addAll(cDOMReference.getContainedObjects());
            }
        }
    }

    public int getPartialStatBonusFor(String string, boolean bl, boolean bl2) {
        List<BonusObj> list = this.getActiveBonusList();
        String string2 = "STAT." + string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (BonusObj object : list) {
            Object object2;
            Object object32;
            if (!object.isApplied() || !object.getBonusName().equals("STAT")) continue;
            boolean bl3 = false;
            block1: for (Object object32 : object.getBonusInfoList()) {
                if (object32 instanceof PCStat && ((PCStat)object32).getAbb().equals(string)) {
                    bl3 = true;
                    break;
                }
                if (!(object32 instanceof MissingObject) || !"%LIST".equals(object2 = ((MissingObject)object32).getObjectName()) && !"LIST".equals(object2) || !(object.getCreatorObject() instanceof CDOMObject)) continue;
                CDOMObject cDOMObject = (CDOMObject)object.getCreatorObject();
                for (FixedStringList fixedStringList : this.getDetailedAssociations(cDOMObject)) {
                    if (!fixedStringList.contains(string)) continue;
                    bl3 = true;
                    continue block1;
                }
            }
            if (!bl3) continue;
            boolean bl4 = false;
            bl4 = object.getCreatorObject() instanceof Equipment || object.getCreatorObject() instanceof EquipmentModifier ? bl2 : (this.tempBonusList.contains(object) ? bl : true);
            if (!bl4) continue;
            object32 = object.getStringListFromBonus(this).iterator();
            while (object32.hasNext()) {
                object2 = (BonusObj.BonusPair)object32.next();
                if (!((BonusObj.BonusPair)object2).bonusKey.startsWith(string2)) continue;
                this.setActiveBonusStack(((BonusObj.BonusPair)object2).resolve(this).doubleValue(), ((BonusObj.BonusPair)object2).bonusKey, hashMap);
            }
        }
        int n = 0;
        for (String string3 : hashMap.keySet()) {
            n = (int)((float)n + Float.parseFloat((String)hashMap.get(string3)));
        }
        return n;
    }

    public int getPartialStatAtLevel(String string, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = this.getStatList().getPartialStatFor(string, bl2, bl3);
        for (int i = this.getLevelInfoSize() - 1; i >= n; --i) {
            int n3 = this.pcLevelInfo.get(i).getTotalStatMod(string, bl);
            n2 -= n3;
        }
        return n2;
    }

    public Object clone() {
        PlayerCharacter playerCharacter = null;
        playerCharacter = new PlayerCharacter();
        for (Ability iterator2 : this.getRealAbilitiesList(AbilityCategory.FEAT)) {
            playerCharacter.addRealAbility(AbilityCategory.FEAT, iterator2.clone());
        }
        for (Category category : this.theAbilities.getKeySet()) {
            for (Ability ability : this.getRealAbilityList(category)) {
                playerCharacter.addRealAbility(category, ability.clone());
            }
        }
        playerCharacter.miscList.addAll(this.getMiscList());
        for (NoteItem noteItem : this.getNotesList()) {
            playerCharacter.addNotesItem(noteItem);
        }
        playerCharacter.primaryWeapons.addAll(this.getPrimaryWeapons());
        playerCharacter.secondaryWeapons.addAll(this.getSecondaryWeapons());
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill = (Skill)iterator.next();
            playerCharacter.skillList.add(skill.clone());
        }
        playerCharacter.specialAbilityList.addAll(this.getSpecialAbilityList());
        playerCharacter.templateList.addAll(this.getTemplateList());
        for (String string : this.variableList) {
            playerCharacter.variableList.add(string);
        }
        playerCharacter.gold = new BigDecimal(this.gold.toString());
        playerCharacter.deity = this.deity;
        playerCharacter.domainSourceMap = new HashMap<String, String>(this.domainSourceMap);
        playerCharacter.characterDomainList.addAll(this.characterDomainList);
        for (PCClass pCClass : this.classList) {
            PCClass pCClass2 = pCClass.clone();
            pCClass2.addFeatPoolBonus(playerCharacter);
            playerCharacter.classList.add(pCClass2);
        }
        playerCharacter.companionModList.addAll(this.companionModList);
        playerCharacter.qualifyArrayMap.addAllLists(this.qualifyArrayMap);
        playerCharacter.followerMaster = this.followerMaster != null ? this.followerMaster.clone() : null;
        for (EquipSet equipSet : this.equipSetList) {
            playerCharacter.addEquipSet((EquipSet)equipSet.clone());
        }
        playerCharacter.equipmentList.addAll(this.equipmentList);
        playerCharacter.equipmentMasterList.addAll(this.equipmentMasterList);
        for (PCLevelInfo pCLevelInfo : this.pcLevelInfo) {
            playerCharacter.pcLevelInfo.add(pCLevelInfo.clone());
        }
        for (String string : this.spellBooks) {
            playerCharacter.addSpellBook(new String(string));
        }
        playerCharacter.tempBonusItemList.addAll(this.tempBonusItemList);
        playerCharacter.tempBonusList.addAll(this.tempBonusList);
        playerCharacter.tempBonusFilters.addAll(this.tempBonusFilters);
        playerCharacter.race = this.race;
        playerCharacter.selectedFavoredClass = this.selectedFavoredClass;
        playerCharacter.statList.clear();
        for (PCStat pCStat : this.statList) {
            playerCharacter.statList.addStat(pCStat.clone());
        }
        if (this.kitList != null) {
            playerCharacter.kitList = new ArrayList<Kit>();
            playerCharacter.kitList.addAll(this.kitList);
        }
        playerCharacter.templateAutoLanguages.addAll(this.templateAutoLanguages);
        playerCharacter.templateLanguages.addAll(this.templateLanguages);
        playerCharacter.setBio(new String(this.getBio()));
        playerCharacter.setBirthday(new String(this.getBirthday()));
        playerCharacter.setBirthplace(new String(this.getBirthplace()));
        playerCharacter.setCatchPhrase(new String(this.getCatchPhrase()));
        playerCharacter.setCurrentEquipSetName(new String(this.getCurrentEquipSetName()));
        playerCharacter.setDescription(new String(this.getDescription()));
        playerCharacter.setDescriptionLst(new String(this.getDescriptionLst()));
        playerCharacter.setEyeColor(new String(this.getEyeColor()));
        playerCharacter.setFileName(new String(this.getFileName()));
        playerCharacter.setGender(new String(this.getGender()));
        playerCharacter.setHairColor(new String(this.getHairColor()));
        playerCharacter.setHairStyle(new String(this.getHairStyle()));
        playerCharacter.setHanded(new String(this.getHanded()));
        playerCharacter.setInterests(new String(this.getInterests()));
        playerCharacter.setLocation(new String(this.getLocation()));
        playerCharacter.setName(new String(this.getName()));
        playerCharacter.setPhobias(new String(this.getPhobias()));
        playerCharacter.setPlayersName(new String(this.getPlayersName()));
        playerCharacter.setPortraitPath(new String(this.getPortraitPath()));
        if (this.getRegion() != null) {
            playerCharacter.setRegion(new String(this.getRegion()));
        }
        playerCharacter.setResidence(new String(this.getResidence()));
        playerCharacter.setSkinColor(new String(this.getSkinColor()));
        playerCharacter.setSpeechTendency(new String(this.getSpeechTendency()));
        if (this.getSubRegion() != null) {
            playerCharacter.setSubRegion(new String(this.getSubRegion()));
        }
        playerCharacter.tabName = new String(this.tabName);
        playerCharacter.setTrait1(new String(this.getTrait1()));
        playerCharacter.setTrait2(new String(this.getTrait2()));
        playerCharacter.languages.addAll(this.languages);
        if (this.theWeaponProfs != null) {
            playerCharacter.theWeaponProfs = new TreeSet<WeaponProf>();
            playerCharacter.theWeaponProfs.addAll(this.theWeaponProfs);
        }
        playerCharacter.autoKnownSpells = this.autoKnownSpells;
        playerCharacter.autoLoadCompanion = this.autoLoadCompanion;
        playerCharacter.autoSortGear = this.autoSortGear;
        playerCharacter.outputSheetHTML = new String(this.outputSheetHTML);
        playerCharacter.outputSheetPDF = new String(this.outputSheetPDF);
        playerCharacter.ageSetKitSelections = new boolean[10];
        System.arraycopy(this.ageSetKitSelections, 0, playerCharacter.ageSetKitSelections, 0, this.ageSetKitSelections.length);
        playerCharacter.serial = this.serial;
        playerCharacter.displayUpdate = this.displayUpdate;
        playerCharacter.setImporting(false);
        playerCharacter.useTempMods = this.useTempMods;
        playerCharacter.setFeats(this.feats);
        playerCharacter.age = this.age;
        playerCharacter.alignment = this.alignment;
        playerCharacter.costPool = this.costPool;
        playerCharacter.currentEquipSetNumber = this.currentEquipSetNumber;
        playerCharacter.earnedXP = this.earnedXP;
        playerCharacter.equipOutputOrder = this.equipOutputOrder;
        playerCharacter.freeLangs = this.freeLangs;
        playerCharacter.heightInInches = this.heightInInches;
        playerCharacter.poolAmount = this.poolAmount;
        playerCharacter.skillsOutputOrder = this.skillsOutputOrder;
        playerCharacter.spellLevelTemp = this.spellLevelTemp;
        playerCharacter.weightInPounds = this.weightInPounds;
        playerCharacter.variableProcessor = new VariableProcessorPC(playerCharacter);
        playerCharacter.pointBuyPoints = this.pointBuyPoints;
        playerCharacter.setDirty(true);
        playerCharacter.setAutomaticFeatsStable(false);
        playerCharacter.setVirtualFeatsStable(false);
        playerCharacter.adjustMoveRates();
        playerCharacter.calcActiveBonuses();
        return playerCharacter;
    }

    public void setStringFor(StringKey stringKey, String string) {
        this.stringChar.put(stringKey, string);
        this.setDirty(true);
    }

    private Float getEquippedQty(EquipSet equipSet, Equipment equipment) {
        String string = equipSet.getIdPath();
        for (EquipSet equipSet2 : this.getEquipSet()) {
            String string2;
            String string3 = equipSet2.getIdPath() + ".";
            if (!string3.startsWith(string2 = string + ".") || !equipment.getName().equals(equipSet2.getValue())) continue;
            return equipSet2.getQty();
        }
        return Float.valueOf(0.0f);
    }

    private String getSingleLocation(Equipment equipment) {
        if (equipment.isNatural() && equipment.getSlots(this) == 0) {
            if (equipment.modifiedName().endsWith("Primary")) {
                return "Natural-Primary";
            }
            return "Natural-Secondary";
        }
        if (equipment.isWeapon() && !equipment.isArmor()) {
            return "";
        }
        List<EquipSlot> list = SystemCollections.getUnmodifiableEquipSlotList();
        if (list == null || list.isEmpty()) {
            return "";
        }
        for (EquipSlot equipSlot : list) {
            if (!equipSlot.canContainType(equipment.getType())) continue;
            return equipSlot.getSlotName();
        }
        return "";
    }

    public boolean canEquipItem(EquipSet equipSet, String string, Equipment equipment, Equipment equipment2) {
        Object object;
        String string2;
        String string3;
        String string4 = equipSet.getIdPath();
        if (equipment2 != null && equipment2.isContainer()) {
            return true;
        }
        if (string.startsWith("Carried") || string.startsWith("Equipped") || string.startsWith("Not Carried")) {
            return true;
        }
        if (equipment.isUnarmed()) {
            return true;
        }
        if (string.equals("Natural-Secondary")) {
            return true;
        }
        if (equipment.isWeapon() && equipment.isWeaponOutsizedForPC(this) && !equipment.isNatural()) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (EquipSet equipSet2 : this.getEquipSet()) {
            string3 = equipSet2.getParentIdPath() + ".";
            if (!string3.startsWith(string2 = string4 + ".") || !equipSet2.getName().equals(string)) continue;
            object = equipSet2.getItem();
            String string5 = (String)hashMap.get(string);
            int n = 0;
            if (string5 != null) {
                n = Integer.parseInt(string5);
            }
            if (object != null) {
                n += ((Equipment)object).getSlots(this);
            }
            hashMap.put(string, String.valueOf(n));
        }
        for (EquipSet equipSet2 : this.getEquipSet()) {
            string3 = equipSet2.getParentIdPath() + ".";
            if (!string3.startsWith(string2 = string4 + ".")) continue;
            if (equipment.isWeapon()) {
                if (equipSet2.getName().equals(string)) {
                    return false;
                }
                if ((string.equals("Both Hands") || string.equals("Double Weapon")) && (equipSet2.getName().equals("Primary Hand") || equipSet2.getName().equals("Secondary Hand") || equipSet2.getName().equals("Both Hands") || equipSet2.getName().equals("Double Weapon"))) {
                    return false;
                }
                if ((string.equals("Primary Hand") || string.equals("Secondary Hand")) && (equipSet2.getName().equals("Both Hands") || equipSet2.getName().equals("Double Weapon"))) {
                    return false;
                }
            }
            if (!equipSet2.getName().equals(string)) continue;
            object = (String)hashMap.get(string);
            int n = 0;
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
            n += equipment.getSlots(this);
            EquipSlot equipSlot = Globals.getEquipSlotByName(string);
            if (equipSlot == null) {
                return true;
            }
            for (String string6 : equipSlot.getContainType()) {
                if (!equipment.isType(string6) || n <= equipSlot.getSlotCount() + (int)this.getTotalBonusTo("SLOTS", string6)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public EquipSet getEquipSetForItem(EquipSet equipSet, Equipment equipment) {
        String string = equipSet.getIdPath();
        for (EquipSet equipSet2 : this.getEquipSet()) {
            String string2;
            String string3 = equipSet2.getIdPath() + ".";
            if (!string3.startsWith(string2 = string + ".") || !equipment.getName().equals(equipSet2.getValue())) continue;
            return equipSet2;
        }
        return null;
    }

    private String getNewIdPath(EquipSet equipSet) {
        String string = "0";
        int n = 0;
        if (equipSet != null) {
            string = equipSet.getIdPath();
        }
        for (EquipSet equipSet2 : this.getEquipSet()) {
            if (!equipSet2.getParentIdPath().equals(string) || equipSet2.getId() <= n) continue;
            n = equipSet2.getId();
        }
        return string + "." + ++n;
    }

    public EquipSet addEquipToTarget(EquipSet equipSet, Equipment equipment, String string, Equipment equipment2, Float f) {
        float f2 = 1.0f;
        if (f != null) {
            f2 = f.floatValue();
        } else {
            f = Float.valueOf(f2);
        }
        boolean bl = false;
        boolean bl2 = false;
        Equipment equipment3 = this.getEquipmentNamed(equipment2.getName());
        if (equipment3 == null) {
            return null;
        }
        float f3 = equipment3.getQty().floatValue() - this.getEquippedQty(equipSet, equipment2).floatValue();
        if (f.floatValue() < 0.0f) {
            f2 = f3;
            f = new Float(f2 + this.getEquippedQty(equipSet, equipment2).floatValue());
            bl = true;
        }
        if (f2 > f3) {
            return null;
        }
        if (equipment != null && equipment.isContainer()) {
            equipment2.setQty(f);
            equipment2.setNumberCarried(f);
            if (equipment.canContain(this, equipment2) == 1) {
                string = equipment.getName();
                bl = true;
                bl2 = true;
            } else {
                return null;
            }
        }
        if ((string == null || string.length() == 0) && (string = this.getSingleLocation(equipment2)).length() == 0) {
            return null;
        }
        if (!this.canEquipItem(equipSet, string, equipment2, equipment)) {
            return null;
        }
        if (equipment2.isContainer()) {
            bl2 = false;
        }
        EquipSet equipSet2 = this.getEquipSetForItem(equipSet, equipment2);
        if (bl && bl2 && equipSet2 != null) {
            f = new Float(f2 + this.getEquippedQty(equipSet, equipment2).floatValue());
            equipSet2.setQty(f);
            equipment2.setQty(f);
            equipment2.setNumberCarried(f);
            this.setDirty(true);
            if (equipment != null && equipment.isContainer()) {
                equipment.updateContainerContentsString(this);
            }
            return equipSet2;
        }
        if (equipment != null && equipment.isContainer()) {
            equipment.insertChild(this, equipment2);
            equipment2.setParent(equipment);
        }
        String string2 = this.getNewIdPath(equipSet);
        EquipSet equipSet3 = new EquipSet(string2, string, equipment2.getName(), equipment2);
        equipment2.setQty(f);
        equipSet3.setQty(f);
        this.addEquipSet(equipSet3);
        this.setDirty(true);
        return equipSet3;
    }

    public String getStringFor(StringKey stringKey) {
        return this.stringChar.get((Object)stringKey);
    }

    public String getSafeStringFor(StringKey stringKey) {
        String string = this.stringChar.get((Object)stringKey);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setDoLevelAbilities(boolean bl) {
        this.processLevelAbilities = bl;
    }

    public boolean doLevelAbilities() {
        return this.processLevelAbilities;
    }

    public void setAllowFeatPoolAdjustment(boolean bl) {
        this.allowFeatPoolAdjustment = bl;
    }

    private void setAggregateFeatsStable(boolean bl) {
        this.setAggregateAbilitiesStable(AbilityCategory.FEAT, bl);
    }

    public void setAggregateAbilitiesStable(Category<Ability> category, boolean bl) {
        if (!bl && this.rebuildingAbilities) {
            return;
        }
        if (!bl) {
            this.cachedWeaponProfs = null;
        }
        if (category == AbilityCategory.FEAT) {
            this.aggregateFeatsStable = bl;
            this.setVirtualFeatsStable(bl);
            this.setAutomaticFeatsStable(bl);
            if (!bl) {
                this.cachedWeaponProfs = null;
            }
        }
        if (category == null) {
            if (!bl) {
                for (Category<Ability> category2 : this.theAbilities.getKeySet()) {
                    if (category2 == null) {
                        Logging.errorPrint("Null category entry in character's abilities key set " + String.valueOf(this.theAbilities.getKeySet()));
                        continue;
                    }
                    this.setAggregateAbilitiesStable(category2, bl);
                }
            }
            this.setAggregateFeatsStable(bl);
            return;
        }
        if (!bl) {
            this.theAbilities.put(category, Ability.Nature.AUTOMATIC, null);
            this.theAbilities.put(category, Ability.Nature.VIRTUAL, null);
            this.theAbilities.put(category, Ability.Nature.NORMAL, null);
        }
    }

    private boolean isAggregateFeatsStable() {
        return this.theAbilities.get(AbilityCategory.FEAT, Ability.Nature.AUTOMATIC) != null && this.virtualFeatsStable && this.aggregateFeatsStable;
    }

    private void setAutomaticFeatsStable(boolean bl) {
        this.setAutomaticAbilitiesStable(AbilityCategory.FEAT, bl);
    }

    public void setAutomaticAbilitiesStable(AbilityCategory abilityCategory, boolean bl) {
        if (abilityCategory == null) {
            if (!bl) {
                for (Category<Ability> category : this.theAbilities.getKeySet()) {
                    this.theAbilities.put(category, Ability.Nature.AUTOMATIC, null);
                }
            }
            this.setAutomaticFeatsStable(bl);
            return;
        }
        if (!bl) {
            this.theAbilities.put(abilityCategory, Ability.Nature.AUTOMATIC, null);
        }
    }

    public boolean addRealAbility(Category<Ability> category, Ability ability) {
        if (ability == null) {
            return false;
        }
        ability.setAbilityNature(Ability.Nature.NORMAL);
        List<Ability> list = this.realAbilities.get(category);
        if (list == null) {
            list = new ArrayList<Ability>();
            this.realAbilities.put(category, list);
        }
        list.add(ability);
        return true;
    }

    public void clearRealAbilities(AbilityCategory abilityCategory) {
        if (abilityCategory == null) {
            for (Category<Ability> category : this.theAbilities.getKeySet()) {
                this.theAbilities.put(category, Ability.Nature.NORMAL, null);
            }
            return;
        }
        this.theAbilities.put(abilityCategory, Ability.Nature.NORMAL, null);
    }

    public HashMap<Ability.Nature, Set<Ability>> getAbilitiesSet() {
        Set<Category<Ability>> set = this.theAbilities.getKeySet();
        HashMap<Ability.Nature, Set<Ability>> hashMap = new HashMap<Ability.Nature, Set<Ability>>();
        hashMap.put(Ability.Nature.AUTOMATIC, new HashSet());
        hashMap.put(Ability.Nature.NORMAL, new HashSet());
        hashMap.put(Ability.Nature.VIRTUAL, new HashSet());
        hashMap.put(Ability.Nature.ANY, new HashSet());
        if (set == null) {
            return hashMap;
        }
        hashMap.get((Object)Ability.Nature.VIRTUAL).addAll(this.getAbilitySetByNature(Ability.Nature.VIRTUAL));
        hashMap.get((Object)Ability.Nature.AUTOMATIC).addAll(this.getAbilitySetByNature(Ability.Nature.AUTOMATIC));
        hashMap.get((Object)Ability.Nature.NORMAL).addAll(this.getAbilitySetByNature(Ability.Nature.NORMAL));
        hashMap.get((Object)Ability.Nature.ANY).addAll((Collection<Ability>)hashMap.get((Object)Ability.Nature.NORMAL));
        hashMap.get((Object)Ability.Nature.ANY).addAll((Collection<Ability>)hashMap.get((Object)Ability.Nature.AUTOMATIC));
        hashMap.get((Object)Ability.Nature.ANY).addAll((Collection<Ability>)hashMap.get((Object)Ability.Nature.VIRTUAL));
        return hashMap;
    }

    public List<Ability> getAllAbilities() {
        Set<Category<Ability>> set = this.theAbilities.getKeySet();
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        if (set == null) {
            return arrayList;
        }
        for (Category<Ability> category : set) {
            arrayList.addAll(this.getAutomaticAbilityList(category));
            arrayList.addAll(this.getRealAbilitiesList(category));
            arrayList.addAll(this.getVirtualAbilityList(category));
        }
        return arrayList;
    }

    public List<Ability> getRealAbilitiesList(Category<Ability> category) {
        List<Ability> list = this.theAbilities.get(category, Ability.Nature.NORMAL);
        if (list != null) {
            return new ArrayList<Ability>(list);
        }
        this.rebuildAggregateAbilityList();
        list = this.theAbilities.get(category, Ability.Nature.NORMAL);
        return new ArrayList<Ability>(list);
    }

    public List<Ability> getRealAbilitiesListAnyCat(AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (AbilityCategory abilityCategory2 : SettingsHandler.getGame().getAllAbilityCategories()) {
            for (Ability ability : this.getRealAbilitiesList(abilityCategory2)) {
                if (!abilityCategory.getKeyName().equals(ability.getCategory())) continue;
                arrayList.add(ability);
            }
        }
        return arrayList;
    }

    public List<Ability> getRealFeatList() {
        return this.getRealAbilitiesList(AbilityCategory.FEAT);
    }

    @Deprecated
    public List<Ability> getRealAbilityList(Category<Ability> category) {
        return this.getRealAbilitiesList(category);
    }

    public Ability getRealFeatKeyed(String string) {
        return this.getRealAbilityKeyed(AbilityCategory.FEAT, string);
    }

    public Ability getRealAbilityKeyed(AbilityCategory abilityCategory, String string) {
        List<Ability> list = this.getRealAbilitiesList(abilityCategory);
        if (list != null) {
            for (Ability ability : list) {
                if (!ability.getKeyName().equals(string)) continue;
                return ability;
            }
        }
        return null;
    }

    public boolean hasRealFeat(Ability ability) {
        return this.hasRealAbility(AbilityCategory.FEAT, ability);
    }

    public boolean hasRealAbility(AbilityCategory abilityCategory, Ability ability) {
        List<Ability> list = this.theAbilities.get(abilityCategory, Ability.Nature.NORMAL);
        if (list == null) {
            return false;
        }
        return list.contains(ability);
    }

    public boolean hasAbility(AbilityCategory abilityCategory, Ability.Nature nature, Ability ability) {
        int n;
        int n2;
        ArrayList<AbilityCategory> arrayList;
        if (abilityCategory == null) {
            arrayList = new ArrayList<AbilityCategory>();
            Collection<AbilityCategory> collection = SettingsHandler.getGame().getAllAbilityCategories();
            for (AbilityCategory abilityCategory2 : collection) {
                if (!abilityCategory2.getAbilityCategory().equals(ability.getCategory())) continue;
                arrayList.add(abilityCategory2);
            }
        } else {
            arrayList = new ArrayList();
            arrayList.add(abilityCategory);
        }
        if (nature == Ability.Nature.ANY) {
            n2 = 0;
            n = Ability.Nature.values().length - 2;
        } else {
            n2 = n = nature.ordinal();
        }
        for (int i = n2; i <= n; ++i) {
            Ability.Nature nature2 = Ability.Nature.values()[i];
            boolean bl = false;
            for (AbilityCategory abilityCategory3 : arrayList) {
                switch (nature2) {
                    case NORMAL: {
                        bl = this.hasRealAbility(abilityCategory3, ability);
                        break;
                    }
                    case AUTOMATIC: {
                        bl = this.hasAutomaticAbility(abilityCategory3, ability);
                        break;
                    }
                    case VIRTUAL: {
                        bl = this.hasVirtualAbility(abilityCategory3, ability);
                    }
                }
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRealFeatNamed(String string) {
        List<Ability> list = this.theAbilities.get(AbilityCategory.FEAT, Ability.Nature.NORMAL);
        if (list == null) {
            return false;
        }
        return AbilityUtilities.getAbilityFromList(list, "FEAT", string, Ability.Nature.ANY) != null;
    }

    public boolean removeRealFeat(Ability ability) {
        return this.removeRealAbility(AbilityCategory.FEAT, ability);
    }

    public boolean removeRealAbility(AbilityCategory abilityCategory, Ability ability) {
        List<Ability> list = this.realAbilities.get(abilityCategory);
        if (list == null) {
            return false;
        }
        return list.remove(ability);
    }

    public List<Ability> getDirectVirtualAbilities(AbilityCategory abilityCategory) {
        List<Ability> list = this.virtualAbilities.get(abilityCategory);
        if (list == null) {
            list = new ArrayList<Ability>();
            this.virtualAbilities.put(abilityCategory, list);
        }
        return list;
    }

    public void adjustFeats(double d) {
        if (this.allowFeatPoolAdjustment) {
            this.feats += d;
        }
        this.setDirty(true);
    }

    public void adjustAbilities(AbilityCategory abilityCategory, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        if (bigDecimal.equals(BigDecimal.ZERO)) {
            return;
        }
        if (abilityCategory == AbilityCategory.FEAT) {
            this.adjustFeats(bigDecimal.doubleValue());
            return;
        }
        if (this.theUserPoolBonuses == null) {
            this.theUserPoolBonuses = new HashMap<AbilityCategory, BigDecimal>();
        }
        bigDecimal2 = (bigDecimal2 = this.theUserPoolBonuses.get(abilityCategory)) != null ? bigDecimal2.add(bigDecimal) : bigDecimal;
        this.theUserPoolBonuses.put(abilityCategory, bigDecimal2);
        this.setDirty(true);
    }

    public void setFeats(double d) {
        if (this.allowFeatPoolAdjustment) {
            this.feats = d;
        }
        this.setDirty(true);
    }

    public void setUserPoolBonus(AbilityCategory abilityCategory, BigDecimal bigDecimal) {
        if (this.theUserPoolBonuses == null) {
            this.theUserPoolBonuses = new HashMap<AbilityCategory, BigDecimal>();
        }
        this.theUserPoolBonuses.put(abilityCategory, bigDecimal);
    }

    public double getUserPoolBonus(AbilityCategory abilityCategory) {
        BigDecimal bigDecimal = null;
        if (this.theUserPoolBonuses != null) {
            bigDecimal = this.theUserPoolBonuses.get(abilityCategory);
        }
        if (bigDecimal == null) {
            return 0.0;
        }
        return bigDecimal.doubleValue();
    }

    public BigDecimal getTotalAbilityPool(AbilityCategory abilityCategory) {
        if (abilityCategory == AbilityCategory.FEAT) {
            BigDecimal bigDecimal = this.getAbilityPoolSpent(abilityCategory);
            return bigDecimal.add(new BigDecimal(this.getFeats()));
        }
        Float f = this.getVariableValue(abilityCategory.getPoolFormula(), this.getClass().toString());
        if (!abilityCategory.allowFractionalPool()) {
            f = new Float(f.intValue());
        }
        double d = this.getTotalBonusTo("ABILITYPOOL", abilityCategory.getKeyName());
        if (!abilityCategory.allowFractionalPool()) {
            d = Math.floor(d);
        }
        double d2 = this.getUserPoolBonus(abilityCategory);
        return BigDecimal.valueOf((double)f.floatValue() + d + d2);
    }

    public List<Ability> getSelectedAbilities(AbilityCategory abilityCategory) {
        return this.getRealAbilitiesList(abilityCategory);
    }

    public double getFeats() {
        if (Globals.getGameModeHasPointPool()) {
            return this.getSkillPoints();
        }
        return this.getRawFeats(true);
    }

    public BigDecimal getAvailableAbilityPool(AbilityCategory abilityCategory) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return BigDecimal.valueOf(this.getFeats());
        }
        return this.getTotalAbilityPool(abilityCategory).subtract(this.getAbilityPoolSpent(abilityCategory));
    }

    public double getRawFeats(boolean bl) {
        double d = this.feats;
        if (bl) {
            d += this.getBonusFeatPool();
        }
        return d;
    }

    public boolean canSelectAbility(Ability ability) {
        return this.canSelectAbility(ability, false);
    }

    public boolean canSelectAbility(Ability ability, boolean bl) {
        boolean bl2 = this.qualifiesForFeat(ability);
        boolean bl3 = ability.getSafe(ObjectKey.MULTIPLE_ALLOWED);
        boolean bl4 = this.hasRealFeat(ability);
        boolean bl5 = this.hasFeatAutomatic(ability.getKeyName());
        boolean bl6 = !bl4 && !bl5;
        return !(!bl && !bl2 || !bl3 && !bl6);
    }

    public double getUsedFeatCount() {
        double d = 0.0;
        List<Ability> list = this.realAbilities.get(AbilityCategory.FEAT);
        if (list == null) {
            return 0.0;
        }
        for (Ability ability : list) {
            if (ability.getSafe(ObjectKey.VISIBILITY) == Visibility.HIDDEN || ability.getSafe(ObjectKey.VISIBILITY) == Visibility.OUTPUT_ONLY) continue;
            int n = this.getSelectCorrectedAssociationCount(ability);
            double d2 = ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
            if (ability.getSafe(StringKey.CHOICE_STRING) != null && ability.getSafe(StringKey.CHOICE_STRING).length() > 0) {
                d += Math.ceil((double)n * d2);
                continue;
            }
            int n2 = ability.getSafe(FormulaKey.SELECT).resolve(this, "").intValue();
            double d3 = d2 / (double)n2;
            if (!AbilityCategory.FEAT.allowFractionalPool()) {
                d += (double)((int)Math.ceil(d3));
                continue;
            }
            d += d3;
        }
        return d;
    }

    public BigDecimal getAbilityPoolSpent(AbilityCategory abilityCategory) {
        if (abilityCategory == AbilityCategory.FEAT) {
            return BigDecimal.valueOf(this.getUsedFeatCount());
        }
        double d = 0.0;
        List<Ability> list = this.getSelectedAbilities(abilityCategory);
        if (list != null) {
            for (Ability ability : list) {
                int n = this.getSelectCorrectedAssociationCount(ability);
                double d2 = ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
                if (ability.getSafe(StringKey.CHOICE_STRING) != null && ability.getSafe(StringKey.CHOICE_STRING).length() > 0) {
                    d += Math.ceil((double)n * d2);
                    continue;
                }
                int n2 = ability.getSafe(FormulaKey.SELECT).resolve(this, "").intValue();
                double d3 = d2 / (double)n2;
                if (!abilityCategory.allowFractionalPool()) {
                    d += (double)((int)Math.ceil(d3));
                    continue;
                }
                d += d3;
            }
        }
        if (!abilityCategory.allowFractionalPool()) {
            return BigDecimal.valueOf((int)Math.ceil(d));
        }
        return BigDecimal.valueOf(d);
    }

    private void setVirtualFeatsStable(boolean bl) {
        this.virtualFeatsStable = bl;
    }

    public void setVirtualAbilitiesStable(AbilityCategory abilityCategory, boolean bl) {
        if (abilityCategory == AbilityCategory.FEAT) {
            this.setVirtualFeatsStable(bl);
            return;
        }
        if (!bl) {
            this.theAbilities.put(abilityCategory, Ability.Nature.VIRTUAL, null);
        }
    }

    public void addFeat(Ability ability, PCLevelInfo pCLevelInfo) {
        if (this.hasRealFeat(ability)) {
            Logging.errorPrint("Adding duplicate feat: " + ability.getDisplayName());
        }
        if (!this.addRealAbility(AbilityCategory.FEAT, ability)) {
            Logging.errorPrint("Problem adding feat: " + ability.getDisplayName());
        }
        if (pCLevelInfo != null) {
            pCLevelInfo.addObject(ability);
        }
        this.addNaturalWeapons(ability.getListFor(ListKey.NATURAL_WEAPON));
        this.setAggregateFeatsStable(false);
        this.calcActiveBonuses();
    }

    public void addAbility(AbilityCategory abilityCategory, Ability ability, PCLevelInfo pCLevelInfo) {
        if (this.hasRealAbility(abilityCategory, ability)) {
            Logging.errorPrint("Adding duplicate ability: " + ability.getDisplayName());
        }
        if (!this.addRealAbility(abilityCategory, ability)) {
            Logging.errorPrint("Problem adding ability: " + ability.getDisplayName());
        }
        if (pCLevelInfo != null) {
            pCLevelInfo.addObject(ability);
        }
        this.addNaturalWeapons(ability.getListFor(ListKey.NATURAL_WEAPON));
        this.setAggregateAbilitiesStable(abilityCategory, false);
        this.calcActiveBonuses();
    }

    public Ability getFeatAutomaticKeyed(String string) {
        return this.getAutomaticAbilityKeyed(AbilityCategory.FEAT, string);
    }

    public Ability getAutomaticAbilityKeyed(AbilityCategory abilityCategory, String string) {
        List<Ability> list = this.getAutomaticAbilityList(abilityCategory);
        for (Ability ability : list) {
            if (!ability.getKeyName().equals(string)) continue;
            return ability;
        }
        return null;
    }

    public int addAbility(PCLevelInfo pCLevelInfo, AbilityCategory abilityCategory, String string, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = !bl2;
        if (!this.isImporting()) {
            this.getSpellList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        String string3 = AbilityUtilities.getUndecoratedName(string, arrayList);
        String string4 = arrayList.size() > 0 ? (String)arrayList.iterator().next() : "";
        Ability ability = this.getRealAbilityKeyed(abilityCategory, string2);
        if (ability == null) {
            ability = this.getRealAbilityKeyed(abilityCategory, string3);
            if (!bl3 && ability != null && string4.length() != 0) {
                bl3 = true;
            }
        }
        if (ability == null && bl) {
            ability = Globals.getAbilityKeyed(abilityCategory, string3);
            if (ability == null && (ability = Globals.getAbilityKeyed(abilityCategory, string2)) != null) {
                string4 = "";
            }
            if (ability == null) {
                Logging.errorPrint("Ability not found: " + string2);
                return bl ? 1 : 0;
            }
            ability = ability.clone();
            this.addAbility(abilityCategory, ability, pCLevelInfo);
            this.selectTemplates(ability, this.isImporting());
        }
        if (ability == null) {
            return bl ? 1 : 0;
        }
        return AbilityUtilities.finaliseAbility(ability, string4, this, bl, bl3, abilityCategory);
    }

    public Ability getFeatKeyed(String string) {
        return this.getAbilityKeyed(AbilityCategory.FEAT, string);
    }

    public Ability getAbilityKeyed(AbilityCategory abilityCategory, Ability.Nature nature, String string) {
        List<Ability> list = this.theAbilities.get(abilityCategory, nature);
        for (Ability ability : list) {
            if (!ability.getKeyName().equals(string)) continue;
            return ability;
        }
        return null;
    }

    public Ability getAbilityKeyed(AbilityCategory abilityCategory, String string) {
        List<Ability> list = this.getAggregateAbilityList(abilityCategory);
        for (Ability ability : list) {
            if (!ability.getKeyName().equals(string)) continue;
            return ability;
        }
        return null;
    }

    public Ability getAbilityKeyed(String string) {
        List<Ability> list = this.getFullAbilityList();
        for (Ability ability : list) {
            if (!ability.getKeyName().equals(string)) continue;
            return ability;
        }
        return null;
    }

    public boolean hasAbilityKeyed(String string) {
        return this.getAbilityKeyed(string) != null;
    }

    public List<Ability> aggregateFeatList() {
        List<Ability> list = this.getStableAggregateFeatList();
        if (list != null) {
            return list;
        }
        return this.rebuildFeatAggreagateList();
    }

    public List<Ability> getAggregateAbilityList(AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>(this.getRealAbilitiesList(abilityCategory));
        arrayList.addAll(this.getVirtualAbilityList(abilityCategory));
        arrayList.addAll(this.getAutomaticAbilityList(abilityCategory));
        return arrayList;
    }

    public List<Ability> getAggregateAbilityListNoDuplicates(AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        HashMap<String, Ability> hashMap = new HashMap<String, Ability>();
        for (Ability ability : this.getRealAbilitiesList(abilityCategory)) {
            if (ability == null) continue;
            hashMap.put(ability.getKeyName(), ability);
        }
        this.addUniqueAbilitiesToMap(hashMap, this.getVirtualAbilityList(abilityCategory));
        this.addUniqueAbilitiesToMap(hashMap, this.getAutomaticAbilityList(abilityCategory));
        arrayList.addAll(hashMap.values());
        return arrayList;
    }

    private List<Ability> rebuildFeatAggreagateList() {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        HashMap<String, Ability> hashMap = new HashMap<String, Ability>();
        for (Ability ability : this.getRealAbilitiesList(AbilityCategory.FEAT)) {
            if (ability == null) continue;
            hashMap.put(ability.getKeyName(), ability);
        }
        this.addUniqueAbilitiesToMap(hashMap, this.getVirtualFeatList());
        arrayList.addAll(hashMap.values());
        this.setStableAggregateFeatList(arrayList);
        this.addUniqueAbilitiesToMap(hashMap, this.featAutoList());
        arrayList = new ArrayList();
        arrayList.addAll(hashMap.values());
        this.setStableAggregateFeatList(arrayList);
        return arrayList;
    }

    private void addUniqueAbilitiesToMap(Map<String, Ability> map, List<Ability> list) {
        for (Ability ability : list) {
            if (!map.containsKey(ability.getKeyName())) {
                map.put(ability.getKeyName(), ability);
                continue;
            }
            if (!ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) continue;
            Ability ability2 = map.get(ability.getKeyName());
            Ability ability3 = ability2.clone();
            for (String string : this.getAssociationList(ability2)) {
                this.addAssociation((CDOMObject)ability3, string);
            }
            for (String string : this.getAssociationList(ability)) {
                if (!ability3.getSafe(ObjectKey.STACKS).booleanValue() && this.containsAssociated((CDOMObject)ability3, string)) continue;
                this.addAssociation((CDOMObject)ability3, string);
            }
            map.put(ability.getKeyName(), ability3);
        }
    }

    public List<Ability> aggregateVisibleFeatList() {
        return this.getAggregateVisibleAbilityList(AbilityCategory.FEAT);
    }

    public List<Ability> getAggregateVisibleAbilityList(AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        arrayList.addAll(this.getRealAbilitiesListAnyCat(abilityCategory));
        arrayList.addAll(this.getAutomaticAbilityList(abilityCategory));
        arrayList.addAll(this.getVirtualAbilityList(abilityCategory));
        ArrayList<Ability> arrayList2 = new ArrayList<Ability>(arrayList.size());
        for (Ability ability : arrayList) {
            if (ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT && ability.getSafe(ObjectKey.VISIBILITY) != Visibility.OUTPUT_ONLY) continue;
            arrayList2.add(ability);
        }
        return arrayList2;
    }

    public List<Ability> getVirtualFeatList() {
        return this.getVirtualAbilityList(AbilityCategory.FEAT);
    }

    public Set<Ability> getAbilitySetByNature(Ability.Nature nature) {
        GameMode gameMode = SettingsHandler.getGame();
        HashSet<AbilityCategory> hashSet = new HashSet<AbilityCategory>();
        hashSet.addAll(gameMode.getAllAbilityCategories());
        HashSet<Ability> hashSet2 = new HashSet<Ability>();
        switch (nature) {
            case AUTOMATIC: {
                for (AbilityCategory abilityCategory : hashSet) {
                    hashSet2.addAll(this.getAutomaticAbilityList(abilityCategory));
                }
                break;
            }
            case NORMAL: {
                for (AbilityCategory abilityCategory : hashSet) {
                    hashSet2.addAll(this.getRealAbilitiesList(abilityCategory));
                }
                break;
            }
            case VIRTUAL: {
                for (AbilityCategory abilityCategory : hashSet) {
                    hashSet2.addAll(this.getVirtualAbilityList(abilityCategory));
                }
                break;
            }
            default: {
                Logging.errorPrint("Attempt to get abilities of Nature: " + (Object)((Object)nature));
            }
        }
        return hashSet2;
    }

    public Set<Ability> getFullAbilitySet() {
        GameMode gameMode = SettingsHandler.getGame();
        HashSet<AbilityCategory> hashSet = new HashSet<AbilityCategory>();
        hashSet.addAll(gameMode.getAllAbilityCategories());
        HashSet<Ability> hashSet2 = new HashSet<Ability>();
        for (AbilityCategory abilityCategory : hashSet) {
            hashSet2.addAll(this.getAggregateAbilityList(abilityCategory));
        }
        return hashSet2;
    }

    public List<Ability> getFullAbilityList() {
        GameMode gameMode = SettingsHandler.getGame();
        HashSet<AbilityCategory> hashSet = new HashSet<AbilityCategory>();
        hashSet.addAll(gameMode.getAllAbilityCategories());
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (AbilityCategory abilityCategory : hashSet) {
            arrayList.addAll(this.getAggregateAbilityListNoDuplicates(abilityCategory));
        }
        return arrayList;
    }

    public List<Ability> getVirtualAbilityList(Category<Ability> category) {
        List<Ability> list = this.theAbilities.get(category, Ability.Nature.VIRTUAL);
        if (list == null) {
            this.rebuildAggregateAbilityList();
            list = this.theAbilities.get(category, Ability.Nature.VIRTUAL);
        }
        return Collections.unmodifiableList(list);
    }

    public List<Ability> featAutoList() {
        return this.getAutomaticAbilityList(AbilityCategory.FEAT);
    }

    public List<Ability> getAutomaticAbilityList(Category<Ability> category) {
        List<Ability> list = this.theAbilities.get(category, Ability.Nature.AUTOMATIC);
        if (list == null) {
            this.rebuildAggregateAbilityList();
            list = this.theAbilities.get(category, Ability.Nature.AUTOMATIC);
        }
        return Collections.unmodifiableList(list);
    }

    private synchronized void rebuildAggregateAbilityList() {
        this.rebuildingAbilities = true;
        this.getVariableProcessor().pauseCache();
        this.rebuildAggregateAbilityListWorker();
        this.getVariableProcessor().restartCache();
        this.rebuildingAbilities = false;
    }

    private synchronized void rebuildAggregateAbilityListWorker() {
        GameMode gameMode = SettingsHandler.getGame();
        Collection<CDOMReference<AbilityList>> collection = AbilityList.getAbilityLists();
        HashSet<AbilityCategory> hashSet = new HashSet<AbilityCategory>();
        hashSet.addAll(gameMode.getAllAbilityCategories());
        for (AbilityCategory abilityCategory : hashSet) {
            for (Ability.Nature object : Ability.Nature.values()) {
                if (object == Ability.Nature.ANY) continue;
                Iterator<CDOMReference<AbilityList>> iterator = new ArrayList();
                if (object == Ability.Nature.NORMAL && this.realAbilities.get(abilityCategory) != null) {
                    iterator.addAll((Collection)this.realAbilities.get(abilityCategory));
                } else if (object == Ability.Nature.VIRTUAL) {
                    for (Ability ability : this.getDirectVirtualAbilities(abilityCategory)) {
                        if (!PrereqHandler.passesAll(ability.getPrerequisiteList(), this, ability)) continue;
                        iterator.add((CDOMReference<AbilityList>)((Object)ability));
                    }
                }
                this.theAbilities.put(abilityCategory, object, (List<Ability>)((Object)iterator));
            }
        }
        int n = -1;
        int n2 = 0;
        while (n != this.theAbilities.deepSize() && n2 < 10) {
            n = this.theAbilities.deepSize();
            ++n2;
            ArrayList arrayList = new ArrayList();
            ArrayList<Equipment> arrayList2 = new ArrayList<Equipment>();
            for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
                Object object;
                List<Object> list;
                Object object2;
                Object object3;
                for (CDOMReference cDOMReference : cDOMObject.getSafeListMods(Ability.FEATLIST)) {
                    Collection<AssociatedPrereqObject> collection2 = cDOMObject.getListAssociations(Ability.FEATLIST, cDOMReference);
                    for (Ability ability : cDOMReference.getContainedObjects()) {
                        for (AssociatedPrereqObject associatedPrereqObject : collection2) {
                            if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), this, cDOMObject)) continue;
                            object3 = associatedPrereqObject.getAssociation(AssociationKey.ASSOC_CHOICES);
                            if (object3 == null) {
                                object3 = Collections.emptyList();
                            }
                            if ((object2 = AbilityUtilities.addAbilityToListwithChoices(this, ability, object3, list = this.theAbilities.get(AbilityCategory.FEAT, (Ability.Nature)((Object)(object = associatedPrereqObject.getAssociation(AssociationKey.NATURE)))))) == null) continue;
                            ((Ability)object2).setAbilityNature((Ability.Nature)((Object)object));
                            for (CDOMReference<PCTemplate> cDOMReference2 : ((CDOMObject)object2).getSafeListFor(ListKey.TEMPLATE)) {
                                arrayList.addAll(cDOMReference2.getContainedObjects());
                            }
                            arrayList2.addAll(((CDOMObject)object2).getSafeListFor(ListKey.NATURAL_WEAPON));
                        }
                    }
                    this.addTemplatesIfMissing(arrayList);
                    this.addNaturalWeaponsIfMissing(arrayList2);
                }
                for (CDOMReference<AbilityList> cDOMReference : collection) {
                    for (CDOMReference cDOMReference3 : cDOMObject.getSafeListMods(cDOMReference)) {
                        Collection<AssociatedPrereqObject> collection3 = cDOMObject.getListAssociations(cDOMReference, cDOMReference3);
                        for (AssociatedPrereqObject associatedPrereqObject : collection3) {
                            if (!PrereqHandler.passesAll(associatedPrereqObject.getPrerequisiteList(), this, cDOMObject)) continue;
                            object3 = associatedPrereqObject.getAssociation(AssociationKey.NATURE);
                            object = associatedPrereqObject.getAssociation(AssociationKey.CATEGORY);
                            list = associatedPrereqObject.getAssociation(AssociationKey.ASSOC_CHOICES);
                            if (list == null) {
                                list = Collections.emptyList();
                            }
                            if ((object2 = this.theAbilities.get((Category<Ability>)object, (Ability.Nature)((Object)object3))) == null) {
                                Logging.errorPrint("Failed to retrieve list of abilities for " + (Object)object + " and " + object3);
                            }
                            for (Ability ability : cDOMReference3.getContainedObjects()) {
                                Ability ability2 = AbilityUtilities.addAbilityToListwithChoices(this, ability, list, (List<Ability>)object2);
                                if (ability2 == null) continue;
                                ability2.setAbilityNature((Ability.Nature)((Object)object3));
                                for (CDOMReference<PCTemplate> cDOMReference4 : ability2.getSafeListFor(ListKey.TEMPLATE)) {
                                    arrayList.addAll(cDOMReference4.getContainedObjects());
                                }
                                arrayList2.addAll(ability2.getSafeListFor(ListKey.NATURAL_WEAPON));
                            }
                        }
                    }
                }
                this.addTemplatesIfMissing(arrayList);
                this.addNaturalWeaponsIfMissing(arrayList2);
            }
            this.addNonAbilityAutoFeats(this.theAbilities.get(AbilityCategory.FEAT, Ability.Nature.AUTOMATIC));
            List<PObject> list = this.getConditionalTemplateObjects();
            list.addAll(this.getPObjectList());
            this.stableAggregateFeatList = new ArrayList<Ability>();
            this.stableAggregateFeatList.addAll((Collection<Ability>)this.theAbilities.get(AbilityCategory.FEAT, Ability.Nature.NORMAL));
            this.stableAggregateFeatList.addAll((Collection<Ability>)this.theAbilities.get(AbilityCategory.FEAT, Ability.Nature.AUTOMATIC));
            this.stableAggregateFeatList.addAll((Collection<Ability>)this.theAbilities.get(AbilityCategory.FEAT, Ability.Nature.VIRTUAL));
        }
        this.cachedWeaponProfs = null;
        this.rebuildFeatAggreagateList();
    }

    private void addTemplatesIfMissing(List<PCTemplate> list) {
        for (PCTemplate pCTemplate : list) {
            this.addTemplate(pCTemplate);
        }
    }

    private void addNaturalWeaponsIfMissing(List<Equipment> list) {
        Iterator<Equipment> iterator = list.iterator();
        while (iterator.hasNext()) {
            Equipment equipment = iterator.next();
            if (!this.equipmentList.contains(equipment)) continue;
            iterator.remove();
        }
        this.addNaturalWeapons(list);
    }

    private List<Ability> getStableAggregateFeatList() {
        if (this.isAggregateFeatsStable()) {
            return this.stableAggregateFeatList;
        }
        return null;
    }

    private void addNonAbilityAutoFeats(List<Ability> list) {
        Object object;
        Object object2;
        if (this.getRace() != null) {
            this.addAutoProfsToList(this.getRace().getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS), list);
        }
        for (PCClass object3 : this.getClassList()) {
            this.addAutoProfsToList(object3.getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS), list);
        }
        if (!this.getTemplateList().isEmpty()) {
            for (PCTemplate pCTemplate : this.getTemplateList()) {
                object2 = this.feats(pCTemplate, this.getTotalLevels(), this.totalHitDice(), false);
                if (!object2.isEmpty()) {
                    Iterator<Object> iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        String string = iterator.next();
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            object = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(this, list, "FEAT", stringTokenizer.nextToken());
                            if (object == null) continue;
                            ((Ability)object).setAbilityNature(Ability.Nature.AUTOMATIC);
                        }
                    }
                }
                this.addAutoProfsToList(pCTemplate.getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS), list);
            }
        }
        if (!this.getCharacterDomainList().isEmpty()) {
            for (CharacterDomain characterDomain : this.getCharacterDomainList()) {
                object2 = characterDomain.getDomain();
                if (object2 == null) continue;
                for (String string : this.getAssociationList((CDOMObject)object2)) {
                    if (!string.startsWith("FEAT")) continue;
                    int n = string.indexOf(63);
                    if (n > -1) {
                        object = AbilityUtilities.addCloneOfGlobalAbilityToListWithChoices(this, list, "FEAT", string.substring(n + 1));
                        if (object == null) continue;
                        ((Ability)object).setAbilityNature(Ability.Nature.AUTOMATIC);
                        continue;
                    }
                    Logging.errorPrint("no '?' in Domain assocatedList entry: " + string);
                }
                for (CDOMReference cDOMReference : ((CDOMObject)object2).getSafeListMods(Ability.FEATLIST)) {
                    Collection<AssociatedPrereqObject> collection = ((CDOMObject)object2).getListAssociations(Ability.FEATLIST, cDOMReference);
                    for (Ability ability : cDOMReference.getContainedObjects()) {
                        for (AssociatedPrereqObject associatedPrereqObject : collection) {
                            Ability ability2;
                            List<String> list2 = associatedPrereqObject.getAssociation(AssociationKey.ASSOC_CHOICES);
                            if (list2 == null) {
                                list2 = Collections.emptyList();
                            }
                            if ((ability2 = AbilityUtilities.addAbilityToListwithChoices(this, ability, list2, list)) == null) continue;
                            ability2.setAbilityNature(Ability.Nature.AUTOMATIC);
                        }
                    }
                }
                this.addAutoProfsToList(((CDOMObject)object2).getSafeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS), list);
            }
        }
    }

    private void addAutoProfsToList(List<String> list, List<Ability> list2) {
        for (String string : list) {
            this.addWeaponProfToList(list2, string, true);
        }
    }

    public Point2D.Double getFace() {
        Object object;
        Race race = this.getRace();
        Object object2 = new Point2D.Double(5.0, 0.0);
        if (race != null && (object = race.getFace()) != null) {
            object2 = object;
        }
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            Point2D.Double double_ = pCTemplate.getFace();
            if (double_ == null) continue;
            object2 = double_;
        }
        return object2;
    }

    public int getHands() {
        Race race = this.getRace();
        int n = 0;
        if (race != null) {
            n = race.getSafe(IntegerKey.CREATURE_HANDS);
        }
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            Integer n2 = pCTemplate.get(IntegerKey.CREATURE_HANDS);
            if (n2 == null) continue;
            n = n2;
        }
        return n;
    }

    public int getLegs() {
        Race race = this.getRace();
        int n = 0;
        if (race != null) {
            n = race.getSafe(IntegerKey.LEGS);
        }
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            Integer n2 = pCTemplate.get(IntegerKey.LEGS);
            if (n2 == null) continue;
            n = n2;
        }
        return n;
    }

    public int getReach() {
        Race race = this.getRace();
        int n = 0;
        if (race != null) {
            n = race.getSafe(IntegerKey.REACH);
        }
        for (PCTemplate pCTemplate : this.getTemplateList()) {
            Integer n2 = pCTemplate.get(IntegerKey.REACH);
            if (n2 == null) continue;
            n = n2;
        }
        return n += (int)this.getTotalBonusTo("COMBAT", "REACH");
    }

    public List<Ability> getFeatNamedAnyCat(String string) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (AbilityCategory abilityCategory : SettingsHandler.getGame().getAllAbilityCategories()) {
            Ability ability = AbilityUtilities.getAbilityFromList(this.getAggregateAbilityList(abilityCategory), "FEAT", string, Ability.Nature.ANY);
            if (ability == null) continue;
            arrayList.add(ability);
        }
        return arrayList;
    }

    public boolean hasSpellInSpellbook(Spell spell, String string) {
        for (PObject pObject : this.getPObjectList()) {
            List<CharacterSpell> list = this.getCharacterSpells(pObject, spell, string, -1);
            if (list == null || list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void resetEpicCache() {
        this.epicBAB = null;
        this.epicCheckMap.clear();
    }

    public int getCritRange(Equipment equipment, boolean bl) {
        if (!bl && !equipment.isDouble()) {
            return 0;
        }
        int n = equipment.getRawCritRange(bl);
        int n2 = (int)equipment.bonusTo(this, "EQMWEAPON", "CRITRANGEADD", bl);
        int n3 = 1 + (int)equipment.bonusTo(this, "EQMWEAPON", "CRITRANGEDOUBLE", bl);
        return n * n3 + n2;
    }

    public List<String> feats(PCTemplate pCTemplate, int n, int n2, boolean bl) {
        List<String> list;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PCTemplate pCTemplate2 : pCTemplate.getSafeListFor(ListKey.REPEATLEVEL_TEMPLATES)) {
            for (PCTemplate pCTemplate3 : pCTemplate2.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
                List<String> list2 = this.getAssocList(pCTemplate3, AssociationListKey.TEMPLATE_FEAT);
                if (list2 == null && bl && pCTemplate3.get(IntegerKey.LEVEL) <= n) {
                    list2 = this.getLevelFeat(pCTemplate3);
                }
                if (list2 == null) continue;
                arrayList.addAll(list2);
            }
        }
        for (PCTemplate pCTemplate2 : pCTemplate.getSafeListFor(ListKey.LEVEL_TEMPLATES)) {
            list = this.getAssocList(pCTemplate2, AssociationListKey.TEMPLATE_FEAT);
            if (list == null && bl && pCTemplate2.get(IntegerKey.LEVEL) <= n) {
                list = this.getLevelFeat(pCTemplate2);
            }
            if (list == null) continue;
            arrayList.addAll((Collection<String>)list);
        }
        for (PCTemplate pCTemplate2 : pCTemplate.getSafeListFor(ListKey.HD_TEMPLATES)) {
            list = this.getAssocList(pCTemplate2, AssociationListKey.TEMPLATE_FEAT);
            if (list == null && bl && pCTemplate2.get(IntegerKey.HD_MAX) <= n2 && pCTemplate2.get(IntegerKey.HD_MIN) >= n2) {
                list = this.getLevelFeat(pCTemplate2);
            }
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<String> getLevelFeat(PCTemplate pCTemplate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PersistentTransitionChoice<AbilitySelection> persistentTransitionChoice = pCTemplate.get(ObjectKey.TEMPLATE_FEAT);
        if (persistentTransitionChoice != null) {
            Collection<AbilitySelection> collection = this.actOn(pCTemplate, persistentTransitionChoice);
            for (AbilitySelection abilitySelection : collection) {
                arrayList.add(((Object)abilitySelection).toString());
            }
        }
        return arrayList;
    }

    private <T> Collection<? extends T> actOn(PCTemplate pCTemplate, PersistentTransitionChoice<T> persistentTransitionChoice) {
        Collection collection = persistentTransitionChoice.driveChoice(this);
        persistentTransitionChoice.act(collection, pCTemplate, this);
        return collection;
    }

    void selectTemplates(CDOMObject cDOMObject, boolean bl) {
        this.templatesAdded.removeListFor(cDOMObject);
        if (!bl) {
            for (CDOMReference<PCTemplate> iterator : cDOMObject.getSafeListFor(ListKey.TEMPLATE)) {
                for (PCTemplate pCTemplate : iterator.getContainedObjects()) {
                    this.templatesAdded.addToListFor(cDOMObject, pCTemplate);
                    this.addTemplate(pCTemplate);
                }
            }
            ArrayList arrayList = new ArrayList();
            for (CDOMReference<PCTemplate> cDOMReference : cDOMObject.getSafeListFor(ListKey.TEMPLATE_ADDCHOICE)) {
                arrayList.addAll(cDOMReference.getContainedObjects());
            }
            for (CDOMReference<PCTemplate> cDOMReference : cDOMObject.getSafeListFor(ListKey.TEMPLATE_CHOOSE)) {
                ArrayList<PCTemplate> arrayList2 = new ArrayList<PCTemplate>(arrayList);
                arrayList2.addAll(cDOMReference.getContainedObjects());
                PCTemplate pCTemplate = TemplateSelect.chooseTemplate(cDOMObject, arrayList2, true, this);
                if (pCTemplate == null) continue;
                this.templatesAdded.addToListFor(cDOMObject, pCTemplate);
                this.addTemplate(pCTemplate);
            }
            for (CDOMReference<PCTemplate> cDOMReference : cDOMObject.getSafeListFor(ListKey.REMOVE_TEMPLATES)) {
                for (PCTemplate pCTemplate : cDOMReference.getContainedObjects()) {
                    this.removeTemplate(pCTemplate);
                }
            }
        }
    }

    public void removeTemplatesFrom(PObject pObject) {
        Object object;
        Object object2;
        Collection<PCTemplate> collection = this.getTemplatesAdded(pObject);
        if (collection != null) {
            object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (PCTemplate)object2.next();
                this.removeTemplate(this.getTemplateKeyed(((CDOMObject)object).getKeyName()));
            }
        }
        if ((object2 = pObject.getListFor(ListKey.TEMPLATE)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                CDOMReference cDOMReference = (CDOMReference)object.next();
                for (PCTemplate pCTemplate : cDOMReference.getContainedObjects()) {
                    this.removeTemplate(this.getTemplateKeyed(pCTemplate.getKeyName()));
                }
            }
        }
    }

    public Collection<PCTemplate> getTemplatesAdded(PObject pObject) {
        return this.templatesAdded.getListFor(pObject);
    }

    public void setTemplatesAdded(PObject pObject, PCTemplate pCTemplate) {
        this.templatesAdded.addToListFor(pObject, pCTemplate);
    }

    public boolean isClassSkill(Skill skill, PCClass pCClass) {
        return SkillCost.CLASS.equals((Object)this.cache.getSkillCost(this, skill, pCClass));
    }

    public boolean isClassSkill(Skill skill) {
        for (PCClass pCClass : this.classList) {
            if (!this.isClassSkill(skill, pCClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isCrossClassSkill(Skill skill, PCClass pCClass) {
        return SkillCost.CROSS_CLASS.equals((Object)this.cache.getSkillCost(this, skill, pCClass));
    }

    public boolean isCrossClassSkill(Skill skill) {
        for (PCClass pCClass : this.classList) {
            if (!this.isCrossClassSkill(skill, pCClass)) continue;
            return true;
        }
        return false;
    }

    public SkillCost getSkillCostForClass(Skill skill, PCClass pCClass) {
        return this.cache.getSkillCost(this, skill, pCClass);
    }

    @Override
    public void addAssociation(CDOMObject cDOMObject, String string) {
        this.assocSupt.addAssoc(cDOMObject, AssociationListKey.CHOICES, new FixedStringList(string));
        List<ChooseResultActor> list = cDOMObject.getListFor(ListKey.CHOOSE_ACTOR);
        if (list != null) {
            for (ChooseResultActor chooseResultActor : list) {
                chooseResultActor.apply(this, cDOMObject, string);
            }
        }
    }

    @Override
    public void addAssociation(CDOMObject cDOMObject, FixedStringList fixedStringList) {
        this.assocSupt.addAssoc(cDOMObject, AssociationListKey.CHOICES, fixedStringList);
    }

    @Override
    public boolean containsAssociated(CDOMObject cDOMObject, String string) {
        return this.containsAssociated(cDOMObject, new FixedStringList(string));
    }

    @Override
    public boolean containsAssociated(CDOMObject cDOMObject, FixedStringList fixedStringList) {
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        if (list != null) {
            for (FixedStringList fixedStringList2 : list) {
                if (FixedStringList.CASE_INSENSITIVE_ORDER.compare(fixedStringList2, fixedStringList) != 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSelectCorrectedAssociationCount(CDOMObject cDOMObject) {
        return this.assocSupt.getAssocCount(cDOMObject, AssociationListKey.CHOICES) / cDOMObject.getSafe(FormulaKey.SELECT).resolve(this, "").intValue();
    }

    @Override
    public List<String> getAssociationList(CDOMObject cDOMObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        if (list != null) {
            for (FixedStringList fixedStringList : list) {
                String string = fixedStringList.get(0);
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    @Override
    public boolean hasAssociations(CDOMObject cDOMObject) {
        return this.assocSupt.hasAssocs((Object)cDOMObject, AssociationListKey.CHOICES);
    }

    @Override
    public List<String> removeAllAssociations(CDOMObject cDOMObject) {
        List<String> list = this.getAssociationList(cDOMObject);
        this.assocSupt.removeAllAssocs(cDOMObject, AssociationListKey.CHOICES);
        List<ChooseResultActor> list2 = cDOMObject.getListFor(ListKey.CHOOSE_ACTOR);
        if (list2 != null) {
            for (ChooseResultActor chooseResultActor : list2) {
                for (String string : list) {
                    chooseResultActor.remove(this, cDOMObject, string);
                }
            }
        }
        return list;
    }

    @Override
    public void removeAssociation(CDOMObject cDOMObject, String string) {
        List<ChooseResultActor> list = cDOMObject.getListFor(ListKey.CHOOSE_ACTOR);
        if (list != null) {
            for (ChooseResultActor chooseResultActor : list) {
                chooseResultActor.remove(this, cDOMObject, string);
            }
        }
        this.assocSupt.removeAssoc(cDOMObject, AssociationListKey.CHOICES, new FixedStringList(string));
    }

    @Override
    public void removeAssociation(CDOMObject cDOMObject, FixedStringList fixedStringList) {
        this.assocSupt.removeAssoc(cDOMObject, AssociationListKey.CHOICES, fixedStringList);
    }

    @Override
    public int getDetailedAssociationCount(CDOMObject cDOMObject) {
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        int n = 0;
        if (list != null) {
            for (FixedStringList fixedStringList : list) {
                n += fixedStringList.size();
            }
        }
        return n;
    }

    @Override
    public List<FixedStringList> getDetailedAssociations(CDOMObject cDOMObject) {
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<String> getExpandedAssociations(CDOMObject cDOMObject) {
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (FixedStringList fixedStringList : list) {
                for (String string : fixedStringList) {
                    arrayList.add(string);
                }
            }
        }
        return arrayList;
    }

    @Override
    public String getFirstAssociation(CDOMObject cDOMObject) {
        return this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES).get(0).get(0);
    }

    public <T> void addAssoc(Object object, AssociationListKey<T> associationListKey, T t) {
        this.assocSupt.addAssoc(object, associationListKey, t);
    }

    public <T> boolean containsAssoc(Object object, AssociationListKey<T> associationListKey, T t) {
        return this.assocSupt.containsAssoc(object, associationListKey, t);
    }

    public int getAssocCount(Object object, AssociationListKey<?> associationListKey) {
        return this.assocSupt.getAssocCount(object, associationListKey);
    }

    public <T> List<T> getAssocList(Object object, AssociationListKey<T> associationListKey) {
        return this.assocSupt.getAssocList(object, associationListKey);
    }

    public <T extends Comparable<T>> void sortAssocList(Object object, AssociationListKey<T> associationListKey) {
        this.assocSupt.sortAssocList(object, associationListKey);
    }

    public <T> Collection<T> getSafeAssocList(Object object, AssociationListKey<T> associationListKey) {
        List<T> list = this.getAssocList(object, associationListKey);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public boolean hasAssocs(Object object, AssociationListKey<?> associationListKey) {
        return this.assocSupt.hasAssocs(object, associationListKey);
    }

    public <T> List<T> removeAllAssocs(Object object, AssociationListKey<T> associationListKey) {
        return this.assocSupt.removeAllAssocs(object, associationListKey);
    }

    public <T> void removeAssoc(Object object, AssociationListKey<T> associationListKey, T t) {
        this.assocSupt.removeAssoc(object, associationListKey, t);
    }

    public <T> T getAssoc(Object object, AssociationKey<T> associationKey) {
        return this.assocSupt.getAssoc(object, associationKey);
    }

    public boolean hasAssocs(Object object, AssociationKey<?> associationKey) {
        return this.assocSupt.hasAssocs(object, associationKey);
    }

    public <T> void removeAssoc(Object object, AssociationKey<T> associationKey) {
        this.assocSupt.removeAssoc(object, associationKey);
    }

    public <T> void setAssoc(Object object, AssociationKey<T> associationKey, T t) {
        this.assocSupt.setAssoc(object, associationKey, t);
    }

    public boolean hasUnlockedStat(PCStat pCStat) {
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            if (!cDOMObject.containsInList(ListKey.UNLOCKED_STATS, pCStat)) continue;
            return true;
        }
        return false;
    }

    public Number getLockedStat(PCStat pCStat) {
        Number number = Double.NEGATIVE_INFINITY;
        boolean bl = false;
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            List<StatLock> list = cDOMObject.getListFor(ListKey.STAT_LOCKS);
            if (list == null) continue;
            for (StatLock statLock : list) {
                Number number2;
                if (!statLock.getLockedStat().equals(pCStat) || !((number2 = statLock.getLockValue().resolve(this, cDOMObject.getKeyName())).doubleValue() > number)) continue;
                bl = true;
                number = number2;
            }
        }
        return bl ? number : null;
    }

    public PCClass getSelectedFavoredClass() {
        return this.selectedFavoredClass;
    }

    public void setSelectedFavoredClass(PCClass pCClass) {
        this.selectedFavoredClass = pCClass;
    }

    public String getDescription(PObject pObject) {
        List<Description> list = pObject.getListFor(pObject.getDescriptionKey());
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Description description : list) {
            String string = description.getDescription(this, pObject);
            if (string.length() <= 0) continue;
            if (bl) {
                stringBuilder.append(",").append(' ');
            }
            stringBuilder.append(string);
            bl = true;
        }
        return stringBuilder.toString();
    }

    public void buildLangLists(List<Language> list, List<Language> list2, List<Language> list3) {
        SortedSet<Language> sortedSet = this.getAutoLanguages();
        Skill pObject = null;
        ArrayList<Skill> arrayList = new ArrayList<Skill>(this.getSkillList());
        for (Skill pObject2 : arrayList) {
            if (pObject2.getSafe(StringKey.CHOICE_STRING).indexOf(PropertyFactory.getString("in_language")) < 0) continue;
            pObject = pObject2;
        }
        for (Language language : this.getLanguageBonusSelectionList()) {
            if (language == null || !PrereqHandler.passesAll(language.getPrerequisiteList(), this, language)) continue;
            list.add(language);
        }
        for (Language language : this.getLanguagesList()) {
            boolean bl = false;
            if (pObject != null && this.containsAssociated((CDOMObject)pObject, language.getKeyName())) {
                bl = false;
            } else if (!sortedSet.contains(language)) {
                bl = true;
            }
            list.remove(language);
            if (bl) {
                list2.add(language);
                continue;
            }
            list3.add(language);
        }
    }

    public boolean containsAssocList(Object object, AssociationListKey<?> associationListKey) {
        return this.assocSupt.containsAssocList(object, associationListKey);
    }

    public HashMapToList<CDOMList<Spell>, Integer> getMasterLevelInfo(Spell spell) {
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList = this.cache.get(MapKey.SPELL_MASTER_INFO, spell);
        if (hashMapToList == null) {
            hashMapToList = SpellLevel.getMasterLevelInfo(this, spell);
            this.cache.addToMapFor(MapKey.SPELL_MASTER_INFO, spell, hashMapToList);
        }
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList2 = new HashMapToList<CDOMList<Spell>, Integer>();
        hashMapToList2.addAllLists(hashMapToList);
        return hashMapToList2;
    }

    public HashMapToList<CDOMList<Spell>, Integer> getPCBasedLevelInfo(Spell spell) {
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList = this.cache.get(MapKey.SPELL_PC_INFO, spell);
        if (hashMapToList == null) {
            hashMapToList = SpellLevel.getPCBasedLevelInfo(this, spell);
            this.cache.addToMapFor(MapKey.SPELL_PC_INFO, spell, hashMapToList);
        }
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList2 = new HashMapToList<CDOMList<Spell>, Integer>();
        hashMapToList2.addAllLists(hashMapToList);
        return hashMapToList2;
    }

    public DoubleKeyMapToList<Spell, CDOMList<Spell>, Integer> getPCBasedLevelInfo() {
        DoubleKeyMapToList<Spell, CDOMList<Spell>, Integer> doubleKeyMapToList = this.cache.get(ObjectKey.SPELL_PC_INFO);
        if (doubleKeyMapToList == null) {
            doubleKeyMapToList = SpellLevel.getPCBasedLevelInfo(this);
            this.cache.put(ObjectKey.SPELL_PC_INFO, doubleKeyMapToList);
        }
        DoubleKeyMapToList<Spell, CDOMList<Spell>, Integer> doubleKeyMapToList2 = new DoubleKeyMapToList<Spell, CDOMList<Spell>, Integer>();
        doubleKeyMapToList2.addAll(doubleKeyMapToList);
        return doubleKeyMapToList2;
    }

    public HashMapToList<CDOMList<Spell>, Integer> getLevelInfo(Spell spell) {
        HashMapToList<CDOMList<Spell>, Integer> hashMapToList = this.getMasterLevelInfo(spell);
        hashMapToList.addAllLists(this.getPCBasedLevelInfo(spell));
        return hashMapToList;
    }

    public CharacterSpell getCharacterSpellForSpell(PObject pObject, Spell spell) {
        List<CharacterSpell> list = this.getAssocList(pObject, AssociationListKey.CHARACTER_SPELLS);
        if (list == null) {
            list = new ArrayList<CharacterSpell>();
        }
        SpellLevel.addBonusKnowSpellsToList(this, pObject, list);
        if (list != null) {
            for (CharacterSpell characterSpell : list) {
                Spell spell2 = characterSpell.getSpell();
                if (!spell.equals(spell2) || !characterSpell.getOwner().equals(pObject)) continue;
                return characterSpell;
            }
        }
        return null;
    }

    public final List<CharacterSpell> getCharacterSpells(PObject pObject, Spell spell, String string, int n) {
        List<CharacterSpell> list = this.getAssocList(pObject, AssociationListKey.CHARACTER_SPELLS);
        if (list == null) {
            list = new ArrayList<CharacterSpell>();
        }
        SpellLevel.addBonusKnowSpellsToList(this, pObject, list);
        ArrayList<CharacterSpell> arrayList = new ArrayList<CharacterSpell>();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        for (CharacterSpell characterSpell : list) {
            SpellInfo spellInfo;
            if (spell != null && !characterSpell.getSpell().equals(spell) || (spellInfo = characterSpell.getSpellInfoFor(string, n, -1, null)) == null) continue;
            arrayList.add(characterSpell);
        }
        return arrayList;
    }

    public final List<CharacterSpell> getCharacterSpellsNoBonus(PObject pObject, Spell spell, String string, int n) {
        List<CharacterSpell> list = this.getAssocList(pObject, AssociationListKey.CHARACTER_SPELLS);
        if (list == null) {
            list = new ArrayList<CharacterSpell>();
        }
        ArrayList<CharacterSpell> arrayList = new ArrayList<CharacterSpell>();
        if (list == null || list.size() == 0) {
            return arrayList;
        }
        for (CharacterSpell characterSpell : list) {
            SpellInfo spellInfo;
            if (spell != null && !characterSpell.getSpell().equals(spell) || (spellInfo = characterSpell.getSpellInfoFor(string, n, -1, null)) == null) continue;
            arrayList.add(characterSpell);
        }
        return arrayList;
    }

    public int getDC(Spell spell, SpellInfo spellInfo) {
        return this.getDC(spell, spellInfo, null, 0);
    }

    public int getDC(Spell spell, SpellInfo spellInfo, PCClass pCClass, int n) {
        PCStat pCStat;
        Object object;
        PObject pObject = null;
        int n2 = n;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n3 = 0;
        int n4 = 0;
        if (spellInfo != null) {
            CharacterSpell characterSpell = spellInfo.getOwner();
            if (characterSpell != null) {
                n2 = spellInfo.getActualLevel();
                pObject = characterSpell.getOwner();
                object = characterSpell.getFixedDC();
                if (object != null && "INNATE".equalsIgnoreCase(spellInfo.getBook())) {
                    return this.getVariableValue((String)object, "").intValue();
                }
                if (object != null && pObject != null && !(pObject instanceof PCClass)) {
                    return this.getVariableValue((String)object, "").intValue();
                }
            }
            if (spellInfo.getFeatList() != null) {
                for (Ability iterator2 : spellInfo.getFeatList()) {
                    n2 -= iterator2.getSafe(IntegerKey.ADD_SPELL_LEVEL);
                    n3 = (int)((double)n3 + iterator2.bonusTo("DC", "FEATBONUS", this, this));
                }
            }
        } else {
            pObject = pCClass;
        }
        if (pObject instanceof Domain) {
            string = "DOMAIN." + pObject.getKeyName();
            object = this.getCharacterDomainForDomain(pObject.getKeyName());
            if (object != null && ((CharacterDomain)object).isFromPCClass()) {
                String string5 = ((CharacterDomain)object).getObjectName();
                pCClass = this.getClassKeyed(string5);
            }
        }
        if (pCClass != null || pObject instanceof PCClass) {
            if (pCClass == null || pObject instanceof PCClass) {
                pCClass = pObject;
            }
            string2 = "CLASS." + pCClass.getKeyName();
            string4 = "CLASS:" + pCClass.getKeyName();
            string3 = pCClass.getSpellType();
            n4 = pCClass.baseSpellIndex();
        }
        if (!(pObject instanceof PCClass) && !(pObject instanceof Domain)) {
            n4 = -2;
        }
        this.setSpellLevelTemp(n2);
        int n5 = this.getVariableValue(Globals.getGameModeBaseSpellDC(), string4).intValue() + n3;
        n5 += (int)this.getTotalBonusTo("DC", "ALLSPELLS");
        if (n4 == -2 && (pCStat = spell.get(ObjectKey.SPELL_STAT)) != null) {
            n5 += this.getStatList().getStatModFor(pCStat.getAbb());
        }
        if (spell.getKeyName().length() > 0) {
            n5 += (int)this.getTotalBonusTo("DC", "SPELL." + spell.getKeyName());
        }
        if (string.length() > 0) {
            n5 += (int)this.getTotalBonusTo("DC", string);
        }
        if (string2.length() > 0) {
            n5 += (int)this.getTotalBonusTo("DC", string2);
        }
        n5 += (int)this.getTotalBonusTo("DC", "TYPE." + string3);
        if (string3.equals("ALL")) {
            for (Type type : spell.getTrueTypeList(false)) {
                n5 += (int)this.getTotalBonusTo("DC", "TYPE." + type);
            }
        }
        for (String string6 : spell.getSafeListFor(ListKey.SPELL_SCHOOL)) {
            n5 += (int)this.getTotalBonusTo("DC", "SCHOOL." + string6);
        }
        for (String string7 : spell.getSafeListFor(ListKey.SPELL_SUBSCHOOL)) {
            n5 += (int)this.getTotalBonusTo("DC", "SUBSCHOOL." + string7);
        }
        for (String string8 : spell.getSafeListFor(ListKey.SPELL_DESCRIPTOR)) {
            n5 += (int)this.getTotalBonusTo("DC", "DESCRIPTOR." + string8);
        }
        this.setSpellLevelTemp(0);
        return n5;
    }

    private class CasterLevelSpellBonus {
        private int bonus;
        private String type;

        public CasterLevelSpellBonus(int n, String string) {
            this.bonus = n;
            this.type = string;
        }

        public int getBonus() {
            return this.bonus;
        }

        public String getType() {
            return this.type;
        }

        public void setBonus(int n) {
            this.bonus = n;
        }

        public String toString() {
            return "bonus: " + this.bonus + "    type: " + this.type;
        }
    }
}

