/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import pcgen.core.PlayerCharacter;
import pcgen.util.Logging;

public final class LevelInfo {
    private String maxClassSkillString = "0";
    private String maxCrossClassSkillString = "0";
    private String levelString = "0";
    private String minXPString = "0";

    public void setLevelString(String string) {
        this.levelString = string;
    }

    public String getLevelString() {
        return this.levelString;
    }

    public void setMaxClassSkillString(String string) {
        this.maxClassSkillString = string;
    }

    public void setMaxCrossClassSkillString(String string) {
        this.maxCrossClassSkillString = string;
    }

    public void setMinXPString(String string) {
        this.minXPString = string;
    }

    public String toString() {
        return "Level: " + this.levelString + " MinXP: " + this.minXPString + " MaxClassSkill: " + this.maxClassSkillString + " MaxCrossClassSkill: " + this.maxCrossClassSkillString + ".";
    }

    public int getMinXP(int n, PlayerCharacter playerCharacter) {
        int n2;
        if (playerCharacter == null) {
            return 0;
        }
        try {
            n2 = playerCharacter.getVariableValue(this.minXPString.replaceAll(this.levelString, String.valueOf(n)), "").intValue();
        }
        catch (Exception exception) {
            String string = this.minXPString.replaceAll(this.levelString, String.valueOf(n));
            n2 = playerCharacter.getVariableValue(string, "").intValue();
        }
        return n2;
    }

    public BigDecimal getMaxClassSkillRank(int n, PlayerCharacter playerCharacter) {
        return this.getMaxSkillRank(n, playerCharacter, this.maxClassSkillString);
    }

    public BigDecimal getMaxCrossClassSkillRank(int n, PlayerCharacter playerCharacter) {
        return this.getMaxSkillRank(n, playerCharacter, this.maxCrossClassSkillString);
    }

    private BigDecimal getMaxSkillRank(int n, PlayerCharacter playerCharacter, String string) {
        double d;
        if (playerCharacter == null) {
            return BigDecimal.ZERO;
        }
        try {
            d = playerCharacter.getVariableValue(string.replaceAll(this.levelString, String.valueOf(n)), "").doubleValue();
        }
        catch (Exception exception) {
            Logging.errorPrint("Exception while getting max rank for " + this.levelString, exception);
            d = 0.0;
        }
        return new BigDecimal(d);
    }
}

