/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.CDOMSingleRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferenceUtilities {
    private static final Collator COLLATOR = Collator.getInstance();
    public static final Comparator<CDOMReference<?>> REFERENCE_SORTER = new Comparator<CDOMReference<?>>(){

        @Override
        public int compare(CDOMReference<?> cDOMReference, CDOMReference<?> cDOMReference2) {
            return ReferenceUtilities.compareRefs(cDOMReference, cDOMReference2);
        }
    };

    private ReferenceUtilities() {
    }

    public static String joinLstFormat(Collection<? extends CDOMReference<?>> collection, String string) {
        if (collection == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 10);
        boolean bl = false;
        for (CDOMReference<?> cDOMReference : collection) {
            if (bl) {
                stringBuilder.append(string);
            }
            bl = true;
            stringBuilder.append(cDOMReference.getLSTformat());
        }
        return stringBuilder.toString();
    }

    public static String joinDisplayFormat(Collection<? extends CDOMReference<? extends CDOMObject>> collection, String string) {
        if (collection == null) {
            return "";
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (CDOMReference<? extends CDOMObject> cDOMReference : collection) {
            for (CDOMObject cDOMObject : cDOMReference.getContainedObjects()) {
                treeSet.add(cDOMObject.getDisplayName());
            }
        }
        return StringUtil.join(treeSet, string);
    }

    public static int compareRefs(CDOMReference<?> cDOMReference, CDOMReference<?> cDOMReference2) {
        if (cDOMReference instanceof CDOMSingleRef) {
            if (!(cDOMReference2 instanceof CDOMSingleRef)) {
                return -1;
            }
            return COLLATOR.compare(cDOMReference.getName(), cDOMReference2.getName());
        }
        if (cDOMReference2 instanceof CDOMSingleRef) {
            return 1;
        }
        return COLLATOR.compare(cDOMReference.getName(), cDOMReference2.getName());
    }

    public static String joinLstFormat(Collection<? extends CDOMReference<?>> collection, String string, boolean bl) {
        if (collection == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 10);
        boolean bl2 = false;
        for (CDOMReference<?> cDOMReference : collection) {
            if (bl2) {
                stringBuilder.append(string);
            }
            bl2 = true;
            String string2 = cDOMReference.getLSTformat();
            if (bl && "ALL".equals(string2)) {
                string2 = "ANY";
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

