/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.modifier;

import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.content.Modifier;
import pcgen.util.StringPClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextModifier<T, R extends PrereqObject>
implements Modifier<T> {
    private final Modifier<T> modifier;
    private final CDOMReference<R> contextItems;

    public ContextModifier(Modifier<T> modifier, CDOMReference<R> cDOMReference) {
        if (modifier == null) {
            throw new IllegalArgumentException("Modifier in ContextModifier cannot be null");
        }
        if (cDOMReference == null) {
            throw new IllegalArgumentException("Context in ContextModifier cannot be null");
        }
        this.modifier = modifier;
        this.contextItems = cDOMReference;
    }

    @Override
    public T applyModifier(T t, Object object) {
        return object instanceof PrereqObject && this.contextItems.contains((PrereqObject)object) ? this.modifier.applyModifier(t, object) : t;
    }

    @Override
    public String getLSTformat() {
        String string = this.contextItems.getLSTformat();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.modifier.getLSTformat()).append('|');
        stringBuilder.append(StringPClassUtil.getStringFor(this.contextItems.getReferenceClass()));
        stringBuilder.append(string.indexOf(61) == -1 ? (char)'=' : '.');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Override
    public Class<T> getModifiedClass() {
        return this.modifier.getModifiedClass();
    }

    public boolean equals(Object object) {
        if (object instanceof ContextModifier) {
            ContextModifier contextModifier = (ContextModifier)object;
            return this.modifier.equals(contextModifier.modifier) && this.contextItems.equals(contextModifier.contextItems);
        }
        return false;
    }

    public int hashCode() {
        return this.modifier.hashCode() * 31 - this.contextItems.hashCode();
    }
}

