/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReferenceChoiceSet
implements PrimitiveChoiceSet<PCClass> {
    private final Set<CDOMReference<? extends PCClass>> set;

    public ClassReferenceChoiceSet(Collection<? extends CDOMReference<? extends PCClass>> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Choice Collection cannot be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Choice Collection cannot be empty");
        }
        this.set = new HashSet<CDOMReference<? extends PCClass>>(collection);
    }

    @Override
    public String getLSTformat(boolean bl) {
        TreeSet treeSet = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        treeSet.addAll(this.set);
        return ReferenceUtilities.joinLstFormat(treeSet, ",", bl);
    }

    @Override
    public Class<PCClass> getChoiceClass() {
        return PCClass.class;
    }

    @Override
    public Set<PCClass> getSet(PlayerCharacter playerCharacter) {
        HashSet<PCClass> hashSet = new HashSet<PCClass>();
        for (CDOMReference<? extends PCClass> cDOMReference : this.set) {
            hashSet.addAll(cDOMReference.getContainedObjects());
        }
        return hashSet;
    }

    public int hashCode() {
        return this.set.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ClassReferenceChoiceSet) {
            ClassReferenceChoiceSet classReferenceChoiceSet = (ClassReferenceChoiceSet)object;
            return ((Object)this.set).equals(classReferenceChoiceSet.set);
        }
        return false;
    }
}

