/*
 * Decompiled with CFR 0.152.
 */
package plugin.doomsdaybook.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugin.doomsdaybook.util.DataElement;
import plugin.doomsdaybook.util.Operation;
import plugin.doomsdaybook.util.variableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableHashMap
extends HashMap<String, String> {
    private List<Operation> initialize = new ArrayList<Operation>();
    private Map<String, DataElement> dataElements;

    public VariableHashMap() {
        this.dataElements = new HashMap<String, DataElement>();
    }

    public VariableHashMap(HashMap<String, DataElement> hashMap) {
        this.dataElements = hashMap;
    }

    public DataElement getDataElement(String string) throws Exception {
        DataElement dataElement = this.dataElements.get(string);
        if (dataElement == null) {
            throw new Exception("Data Set " + string + " Does Not Exist");
        }
        return dataElement;
    }

    public String getVal(String string) throws variableException {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            throw new variableException("Variable " + string + " does not exist, cannot get value");
        }
        return string2;
    }

    public void setVar(String string, String string2) throws variableException {
        if (this.get(string) == null) {
            throw new variableException("Variable " + string + " does not exist, cannot set value");
        }
        this.put(string, string2);
    }

    public void addDataElement(DataElement dataElement) {
        String string = dataElement.getId();
        dataElement.trimToSize();
        this.dataElements.put(string, dataElement);
    }

    public void addInitialOperations(Operation operation) {
        this.initialize.add(operation);
    }

    public String addVar(String string, int n) throws variableException {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            throw new variableException("Variable " + string + " does not exist, cannot add to value");
        }
        int n2 = "".equals(string2) ? 0 : Integer.parseInt((String)this.get(string));
        return this.put(string, Integer.toString(n2 + n));
    }

    public String divideVar(String string, int n) throws variableException {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            throw new variableException("Variable " + string + " does not exist, cannot divide by value");
        }
        int n2 = "".equals(string2) ? 0 : Integer.parseInt((String)this.get(string));
        return this.put(string, Integer.toString(n2 / n));
    }

    public void doOperation(List<Operation> list) throws variableException {
        for (Operation operation : list) {
            this.doOperation(operation);
        }
    }

    public void doOperation(Operation operation) throws variableException {
        String string = operation.getType();
        String string2 = operation.getKey();
        String string3 = operation.getValue();
        if (string.equals("Set")) {
            string3 = this.parse(string3);
            this.setVar(string2, string3);
        } else if (string.equals("Add")) {
            int n = Integer.parseInt(this.parse(string3));
            this.addVar(string2, n);
        } else if (string.equals("Subtract")) {
            int n = Integer.parseInt(this.parse(string3));
            this.subtractVar(string2, n);
        } else if (string.equals("Multiply")) {
            int n = Integer.parseInt(this.parse(string3));
            this.multiplyVar(string2, n);
        } else if (string.equals("Divide")) {
            int n = Integer.parseInt(this.parse(string3));
            this.divideVar(string2, n);
        }
    }

    public void initialize() throws variableException {
        this.doOperation(this.initialize);
    }

    public String multiplyVar(String string, int n) throws variableException {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            throw new variableException("Variable " + string + " does not exist, cannot multiply by value");
        }
        int n2 = "".equals(string2) ? 0 : Integer.parseInt((String)this.get(string));
        return this.put(string, Integer.toString(n2 * n));
    }

    public String parse(String string) {
        String string2 = string;
        if (string.matches("\\$\\{.*?\\}.*")) {
            String string3 = string.substring(string.indexOf("${") + 2, string.indexOf("}"));
            String string4 = (String)this.get(string3);
            if (string4 == null) {
                string4 = "";
            }
            string2 = string.replaceFirst("\\$\\{.*?\\}", string4);
        }
        return string2;
    }

    public String subtractVar(String string, int n) throws variableException {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            throw new variableException("Variable " + string + " does not exist, cannot subtract from value");
        }
        int n2 = "".equals(string2) ? 0 : Integer.parseInt((String)this.get(string));
        return this.put(string, Integer.toString(n2 - n));
    }
}

