/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.helper.Aspect;
import pcgen.core.Ability;
import pcgen.io.EntityEncoder;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.MapChanges;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectToken
extends AbstractToken
implements CDOMPrimaryToken<Ability> {
    public String getTokenName() {
        return "ASPECT";
    }

    public boolean parse(LoadContext loadContext, Ability ability, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " expecting '|', format is: " + "AspectName|Aspect value|Variable|... was: " + string));
            return false;
        }
        String string2 = string.substring(0, n);
        if (string2.length() == 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " expecting non-empty type, " + "format is: AspectName|Aspect value|Variable|... was: " + string));
            return false;
        }
        String string3 = string.substring(n + 1);
        if (string3.length() == 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " expecting non-empty value, " + "format is: AspectName|Aspect value|Variable|... was: " + string));
            return false;
        }
        if (string3.startsWith("|")) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " expecting non-empty value, " + "format is: AspectName|Aspect value|Variable|... was: " + string));
            return false;
        }
        Aspect aspect = this.parseAspect(string2, string3);
        loadContext.getObjectContext().put((CDOMObject)ability, MapKey.ASPECT, (Object)aspect.getKey(), (Object)aspect);
        return true;
    }

    public Aspect parseAspect(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        Aspect aspect = new Aspect(string, EntityEncoder.decode((String)stringTokenizer.nextToken()));
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            aspect.addVariable(string3);
        }
        return aspect;
    }

    public String[] unparse(LoadContext loadContext, Ability ability) {
        MapChanges mapChanges = loadContext.getObjectContext().getMapChanges((CDOMObject)ability, MapKey.ASPECT);
        if (mapChanges == null || mapChanges.isEmpty()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        Set set = mapChanges.getAdded().keySet();
        for (AspectName aspectName : set) {
            Aspect aspect = (Aspect)mapChanges.getAdded().get(aspectName);
            treeSet.add(aspect.getName() + "|" + aspect.getPCCText());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<Ability> getTokenClass() {
        return Ability.class;
    }
}

