/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.AbstractPrerequisiteWriter;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;

public class PreAbilityWriter
extends AbstractPrerequisiteWriter
implements PrerequisiteWriterInterface {
    public String kindHandled() {
        return "ability";
    }

    public PrerequisiteOperator[] operatorsHandled() {
        return new PrerequisiteOperator[]{PrerequisiteOperator.GTEQ, PrerequisiteOperator.LT};
    }

    public void write(Writer writer, Prerequisite prerequisite) throws PersistenceLayerException {
        this.checkValidOperator(prerequisite, this.operatorsHandled());
        try {
            String string;
            if (prerequisite.getOperator().equals((Object)PrerequisiteOperator.LT)) {
                writer.write(33);
            }
            writer.write("PREABILITY:" + (prerequisite.isOverrideQualify() ? "Q:" : ""));
            writer.write(prerequisite.getOperand());
            writer.write(44);
            if (prerequisite.isOriginalCheckMult()) {
                writer.write("CHECKMULT,");
            }
            if ((string = prerequisite.getCategoryName()) == null) {
                writer.write("CATEGORY=ANY,");
            } else {
                writer.write("CATEGORY=" + string + ",");
            }
            writer.write(prerequisite.getKey());
            if (prerequisite.getSubKey() != null) {
                writer.write(" (");
                writer.write(prerequisite.getSubKey());
                writer.write(")");
            }
        }
        catch (IOException iOException) {
            throw new PersistenceLayerException(iOException.getMessage());
        }
    }

    public boolean specialCase(Writer writer, Prerequisite prerequisite) throws IOException {
        PrerequisiteOperator prerequisiteOperator = this.getConsolidateMethod(this.kindHandled(), prerequisite, false);
        if (prerequisiteOperator == null) {
            return false;
        }
        if (this.hasSubordinateCheckMult(prerequisite)) {
            return false;
        }
        List list = prerequisite.getPrerequisites();
        String string = null;
        boolean bl = false;
        for (Prerequisite prerequisite2 : list) {
            if (bl) {
                String string2 = prerequisite2.getCategoryName();
                if (!(string2 == null ? string != null : !string2.equals(string))) continue;
                return false;
            }
            string = prerequisite2.getCategoryName();
            bl = true;
        }
        if (!prerequisiteOperator.equals((Object)prerequisite.getOperator())) {
            writer.write(33);
        }
        writer.write("PRE" + this.kindHandled().toUpperCase() + ":" + (prerequisite.isOverrideQualify() ? "Q:" : ""));
        writer.write(prerequisiteOperator.equals((Object)PrerequisiteOperator.GTEQ) ? prerequisite.getOperand() : "1");
        if (prerequisite.isOriginalCheckMult()) {
            writer.write(",CHECKMULT");
        }
        if (string == null) {
            writer.write(",CATEGORY=ANY");
        } else {
            writer.write(",CATEGORY=" + string);
        }
        for (Prerequisite prerequisite2 : prerequisite.getPrerequisites()) {
            writer.write(44);
            writer.write(prerequisite2.getKey());
            if (prerequisite2.getSubKey() == null) continue;
            writer.write(" (");
            writer.write(prerequisite2.getSubKey());
            writer.write(")");
        }
        return true;
    }

    private boolean hasSubordinateCheckMult(Prerequisite prerequisite) {
        for (Prerequisite prerequisite2 : prerequisite.getPrerequisites()) {
            if (prerequisite2.isOriginalCheckMult()) {
                return true;
            }
            for (Prerequisite prerequisite3 : prerequisite2.getPrerequisites()) {
                if (!this.hasSubordinateCheckMult(prerequisite3)) continue;
                return true;
            }
        }
        return false;
    }
}

