/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.SVGBrokenLinkProvider;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ImageNode;
import org.apache.batik.gvt.RasterImageNode;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImageElementBridge
extends AbstractGraphicsNodeBridge {
    protected SVGDocument imgDocument;

    public String getLocalName() {
        return "image";
    }

    public Bridge getInstance() {
        return new SVGImageElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        ImageNode imageNode = (ImageNode)super.createGraphicsNode(ctx, e);
        if (imageNode == null) {
            return null;
        }
        String uriStr = XLinkSupport.getXLinkHref(e);
        if (uriStr.length() == 0) {
            throw new BridgeException(e, "attribute.missing", new Object[]{"xlink:href"});
        }
        if (uriStr.indexOf(35) != -1) {
            throw new BridgeException(e, "attribute.malformed", new Object[]{"xlink:href", uriStr});
        }
        GraphicsNode node = null;
        SVGDocument svgDoc = (SVGDocument)e.getOwnerDocument();
        DocumentLoader loader = ctx.getDocumentLoader();
        URIResolver resolver = new URIResolver(svgDoc, loader);
        try {
            Node n = resolver.getNode(uriStr, e);
            if (n.getNodeType() == 9) {
                this.imgDocument = (SVGDocument)n;
                node = SVGImageElementBridge.createSVGImageNode(ctx, e, this.imgDocument);
            }
        }
        catch (BridgeException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw new BridgeException(e, "uri.unsecure", new Object[]{uriStr});
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (node == null) {
            String baseURI = XMLBaseSupport.getCascadedXMLBase(e);
            ParsedURL purl = baseURI == null ? new ParsedURL(uriStr) : new ParsedURL(baseURI, uriStr);
            node = SVGImageElementBridge.createRasterImageNode(ctx, e, purl);
        }
        if (node == null) {
            throw new BridgeException(e, "uri.image.invalid", new Object[]{uriStr});
        }
        imageNode.setImage(node);
        RenderingHints hints = CSSUtilities.convertImageRendering(e, null);
        hints = CSSUtilities.convertColorRendering(e, hints);
        if (hints != null) {
            imageNode.setRenderingHints(hints);
        }
        return imageNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new ImageNode();
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext ctx, Element e, GraphicsNode node) {
        this.e = e;
        this.node = node;
        this.ctx = ctx;
        ImageNode imgNode = (ImageNode)node;
        if (imgNode.getImage() instanceof RasterImageNode) {
            ctx.bind(e, imgNode.getImage());
        } else {
            ctx.bind(e, node);
        }
        ((SVGOMElement)e).setSVGContext(this);
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("x") || attrName.equals("y") || attrName.equals("width") || attrName.equals("height") || attrName.equals("preserveAspectRatio")) {
            Rectangle2D bounds = SVGImageElementBridge.getImageBounds(this.ctx, this.e);
            GraphicsNode imageNode = ((ImageNode)this.node).getImage();
            float[] vb = null;
            if (imageNode instanceof RasterImageNode) {
                Rectangle2D imgBounds = ((RasterImageNode)imageNode).getImageBounds();
                vb = new float[]{0.0f, 0.0f, (float)imgBounds.getWidth(), (float)imgBounds.getHeight()};
            } else if (this.imgDocument != null) {
                SVGSVGElement svgElement = this.imgDocument.getRootElement();
                String viewBox = svgElement.getAttributeNS(null, "viewBox");
                vb = ViewBox.parseViewBoxAttribute(this.e, viewBox);
            }
            if (imageNode != null) {
                SVGImageElementBridge.initializeViewport(this.ctx, this.e, imageNode, vb, bounds);
            }
        } else {
            super.handleDOMAttrModifiedEvent(evt);
        }
    }

    protected void handleCSSPropertyChanged(int property) {
        switch (property) {
            case 6: 
            case 30: {
                RenderingHints hints = CSSUtilities.convertImageRendering(this.e, null);
                hints = CSSUtilities.convertColorRendering(this.e, hints);
                if (hints == null) break;
                this.node.setRenderingHints(hints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(property);
            }
        }
    }

    protected static GraphicsNode createRasterImageNode(BridgeContext ctx, Element e, ParsedURL purl) {
        RasterImageNode node = new RasterImageNode();
        ImageTagRegistry reg = ImageTagRegistry.getRegistry();
        Filter img = reg.readURL(purl, SVGImageElementBridge.extractColorSpace(e, ctx));
        Object obj = img.getProperty("org.apache.batik.bridge.BrokenLinkDocument");
        if (obj != null && obj instanceof SVGDocument) {
            SVGOMDocument doc = (SVGOMDocument)obj;
            ctx.initializeDocument(doc);
            return SVGImageElementBridge.createSVGImageNode(ctx, e, doc);
        }
        node.setImage(img);
        Rectangle2D imgBounds = img.getBounds2D();
        Rectangle2D bounds = SVGImageElementBridge.getImageBounds(ctx, e);
        float[] vb = new float[]{0.0f, 0.0f, (float)imgBounds.getWidth(), (float)imgBounds.getHeight()};
        SVGImageElementBridge.initializeViewport(ctx, e, node, vb, bounds);
        return node;
    }

    protected static GraphicsNode createSVGImageNode(BridgeContext ctx, Element e, SVGDocument imgDocument) {
        CompositeGraphicsNode result = new CompositeGraphicsNode();
        Rectangle2D r = CSSUtilities.convertEnableBackground(e);
        if (r != null) {
            result.setBackgroundEnable(r);
        }
        SVGSVGElement svgElement = imgDocument.getRootElement();
        GraphicsNode node = ctx.getGVTBuilder().build(ctx, svgElement);
        node.setClip(null);
        result.getChildren().add(node);
        String viewBox = svgElement.getAttributeNS(null, "viewBox");
        float[] vb = ViewBox.parseViewBoxAttribute(e, viewBox);
        Rectangle2D bounds = SVGImageElementBridge.getImageBounds(ctx, e);
        SVGImageElementBridge.initializeViewport(ctx, e, result, vb, bounds);
        if (ctx.isDynamic()) {
            ForwardEventListener listener = new ForwardEventListener(svgElement, e);
            SVGSVGElement target = svgElement;
            target.addEventListener("click", listener, false);
            ctx.storeEventListener(target, "click", listener, false);
            target.addEventListener("mouseover", listener, false);
            ctx.storeEventListener(target, "mouseover", listener, false);
            target.addEventListener("mouseout", listener, false);
            ctx.storeEventListener(target, "mouseout", listener, false);
        }
        return result;
    }

    protected static void initializeViewport(BridgeContext ctx, Element e, GraphicsNode node, float[] vb, Rectangle2D bounds) {
        float x = (float)bounds.getX();
        float y = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        AffineTransform at = ViewBox.getPreserveAspectRatioTransform(e, vb, w, h);
        at.preConcatenate(AffineTransform.getTranslateInstance(x, y));
        node.setTransform(at);
        Shape clip = null;
        if (CSSUtilities.convertOverflow(e)) {
            float[] offsets = CSSUtilities.convertClip(e);
            clip = offsets == null ? new Rectangle2D.Float(x, y, w, h) : new Rectangle2D.Float(x + offsets[3], y + offsets[0], w - offsets[1] - offsets[3], h - offsets[2] - offsets[0]);
        }
        if (clip != null) {
            try {
                at = at.createInverse();
                Filter filter = node.getGraphicsNodeRable(true);
                clip = at.createTransformedShape(clip);
                node.setClip(new ClipRable8Bit(filter, clip));
            }
            catch (NoninvertibleTransformException ex) {
                // empty catch block
            }
        }
    }

    protected static ICCColorSpaceExt extractColorSpace(Element element, BridgeContext ctx) {
        SVGColorProfileElementBridge profileBridge;
        String colorProfileProperty = CSSUtilities.getComputedStyle(element, 8).getStringValue();
        ICCColorSpaceExt colorSpace = null;
        if ("srgb".equalsIgnoreCase(colorProfileProperty)) {
            colorSpace = new ICCColorSpaceExt(ICC_Profile.getInstance(1000), 4);
        } else if (!"auto".equalsIgnoreCase(colorProfileProperty) && !"".equalsIgnoreCase(colorProfileProperty) && (profileBridge = (SVGColorProfileElementBridge)ctx.getBridge("http://www.w3.org/2000/svg", "color-profile")) != null) {
            colorSpace = profileBridge.createICCColorSpaceExt(ctx, element, colorProfileProperty);
        }
        return colorSpace;
    }

    protected static Rectangle2D getImageBounds(BridgeContext ctx, Element element) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, element);
        String s = element.getAttributeNS(null, "x");
        float x = 0.0f;
        if (s.length() != 0) {
            x = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x", uctx);
        }
        s = element.getAttributeNS(null, "y");
        float y = 0.0f;
        if (s.length() != 0) {
            y = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y", uctx);
        }
        if ((s = element.getAttributeNS(null, "width")).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"width"});
        }
        float w = UnitProcessor.svgHorizontalLengthToUserSpace(s, "width", uctx);
        s = element.getAttributeNS(null, "height");
        if (s.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"height"});
        }
        float h = UnitProcessor.svgVerticalLengthToUserSpace(s, "height", uctx);
        return new Rectangle2D.Float(x, y, w, h);
    }

    static {
        ImageTagRegistry.setBrokenLinkProvider(new SVGBrokenLinkProvider());
    }

    protected static class ForwardEventListener
    implements EventListener {
        protected Element svgElement;
        protected Element imgElement;

        public ForwardEventListener(Element svgElement, Element imgElement) {
            this.svgElement = svgElement;
            this.imgElement = imgElement;
        }

        public void handleEvent(Event e) {
            MouseEvent evt = (MouseEvent)e;
            MouseEvent newMouseEvent = (MouseEvent)((DocumentEvent)((Object)this.imgElement.getOwnerDocument())).createEvent("MouseEvents");
            newMouseEvent.initMouseEvent(evt.getType(), evt.getBubbles(), evt.getCancelable(), evt.getView(), evt.getDetail(), evt.getScreenX(), evt.getScreenY(), evt.getClientX(), evt.getClientY(), evt.getCtrlKey(), evt.getAltKey(), evt.getShiftKey(), evt.getMetaKey(), evt.getButton(), (EventTarget)((Object)this.imgElement));
            ((EventTarget)((Object)this.imgElement)).dispatchEvent(newMouseEvent);
        }
    }
}

