/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.list.AbilityList;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getParentToken() {
        return "AUTO";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String getTokenName() {
        return "FEAT";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        String string2;
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        AbilityCategory abilityCategory = AbilityCategory.FEAT;
        Ability.Nature nature = Ability.Nature.AUTOMATIC;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string3 = stringTokenizer.nextToken();
        if (string3.startsWith("PRE") || string3.startsWith("!PRE")) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Cannot have only PRExxx subtoken in " + this.getFullName() + ": " + string));
            return false;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CDOMReference cDOMReference = AbilityList.getAbilityListReference((Category)abilityCategory, (Ability.Nature)nature);
        boolean bl = true;
        do {
            Object object;
            if (".CLEAR".equals(string3)) {
                if (!bl) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("  Non-sensical " + this.getFullName() + ": .CLEAR was not the first list item: " + string));
                    return false;
                }
                loadContext.getListContext().removeAllFromList(this.getFullName(), cDOMObject, cDOMReference);
            } else if (string3.startsWith(".CLEAR.")) {
                string2 = string3.substring(7);
                object = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)abilityCategory, (String)string2);
                loadContext.getListContext().removeFromList(this.getFullName(), cDOMObject, cDOMReference, (CDOMReference)object);
            } else {
                string2 = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)abilityCategory, (String)string3);
                if (string2 == null) {
                    return false;
                }
                object = loadContext.getListContext().addToList(this.getFullName(), cDOMObject, cDOMReference, (CDOMReference)string2);
                object.setAssociation(AssociationKey.NATURE, (Object)nature);
                object.setAssociation(AssociationKey.CATEGORY, (Object)abilityCategory);
                if (string3.indexOf(40) != -1) {
                    ArrayList object2 = new ArrayList();
                    AbilityUtilities.getUndecoratedName((String)string3, object2);
                    object.setAssociation(AssociationKey.ASSOC_CHOICES, object2);
                }
                arrayList.add(object);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return true;
            }
            bl = false;
        } while (!(string3 = stringTokenizer.nextToken()).startsWith("PRE") && !string3.startsWith("!PRE"));
        while (true) {
            if ((string2 = this.getPrerequisite(string3)) == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("   (Did you put feats after the PRExxx tags in " + this.getFullName() + ":?)"));
                return false;
            }
            for (AssociatedPrereqObject associatedPrereqObject : arrayList) {
                associatedPrereqObject.addPrerequisite((Prerequisite)string2);
            }
            if (!stringTokenizer.hasMoreTokens()) break;
            string3 = stringTokenizer.nextToken();
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        TreeSet<String> treeSet = new TreeSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMapToList hashMapToList = new HashMapToList();
        AbilityCategory abilityCategory = AbilityCategory.FEAT;
        Ability.Nature nature = Ability.Nature.AUTOMATIC;
        CDOMReference cDOMReference = AbilityList.getAbilityListReference((Category)abilityCategory, (Ability.Nature)nature);
        AssociatedChanges associatedChanges = loadContext.getListContext().getChangesInList(this.getFullName(), cDOMObject, cDOMReference);
        Collection collection = associatedChanges.getRemoved();
        if (associatedChanges.includesGlobalClear()) {
            if (collection != null && !collection.isEmpty()) {
                loadContext.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            arrayList.add(".CLEAR");
        } else if (collection != null && !collection.isEmpty()) {
            arrayList.add(".CLEAR." + ReferenceUtilities.joinLstFormat((Collection)collection, (String)"|.CLEAR.", (boolean)true));
        }
        MapToList mapToList = associatedChanges.getAddedAssociations();
        if (mapToList != null) {
            for (Object object : mapToList.getKeySet()) {
                for (AssociatedPrereqObject associatedPrereqObject : mapToList.getListFor(object)) {
                    hashMapToList.addToListFor((Object)associatedPrereqObject.getPrerequisiteList(), object);
                }
            }
        }
        for (Object object : hashMapToList.getKeySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ReferenceUtilities.joinLstFormat((Collection)hashMapToList.getListFor(object), (String)"|"));
            if (object != null && !object.isEmpty()) {
                stringBuilder.append("|");
                stringBuilder.append(this.getPrerequisiteString(loadContext, (Collection)object));
            }
            treeSet.add(stringBuilder.toString());
        }
        arrayList.addAll(treeSet);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

