/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.ability;

import pcgen.core.kit.KitAbilities;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountToken
extends AbstractToken
implements CDOMSecondaryToken<KitAbilities> {
    public String getTokenName() {
        return "COUNT";
    }

    public Class<KitAbilities> getTokenClass() {
        return KitAbilities.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitAbilities kitAbilities, String string) {
        try {
            Integer n = Integer.valueOf(string);
            if (n <= 0) {
                Logging.errorPrint((String)(this.getTokenName() + " expected an integer > 0"));
                return false;
            }
            kitAbilities.setCount(n);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>"));
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, KitAbilities kitAbilities) {
        Integer n = kitAbilities.getCount();
        if (n == null) {
            return null;
        }
        return new String[]{n.toString()};
    }
}

