/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes.gui;

import gmgen.GMGenSystem;
import gmgen.gui.ExtendedHTMLDocument;
import gmgen.gui.ExtendedHTMLEditorKit;
import gmgen.util.MiscUtilities;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesTreeNode
implements MutableTreeNode,
DocumentListener {
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    protected ExtendedHTMLDocument notesDoc;
    protected File dir;
    protected JTextPane pane;
    protected JTree tree;
    protected MutableTreeNode parent;
    protected transient Object userObject;
    protected Vector<MutableTreeNode> children;
    protected boolean allowsChildren = true;
    protected boolean dirty = false;
    protected boolean hasBeenPopulated = false;
    protected boolean ignoreUpdateSemaphore = false;
    protected int cacheCounter = 0;

    public NotesTreeNode(String string, File file, JTree jTree) {
        this.userObject = string;
        this.tree = jTree;
        this.dir = file;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public TreeNode getChildAt(int n) {
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return this.children.elementAt(n);
    }

    @Override
    public int getChildCount() {
        File[] fileArray;
        int n = 0;
        if (this.children != null) {
            n = this.children.size();
        }
        if (!this.hasBeenPopulated && (fileArray = this.dir.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory() || fileArray[i].getName().equals("CVS")) continue;
                ++n;
            }
        }
        return n;
    }

    public File getDir() {
        return this.dir;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEmpty() {
        File[] fileArray = this.dir.listFiles();
        return fileArray.length <= 0 && !this.dirty;
    }

    public List<File> getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : this.dir.listFiles()) {
            if (file.isDirectory() || file.getName().equals("data.html")) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        if (!this.isNodeChild(treeNode)) {
            return -1;
        }
        return this.children.indexOf(treeNode);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isNodeAncestor(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        TreeNode treeNode2 = this;
        do {
            if (treeNode2 != treeNode) continue;
            return true;
        } while ((treeNode2 = treeNode2.getParent()) != null);
        return false;
    }

    public boolean isNodeChild(TreeNode treeNode) {
        boolean bl = treeNode == null ? false : (this.getChildCount() == 0 ? false : treeNode.getParent() == this);
        return bl;
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public JTextPane getTextPane(JTextPane jTextPane) {
        Object object;
        boolean bl = false;
        this.cacheCounter = 10;
        if (this.notesDoc != null) {
            this.ignoreUpdateSemaphore = true;
        }
        if (this.pane == null) {
            this.pane = jTextPane;
            bl = true;
            object = new ExtendedHTMLEditorKit();
            this.pane.setEditorKit((EditorKit)object);
            this.notesDoc = (ExtendedHTMLDocument)object.createDefaultDocument();
            this.notesDoc.putProperty((Object)"docroot", (Object)(this.dir.getAbsolutePath() + File.separator + "data.html"));
        }
        this.pane.setDocument((Document)this.notesDoc);
        if (bl) {
            object = new File(this.dir.getAbsolutePath() + File.separator + "data.html");
            if (((File)object).exists()) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object));
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = "";
                    while (string != null) {
                        string = bufferedReader.readLine();
                        if (string == null) continue;
                        stringBuffer.append(string + "\n");
                    }
                    bufferedReader.close();
                    this.pane.setText(stringBuffer.toString());
                }
                catch (Exception exception) {
                    Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
                }
            }
            this.notesDoc.addDocumentListener((DocumentListener)this);
        }
        return this.pane;
    }

    public JTextPane getTextPane() {
        Object object;
        boolean bl = false;
        this.cacheCounter = 10;
        if (this.pane == null) {
            this.pane = new JTextPane();
            bl = true;
            object = new ExtendedHTMLEditorKit();
            this.pane.setEditorKit((EditorKit)object);
            this.notesDoc = (ExtendedHTMLDocument)object.createDefaultDocument();
            this.notesDoc.putProperty((Object)"docroot", (Object)(this.dir.getAbsolutePath() + File.separator + "data.html"));
        }
        this.pane.setDocument((Document)this.notesDoc);
        if (bl) {
            object = new File(this.dir.getAbsolutePath() + File.separator + "data.html");
            if (((File)object).exists()) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object));
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = "";
                    while (string != null) {
                        string = bufferedReader.readLine();
                        if (string == null) continue;
                        stringBuffer.append(string + "\n");
                    }
                    bufferedReader.close();
                    this.pane.setText(stringBuffer.toString());
                }
                catch (Exception exception) {
                    Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
                }
            }
            this.pane.setCaretPosition(0);
            this.notesDoc.addDocumentListener((DocumentListener)this);
        }
        return this.pane;
    }

    public boolean isTreeDirty() {
        if (this.dirty) {
            return true;
        }
        if (this.hasBeenPopulated) {
            Enumeration enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                NotesTreeNode notesTreeNode = (NotesTreeNode)enumeration.nextElement();
                if (!notesTreeNode.isTreeDirty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void add(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode != null && mutableTreeNode.getParent() == this) {
            this.insert(mutableTreeNode, this.getChildCount() - 1);
        } else {
            this.insert(mutableTreeNode, this.getChildCount());
        }
    }

    public void appendText(String string) {
        try {
            if (this.notesDoc == null) {
                this.getTextPane();
            }
            this.notesDoc.insertAfterEnd(this.notesDoc.getCharacterElement(this.notesDoc.getLength()), string);
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.ignoreUpdateSemaphore) {
            this.ignoreUpdateSemaphore = false;
        } else {
            this.dirty = true;
            this.tree.updateUI();
        }
    }

    public void checkCache() {
        if (!this.dirty && this.pane != null) {
            if (this.cacheCounter > 0) {
                --this.cacheCounter;
            } else {
                this.revert();
            }
        }
        if (this.hasBeenPopulated) {
            Enumeration enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                NotesTreeNode notesTreeNode = (NotesTreeNode)enumeration.nextElement();
                notesTreeNode.checkCache();
            }
        }
    }

    public static String checkName(String string) {
        String string2 = string.replaceAll("\\:", "-");
        string2 = string2.replaceAll("\\;", "-");
        string2 = string2.replaceAll("\\+", "-");
        string2 = string2.replaceAll("\\=", "-");
        string2 = string2.replaceAll("\\|", "-");
        string2 = string2.replaceAll("\\?", "-");
        string2 = string2.replaceAll("\\*", "-");
        return string2;
    }

    public void checkSave() {
        if (((String)this.userObject).equals("Logs")) {
            int n;
            if (this.isTreeDirty() && (n = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "You have unsaved Logs.  Save?", "Save", 0)) == 0) {
                this.save();
                this.saveChildren();
            }
            this.trimEmpty();
        } else {
            int n;
            if (this.dirty && (n = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "Note '" + this.getUserObject() + "' changed.  Save?", "Save", 0)) == 0) {
                this.save();
            }
            if (this.hasBeenPopulated) {
                Enumeration enumeration = this.children();
                while (enumeration.hasMoreElements()) {
                    NotesTreeNode notesTreeNode = (NotesTreeNode)enumeration.nextElement();
                    notesTreeNode.checkSave();
                }
            }
        }
    }

    public Enumeration children() {
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public NotesTreeNode createChild(String string) {
        boolean bl = true;
        string = NotesTreeNode.checkName(string);
        int n = 1;
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        while (bl) {
            File file;
            if (n > 1) {
                string = string + " (" + n + ")";
            }
            if (!(file = new File(this.dir.getAbsolutePath() + File.separator + string)).exists()) {
                try {
                    file.mkdir();
                    bl = false;
                    NotesTreeNode notesTreeNode = new NotesTreeNode(string, file, this.tree);
                    this.add(notesTreeNode);
                    return notesTreeNode;
                }
                catch (Exception exception) {
                    Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
                    return null;
                }
            }
            ++n;
        }
        return null;
    }

    public NotesTreeNode createChild() {
        return this.createChild("New Note");
    }

    public void delete() {
        int n;
        if (!this.isEmpty() && (n = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "Node " + this.dir.getName() + " Contains Content.  Delete?", "Node Populated", 0, 3)) != 0) {
            return;
        }
        try {
            boolean bl;
            for (File file : this.dir.listFiles()) {
                boolean bl2 = file.delete();
                if (bl2) continue;
                JOptionPane.showMessageDialog(null, "Cannot delete file " + file.getName());
                break;
            }
            if (bl = this.dir.delete()) {
                this.removeFromParent();
            } else {
                JOptionPane.showMessageDialog(null, "Cannot delete directory " + this.dir.getName());
            }
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    public boolean handleDropJavaFileList(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        Transferable transferable = dropTargetDropEvent.getTransferable();
        try {
            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            for (int i = 0; i < list.size(); ++i) {
                File file = (File)list.get(i);
                if (!file.exists()) continue;
                MiscUtilities.copy((File)file, (File)new File(this.dir.getAbsolutePath() + File.separator + file.getName()));
            }
        }
        catch (Exception exception) {
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            return false;
        }
        return true;
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        MutableTreeNode mutableTreeNode2;
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(mutableTreeNode)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        if ((mutableTreeNode2 = (MutableTreeNode)mutableTreeNode.getParent()) != null) {
            mutableTreeNode2.remove(mutableTreeNode);
        }
        mutableTreeNode.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(mutableTreeNode, n);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.dirty = true;
        this.tree.updateUI();
    }

    public void refresh() {
        if (this.hasBeenPopulated) {
            Object object2;
            Enumeration enumeration = this.children();
            List<File> list = Arrays.asList(this.dir.listFiles());
            ArrayList<File> arrayList = new ArrayList<File>();
            while (enumeration.hasMoreElements()) {
                object2 = (NotesTreeNode)enumeration.nextElement();
                File object3 = ((NotesTreeNode)object2).getDir();
                if (object3.exists()) {
                    for (int i = 0; i < list.size(); ++i) {
                        File file = list.get(i);
                        if (!object3.getName().equals(file.getName())) continue;
                        arrayList.add(file);
                    }
                    continue;
                }
                this.remove((MutableTreeNode)object2);
            }
            for (File file : list) {
                if (arrayList.contains(file) || !file.isDirectory() || file.getName().equals("CVS")) continue;
                this.add(new NotesTreeNode(file.getName(), file, this.tree));
            }
            object2 = this.children();
            while (object2.hasMoreElements()) {
                NotesTreeNode notesTreeNode = (NotesTreeNode)object2.nextElement();
                notesTreeNode.refresh();
            }
        }
    }

    public void rehome(String string) {
        this.dir = new File(string + File.separator + this.dir.getName());
        this.rehomeChildren(this.dir.getAbsolutePath());
        this.notesDoc.putProperty((Object)"docroot", (Object)(this.dir.getAbsolutePath() + File.separator + "data.html"));
    }

    public void rehomeChildren(String string) {
        if (this.hasBeenPopulated) {
            Enumeration enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                NotesTreeNode notesTreeNode = (NotesTreeNode)enumeration.nextElement();
                notesTreeNode.rehome(string);
            }
        }
    }

    @Override
    public void remove(int n) {
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getChildAt(n);
        this.children.removeElementAt(n);
        mutableTreeNode.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(mutableTreeNode)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (!this.hasBeenPopulated) {
            this.populate();
        }
        this.remove(this.getIndex(mutableTreeNode));
    }

    public void removeAllChildren() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    @Override
    public void removeFromParent() {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getParent();
        if (mutableTreeNode != null) {
            mutableTreeNode.remove(this);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.dirty = true;
        this.tree.updateUI();
    }

    public void rename(String string) {
        String string2 = this.dir.getParent();
        if (this.dir.exists()) {
            String string3 = this.dir.getAbsolutePath();
            String string4 = this.dir.getName();
            boolean bl = this.dir.renameTo(new File(string2 + File.separator + string));
            if (!bl) {
                this.dir = new File(string3);
                this.setUserObject(string4);
            } else {
                this.dir = new File(string2 + File.separator + string);
                this.rehomeChildren(this.dir.getAbsolutePath());
            }
        } else {
            this.dir = new File(string2 + File.separator + string);
            this.dir.mkdirs();
        }
    }

    public void revert() {
        int n;
        if (this.dirty && (n = JOptionPane.showConfirmDialog((Component)GMGenSystem.inst, "Note '" + this.getUserObject() + "' has been altered, are you sure you wish to revert to the saved copy?", "Revert?", 0)) == 1) {
            return;
        }
        this.dirty = false;
        this.pane = null;
        this.notesDoc.removeDocumentListener((DocumentListener)this);
        this.notesDoc = null;
    }

    public void save() {
        if (this.dirty) {
            try {
                File file = new File(this.dir.getAbsolutePath() + File.separator + "data.html");
                if (!file.exists()) {
                    file.createNewFile();
                }
                if (this.pane != null) {
                    FileWriter fileWriter = new FileWriter(file);
                    HTMLWriter hTMLWriter = new HTMLWriter((Writer)fileWriter, (HTMLDocument)this.notesDoc);
                    hTMLWriter.write();
                    fileWriter.flush();
                    fileWriter.close();
                    this.dirty = false;
                }
            }
            catch (Exception exception) {
                Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void saveChildren() {
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)enumeration.nextElement();
            notesTreeNode.save();
            notesTreeNode.saveChildren();
        }
    }

    public String toString() {
        if (this.dirty) {
            return "* " + this.getUserObject().toString();
        }
        return this.getUserObject().toString();
    }

    private void populate() {
        this.hasBeenPopulated = true;
        for (File file : this.dir.listFiles()) {
            if (!file.isDirectory() || file.getName().equals("CVS")) continue;
            this.add(new NotesTreeNode(file.getName(), file, this.tree));
        }
    }

    private void trimEmpty() {
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            NotesTreeNode notesTreeNode = (NotesTreeNode)enumeration.nextElement();
            notesTreeNode.trimEmpty();
            if (!notesTreeNode.isEmpty()) continue;
            notesTreeNode.delete();
        }
    }
}

