/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;
import plugin.network.NetworkModel;
import plugin.network.gui.NetworkView;

public class NetworkServer
extends Thread {
    private NetworkModel model;
    private static List<String> clients = new ArrayList<String>();
    boolean run = true;
    protected ServerSocket sock;

    public NetworkServer(NetworkModel networkModel) {
        this.model = networkModel;
    }

    public void run() {
        try {
            this.startServer();
        }
        catch (UnknownHostException unknownHostException) {
            this.model.getView().setConnectionText("Server Error", "Cannot determine local address");
        }
        catch (Exception exception) {
            this.model.getView().setConnectionText("Server Error", exception.getMessage());
        }
    }

    public void startServer() throws Exception {
        NetworkView networkView = this.model.getView();
        int n = SettingsHandler.getGMGenOption((String)"Network.port", (int)80);
        networkView.setConnectionText("Server Status", "Starting");
        InetAddress inetAddress = InetAddress.getLocalHost();
        networkView.setLocalAddressText(inetAddress.getHostAddress() + ":" + n);
        this.run = true;
        this.sock = new ServerSocket(n);
        networkView.setConnectionText("Server Status", "Started");
        while (this.run) {
            try {
                Socket socket = this.sock.accept();
                new Handler(socket).start();
            }
            catch (Exception exception) {
                networkView.setConnectionText("Server Status", "Stopped");
            }
        }
        this.sock.close();
    }

    public void setRun(boolean bl) {
        if (this.sock != null) {
            try {
                this.sock.close();
                this.run = bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendRemoveUser(String string) {
        ThreadGroup threadGroup = this.getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray);
        for (Thread thread : threadArray) {
            if (!(thread instanceof Handler)) continue;
            ((Handler)thread).sendRemoveUser(string);
        }
    }

    public void sendAllAddUser(String string) {
        ThreadGroup threadGroup = this.getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray);
        for (Thread thread : threadArray) {
            if (!(thread instanceof Handler)) continue;
            ((Handler)thread).sendAddUser("GM");
            for (String string2 : clients) {
                ((Handler)thread).sendAddUser(string2);
            }
        }
    }

    public void sendIM(String string, String string2, String string3) {
        ThreadGroup threadGroup = this.getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray);
        for (Thread thread : threadArray) {
            if (!(thread instanceof Handler)) continue;
            if (string2.equals("Broadcast")) {
                ((Handler)thread).sendBroadcast(string, string3);
                continue;
            }
            if (!((Handler)thread).getUser().equals(string2)) continue;
            ((Handler)thread).sendIM(string, string3);
        }
    }

    public void sendBroadcast(String string, String string2) {
        ThreadGroup threadGroup = this.getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray);
        for (Thread thread : threadArray) {
            if (!(thread instanceof Handler)) continue;
            ((Handler)thread).sendBroadcast(string, string2);
        }
    }

    private String handleUserMessage(String string) throws Exception {
        for (String string2 : clients) {
            if (!string2.equals(string)) continue;
            throw new Exception("User with the name of " + string + " already connected.  Go to Edit->Preferences in GMGen.  Under the network folder, set the User Name to a different value.");
        }
        clients.add(string);
        this.sendAllAddUser(string);
        this.model.addUser(string);
        this.model.log(string, "Network", "Connected");
        this.model.getView().setConnectionText("Server Status", string + " Connected.  " + clients.size() + " clients connected");
        return string;
    }

    private void handleExitMessage(String string) throws Exception {
        this.model.log(string, "Network", "Disconnected");
        for (String string2 : clients) {
            if (string2.equals(string)) {
                clients.remove(string2);
                break;
            }
            this.model.removeUser(string);
            this.sendRemoveUser(string);
        }
        throw new Exception("");
    }

    private void handleLogMessage(String string, String string2) {
        String string3 = "";
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        this.model.log(string, string3, string4);
    }

    private void handleIMMessage(String string, String string2) {
        String string3 = "";
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        if (string3.equals("GM")) {
            this.model.log(string, string4);
        } else {
            this.model.log(string, "(to " + string3 + ")", string4);
            this.sendIM(string, string3, string4);
        }
    }

    private void handleBroadcastMessage(String string, String string2) {
        this.model.log(string, "BROADCAST", string2);
        this.sendBroadcast(string, string2);
    }

    private void handlePcgMessage(String string, Socket socket) {
        int n = string.indexOf(":");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        this.model.handlePcgMessage(string2, string3, socket);
    }

    public String handleMessage(String string, Socket socket) throws Exception {
        String string2 = "Client";
        if (string.startsWith("User:")) {
            string2 = this.handleUserMessage(string.substring(6));
        } else {
            this.handleMessage(string2, string, socket);
        }
        return string2;
    }

    public String handleMessage(String string, String string2, Socket socket) throws Exception {
        String string3 = "";
        if (string2.startsWith("Exit:")) {
            this.handleExitMessage(string);
        } else if (string2.startsWith("Log:")) {
            this.handleLogMessage(string, string2.substring(5));
        } else if (string2.startsWith("Pcg:")) {
            this.handlePcgMessage(string2.substring(5), socket);
        } else if (string2.startsWith("IM:")) {
            this.handleIMMessage(string, string2.substring(4));
        } else if (string2.startsWith("Broadcast:")) {
            this.handleBroadcastMessage(string, string2.substring(11));
        } else {
            string3 = "Return: " + string2;
        }
        return string3;
    }

    protected class Handler
    extends Thread {
        Socket socket;
        PrintStream os = null;
        boolean isRun = true;
        String user = "Client";

        public Handler(Socket socket) {
            this.socket = socket;
        }

        private synchronized void sendMessage(String string, String string2) {
            this.os.print(string + ": " + string2 + "\r\n");
            this.os.flush();
        }

        public void sendIM(String string, String string2) {
            this.sendMessage("IM", string + "|" + string2);
        }

        public void sendBroadcast(String string, String string2) {
            this.sendMessage("Broadcast", string + "|" + string2);
        }

        public void sendRemoveUser(String string) {
            this.sendMessage("RemoveUser", string);
        }

        public void sendAddUser(String string) {
            this.sendMessage("AddUser", string);
        }

        public void sendExitMessage() {
            this.sendMessage("Exit", "");
        }

        public void run() {
            NetworkView networkView = NetworkServer.this.model.getView();
            try {
                String string;
                networkView.setConnectionText("Server Status", this.user + " Connected.  " + clients.size() + " clients connected");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.os = new PrintStream((OutputStream)new BufferedOutputStream(this.socket.getOutputStream()), true, "UTF-8");
                String string2 = " Disconnected. ";
                while ((string = bufferedReader.readLine()) != null) {
                    block8: {
                        String string3 = "";
                        Logging.debugPrint((String)("Network message from Client: " + string));
                        try {
                            if (this.user.equals("Client")) {
                                this.user = NetworkServer.this.handleMessage(string, this.socket);
                            } else {
                                string3 = NetworkServer.this.handleMessage(this.user, string, this.socket);
                            }
                            if (string3.equals("")) break block8;
                            this.os.print(string3 + "\r\n");
                            this.os.flush();
                        }
                        catch (Exception exception) {
                            if (exception.getMessage().equals("")) break;
                            string2 = " Disconnected, " + exception.getMessage() + ". ";
                            this.os.print("Error: " + exception.getMessage());
                            this.os.flush();
                            break;
                        }
                    }
                    if (this.isRun) continue;
                    break;
                }
                this.os.close();
                bufferedReader.close();
                this.socket.close();
                networkView.setConnectionText("Server Status", this.user + string2 + clients.size() + " clients connected");
            }
            catch (Exception exception) {
                for (String string : clients) {
                    if (!string.equals(this.user)) continue;
                    clients.remove(string);
                    break;
                }
                networkView.setConnectionText("Server Error", "IO Error on socket");
                return;
            }
        }

        public void setRun(boolean bl) {
            this.sendExitMessage();
        }

        public Socket getSocket() {
            return this.socket;
        }

        public PrintStream getOutputStream() {
            return this.os;
        }

        public String getUser() {
            return this.user;
        }

        public void setOutputStream(PrintStream printStream) {
            this.os = printStream;
        }

        public void setUser(String string) {
            this.user = string;
        }
    }
}

