/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import gmgen.plugin.Combatant;
import gmgen.plugin.SystemAttribute;
import gmgen.plugin.SystemHP;
import gmgen.plugin.SystemInitiative;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Element;
import plugin.network.NetworkClient;
import plugin.network.NetworkInitiative;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkCombatant
extends Combatant {
    protected String name = "";
    protected String uid;
    protected String player = "";
    protected String htmlString = "";
    protected float cr = 0.0f;
    protected int xp = 0;
    protected Socket sock;

    public NetworkCombatant(String string, Socket socket) {
        this.uid = string;
        this.sock = socket;
        this.init = new NetworkInitiative(string, socket);
        this.hitPoints = new SystemHP(new SystemAttribute("Constitution", 10), 1, 1);
    }

    public void setCR(float f) {
        this.cr = f;
        this.sendNetMessage("CR|" + f);
    }

    public float getCR() {
        return this.cr;
    }

    public String getUid() {
        return this.uid;
    }

    public String getName() {
        return this.name;
    }

    public void setCombatantType(String string) {
        super.setCombatantType(string);
        this.sendNetMessage("COMTYPE|" + string);
    }

    public void setDuration(int n) {
        super.setDuration(n);
        this.sendNetMessage("DURATION|" + n);
    }

    public void setName(String string) {
        this.name = string;
        this.sendNetMessage("NAME|" + string);
    }

    public void setNumber(int n) {
        super.setNumber(n);
        this.sendNetMessage("NUMBER|" + n);
    }

    public Vector<String> getRowVector(List<String> list) {
        Vector<String> vector = new Vector<String>();
        for (String string : list) {
            if (string.equals("Name")) {
                vector.add(this.getName());
                continue;
            }
            if (string.equals("Player")) {
                vector.add("Net: " + this.getPlayer());
                continue;
            }
            if (string.equals("Status")) {
                vector.add(this.getStatus());
                continue;
            }
            if (string.equals("+")) {
                vector.add("" + this.init.getModifier());
                continue;
            }
            if (string.equals("Init")) {
                vector.add("" + this.init.getCurrentInitiative());
                continue;
            }
            if (string.equals("Dur")) {
                if (this.duration == 0) {
                    vector.add("");
                    continue;
                }
                vector.add("" + this.getDuration());
                continue;
            }
            if (string.equals("#")) {
                vector.add("" + this.number);
                continue;
            }
            if (string.equals("HP")) {
                int n = this.hitPoints.getCurrent();
                int n2 = this.hitPoints.getSubdual();
                if (n2 == 0) {
                    vector.add("" + n);
                    continue;
                }
                if (n2 <= 0) continue;
                vector.add(n + "/" + n2 + "s");
                continue;
            }
            if (string.equals("HP Max")) {
                vector.add("" + this.hitPoints.getMax());
                continue;
            }
            if (!string.equals("Type")) continue;
            vector.add(this.comType);
        }
        return vector;
    }

    public void editRow(List<String> list, int n, Object object) {
        String string = list.get(n);
        String string2 = String.valueOf(object);
        if (string.equals("Name")) {
            this.setName(string2);
        } else if (string.equals("Player")) {
            this.setPlayer(string2);
        } else if (string.equals("Status")) {
            this.setStatus(string2);
        } else if (string.equals("+")) {
            this.init.setBonus(Integer.parseInt(string2));
        } else if (string.equals("Init")) {
            this.init.setCurrentInitiative(Integer.parseInt(string2));
        } else if (string.equals("#")) {
            this.setNumber(Integer.parseInt(string2));
        } else if (string.equals("HP")) {
            this.hitPoints.setCurrent(Integer.parseInt(string2));
            this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
            this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
            this.sendNetMessage("STATUS|" + this.status);
        } else if (string.equals("HP Max")) {
            this.hitPoints.setMax(Integer.parseInt(string2));
            this.sendNetMessage("HPMAX|" + this.hitPoints.getMax());
            this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
            this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
            this.sendNetMessage("STATUS|" + this.status);
        } else if (string.equals("Dur")) {
            this.setDuration(Integer.parseInt(string2));
        } else if (string.equals("Type")) {
            this.setCombatantType(string2);
        }
    }

    public void setStatus(String string) {
        super.setStatus(string);
        this.sendNetMessage("STATUS|" + string);
    }

    public void setXP(int n) {
        this.xp = n;
        this.sendNetMessage("XP|" + n);
    }

    public int getXP() {
        return this.xp;
    }

    public void bleed() {
        super.bleed();
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
        this.sendNetMessage("STATUS|" + this.status);
    }

    public void damage(int n) {
        super.damage(n);
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
        this.sendNetMessage("STATUS|" + this.status);
    }

    public int decDuration() {
        super.decDuration();
        this.sendNetMessage("DURATION|" + this.duration);
        this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
        this.sendNetMessage("STATUS|" + this.status);
        return this.duration;
    }

    public void endRound() {
        super.endRound();
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
        this.sendNetMessage("STATUS|" + this.status);
    }

    public void heal(int n) {
        super.heal(n);
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
        this.sendNetMessage("STATUS|" + this.status);
    }

    public void kill() {
        super.kill();
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
        this.sendNetMessage("STATUS|" + this.status);
    }

    public void nonLethalDamage(boolean bl) {
        super.nonLethalDamage(bl);
        this.sendNetMessage("DURATION|" + this.duration);
        this.sendNetMessage("STATUS|" + this.status);
    }

    public void raise() {
        super.raise();
        this.sendNetMessage("HP|" + this.hitPoints.getCurrent());
        this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
        this.sendNetMessage("STATUS|" + this.status);
    }

    public void stabilize() {
        super.stabilize();
        this.sendNetMessage("STATUS|" + this.status);
    }

    public void subdualDamage(int n) {
        super.subdualDamage(n);
        this.sendNetMessage("HPSUB|" + this.hitPoints.getSubdual());
        this.sendNetMessage("HPSTATE|" + this.hitPoints.getState());
        this.sendNetMessage("STATUS|" + this.status);
    }

    public SystemInitiative getInitiative() {
        return this.init;
    }

    public String getPlayer() {
        return this.player;
    }

    public void setPlayer(String string) {
        this.player = string;
        this.sendNetMessage("PLAYER|" + string);
    }

    public Element getSaveElement() {
        return new Element("NetworkCombatant");
    }

    private void sendNetMessage(String string) {
        try {
            PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(this.sock.getOutputStream()), true, "UTF-8");
            printStream.print("Pcg: " + this.uid + ":" + string + "\r\n");
            printStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void recieveNetMessage(String string) {
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        try {
            if (string2 != "" && string3 != "") {
                if (string2.equals("COMTYPE")) {
                    super.setCombatantType(string3);
                } else if (string2.equals("CR")) {
                    this.cr = Float.parseFloat(string3);
                } else if (string2.equals("DURATION")) {
                    super.setDuration(Integer.parseInt(string3));
                } else if (string2.equals("HP")) {
                    this.hitPoints.setCurrent(Integer.parseInt(string3));
                } else if (string2.equals("HPMAX")) {
                    this.hitPoints.setMax(Integer.parseInt(string3));
                } else if (string2.equals("HPSUB")) {
                    this.hitPoints.setSubdual(Integer.parseInt(string3));
                } else if (string2.equals("HPSTATE")) {
                    this.hitPoints.setState(string3);
                } else if (string2.equals("NAME")) {
                    this.name = string3;
                } else if (string2.equals("NUMBER")) {
                    super.setNumber(Integer.parseInt(string3));
                } else if (string2.equals("PLAYER")) {
                    this.player = string3;
                } else if (string2.equals("STATUS")) {
                    super.setStatus(string3);
                } else if (string2.equals("XP")) {
                    this.xp = Integer.parseInt(string3);
                } else if (string2.startsWith("HTMLSTRING")) {
                    this.htmlString = string3;
                } else if (string2.startsWith("INIT")) {
                    ((NetworkInitiative)this.init).recieveNetMessage(string);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void recieveServerMessage(String string, Combatant combatant) {
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        try {
            if (string2 != "" && string3 != "") {
                if (string2.equals("COMTYPE")) {
                    combatant.setCombatantType(string3);
                } else if (string2.equals("CR")) {
                    combatant.setCR(Float.parseFloat(string3));
                } else if (string2.equals("DURATION")) {
                    combatant.setDuration(Integer.parseInt(string3));
                } else if (string2.equals("HPMAX")) {
                    combatant.getHP().setMax(Integer.parseInt(string3));
                } else if (string2.equals("HP")) {
                    combatant.getHP().setCurrent(Integer.parseInt(string3));
                } else if (string2.equals("HPSUB")) {
                    combatant.getHP().setSubdual(Integer.parseInt(string3));
                } else if (string2.equals("HPSTATE")) {
                    combatant.getHP().setState(string3);
                } else if (string2.equals("NAME")) {
                    combatant.setName(string3);
                } else if (string2.equals("NUMBER")) {
                    combatant.setNumber(Integer.parseInt(string3));
                } else if (string2.equals("STATUS")) {
                    combatant.setStatus(string3);
                } else if (string2.equals("XP")) {
                    combatant.setXP(Integer.parseInt(string3));
                } else if (string2.startsWith("INITBONUS")) {
                    combatant.init.setBonus(Integer.parseInt(string3));
                } else if (string2.startsWith("INIT")) {
                    combatant.init.setCurrentInitiative(Integer.parseInt(string3));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getCombatantUid(Combatant combatant, String string) {
        return combatant.getName() + "-" + combatant.getPlayer() + "-" + string;
    }

    public static void sendCombatant(Combatant combatant, NetworkClient networkClient) {
        String string = NetworkCombatant.getCombatantUid(combatant, networkClient.getUser());
        networkClient.sendPcgMessage(string, "COMTYPE|" + combatant.getCombatantType());
        networkClient.sendPcgMessage(string, "CR|" + combatant.getCR());
        networkClient.sendPcgMessage(string, "DURATION|" + combatant.getDuration());
        networkClient.sendPcgMessage(string, "HPMAX|" + combatant.getHP().getMax());
        networkClient.sendPcgMessage(string, "HP|" + combatant.getHP().getCurrent());
        networkClient.sendPcgMessage(string, "HPSUB|" + combatant.getHP().getSubdual());
        networkClient.sendPcgMessage(string, "HPSTATE|" + combatant.getHP().getState());
        networkClient.sendPcgMessage(string, "NAME|" + combatant.getName());
        networkClient.sendPcgMessage(string, "NUMBER|" + combatant.getNumber());
        networkClient.sendPcgMessage(string, "PLAYER|" + combatant.getPlayer());
        networkClient.sendPcgMessage(string, "STATUS|" + combatant.getStatus());
        networkClient.sendPcgMessage(string, "XP|" + combatant.getXP());
        networkClient.sendPcgMessage(string, "INITBONUS|" + combatant.init.getModifier());
        networkClient.sendPcgMessage(string, "INIT|" + combatant.init.getCurrentInitiative());
        networkClient.sendPcgMessage(string, "HTMLSTRING|" + combatant.toHtmlString());
    }

    public String toHtmlString() {
        return this.htmlString;
    }
}

