/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseResultActor;
import pcgen.cdom.content.ConditionalChoiceActor;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.ArmorProfProvider;
import pcgen.cdom.helper.SimpleArmorProfProvider;
import pcgen.core.ArmorProf;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArmorProfToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
ChooseResultActor {
    private static final Class<ArmorProf> ARMORPROF_CLASS = ArmorProf.class;
    private static final Class<Equipment> EQUIPMENT_CLASS = Equipment.class;

    public String getParentToken() {
        return "AUTO";
    }

    public String getTokenName() {
        return "ARMORPROF";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        String string2;
        int n;
        String string3;
        if (this.isEmpty(string)) {
            return false;
        }
        Prerequisite prerequisite = null;
        if (string.indexOf("[") == -1) {
            string3 = string;
        } else {
            n = string.indexOf("[");
            string3 = string.substring(0, n);
            if (!string.endsWith("]")) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Unresolved Prerequisite in " + this.getFullName() + " " + string + " in " + this.getFullName()));
                return false;
            }
            prerequisite = this.getPrerequisite(string.substring(n + 1, string.length() - 1));
            if (prerequisite == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("Error generating Prerequisite " + prerequisite + " in " + this.getFullName()));
                return false;
            }
        }
        if (this.hasIllegalSeparator('|', string3)) {
            return false;
        }
        n = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<ArmorProfToken> arrayList2 = new ArrayList<ArmorProfToken>();
        while (stringTokenizer.hasMoreTokens()) {
            ArmorProfToken armorProfToken;
            string2 = stringTokenizer.nextToken();
            if ("%LIST".equals(string2)) {
                if (prerequisite == null) {
                    armorProfToken = this;
                } else {
                    ConditionalChoiceActor conditionalChoiceActor = new ConditionalChoiceActor((ChooseResultActor)this);
                    conditionalChoiceActor.addPrerequisite(prerequisite);
                    armorProfToken = conditionalChoiceActor;
                }
                loadContext.obj.addToList(cDOMObject, ListKey.CHOOSE_ACTOR, (Object)armorProfToken);
                continue;
            }
            if ("ALL".equalsIgnoreCase(string2)) {
                n = 1;
                arrayList.add(loadContext.ref.getCDOMAllReference(ARMORPROF_CLASS));
                continue;
            }
            if (string2.startsWith("ARMORTYPE.") || string2.startsWith("ARMORTYPE=")) {
                bl = true;
                armorProfToken = TokenUtilities.getTypeReference((LoadContext)loadContext, EQUIPMENT_CLASS, (String)("ARMOR." + string2.substring(10)));
                if (armorProfToken == null) {
                    return false;
                }
                arrayList2.add(armorProfToken);
                continue;
            }
            bl = true;
            arrayList.add(loadContext.ref.getCDOMReference(ARMORPROF_CLASS, string2));
        }
        if (n != 0 && bl) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + string));
            return false;
        }
        string2 = new ArmorProfProvider(arrayList, arrayList2);
        if (prerequisite != null) {
            string2.addPrerequisite(prerequisite);
        }
        loadContext.obj.addToList(cDOMObject, ListKey.AUTO_ARMORPROF, (Object)string2);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.obj.getListChanges(cDOMObject, ListKey.AUTO_ARMORPROF);
        Collection collection = changes.getAdded();
        TreeSet<String> treeSet = new TreeSet<String>();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        for (ArmorProfProvider armorProfProvider : collection) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(armorProfProvider.getLstFormat());
            if (stringBuilder.length() == 0) {
                stringBuilder.append("%LIST");
            }
            if (armorProfProvider.hasPrerequisites()) {
                stringBuilder.append('[');
                stringBuilder.append(this.getPrerequisiteString(loadContext, armorProfProvider.getPrerequisiteList()));
                stringBuilder.append(']');
            }
            treeSet.add(stringBuilder.toString());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void apply(PlayerCharacter playerCharacter, CDOMObject cDOMObject, String string) {
        ArmorProf armorProf = (ArmorProf)Globals.getContext().ref.silentlyGetConstructedCDOMObject(ARMORPROF_CLASS, string);
        if (armorProf != null) {
            playerCharacter.addAssoc((Object)cDOMObject, AssociationListKey.ARMORPROF, (Object)new SimpleArmorProfProvider(armorProf));
        }
    }

    public void remove(PlayerCharacter playerCharacter, CDOMObject cDOMObject, String string) {
        ArmorProf armorProf = (ArmorProf)Globals.getContext().ref.silentlyGetConstructedCDOMObject(ARMORPROF_CLASS, string);
        if (armorProf != null) {
            playerCharacter.removeAssoc((Object)cDOMObject, AssociationListKey.ARMORPROF, (Object)new SimpleArmorProfProvider(armorProf));
        }
    }

    public String getSource() {
        return this.getTokenName();
    }

    public String getLstFormat() {
        return "%LIST";
    }
}

