/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.gear;

import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.helper.EqModRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.EquipmentModifier;
import pcgen.core.kit.KitGear;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqmodToken
extends AbstractToken
implements CDOMSecondaryToken<KitGear> {
    private static final Class<EquipmentModifier> EQUIPMENT_MODIFIER_CLASS = EquipmentModifier.class;

    public String getTokenName() {
        return "EQMOD";
    }

    public Class<KitGear> getTokenClass() {
        return KitGear.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitGear kitGear, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('.', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("NONE")) {
                Logging.errorPrint((String)("Embedded NONE is prohibited in " + this.getTokenName()));
                return false;
            }
            if (this.hasIllegalSeparator('|', string2)) {
                return false;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "|");
            String string3 = stringTokenizer2.nextToken();
            CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(EQUIPMENT_MODIFIER_CLASS, string3);
            EqModRef eqModRef = new EqModRef(cDOMSingleRef);
            while (stringTokenizer2.hasMoreTokens()) {
                String string4 = stringTokenizer2.nextToken();
                if (string4.indexOf(93) != -1) {
                    if (string4.indexOf("[]") != -1) {
                        Logging.errorPrint((String)("Found empty assocation in " + this.getTokenName() + ": " + string));
                        return false;
                    }
                    StringTokenizer stringTokenizer3 = new StringTokenizer(string4, "]");
                    while (stringTokenizer3.hasMoreTokens()) {
                        String string5 = stringTokenizer3.nextToken();
                        int n = string5.indexOf(91);
                        if (n == -1) {
                            Logging.errorPrint((String)("Found close bracket without open bracket in assocation in " + this.getTokenName() + ": " + string));
                            return false;
                        }
                        if (n == string5.lastIndexOf(91)) continue;
                        Logging.errorPrint((String)("Found open bracket without close bracket in assocation in " + this.getTokenName() + ": " + string));
                        return false;
                    }
                }
                eqModRef.addChoice(string4);
            }
            kitGear.addModRef(eqModRef);
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, KitGear kitGear) {
        if (!kitGear.hasEqMods()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (EqModRef eqModRef : kitGear.getEqMods()) {
            String string = eqModRef.getRef().getLSTformat();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            for (String string2 : eqModRef.getChoices()) {
                stringBuilder.append("|").append(string2);
            }
            treeSet.add(stringBuilder.toString());
        }
        return new String[]{StringUtil.join(treeSet, (String)".")};
    }
}

