/*
 * Decompiled with CFR 0.152.
 */
package plugin.experience;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesPanel;
import gmgen.plugin.Combatant;
import gmgen.plugin.InitHolderList;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.CombatRequestMessage;
import gmgen.pluginmgr.messages.PreferencesPanelAddMessage;
import gmgen.pluginmgr.messages.SaveMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.utils.TabbedPaneUtilities;
import pcgen.util.Logging;
import plugin.experience.ExperienceAdjusterModel;
import plugin.experience.ExperienceListItem;
import plugin.experience.gui.AddDefeatedCombatant;
import plugin.experience.gui.ExperienceAdjusterView;
import plugin.experience.gui.PreferencesExperiencePanel;

public class ExperienceAdjusterPlugin
extends GMBPlugin
implements ActionListener,
ChangeListener,
KeyListener {
    public static final String LOG_NAME = "Experience_Adjuster";
    protected ExperienceAdjusterModel eaModel;
    protected ExperienceAdjusterView eaView;
    protected InitHolderList initList;
    protected JMenuItem experienceToolsItem = new JMenuItem();
    protected String name = "Experience";
    protected String version = "01.00.99.01.00";

    public FileFilter[] getFileTypes() {
        return null;
    }

    public void start() {
        this.eaModel = new ExperienceAdjusterModel(this.getDataDir());
        this.eaView = new ExperienceAdjusterView();
        GMBus.send((GMBMessage)new PreferencesPanelAddMessage((GMBComponent)this, this.name, (PreferencesPanel)new PreferencesExperiencePanel()));
        this.initListeners();
        this.update();
        GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, (Component)this.getView(), this.getPluginSystem()));
        this.initMenus();
    }

    public String getPluginSystem() {
        return SettingsHandler.getGMGenOption((String)"Experience_Adjuster.System", (String)"GMGen");
    }

    public int getPluginLoadOrder() {
        return SettingsHandler.getGMGenOption((String)"Experience_Adjuster.LoadOrder", (int)50);
    }

    public ExperienceAdjusterModel getModel() {
        return this.eaModel;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public JPanel getView() {
        return this.eaView;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.eaView.getAddExperienceToCharButton()) {
            this.handleAddExperienceToCharButton();
        }
        if (actionEvent.getSource() == this.eaView.getAddExperienceToPartyButton()) {
            this.handleAddExperienceToPartyButton();
        }
        if (actionEvent.getSource() == this.eaView.getAddEnemyButton()) {
            this.handleAddEnemyButton();
        }
        if (actionEvent.getSource() == this.eaView.getRemoveEnemyButton()) {
            this.handleRemoveEnemyButton();
        }
        if (actionEvent.getSource() == this.eaView.getAdjustCRButton()) {
            this.handleAdjustCRButton();
        }
    }

    public void adjustCR(Combatant combatant) {
        String string = JOptionPane.showInputDialog((Component)GMGenSystem.inst, "CR", Float.toString(combatant.getCR()));
        if (string != null) {
            try {
                combatant.setCR(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint((String)"Value could not be parsed into a number.");
                this.adjustCR(combatant);
            }
        }
    }

    public void handleAddEnemyButton() {
        AddDefeatedCombatant addDefeatedCombatant = new AddDefeatedCombatant((Frame)GMGenSystem.inst, true, this.eaModel);
        addDefeatedCombatant.setVisible(true);
        this.handleGroupBox();
        this.update();
        this.eaView.getEnemyList().updateUI();
    }

    public void handleAddExperienceToCharButton() {
        if (this.eaView.getCharacterList().getSelectedIndex() != -1) {
            try {
                Object[] objectArray = this.eaView.getCharacterList().getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.eaModel.addExperienceToCharacter((ExperienceListItem)objectArray[i], Integer.parseInt(this.eaView.getExperienceField().getText()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.eaView.setExperienceToAdd("");
            }
        }
        this.eaView.getCharacterList().updateUI();
        this.eaView.getExperienceField().setText("0");
    }

    public void handleAddExperienceToPartyButton() {
        this.eaModel.addExperienceToParty();
        this.eaView.getCharacterList().updateUI();
        this.eaModel.clearEnemies();
        this.handleGroupBox();
    }

    public void handleAdjustCRButton() {
        Combatant combatant;
        ExperienceListItem experienceListItem;
        int n;
        Object[] objectArray;
        if (this.eaView.getCharacterList().getSelectedIndex() != -1) {
            objectArray = this.eaView.getCharacterList().getSelectedValues();
            for (n = 0; n < objectArray.length; ++n) {
                experienceListItem = (ExperienceListItem)objectArray[n];
                combatant = experienceListItem.getCombatant();
                this.adjustCR(combatant);
            }
        }
        if (this.eaView.getEnemyList().getSelectedIndex() != -1) {
            objectArray = this.eaView.getEnemyList().getSelectedValues();
            for (n = 0; n < objectArray.length; ++n) {
                experienceListItem = (ExperienceListItem)objectArray[n];
                combatant = experienceListItem.getCombatant();
                this.adjustCR(combatant);
            }
        }
        this.update();
    }

    public void handleExportButton() {
    }

    public void handleGroupBox() {
        this.eaModel.updatePartyExperience();
        this.eaView.setExperienceFromCombat(this.eaModel.getPartyExperience());
    }

    public void handleMultiplierSlider() {
        int n = this.eaView.getExperienceMultSlider().getValue();
        double d = 1.0 + (double)n * 0.1;
        this.eaModel.setMultiplier(d);
        if (CoreUtility.doublesEqual((double)d, (double)0.5)) {
            this.eaView.getExperienceMultNameLabel().setText("Half as Hard");
        } else if (d <= 0.7) {
            this.eaView.getExperienceMultNameLabel().setText("Much Easier");
        } else if (d > 0.7 && d < 1.5) {
            this.eaView.getExperienceMultNameLabel().setText("Normal");
        } else if (d >= 1.5) {
            this.eaView.getExperienceMultNameLabel().setText("Much Harder");
        }
        if (CoreUtility.doublesEqual((double)d, (double)2.0)) {
            this.eaView.getExperienceMultNameLabel().setText("Twice as Hard");
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(1);
        this.eaView.getExperienceMultLabel().setText(numberFormat.format(d) + "X");
        this.handleGroupBox();
    }

    public void handleRemoveEnemyButton() {
        if (this.eaView.getEnemyList().getSelectedIndex() != -1) {
            Object[] objectArray = this.eaView.getEnemyList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.eaModel.removeEnemy((ExperienceListItem)objectArray[i]);
            }
        }
        this.handleGroupBox();
        this.update();
        this.eaView.getEnemyList().updateUI();
    }

    public final void initListeners() {
        this.eaView.getAddExperienceToCharButton().addActionListener(this);
        this.eaView.getAddExperienceToPartyButton().addActionListener(this);
        this.eaView.getAdjustCRButton().addActionListener(this);
        this.eaView.getAddEnemyButton().addActionListener(this);
        this.eaView.getRemoveEnemyButton().addActionListener(this);
        this.eaView.getExperienceMultSlider().addChangeListener(this);
    }

    public void setModel(ExperienceAdjusterModel experienceAdjusterModel) {
        this.eaModel = experienceAdjusterModel;
    }

    public void setView(ExperienceAdjusterView experienceAdjusterView) {
        this.eaView = experienceAdjusterView;
    }

    public void initMenus() {
        this.experienceToolsItem.setMnemonic('E');
        this.experienceToolsItem.setText("Experience Adjuster");
        this.experienceToolsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExperienceAdjusterPlugin.this.toolMenuItem(actionEvent);
            }
        });
        GMBus.send((GMBMessage)new ToolMenuItemAddMessage((GMBComponent)this, this.experienceToolsItem));
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.update();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.eaView.getExperienceMultSlider()) {
            this.handleMultiplierSlider();
        }
    }

    public void toolMenuItem(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = GMGenSystemView.getTabPane();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            if (!(jTabbedPane.getComponentAt(i) instanceof ExperienceAdjusterView)) continue;
            jTabbedPane.setSelectedIndex(i);
        }
    }

    public final void update() {
        this.eaModel.populateLists();
        this.eaView.setParty(this.eaModel.getParty());
        this.eaView.setEnemies(this.eaModel.getEnemies());
        this.handleGroupBox();
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (gMBMessage instanceof CombatRequestMessage) {
            if (gMBMessage.getSource() == this) {
                CombatRequestMessage combatRequestMessage = (CombatRequestMessage)gMBMessage;
                if (this.initList == null) {
                    this.initList = combatRequestMessage.getCombat();
                }
                this.eaModel.setCombat(this.initList);
            }
            this.update();
        } else if (gMBMessage instanceof StateChangedMessage) {
            if (this.isActive()) {
                this.experienceToolsItem.setEnabled(false);
                if (this.initList == null) {
                    GMBus.send((GMBMessage)new CombatRequestMessage((GMBComponent)this));
                }
                this.update();
            } else {
                this.experienceToolsItem.setEnabled(true);
            }
        } else if (gMBMessage instanceof SaveMessage && this.isActive()) {
            this.handleExportButton();
        }
    }

    public boolean isActive() {
        JTabbedPane jTabbedPane = TabbedPaneUtilities.getTabbedPaneFor((Component)this.eaView);
        return jTabbedPane != null && JOptionPane.getFrameForComponent(jTabbedPane).isFocused() && jTabbedPane.getSelectedComponent().equals(this.eaView);
    }
}

