/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.math.BigDecimal;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WtToken
extends AbstractToken
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "WT";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " was expecting a decimal value >= 0 : " + string));
                return false;
            }
            loadContext.getObjectContext().put((CDOMObject)equipment, ObjectKey.WEIGHT, (Object)bigDecimal);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Expected a Double for " + this.getTokenName() + ": " + string));
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        BigDecimal bigDecimal = (BigDecimal)loadContext.getObjectContext().getObject((CDOMObject)equipment, ObjectKey.WEIGHT);
        if (bigDecimal == null) {
            return null;
        }
        return new String[]{bigDecimal.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

