/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddLevelToken
extends AbstractToken
implements CDOMPrimaryToken<PCTemplate> {
    public String getTokenName() {
        return "ADDLEVEL";
    }

    public boolean parse(LoadContext loadContext, PCTemplate pCTemplate, String string) {
        Formula formula;
        if (this.isEmpty(string)) {
            return false;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            Logging.errorPrint((String)("No | found in " + this.getTokenName()));
            Logging.errorPrint((String)("  " + this.getTokenName() + " requires at format: Class|LevelCount"));
            return false;
        }
        if (n != string.lastIndexOf("|")) {
            Logging.errorPrint((String)("Two | found in " + this.getTokenName()));
            Logging.errorPrint((String)("  " + this.getTokenName() + " requires at format: Class|LevelCount"));
            return false;
        }
        String string2 = string.substring(0, n);
        if (string2.length() == 0) {
            Logging.errorPrint((String)("Empty Class found in " + this.getTokenName()));
            Logging.errorPrint((String)("  " + this.getTokenName() + " requires at format: Class|LevelCount"));
            return false;
        }
        CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(PCClass.class, string2);
        String string3 = string.substring(n + 1);
        if (string3.length() == 0) {
            Logging.errorPrint((String)("Empty Level Count found in " + this.getTokenName()));
            Logging.errorPrint((String)("  " + this.getTokenName() + " requires at format: Class|LevelCount"));
            return false;
        }
        try {
            int n2 = Integer.parseInt(string3);
            if (n2 <= 0) {
                Logging.errorPrint((String)("Number of Levels granted in " + this.getTokenName() + " must be greater than zero"));
                return false;
            }
            formula = FormulaFactory.getFormulaFor((Integer)n2);
        }
        catch (NumberFormatException numberFormatException) {
            formula = FormulaFactory.getFormulaFor((String)string3);
        }
        LevelCommandFactory levelCommandFactory = new LevelCommandFactory(cDOMSingleRef, formula);
        loadContext.getObjectContext().addToList((CDOMObject)pCTemplate, ListKey.ADD_LEVEL, (Object)levelCommandFactory);
        return true;
    }

    public String[] unparse(LoadContext loadContext, PCTemplate pCTemplate) {
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)pCTemplate, ListKey.ADD_LEVEL);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (LevelCommandFactory levelCommandFactory : collection) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(levelCommandFactory.getLSTformat()).append("|").append(levelCommandFactory.getLevelCount().toString());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

