/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.Qualifier;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CDOMTransparentCategorizedSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Campaign;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;
import pcgen.util.StringPClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardRefToken
extends AbstractToken
implements CDOMPrimaryToken<Campaign> {
    public String getTokenName() {
        return "FORWARDREF";
    }

    public boolean parse(LoadContext loadContext, Campaign campaign, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        int n = string.indexOf(124);
        if (n == -1) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " requires at least two arguments, " + "ReferenceType and Key: " + string));
            return false;
        }
        if (string.lastIndexOf(124) != n) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " requires at only two pipe separated arguments, " + "ReferenceType and Keys: " + string));
            Logging.log((Level)Logging.LST_ERROR, (String)"  keys are comma separated");
            return false;
        }
        String string2 = string.substring(0, n);
        ReferenceManufacturer referenceManufacturer = loadContext.getManufacturer(string2);
        if (referenceManufacturer == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " unable to generate manufacturer for type: " + string));
            return false;
        }
        String string3 = string.substring(n + 1);
        if (this.hasIllegalSeparator(',', string3)) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " keys are comma separated"));
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            CDOMSingleRef cDOMSingleRef = referenceManufacturer.getReference(stringTokenizer.nextToken());
            loadContext.obj.addToList((CDOMObject)campaign, ListKey.FORWARDREF, (Object)new Qualifier(referenceManufacturer.getReferenceClass(), cDOMSingleRef));
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Campaign campaign) {
        Object object;
        Object object22;
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)campaign, ListKey.FORWARDREF);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection collection = changes.getAdded();
        HashMapToList hashMapToList = new HashMapToList();
        for (Object object22 : collection) {
            Class clazz = object22.getQualifiedClass();
            String string = StringPClassUtil.getStringFor((Class)clazz);
            object = object22.getQualifiedReference();
            String string2 = string;
            if (object instanceof CDOMTransparentCategorizedSingleRef) {
                String string3 = ((CDOMTransparentCategorizedSingleRef)object).getCDOMCategory();
                string2 = "FEAT".equals(string3) ? "FEAT" : string2 + '=' + string3;
            }
            hashMapToList.addToListFor((Object)string2, object);
        }
        TreeSet treeSet = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        object22 = new TreeSet();
        for (String string : hashMapToList.getKeySet()) {
            treeSet.clear();
            treeSet.addAll(hashMapToList.getListFor((Object)string));
            object = new StringBuilder();
            ((StringBuilder)object).append(string).append("|").append(ReferenceUtilities.joinLstFormat((Collection)treeSet, (String)","));
            object22.add(((StringBuilder)object).toString());
        }
        return object22.toArray(new String[object22.size()]);
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

