/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.ArmorProf;
import pcgen.core.Equipment;
import pcgen.core.ShieldProf;
import pcgen.core.WeaponProf;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProficiencyToken
extends AbstractToken
implements CDOMPrimaryToken<Equipment>,
DeferredToken<Equipment> {
    public String getTokenName() {
        return "PROFICIENCY";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Equipment Token PROFICIENCY syntax without a Subtoken is invalid: " + string));
            return false;
        }
        if (n != string.lastIndexOf("|")) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " expecting only one '|', " + "format is: SubToken|ProfName value was: " + string));
            return false;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (string3 == null || string3.length() == 0) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("PROFICIENCY cannot have empty second argument: " + string));
            return false;
        }
        if (string2.equals("WEAPON")) {
            CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(WeaponProf.class, string3);
            loadContext.getObjectContext().put((CDOMObject)equipment, ObjectKey.WEAPON_PROF, (Object)cDOMSingleRef);
        } else if (string2.equals("ARMOR")) {
            CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(ArmorProf.class, string3);
            loadContext.getObjectContext().put((CDOMObject)equipment, ObjectKey.ARMOR_PROF, (Object)cDOMSingleRef);
        } else if (string2.equals("SHIELD")) {
            CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(ShieldProf.class, string3);
            loadContext.getObjectContext().put((CDOMObject)equipment, ObjectKey.SHIELD_PROF, (Object)cDOMSingleRef);
        } else {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Unknown Subtoken for PROFICIENCY: " + string2));
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)"  Subtoken must be WEAPON, ARMOR or SHIELD");
            return false;
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        CDOMSingleRef cDOMSingleRef = (CDOMSingleRef)loadContext.getObjectContext().getObject((CDOMObject)equipment, ObjectKey.WEAPON_PROF);
        CDOMSingleRef cDOMSingleRef2 = (CDOMSingleRef)loadContext.getObjectContext().getObject((CDOMObject)equipment, ObjectKey.SHIELD_PROF);
        CDOMSingleRef cDOMSingleRef3 = (CDOMSingleRef)loadContext.getObjectContext().getObject((CDOMObject)equipment, ObjectKey.ARMOR_PROF);
        if (cDOMSingleRef == null) {
            if (cDOMSingleRef2 == null) {
                if (cDOMSingleRef3 == null) {
                    return null;
                }
                return new String[]{"ARMOR|" + cDOMSingleRef3.getLSTformat()};
            }
            if (cDOMSingleRef3 == null) {
                return new String[]{"SHIELD|" + cDOMSingleRef2.getLSTformat()};
            }
            loadContext.addWriteMessage("Equipment may not have both ARMOR and SHIELD Proficiencies");
            return null;
        }
        if (cDOMSingleRef2 == null) {
            if (cDOMSingleRef3 == null) {
                return new String[]{"WEAPON|" + cDOMSingleRef.getLSTformat()};
            }
            loadContext.addWriteMessage("Equipment may not have both ARMOR and WEAPON Proficiencies");
            return null;
        }
        loadContext.addWriteMessage("Equipment may not have both WEAPON and SHIELD Proficiencies");
        return null;
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }

    public Class<Equipment> getDeferredTokenClass() {
        return Equipment.class;
    }

    public boolean process(LoadContext loadContext, Equipment equipment) {
        CDOMSingleRef cDOMSingleRef = (CDOMSingleRef)equipment.get(ObjectKey.WEAPON_PROF);
        if (equipment.get(ObjectKey.SHIELD_PROF) != null) {
            if (equipment.get(ObjectKey.ARMOR_PROF) != null) {
                Logging.errorPrint((String)("Equipment " + equipment.getKeyName() + " may not have both " + "ARMOR and SHIELD Proficiencies"));
                return false;
            }
            if (cDOMSingleRef != null) {
                Logging.errorPrint((String)("Equipment " + equipment.getKeyName() + " may not have both " + "WEAPON and SHIELD Proficiencies"));
                return false;
            }
        }
        if (cDOMSingleRef != null && equipment.get(ObjectKey.ARMOR_PROF) != null) {
            Logging.errorPrint((String)("Equipment " + equipment.getKeyName() + " may not have both " + "ARMOR and WEAPON Proficiencies"));
            return false;
        }
        return true;
    }
}

