/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.logging;

import com.vladium.logging.ILogLevels;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public abstract class LoggerInit
implements ILogLevels {
    static int s_level = 2;
    static PrintWriter s_out = new PrintWriter(System.out, false);
    static String s_prefix = null;
    static Set s_classMask;

    public static int stringToLevel(String level) {
        if ("SEVERE".equalsIgnoreCase(level)) {
            return 0;
        }
        if ("WARNING".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("INFO".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("VERBOSE".equalsIgnoreCase(level)) {
            return 3;
        }
        if ("TRACE1".equalsIgnoreCase(level)) {
            return 4;
        }
        if ("TRACE2".equalsIgnoreCase(level)) {
            return 5;
        }
        if ("TRACE3".equalsIgnoreCase(level)) {
            return 6;
        }
        if ("ALL".equalsIgnoreCase(level)) {
            return 7;
        }
        int _level = Integer.MIN_VALUE;
        try {
            _level = Integer.parseInt(level);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_level >= -1 && _level <= 7) {
            return _level;
        }
        return -1;
    }

    public static synchronized void setLevel(int level) {
        if (level < -1 || level > 7) {
            throw new IllegalArgumentException("invalid log level: " + level);
        }
        s_level = level;
    }

    public static synchronized void setOut(PrintWriter out) {
        if (out == null || out.checkError()) {
            throw new IllegalArgumentException("null or corrupt input: out");
        }
        s_out = out;
    }

    public static synchronized void setPrefix(String prefix) {
        s_prefix = prefix;
    }

    public static synchronized void setClassMask(String[] names) {
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException("null or empty input: names");
        }
        for (int n = 0; n < names.length; ++n) {
            if (names[n] != null && names[n].length() != 0) continue;
            throw new IllegalArgumentException("null or empty input: names[" + n + "]");
        }
        HashSet<String> classMask = new HashSet<String>();
        for (int n = 0; n < names.length; ++n) {
            classMask.add(names[n]);
        }
        s_classMask = classMask;
    }
}

