/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.SessionData;
import com.vladium.logging.Logger;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.asserts.$assert;
import com.vladium.util.exception.Exceptions;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public final class MergeProcessor
implements IAppErrorCodes {
    private File[] m_dataPath = IConstants.EMPTY_FILE_ARRAY;
    private File m_sdataOutFile;
    private Properties m_propertyOverrides;
    private int m_dataFileCount;
    private boolean m_info;
    private boolean m_verbose;
    private boolean m_trace1;
    private boolean m_trace2;
    private static final Class[] EXPECTED_FAILURES = new Class[]{class$com$vladium$emma$EMMARuntimeException == null ? (class$com$vladium$emma$EMMARuntimeException = MergeProcessor.class$("com.vladium.emma.EMMARuntimeException")) : class$com$vladium$emma$EMMARuntimeException, class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = MergeProcessor.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = MergeProcessor.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException};
    static /* synthetic */ Class class$com$vladium$emma$EMMARuntimeException;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;
    static /* synthetic */ Class class$java$lang$IllegalStateException;

    public static MergeProcessor create() {
        return new MergeProcessor();
    }

    public final synchronized void setDataPath(String[] path) {
        this.m_dataPath = path == null || path.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(path, true);
    }

    public final synchronized void setSessionOutFile(String fileName) {
        if (fileName == null) {
            this.m_sdataOutFile = null;
        } else {
            File _file = new File(fileName);
            if (_file.exists() && !_file.isFile()) {
                throw new IllegalArgumentException("not a file: [" + _file.getAbsolutePath() + "]");
            }
            this.m_sdataOutFile = _file;
        }
    }

    public synchronized void setPropertyOverrides(Properties overrides) {
        this.m_propertyOverrides = overrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_info = Logger.isLoggable(2);
        this.m_verbose = Logger.atVERBOSE();
        this.m_trace1 = Logger.atTRACE1();
        this.m_trace2 = Logger.atTRACE2();
        if (this.m_verbose) {
            Logger.verbose("[EMMA v2.0, build 4127 (2004/06/27 18:28:25)]");
        }
        this.validateState();
        IProperties appProperties = EMMAProperties.getAppProperties();
        IProperties toolProperties = IProperties.Factory.combine(EMMAProperties.wrap(this.m_propertyOverrides), appProperties);
        File sdataOutFile = this.m_sdataOutFile;
        if (sdataOutFile == null) {
            sdataOutFile = new File(toolProperties.getProperty("session.out.file", "coverage.es"));
        }
        RuntimeException failure = null;
        try {
            IMergeable mdata = null;
            IMergeable cdata = null;
            try {
                Logger.info("processing input files ...");
                long start = this.m_info ? System.currentTimeMillis() : 0L;
                for (int f = 0; f < this.m_dataPath.length; ++f) {
                    ICoverageData _cdata;
                    IMergeable[] fileData = DataFactory.load(this.m_dataPath[f]);
                    IMetaData _mdata = (IMetaData)fileData[0];
                    if (_mdata != null) {
                        mdata = mdata == null ? _mdata : (IMetaData)mdata.merge(_mdata);
                    }
                    if ((_cdata = (ICoverageData)fileData[1]) != null) {
                        cdata = cdata == null ? _cdata : (ICoverageData)cdata.merge(_cdata);
                    }
                    ++this.m_dataFileCount;
                }
                if (this.m_info) {
                    long end = System.currentTimeMillis();
                    Logger.info(this.m_dataFileCount + " file(s) read and merged in " + (end - start) + " ms");
                }
                if ((mdata == null || mdata.isEmpty()) && (cdata == null || cdata.isEmpty())) {
                    Logger.warning("nothing to do: no metadata or coverage data found in any of the input files");
                    return;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.out);
            }
            $assert.ASSERT(sdataOutFile != null, "sdataOutFile not null");
            boolean rename = false;
            File tempDataOutFile = null;
            File canonicalDataOutFile = Files.canonicalizeFile(sdataOutFile);
            for (int f = 0; f < this.m_dataPath.length; ++f) {
                File canonicalDataFile = Files.canonicalizeFile(this.m_dataPath[f]);
                if (!canonicalDataOutFile.equals(canonicalDataFile)) continue;
                rename = true;
                break;
            }
            if (rename) {
                File tempFileDir = canonicalDataOutFile.getParentFile();
                if (tempFileDir == null) {
                    tempFileDir = new File("");
                }
                String tempFileName = Files.getFileName(canonicalDataOutFile) + "emma";
                String tempFileExt = ".et";
                try {
                    tempDataOutFile = Files.createTempFile(tempFileDir, tempFileName, ".et");
                }
                catch (IOException ioe) {
                    throw new EMMARuntimeException(ioe);
                }
                Logger.warning("the specified output file is one of the input files [" + canonicalDataOutFile + "]");
                Logger.warning("all merged data will be written to a temp file first [" + tempDataOutFile.getAbsolutePath() + "]");
            }
            long start = this.m_info ? System.currentTimeMillis() : 0L;
            File persistFile = null;
            try {
                File file = persistFile = tempDataOutFile != null ? tempDataOutFile : canonicalDataOutFile;
                if (mdata == null || mdata.isEmpty()) {
                    DataFactory.persist((ICoverageData)cdata, persistFile, false);
                } else if (cdata == null || cdata.isEmpty()) {
                    DataFactory.persist((IMetaData)mdata, persistFile, false);
                } else {
                    DataFactory.persist(new SessionData((IMetaData)mdata, (ICoverageData)cdata), persistFile, false);
                }
            }
            catch (IOException ioe) {
                if (persistFile != null) {
                    persistFile.delete();
                }
                throw new EMMARuntimeException(ioe);
            }
            catch (Error e) {
                if (persistFile != null) {
                    persistFile.delete();
                }
                throw e;
            }
            if (rename && !Files.renameFile(tempDataOutFile, canonicalDataOutFile, true)) {
                throw new EMMARuntimeException("could not rename temporary file [" + tempDataOutFile.getAbsolutePath() + "] to [" + canonicalDataOutFile + "]: make sure the original file is not locked and can be deleted");
            }
            if (this.m_info) {
                long end = System.currentTimeMillis();
                Logger.info("merged/compacted data written to [" + canonicalDataOutFile + "] {in " + (end - start) + " ms}");
            }
        }
        catch (SecurityException se) {
            failure = new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, se);
        }
        catch (RuntimeException re) {
            failure = re;
        }
        finally {
            this.reset();
        }
        if (failure != null) {
            if (Exceptions.unexpectedFailure(failure, EXPECTED_FAILURES)) {
                throw new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{failure.toString(), "http://sourceforge.net/projects/emma"}, failure);
            }
            throw failure;
        }
    }

    private MergeProcessor() {
    }

    private void validateState() {
        if (this.m_dataPath == null) {
            throw new IllegalStateException("data path not set");
        }
    }

    private void reset() {
        this.m_dataFileCount = 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

