/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.companionmod;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.character.CompanionMod;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HdToken
extends AbstractToken
implements CDOMPrimaryToken<CompanionMod> {
    public String getTokenName() {
        return "HD";
    }

    public boolean parse(LoadContext loadContext, CompanionMod companionMod, String string) {
        try {
            Integer n = Integer.valueOf(string);
            if (n <= 0) {
                Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " must be an integer > 0"));
                return false;
            }
            loadContext.getObjectContext().put((CDOMObject)companionMod, IntegerKey.HIT_DIE, n);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>"));
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, CompanionMod companionMod) {
        Integer n = loadContext.getObjectContext().getInteger((CDOMObject)companionMod, IntegerKey.HIT_DIE);
        if (n == null) {
            return null;
        }
        if (n <= 0) {
            loadContext.addWriteMessage(this.getTokenName() + " must be an integer > 0");
            return null;
        }
        return new String[]{n.toString()};
    }

    public Class<CompanionMod> getTokenClass() {
        return CompanionMod.class;
    }
}

