/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.skill;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillArmorCheck;
import pcgen.core.Skill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcheckToken
extends AbstractToken
implements CDOMPrimaryToken<Skill> {
    public String getTokenName() {
        return "ACHECK";
    }

    public boolean parse(LoadContext loadContext, Skill skill, String string) {
        SkillArmorCheck skillArmorCheck;
        if (this.isEmpty(string)) {
            return false;
        }
        try {
            skillArmorCheck = SkillArmorCheck.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            char c = string.charAt(0);
            if (c == 'N') {
                skillArmorCheck = SkillArmorCheck.NONE;
            }
            if (c == 'Y') {
                skillArmorCheck = SkillArmorCheck.YES;
            }
            if (c == 'P') {
                skillArmorCheck = SkillArmorCheck.NONPROF;
            }
            if (c == 'D') {
                skillArmorCheck = SkillArmorCheck.DOUBLE;
            }
            if (c == 'W') {
                skillArmorCheck = SkillArmorCheck.WEIGHT;
            }
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Skill " + this.getTokenName() + " Did not understand: " + string));
            return false;
        }
        loadContext.getObjectContext().put((CDOMObject)skill, ObjectKey.ARMOR_CHECK, (Object)skillArmorCheck);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Skill skill) {
        SkillArmorCheck skillArmorCheck = (SkillArmorCheck)loadContext.getObjectContext().getObject((CDOMObject)skill, ObjectKey.ARMOR_CHECK);
        if (skillArmorCheck == null) {
            return null;
        }
        return new String[]{skillArmorCheck.toString()};
    }

    public Class<Skill> getTokenClass() {
        return Skill.class;
    }
}

