/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util.enumeration;

import java.util.Collection;
import java.util.Collections;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.spell.Spell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProhibitedSpellType {
    ALIGNMENT("Alignment"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return spell.getSafeListFor(ListKey.SPELL_DESCRIPTOR);
        }

        @Override
        public int getRequiredCount(Collection<String> collection) {
            return collection.size();
        }
    }
    ,
    DESCRIPTOR("Descriptor"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return spell.getSafeListFor(ListKey.SPELL_DESCRIPTOR);
        }

        @Override
        public int getRequiredCount(Collection<String> collection) {
            return collection.size();
        }
    }
    ,
    SCHOOL("School"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return spell.getSafeListFor(ListKey.SPELL_SCHOOL);
        }

        @Override
        public int getRequiredCount(Collection<String> collection) {
            return collection.size();
        }
    }
    ,
    SUBSCHOOL("SubSchool"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return spell.getSafeListFor(ListKey.SPELL_SUBSCHOOL);
        }

        @Override
        public int getRequiredCount(Collection<String> collection) {
            return collection.size();
        }
    }
    ,
    SPELL("Spell"){

        @Override
        public Collection<String> getCheckList(Spell spell) {
            return Collections.singletonList(spell.getKeyName());
        }

        @Override
        public int getRequiredCount(Collection<String> collection) {
            return 1;
        }
    };

    private final String text;

    private ProhibitedSpellType(String string2) {
        this.text = string2;
    }

    public abstract Collection<String> getCheckList(Spell var1);

    public abstract int getRequiredCount(Collection<String> var1);

    public String toString() {
        return this.text;
    }
}

