/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util.enumeration;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class AbstractConstant
implements Serializable {
    private transient String _fieldName;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                int n = fieldArray[i].getModifiers();
                if (!Modifier.isStatic(n) || !Modifier.isFinal(n) || !Modifier.isPublic(n) || this != fieldArray[i].get(null)) continue;
                objectOutputStream.writeObject(fieldArray[i].getName());
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException.getLocalizedMessage());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this._fieldName = (String)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getLocalizedMessage());
        }
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            return this.getClass().getField(this._fieldName).get(null);
        }
        catch (SecurityException securityException) {
            throw new InvalidObjectException("Failed to resolve object: " + securityException.getLocalizedMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new InvalidObjectException("Failed to resolve object: " + noSuchFieldException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidObjectException("Failed to resolve object: " + illegalAccessException.getLocalizedMessage());
        }
    }
}

