/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import pcgen.core.SettingsHandler;
import pcgen.util.PCGenLogLevel;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logging {
    private static boolean debugMode = false;
    private static final Toolkit s_TOOLKIT = Toolkit.getDefaultToolkit();
    public static final Level ERROR = Level.SEVERE;
    public static final Level LST_ERROR = PCGenLogLevel.LST_ERROR;
    public static final Level WARNING = Level.WARNING;
    public static final Level LST_WARNING = PCGenLogLevel.LST_WARNING;
    public static final Level INFO = Level.INFO;
    public static final Level LST_INFO = PCGenLogLevel.LST_INFO;
    public static final Level DEBUG = Level.FINER;
    private static LinkedList<QueuedMessage> queuedMessages;
    private static int queuedMessageMark;

    public static void setDebugMode(boolean bl) {
        debugMode = bl;
        if (debugMode) {
            Logger.getLogger("pcgen").setLevel(DEBUG);
            Logger.getLogger("plugin").setLevel(DEBUG);
        } else {
            Logger.getLogger("pcgen").setLevel(LST_WARNING);
            Logger.getLogger("plugin").setLevel(LST_WARNING);
        }
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void debugPrint(String string) {
        Logger logger = Logging.getLogger();
        if (logger.isLoggable(DEBUG)) {
            logger.log(DEBUG, string);
        }
    }

    public static void debugPrint(String string, Object object) {
        Logger logger = Logging.getLogger();
        if (logger.isLoggable(DEBUG)) {
            logger.log(DEBUG, string + object);
        }
    }

    public static void debugPrintLocalised(String string, Object object) {
        Logger logger = Logging.getLogger();
        if (logger.isLoggable(DEBUG)) {
            String string2 = PropertyFactory.getFormattedString(string, object);
            logger.log(DEBUG, string2);
        }
    }

    public static void debugPrintLocalised(String string, Object object, Object object2) {
        Logger logger = Logging.getLogger();
        if (logger.isLoggable(DEBUG)) {
            String string2 = PropertyFactory.getFormattedString(string, object, object2);
            logger.log(DEBUG, string2);
        }
    }

    public static void debugPrint(String string, Throwable throwable) {
        Logging.debugPrint(string);
    }

    public static void errorPrintLocalised(String string) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        String string2 = PropertyFactory.getString(string);
        System.err.println(string2);
    }

    public static void errorPrintLocalised(String string, Object ... objectArray) {
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        String string2 = PropertyFactory.getFormattedString(string, objectArray);
        Logger logger = Logging.getLogger();
        if (logger.isLoggable(ERROR)) {
            logger.log(ERROR, string2);
        }
    }

    public static void deprecationPrint(String string) {
        Logger logger;
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        if ((logger = Logging.getLogger()).isLoggable(LST_WARNING) && SettingsHandler.outputDeprecationMessages()) {
            logger.log(LST_WARNING, string);
        }
    }

    public static void errorPrint(String string) {
        Logger logger;
        if (Logging.isDebugMode()) {
            s_TOOLKIT.beep();
        }
        if ((logger = Logging.getLogger()).isLoggable(ERROR)) {
            logger.log(ERROR, string);
        }
    }

    public static void errorPrint(String string, Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        Logging.errorPrint(string + "\n" + byteArrayOutputStream.toString());
    }

    public static void log(Level level, String string) {
        Logger logger = Logging.getLogger();
        if (logger.isLoggable(level)) {
            logger.log(level, string);
        }
    }

    public static void log(Level level, String string, Throwable throwable) {
        Logger logger = Logging.getLogger();
        if (logger.isLoggable(level)) {
            logger.log(level, string, throwable);
        }
    }

    public static void errorPrintLocalised(String string, Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        Logging.errorPrint(PropertyFactory.getString(string) + "\n" + byteArrayOutputStream.toString());
    }

    public static void memoryReport() {
        System.out.println(Logging.memoryReportStr());
    }

    public static String memoryReportStr() {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        StringBuffer stringBuffer = new StringBuffer("Memory: ");
        stringBuffer.append(numberFormat.format((double)runtime.totalMemory() / 1024.0));
        stringBuffer.append("Kb total, ");
        stringBuffer.append(numberFormat.format((double)runtime.freeMemory() / 1024.0));
        stringBuffer.append("Kb free, ");
        stringBuffer.append(numberFormat.format((double)runtime.maxMemory() / 1024.0));
        stringBuffer.append("Kb max.");
        return stringBuffer.toString();
    }

    public static void printStackTrace() {
        String string = null;
        try {
            string.length();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    private static Logger getLogger() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        StackTraceElement stackTraceElement = null;
        for (int i = 1; i < stackTraceElementArray.length; ++i) {
            if ("pcgen.util.Logging".equals(stackTraceElementArray[i].getClassName())) continue;
            stackTraceElement = stackTraceElementArray[i];
            break;
        }
        String string = stackTraceElement == null ? "" : stackTraceElement.getClassName();
        Logger logger = Logger.getLogger(string);
        return logger;
    }

    public static void reportAllThreads() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        StringBuffer stringBuffer = new StringBuffer();
        for (Thread thread : map.keySet()) {
            StackTraceElement[] stackTraceElementArray;
            stringBuffer.append("Thread: ");
            stringBuffer.append(thread.getName());
            stringBuffer.append(", stacktrace:\n");
            for (StackTraceElement stackTraceElement : stackTraceElementArray = map.get(thread)) {
                stringBuffer.append("  ");
                stringBuffer.append(stackTraceElement.toString());
                stringBuffer.append("\n");
            }
        }
        System.out.println("==== Thread listing ====");
        System.out.println(stringBuffer);
        System.out.println("===== end listing  =====");
    }

    public static void registerHandler(Handler handler) {
        Logger.getLogger("").addHandler(handler);
    }

    public static void removeHandler(Handler handler) {
        Logger.getLogger("").removeHandler(handler);
    }

    public static List<Level> getLoggingLevels() {
        ArrayList<Level> arrayList = new ArrayList<Level>();
        arrayList.add(ERROR);
        arrayList.add(LST_ERROR);
        arrayList.add(WARNING);
        arrayList.add(LST_WARNING);
        arrayList.add(INFO);
        arrayList.add(LST_INFO);
        arrayList.add(DEBUG);
        return arrayList;
    }

    public static Level getCurrentLoggingLevel() {
        return Logger.getLogger("pcgen").getLevel();
    }

    public static void setCurrentLoggingLevel(Level level) {
        Logger.getLogger("pcgen").setLevel(level);
        Logger.getLogger("plugin").setLevel(level);
    }

    public static void addParseMessage(Level level, String string) {
        queuedMessages.add(new QueuedMessage(level, string));
    }

    public static void markParseMessages() {
        queuedMessageMark = queuedMessages.size();
    }

    public static void rewindParseMessages() {
        while (queuedMessageMark > -1 && queuedMessages.size() > queuedMessageMark) {
            queuedMessages.removeLast();
        }
    }

    public static void replayParsedMessages() {
        Logger logger = Logging.getLogger();
        for (QueuedMessage queuedMessage : queuedMessages) {
            if (!logger.isLoggable(queuedMessage.level)) continue;
            logger.log(queuedMessage.level, queuedMessage.message, queuedMessage.stackTrace);
        }
        queuedMessageMark = -1;
    }

    public static void clearParseMessages() {
        queuedMessageMark = -1;
        queuedMessages.clear();
    }

    static {
        Properties properties = System.getProperties();
        File file = new File(SettingsHandler.getDecodedPCGenFilesDir().getAbsolutePath() + File.separator + "logging.properties");
        if (!file.exists()) {
            file = new File("logging.properties");
        }
        if (file.exists() && null == properties.get("java.util.logging.config.file")) {
            properties.put("java.util.logging.config.file", file.getAbsolutePath());
        }
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (SecurityException securityException) {
            System.err.println("Failed to read logging configuration. Error was:");
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            System.err.println("Failed to read logging configuration. Error was:");
            iOException.printStackTrace();
        }
        queuedMessages = new LinkedList();
        queuedMessageMark = -1;
    }

    private static class QueuedMessage {
        public final Level level;
        public final String message;
        public final StackTraceElement[] stackTrace;

        public QueuedMessage(Level level, String string) {
            this.level = level;
            this.message = string;
            this.stackTrace = Thread.currentThread().getStackTrace();
        }
    }
}

