/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.math.BigDecimal;
import pcgen.util.Logging;

public class BigDecimalHelper {
    public static BigDecimal formatBigDecimal(BigDecimal bigDecimal, int n) {
        return bigDecimal.setScale(n, 4);
    }

    public static BigDecimal trimBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal.unscaledValue().intValue() == 0) {
            return BigDecimal.ZERO;
        }
        if (bigDecimal.scale() <= 0) {
            return bigDecimal;
        }
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        if (bigDecimal2.scale() < 0) {
            bigDecimal2 = bigDecimal.setScale(0);
        }
        return bigDecimal2;
    }

    public static String trimZeros(String string) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Cannot trim zeroes from " + string + " as is not a number. Using 0 instead.");
        }
        return BigDecimalHelper.trimBigDecimal(bigDecimal).toString();
    }

    public static String trimZeros(BigDecimal bigDecimal) {
        return BigDecimalHelper.trimBigDecimal(bigDecimal).toString();
    }
}

