/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.CDOMSubToken;
import pcgen.rules.persistence.token.CDOMToken;
import pcgen.rules.persistence.util.TokenFamily;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenFamilySubIterator<C>
implements Iterator<CDOMSecondaryToken<? super C>> {
    private static final Class<Object> OBJECT_CLASS = Object.class;
    private CDOMSecondaryToken<? super C> nextToken = null;
    private boolean needNewToken = true;
    private Class<?> actingClass;
    private final String parentToken;
    private Iterator<CDOMSubToken<?>> subIterator;
    private final Set<String> used = new HashSet<String>();

    public TokenFamilySubIterator(Class<C> clazz, String string) {
        this.actingClass = clazz;
        this.parentToken = string;
        this.subIterator = TokenFamily.CURRENT.getSubTokens(clazz, this.parentToken).iterator();
    }

    @Override
    public CDOMSecondaryToken<? super C> next() {
        this.setNext();
        if (this.nextToken == null) {
            throw new NoSuchElementException();
        }
        this.needNewToken = true;
        return this.nextToken;
    }

    private void setNext() {
        if (this.needNewToken) {
            this.nextToken = this.getNext();
            if (this.nextToken != null) {
                String string = this.nextToken.getTokenName();
                if (this.used.contains(string)) {
                    this.setNext();
                } else {
                    this.used.add(this.nextToken.getTokenName());
                }
            }
        }
    }

    private CDOMSecondaryToken<? super C> getNext() {
        this.needNewToken = false;
        while (this.subIterator.hasNext()) {
            CDOMToken cDOMToken = this.subIterator.next();
            if (!(cDOMToken instanceof CDOMSecondaryToken)) continue;
            return (CDOMSecondaryToken)cDOMToken;
        }
        if (OBJECT_CLASS.equals(this.actingClass)) {
            return null;
        }
        this.actingClass = this.actingClass.getSuperclass();
        this.subIterator = TokenFamily.CURRENT.getSubTokens(this.actingClass, this.parentToken).iterator();
        return this.getNext();
    }

    @Override
    public boolean hasNext() {
        this.setNext();
        return this.nextToken != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator does not support remove");
    }
}

