/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.OneToOneMap;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.SubClassCategory;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.SubClass;
import pcgen.rules.context.ReferenceContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReferenceContext
implements ReferenceContext {
    private static final Class<CategorizedCDOMObject> CATEGORIZED_CDOM_OBJECT_CLASS = CategorizedCDOMObject.class;
    private static final Class<DomainSpellList> DOMAINSPELLLIST_CLASS = DomainSpellList.class;
    private static final Class<ClassSkillList> CLASSSKILLLIST_CLASS = ClassSkillList.class;
    private static final Class<ClassSpellList> CLASSSPELLLIST_CLASS = ClassSpellList.class;
    private static final Class<SubClass> SUBCLASS_CLASS = SubClass.class;
    private final Map<Class<?>, OneToOneMap<CDOMObject, String>> abbMap = new HashMap();
    private final HashMap<CDOMObject, CDOMSingleRef<?>> directRefCache = new HashMap();
    private URI sourceURI;
    private URI extractURI;

    @Override
    public abstract <T extends CDOMObject> ReferenceManufacturer<T, ? extends CDOMSingleRef<T>> getManufacturer(Class<T> var1);

    public abstract <T extends CDOMObject> boolean hasManufacturer(Class<T> var1);

    protected abstract <T extends CDOMObject> ReferenceManufacturer<T, ? extends CDOMSingleRef<T>> getManufacturer(Class<T> var1, Category<T> var2);

    protected abstract <T extends CDOMObject> boolean hasManufacturer(Class<T> var1, Category<T> var2);

    @Override
    public abstract Collection<? extends ReferenceManufacturer<? extends CDOMObject, ?>> getAllManufacturers();

    @Override
    public boolean validate(UnconstructedValidator unconstructedValidator) {
        boolean bl = true;
        for (ReferenceManufacturer<CDOMObject, ?> referenceManufacturer : this.getAllManufacturers()) {
            bl &= referenceManufacturer.validate(unconstructedValidator);
        }
        return bl;
    }

    @Override
    public <T extends CDOMObject> CDOMGroupRef<T> getCDOMAllReference(Class<T> clazz) {
        return this.getManufacturer(clazz).getAllReference();
    }

    @Override
    public <T extends CDOMObject> CDOMGroupRef<T> getCDOMAllReference(Class<T> clazz, Category<T> category) {
        return this.getManufacturer(clazz, category).getAllReference();
    }

    @Override
    public <T extends CDOMObject> CDOMGroupRef<T> getCDOMTypeReference(Class<T> clazz, String ... stringArray) {
        return this.getManufacturer(clazz).getTypeReference(stringArray);
    }

    @Override
    public <T extends CDOMObject> CDOMGroupRef<T> getCDOMTypeReference(Class<T> clazz, Category<T> category, String ... stringArray) {
        return this.getManufacturer(clazz, category).getTypeReference(stringArray);
    }

    @Override
    public <T extends CDOMObject> T constructCDOMObject(Class<T> clazz, String string) {
        CDOMObject cDOMObject;
        if (CATEGORIZED_CDOM_OBJECT_CLASS.isAssignableFrom(clazz)) {
            Class<T> clazz2 = clazz;
            cDOMObject = (CDOMObject)this.getManufacturer(clazz2, (Category)null).constructObject(string);
        } else {
            cDOMObject = (CDOMObject)this.getManufacturer(clazz).constructObject(string);
        }
        cDOMObject.put(ObjectKey.SOURCE_URI, this.sourceURI);
        return (T)cDOMObject;
    }

    @Override
    public <T extends CDOMObject> void constructIfNecessary(Class<T> clazz, String string) {
        this.getManufacturer(clazz).constructIfNecessary(string);
    }

    @Override
    public <T extends CDOMObject> CDOMSingleRef<T> getCDOMReference(Class<T> clazz, String string) {
        ReferenceManufacturer<T, CDOMSingleRef<T>> referenceManufacturer = this.getManufacturer(clazz);
        return referenceManufacturer.getReference(string);
    }

    @Override
    public <T extends CDOMObject> CDOMSingleRef<T> getCDOMReference(Class<T> clazz, Category<T> category, String string) {
        ReferenceManufacturer<T, CDOMSingleRef<T>> referenceManufacturer = this.getManufacturer(clazz, category);
        return referenceManufacturer.getReference(string);
    }

    @Override
    public <T extends CDOMObject> void reassociateKey(String string, T t) {
        if (CATEGORIZED_CDOM_OBJECT_CLASS.isAssignableFrom(t.getClass())) {
            Class<?> clazz = t.getClass();
            this.reassociateCategorizedKey(string, t, clazz);
        } else {
            this.getManufacturer(t.getClass()).renameObject(string, t);
        }
    }

    private <T extends CDOMObject> void reassociateCategorizedKey(String string, CDOMObject cDOMObject, Class<T> clazz) {
        CDOMObject cDOMObject2 = cDOMObject;
        this.getManufacturer(clazz, ((CategorizedCDOMObject)((Object)cDOMObject2)).getCDOMCategory()).renameObject(string, cDOMObject2);
    }

    @Override
    public <T extends CDOMObject> T silentlyGetConstructedCDOMObject(Class<T> clazz, String string) {
        return (T)((CDOMObject)this.getManufacturer(clazz).getActiveObject(string));
    }

    @Override
    public <T extends CDOMObject> T silentlyGetConstructedCDOMObject(Class<T> clazz, Category<T> category, String string) {
        return (T)((CDOMObject)this.getManufacturer(clazz, category).getActiveObject(string));
    }

    @Override
    public <T extends CDOMObject> void reassociateCategory(Category<T> category, T t) {
        Category category2 = ((CategorizedCDOMObject)((Object)t)).getCDOMCategory();
        if (category2 == null && category == null || category2 != null && category2.equals(category)) {
            Logging.errorPrint("Worthless Category change encountered: " + t.getDisplayName() + " " + category2);
        }
        this.reassociateCategory(t.getClass(), t, category2, category);
    }

    private <T extends CDOMObject> void reassociateCategory(Class<T> clazz, T t, Category<T> category, Category<T> category2) {
        this.getManufacturer(clazz, category).forgetObject(t);
        ((CategorizedCDOMObject)((Object)t)).setCDOMCategory(category2);
        this.getManufacturer(clazz, category2).addObject(t, t.getKeyName());
    }

    @Override
    public <T extends CDOMObject> void importObject(T t) {
        if (CATEGORIZED_CDOM_OBJECT_CLASS.isAssignableFrom(t.getClass())) {
            Class<?> clazz = t.getClass();
            this.importCategorized(t, clazz);
        } else {
            this.getManufacturer(t.getClass()).addObject(t, t.getKeyName());
        }
    }

    private <T extends CDOMObject> void importCategorized(CDOMObject cDOMObject, Class<T> clazz) {
        CDOMObject cDOMObject2 = cDOMObject;
        this.getManufacturer(clazz, ((CategorizedCDOMObject)((Object)cDOMObject2)).getCDOMCategory()).addObject(cDOMObject2, cDOMObject2.getKeyName());
    }

    @Override
    public <T extends CDOMObject> boolean forget(T t) {
        OneToOneMap<CDOMObject, String> oneToOneMap = this.abbMap.get(t.getClass());
        if (oneToOneMap != null) {
            oneToOneMap.remove(t);
        }
        if (CATEGORIZED_CDOM_OBJECT_CLASS.isAssignableFrom(t.getClass())) {
            CategorizedCDOMObject categorizedCDOMObject;
            Class<?> clazz = t.getClass();
            if (this.hasManufacturer(clazz, (categorizedCDOMObject = (CategorizedCDOMObject)((Object)t)).getCDOMCategory())) {
                return this.getManufacturer(clazz, categorizedCDOMObject.getCDOMCategory()).forgetObject(t);
            }
        } else if (this.hasManufacturer(t.getClass())) {
            return this.getManufacturer(t.getClass()).forgetObject(t);
        }
        return false;
    }

    @Override
    public <T extends CDOMObject> Collection<T> getConstructedCDOMObjects(Class<T> clazz) {
        return this.getManufacturer(clazz).getAllObjects();
    }

    @Override
    public Set<CDOMObject> getAllConstructedObjects() {
        HashSet<CDOMObject> hashSet = new HashSet<CDOMObject>();
        for (ReferenceManufacturer<CDOMObject, ?> referenceManufacturer : this.getAllManufacturers()) {
            hashSet.addAll(referenceManufacturer.getAllObjects());
        }
        return hashSet;
    }

    @Override
    public <T extends CDOMObject> boolean containsConstructedCDOMObject(Class<T> clazz, String string) {
        return this.getManufacturer(clazz).containsObject(string);
    }

    @Override
    public void buildDerivedObjects() {
        CDOMObject cDOMObject;
        Collection<Domain> collection = this.getConstructedCDOMObjects(Domain.class);
        for (Domain object2 : collection) {
            cDOMObject = this.constructCDOMObject(DOMAINSPELLLIST_CLASS, object2.getKeyName());
            cDOMObject.addToListFor(ListKey.TYPE, Type.DIVINE);
            object2.put(ObjectKey.DOMAIN_SPELLLIST, cDOMObject);
        }
        Collection<PCClass> collection2 = this.getConstructedCDOMObjects(PCClass.class);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            cDOMObject = (PCClass)iterator.next();
            String string = cDOMObject.getKeyName();
            this.constructCDOMObject(CLASSSKILLLIST_CLASS, string);
            ClassSpellList classSpellList = this.constructCDOMObject(CLASSSPELLLIST_CLASS, string);
            String string2 = cDOMObject.get(StringKey.SPELLTYPE);
            if (string2 != null) {
                classSpellList.addToListFor(ListKey.TYPE, Type.getConstant(string2));
            }
            cDOMObject.put(ObjectKey.CLASS_SPELLLIST, classSpellList);
            if (!cDOMObject.containsListFor(ListKey.SUB_CLASS)) continue;
            SubClassCategory subClassCategory = SubClassCategory.getConstant(string);
            boolean bl = cDOMObject.getSafe(ObjectKey.ALLOWBASECLASS);
            for (SubClass subClass : cDOMObject.getListFor(ListKey.SUB_CLASS)) {
                String string3 = subClass.getKeyName();
                if (string3.equalsIgnoreCase(string)) {
                    bl = false;
                }
                this.constructCDOMObject(CLASSSKILLLIST_CLASS, string3);
                classSpellList = this.constructCDOMObject(CLASSSPELLLIST_CLASS, string3);
                if (string2 != null) {
                    classSpellList.addToListFor(ListKey.TYPE, Type.getConstant(string2));
                }
                subClass.put(ObjectKey.CLASS_SPELLLIST, classSpellList);
                subClass.setCDOMCategory(subClassCategory);
                this.importObject(subClass);
            }
            if (!bl) continue;
            SubClass subClass = this.constructCDOMObject(SUBCLASS_CLASS, string);
            this.reassociateCategory(SUBCLASS_CLASS, subClass, null, subClassCategory);
        }
    }

    @Override
    public <T extends CDOMObject> CDOMSingleRef<T> getCDOMDirectReference(T t) {
        CDOMSingleRef<?> cDOMSingleRef = this.directRefCache.get(t);
        if (cDOMSingleRef == null) {
            cDOMSingleRef = new CDOMDirectSingleRef(t);
        }
        return cDOMSingleRef;
    }

    @Override
    public void registerAbbreviation(CDOMObject cDOMObject, String string) {
        OneToOneMap<CDOMObject, String> oneToOneMap = this.abbMap.get(cDOMObject.getClass());
        if (oneToOneMap == null) {
            oneToOneMap = new OneToOneMap();
            this.abbMap.put(cDOMObject.getClass(), oneToOneMap);
        }
        oneToOneMap.put(cDOMObject, string);
        cDOMObject.put(StringKey.ABB, string);
    }

    @Override
    public String getAbbreviation(CDOMObject cDOMObject) {
        OneToOneMap<CDOMObject, String> oneToOneMap = this.abbMap.get(cDOMObject.getClass());
        return oneToOneMap == null ? null : oneToOneMap.get(cDOMObject);
    }

    @Override
    public <T> T getAbbreviatedObject(Class<T> clazz, String string) {
        OneToOneMap<CDOMObject, String> oneToOneMap = this.abbMap.get(clazz);
        return (T)(oneToOneMap == null ? null : oneToOneMap.getKeyFor(string));
    }

    @Override
    public URI getExtractURI() {
        return this.extractURI;
    }

    @Override
    public void setExtractURI(URI uRI) {
        this.extractURI = uRI;
    }

    @Override
    public URI getSourceURI() {
        return this.sourceURI;
    }

    @Override
    public void setSourceURI(URI uRI) {
        this.sourceURI = uRI;
    }

    @Override
    public void resolveReferences() {
        for (ReferenceManufacturer<CDOMObject, ?> referenceManufacturer : this.getAllManufacturers()) {
            referenceManufacturer.resolveReferences();
        }
    }

    @Override
    public void buildDeferredObjects() {
        for (ReferenceManufacturer<CDOMObject, ?> referenceManufacturer : this.getAllManufacturers()) {
            referenceManufacturer.buildDeferredObjects();
        }
    }

    @Override
    public <T extends CDOMObject> T constructNowIfNecessary(Class<T> clazz, String string) {
        return (T)((CDOMObject)this.getManufacturer(clazz).constructNowIfNecessary(string));
    }
}

