/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import pcgen.core.SystemCollections;
import pcgen.core.system.LoadInfo;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LoadInfoLstToken;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class LoadInfoLoader
extends LstLineFileLoader {
    public void loadLstFile(LoadContext loadContext, URI uRI, String string) throws PersistenceLayerException {
        super.loadLstFile(loadContext, uRI, string);
        if (SystemCollections.getLoadInfo(string).getLoadMultiplierCount() == 0) {
            Logging.errorPrint("Warning: load.lst for game mode " + string + " does not contain load category definitions. No weight categories will be available. " + "Please refer to the documentation for the Load List file.");
        } else if (SystemCollections.getLoadInfo(string).getLoadMultiplier("LIGHT") == null || SystemCollections.getLoadInfo(string).getLoadMultiplier("MEDIUM") == null || SystemCollections.getLoadInfo(string).getLoadMultiplier("HEAVY") == null) {
            Logging.errorPrint("Warning: load.lst for game mode " + string + " does not contain load category definitions for 'Light', 'Medium' and 'Heavy'. " + "Please refer to the documentation for the Load List file.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseLine(LoadContext loadContext, String string, URI uRI) {
        String[] stringArray;
        LoadInfo loadInfo = SystemCollections.getLoadInfo(this.getGameMode());
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(LoadInfoLstToken.class);
        int n = string.indexOf(58);
        String string2 = "";
        try {
            string2 = string.substring(0, n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        LoadInfoLstToken loadInfoLstToken = (LoadInfoLstToken)map.get(string2);
        if (loadInfoLstToken != null) {
            String string3 = string.substring(n + 1);
            LstUtils.deprecationCheck(loadInfoLstToken, loadInfo.toString(), uRI, string3);
            if (loadInfoLstToken.parse(loadInfo, string3)) return;
            Logging.errorPrint("Error parsing ability " + loadInfo + ':' + "level.lst" + ':' + string + "\"");
            return;
        }
        LstUtils.deprecationWarning("Using deprecated style of load.lst.  Please consult the docs for information about the new style load.lst");
        String[] stringArray2 = string.split(",");
        if (stringArray2.length > 1) {
            stringArray = stringArray2[0].split("\\|");
            if (stringArray.length != 2) {
                Logging.errorPrint("LoadInfoLoader got unexpected line '" + string + ". Line ignored.");
                return;
            }
        } else {
            String[] stringArray3 = string.split("\t");
            if (stringArray3.length != 2) {
                Logging.errorPrint("LoadInfoLoader got unexpected line '" + string + ". Line ignored.");
                return;
            }
            if ("x".equals(stringArray3[0])) {
                loadInfo.setLoadScoreMultiplier(new Float(stringArray3[1]));
                return;
            }
            loadInfo.addLoadScoreValue(Integer.parseInt(stringArray3[0]), new Float(stringArray3[1]));
            return;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray = stringArray2[n2].split("\\|");
            if (stringArray.length != 2) {
                Logging.errorPrint("LoadInfoLoader got unexpected line '" + string + ". Line ignored.");
                return;
            }
            String string4 = stringArray[0];
            Float f = new Float(stringArray[1]);
            loadInfo.addSizeAdjustment(string4, f);
            ++n2;
        }
    }
}

