/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.AbilityCategory;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.AbilityCategoryLstToken;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class AbilityCategoryLoader
extends LstLineFileLoader {
    public void parseLine(GameMode gameMode, String string, URI uRI) throws PersistenceLayerException {
        this.parseLine(gameMode, string, uRI, false);
    }

    public void parseLine(GameMode gameMode, String string, URI uRI, boolean bl) throws PersistenceLayerException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(AbilityCategoryLstToken.class);
        AbilityCategory abilityCategory = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken().trim();
            int n = string4.indexOf(58);
            try {
                string3 = string4.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (abilityCategory == null && bl) {
                    string3 = "ABILITYCATEGORY";
                }
                throw new PersistenceLayerException(PropertyFactory.getFormattedString("Errors.LstTokens.InvalidTokenFormat", this.getClass().toString(), string4));
            }
            AbilityCategoryLstToken abilityCategoryLstToken = (AbilityCategoryLstToken)map.get(string3);
            if (string3.equals("ABILITYCATEGORY")) {
                string2 = string4.substring(n + 1).trim();
                abilityCategory = gameMode.silentlyGetAbilityCategory(string2);
                if (abilityCategory != null) continue;
                abilityCategory = new AbilityCategory(string2);
                if (bl) {
                    gameMode.addLstAbilityCategory(abilityCategory);
                    continue;
                }
                gameMode.addAbilityCategory(abilityCategory);
                continue;
            }
            if (abilityCategoryLstToken != null) {
                string2 = string4.substring(n + 1).trim();
                LstUtils.deprecationCheck(abilityCategoryLstToken, "Ability Category", uRI, string2);
                if (abilityCategoryLstToken.parse(abilityCategory, string2)) continue;
                Logging.errorPrint("Error parsing ability category:miscinfo.lst from the " + gameMode.getName() + " Game Mode" + ':' + string4 + "\"");
                continue;
            }
            Logging.errorPrint("Invalid sub tag " + string3 + " on ABILITYCATEGORY line");
            throw new PersistenceLayerException("Invalid sub tag " + string3 + " on ABILITYCATEGORY line");
        }
        this.validateCategory(abilityCategory, uRI);
    }

    public void parseLine(LoadContext loadContext, String string, URI uRI) throws PersistenceLayerException {
        this.parseLine(SettingsHandler.getGame(), string, uRI, true);
    }

    private void validateCategory(AbilityCategory abilityCategory, URI uRI) {
        if (!abilityCategory.getAbilityTypes().isEmpty() && abilityCategory.getAbilityCategory().equalsIgnoreCase(abilityCategory.getKeyName())) {
            Logging.log(Logging.LST_ERROR, "TYPE is not valid in 'parent' category " + abilityCategory.getKeyName() + " of " + uRI + ".");
        }
        if (!abilityCategory.getAbilityKeys().isEmpty() && abilityCategory.getAbilityCategory().equalsIgnoreCase(abilityCategory.getKeyName())) {
            Logging.log(Logging.LST_ERROR, "ABILITYLIST is not valid in 'parent' category " + abilityCategory.getKeyName() + " of " + uRI + ".");
        }
    }
}

