/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.QualifiedName;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbilityToken;
import pcgen.io.exporttoken.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityListToken
extends Token {
    private static final String DELIM = ", ";
    private List<Ability> abilityList = null;
    private PlayerCharacter lastPC = null;
    private int lastPCSerial;
    private String lastType = "";
    private AbilityCategory lastCategory = null;
    public static final String TOKENNAME = "ABILITYLIST";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        AbilityCategory abilityCategory = SettingsHandler.getGame().getAbilityCategory(string3);
        return this.getTokenForCategory(playerCharacter, stringTokenizer, string2, abilityCategory);
    }

    protected String getTokenForCategory(PlayerCharacter playerCharacter, StringTokenizer stringTokenizer, String string, AbilityCategory abilityCategory) {
        int n;
        Collection<AbilityCategory> collection;
        if (abilityCategory == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lastPC != playerCharacter || !abilityCategory.equals(this.lastCategory) || this.lastPCSerial != playerCharacter.getSerial() || !string.equals(this.lastType)) {
            collection = SettingsHandler.getGame().getAllAbilityCatsForKey(abilityCategory.getKeyName());
            this.abilityList = new ArrayList<Ability>();
            for (AbilityCategory object2 : collection) {
                this.abilityList.addAll(this.getAbilityList(playerCharacter, object2));
            }
            this.lastPC = playerCharacter;
            this.lastCategory = abilityCategory;
            this.lastPCSerial = playerCharacter.getSerial();
            this.lastType = string;
        }
        collection = new ArrayList<AbilityCategory>();
        ArrayList arrayList = new ArrayList();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n = string2.indexOf("TYPE=");
            if (n == -1 || string2.length() <= 5) continue;
            if (n > 0) {
                arrayList.add(string2.substring(n + 5));
                continue;
            }
            collection.add((AbilityCategory)((Object)string2.substring(n + 5)));
        }
        List<Ability> list = AbilityToken.buildAbilityList(collection, arrayList, null, 1, this.abilityList);
        n = 0;
        for (Ability ability : list) {
            if (n != 0) {
                stringBuffer.append(DELIM);
            }
            n = 1;
            stringBuffer.append(QualifiedName.qualifiedName(playerCharacter, ability));
        }
        return stringBuffer.toString();
    }

    protected List<Ability> getAbilityList(PlayerCharacter playerCharacter, AbilityCategory abilityCategory) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (Ability ability : playerCharacter.getRealAbilitiesList(abilityCategory)) {
            arrayList.add(ability);
        }
        return arrayList;
    }
}

