/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.IOHandler;
import pcgen.io.PCGParseException;
import pcgen.io.PCGParser;
import pcgen.io.PCGVer0Parser;
import pcgen.io.PCGVer2Creator;
import pcgen.io.PCGVer2Parser;
import pcgen.util.InputFactory;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PCGIOHandler
extends IOHandler {
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private PlayerCharacter aPC;

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getMessages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.errors);
        arrayList.addAll(this.warnings);
        return arrayList;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public static void buildSALIST(String string, List<String> list, List<String> list2, PlayerCharacter playerCharacter) {
        String string2;
        String string3 = "";
        int n = string.indexOf(124, 7);
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(7, n);
            string3 = string.substring(n + 1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        List<SpecialAbility> list3 = playerCharacter.getSpecialAbilityList();
        for (String string4 : arrayList) {
            for (SpecialAbility specialAbility : list3) {
                String string5 = specialAbility.getKeyName();
                if (!string5.startsWith(string2)) continue;
                String string6 = "";
                n = string5.indexOf(124);
                if (n >= 0) {
                    string6 = string5.substring(n + 1);
                    n = string5.indexOf(37);
                    if (n >= 0) {
                        string5 = string5.substring(0, n).trim();
                    }
                }
                if (list.contains(string5)) continue;
                list.add(string5);
                n = string3.indexOf(37);
                if (n >= 0) {
                    string6 = string3.substring(0, n) + string6 + string3.substring(n + 1);
                }
                list2.add(string5 + "|" + string6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(PlayerCharacter playerCharacter, InputStream inputStream, boolean bl) {
        this.aPC = playerCharacter;
        this.warnings.clear();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
                bl2 |= string.startsWith("PCGVERSION");
            }
        }
        catch (IOException iOException) {
            Logging.errorPrint("Exception in PCGIOHandler::read", iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Logging.errorPrint("Couldn't close file in PCGIOHandler.read", iOException);
            }
        }
        playerCharacter.setImporting(true);
        boolean bl3 = SettingsHandler.isLoadCampaignsWithPC();
        if (!bl) {
            SettingsHandler.setLoadCampaignsWithPC(false);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        PCGParser pCGParser = bl2 ? new PCGVer2Parser(playerCharacter) : new PCGVer0Parser(playerCharacter);
        try {
            pCGParser.parsePCG(stringArray);
        }
        catch (PCGParseException pCGParseException) {
            this.errors.add(pCGParseException.getMessage() + Constants.s_LINE_SEP + "Method: " + pCGParseException.getMethod() + '\n' + "Line: " + pCGParseException.getLine());
        }
        this.warnings.addAll(pCGParser.getWarnings());
        playerCharacter.setImporting(false);
        SettingsHandler.setLoadCampaignsWithPC(bl3);
        try {
            this.sanityChecks(playerCharacter, pCGParser);
        }
        catch (NumberFormatException numberFormatException) {
            this.errors.add(numberFormatException.getMessage() + Constants.s_LINE_SEP + "Method: sanityChecks");
        }
        playerCharacter.setDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(PlayerCharacter playerCharacter, OutputStream outputStream) {
        this.aPC = playerCharacter;
        String string = new PCGVer2Creator(playerCharacter).createPCGString();
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            playerCharacter.setDirty(false);
        }
        catch (IOException iOException) {
            Logging.errorPrint("Exception in PCGIOHandler::write", iOException);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                Logging.errorPrint("Couldn't close file in PCGIOHandler.write", iOException);
            }
        }
    }

    private void sanityChecks(PlayerCharacter playerCharacter, PCGParser pCGParser) {
        boolean bl = false;
        this.aPC.setCalcEquipmentList();
        this.aPC.setCalcFollowerBonus(playerCharacter);
        this.aPC.calcActiveBonuses();
        int n = this.aPC.hitPoints();
        if (pCGParser.isCalcFeatPoolAfterLoad()) {
            double d = pCGParser.getBaseFeatPool();
            double d2 = this.aPC.getRawFeats(true);
            this.aPC.setFeats(d -= d2);
        }
        for (Ability pObject : this.aPC.getRealAbilitiesList(AbilityCategory.FEAT)) {
            Object object;
            if (pObject.getSafe(StringKey.CHOICE_STRING).startsWith("SALIST|")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                PCGIOHandler.buildSALIST(pObject.getSafe(StringKey.CHOICE_STRING), arrayList, arrayList2, playerCharacter);
                object = this.aPC.getAssociationList(pObject).iterator();
                block1: while (object.hasNext()) {
                    String string;
                    String string2 = string = object.next();
                    String string3 = string + "|";
                    boolean bl2 = true;
                    while (true) {
                        Object object2;
                        Object object3;
                        String string4;
                        int n2;
                        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                            string4 = (String)arrayList2.get(n2);
                            if (!string4.startsWith(string3)) continue;
                            object3 = string4.substring(string4.indexOf(124) + 1);
                            object2 = Bonus.newBonus((String)object3);
                            if (object2 == null) break;
                            ((BonusObj)object2).setCreatorObject(pObject);
                            this.aPC.addAssoc(pObject, AssociationListKey.BONUS, object2);
                            break;
                        }
                        if (n2 < arrayList2.size() || !bl2) continue block1;
                        bl2 = false;
                        if (arrayList2.size() == 1) {
                            string = (String)arrayList2.get(0);
                            string = string.substring(0, string.indexOf(124));
                        } else {
                            while (true) {
                                string4 = pObject.getDisplayName() + " has been modified and PCGen is unable to " + "determine your previous selection(s)." + Constants.s_LINE_SEP + Constants.s_LINE_SEP + "This box will pop up once for each time you " + "have taken the feat.";
                                object3 = InputFactory.getInputInstance();
                                object2 = object3.showInputDialog(null, string4, "PCGen", MessageType.INFORMATION, arrayList.toArray(), arrayList.get(0));
                                if (object2 != null) {
                                    string = (String)object2;
                                    break;
                                }
                                ShowMessageDelegate.showMessageDialog("You MUST make a selection", "PCGen", MessageType.INFORMATION);
                            }
                        }
                        this.aPC.removeAssociation((CDOMObject)pObject, string2);
                        this.aPC.addAssociation((CDOMObject)pObject, string);
                    }
                }
            } else if (pObject.getSafe(StringKey.CHOICE_STRING).startsWith("NONCLASSSKILLLIST|")) {
                for (String string : playerCharacter.getAssociationList(pObject)) {
                    object = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string);
                    if (object == null) continue;
                    playerCharacter.addAssoc(pObject, AssociationListKey.CSKILL, object);
                }
            }
            if (!pObject.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() || playerCharacter.hasAssociations(pObject)) continue;
            playerCharacter.addAssociation((CDOMObject)pObject, "PLEASE MAKE APPROPRIATE SELECTION");
            this.warnings.add("Multiple selection feat found with no selections (" + pObject.getDisplayName() + "). Correct on Feat tab.");
        }
        if (this.aPC.getClassList() != null) {
            for (PCClass pCClass : this.aPC.getClassList()) {
                if (pCClass.getLevel() < 1) continue;
                for (int i = 0; i <= pCClass.getLevel(); ++i) {
                    int n3;
                    int n4 = pCClass.getLevelHitDie(playerCharacter, i + 1).getDie();
                    int n5 = pCClass.getHitPoint(i);
                    if (n5 <= (n3 = n4 + (int)pCClass.getBonusTo("HD", "MAX", i + 1, this.aPC))) continue;
                    pCClass.setHitPoint(i, n3);
                    bl = true;
                }
            }
        }
        if (bl) {
            String string = "Fixed illegal value in hit points. Current character hit points: " + this.aPC.hitPoints() + " not " + n;
            this.warnings.add(string);
        }
        for (PCClass pCClass : this.aPC.getClassList()) {
            pCClass.setLevel(pCClass.getLevel(), playerCharacter);
        }
        this.aPC.adjustMoveRates();
        this.aPC.calcActiveBonuses();
        this.aPC.setDirty(false);
    }
}

