/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.TableColumnManager;
import pcgen.gui.filter.Filterable;
import pcgen.gui.tabs.IFilterableView;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.tabs.ability.AbilityModel;
import pcgen.gui.tabs.ability.IAbilityCategorySelectionListener;
import pcgen.gui.tabs.ability.IAbilityListFilter;
import pcgen.gui.tabs.ability.IAbilitySelectionListener;
import pcgen.gui.tabs.ability.PCAbilityCategory;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbilitySelectionPanel
extends JPanel
implements IFilterableView,
IAbilityListFilter {
    private PlayerCharacter thePC;
    private List<AbilityCategory> theCategoryList;
    protected AbilityModel theModel;
    protected JTreeTable theTable;
    protected JTreeTableSorter theSorter;
    private List<IAbilitySelectionListener> theListeners = new ArrayList<IAbilitySelectionListener>(2);
    private List<IAbilityCategorySelectionListener> theCatListeners = new ArrayList<IAbilityCategorySelectionListener>();
    private String theOptionsRoot = "InfoAbility.";
    ViewMode theViewMode = ViewMode.PREREQTREE;
    private transient ViewMode theSavedViewMode = null;
    private Filterable theFilter = null;
    private ListSelectionListener listSelListener = null;

    public AbilitySelectionPanel(PlayerCharacter playerCharacter, AbilityCategory abilityCategory) {
        this.thePC = playerCharacter;
        this.theCategoryList = new ArrayList<AbilityCategory>();
        this.theCategoryList.add(abilityCategory);
        this.theOptionsRoot = this.theOptionsRoot + abilityCategory.getKeyName();
        int n = SettingsHandler.getPCGenOption(this.getFullOptionKey() + ".viewmode", this.getDefaultViewMode().ordinal());
        this.theViewMode = ViewMode.values()[n];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbilitySelectionPanel.this.initComponents();
            }
        });
    }

    public AbilitySelectionPanel(PlayerCharacter playerCharacter, List<AbilityCategory> list) {
        this.thePC = playerCharacter;
        this.theCategoryList = list;
        this.theOptionsRoot = this.theOptionsRoot + list.get(0).getDisplayLocation();
        int n = SettingsHandler.getPCGenOption(this.getFullOptionKey() + ".viewmode", this.getDefaultViewMode().ordinal());
        this.theViewMode = n >= 0 && n < ViewMode.values().length ? ViewMode.values()[n] : this.getDefaultViewMode();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbilitySelectionPanel.this.initComponents();
            }
        });
    }

    public PlayerCharacter getPC() {
        return this.thePC;
    }

    public void setPC(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
    }

    public AbilityCategory getCategory() {
        return this.theCategoryList.get(0);
    }

    public List<AbilityCategory> getCategoryList() {
        return Collections.unmodifiableList(this.theCategoryList);
    }

    protected abstract Map<AbilityCategory, List<Ability>> getAbilityList();

    protected abstract String getOptionKey();

    protected abstract boolean getSplitByCategory();

    protected void initComponents() {
        Object object;
        Serializable serializable;
        this.theModel = new AbilityModel(this.thePC, this.getAbilityList(), this.theCategoryList, this.theViewMode, this.getFullOptionKey(), this.getSplitByCategory());
        this.theModel.setAbilityFilter(this);
        this.theTable = new JTreeTable(this.theModel);
        TableColumnModel tableColumnModel = this.theTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            serializable = tableColumnModel.getColumn(i);
            object = AbilityModel.Column.get(i);
            int n = SettingsHandler.getPCGenOption(this.getFullOptionKey() + ".sizecol." + ((Enum)object).toString(), ((AbilityModel.Column)((Object)object)).getWidth());
            ((TableColumn)serializable).setPreferredWidth(n);
            ((TableColumn)serializable).addPropertyChangeListener(new PropertyChangeListener((TableColumn)serializable){
                final /* synthetic */ TableColumn val$col;
                {
                    this.val$col = tableColumn;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("width")) {
                        SettingsHandler.setPCGenOption(AbilitySelectionPanel.this.getFullOptionKey() + ".sizecol." + (Object)((Object)AbilityModel.Column.get(this.val$col.getModelIndex())), Integer.parseInt(propertyChangeEvent.getNewValue().toString()));
                    }
                }
            });
        }
        this.theSorter = new JTreeTableSorter(this.theTable, (PObjectNode)this.theModel.getRoot(), this.theModel);
        this.addListSelectionListener();
        JTree jTree = this.theTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        serializable = new JScrollPane(this.theTable, 22, 30);
        this.add((Component)serializable, "Center");
        object = new JButton();
        ((JScrollPane)serializable).setCorner("UPPER_RIGHT_CORNER", (Component)object);
        ((AbstractButton)object).setText("^");
        new TableColumnManager(this.theTable, (JComponent)object, this.theModel);
    }

    public void addAbilitySelectionListener(IAbilitySelectionListener iAbilitySelectionListener) {
        if (!this.theListeners.contains(iAbilitySelectionListener)) {
            this.theListeners.add(iAbilitySelectionListener);
        }
    }

    public List<IAbilitySelectionListener> getListeners() {
        return Collections.unmodifiableList(this.theListeners);
    }

    private void addListSelectionListener() {
        if (this.listSelListener == null) {
            this.listSelListener = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        int n = InfoTabUtils.getSelectedIndex(listSelectionEvent);
                        if (n < 0) {
                            return;
                        }
                        Object object = AbilitySelectionPanel.this.theTable.getTree().getPathForRow(n).getLastPathComponent();
                        final Ability ability = AbilitySelectionPanel.this.getAbilityFromObject(object);
                        final PCAbilityCategory pCAbilityCategory = AbilitySelectionPanel.this.getPCAbilityCategoryFromObject(object);
                        for (final IAbilitySelectionListener iAbilitySelectionListener : AbilitySelectionPanel.this.theListeners) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    AbilitySelectionPanel.this.abilitySelected(ability);
                                    iAbilitySelectionListener.abilitySelected(ability);
                                    if (pCAbilityCategory != null) {
                                        AbilitySelectionPanel.this.categorySelected(pCAbilityCategory);
                                    }
                                }
                            });
                        }
                    }
                }
            };
        }
        this.theTable.getSelectionModel().addListSelectionListener(this.listSelListener);
    }

    private void removeListSelectionListener() {
        if (this.listSelListener != null) {
            this.theTable.getSelectionModel().removeListSelectionListener(this.listSelListener);
        }
    }

    protected void abilitySelected(Ability ability) {
    }

    protected void categorySelected(PCAbilityCategory pCAbilityCategory) {
    }

    protected Ability getAbilityFromObject(Object object) {
        Object object2;
        if (object == null) {
            Logging.debugPrint("No ability selected while processing event");
            return null;
        }
        if (object instanceof PObjectNode && (object2 = ((PObjectNode)object).getItem()) instanceof Ability) {
            return (Ability)object2;
        }
        return null;
    }

    public void addAbilityCategorySelectionListener(IAbilityCategorySelectionListener iAbilityCategorySelectionListener) {
        if (!this.theCatListeners.contains(iAbilityCategorySelectionListener)) {
            this.theCatListeners.add(iAbilityCategorySelectionListener);
        }
    }

    public List<IAbilityCategorySelectionListener> getCategoryListeners() {
        return Collections.unmodifiableList(this.theCatListeners);
    }

    protected PCAbilityCategory getPCAbilityCategoryFromObject(Object object) {
        if (object == null) {
            Logging.debugPrint("No ability selected while processing event");
            return null;
        }
        if (object instanceof PObjectNode) {
            Object object2 = ((PObjectNode)object).getItem();
            if (object2 instanceof PCAbilityCategory) {
                return (PCAbilityCategory)object2;
            }
            PObjectNode pObjectNode = ((PObjectNode)object).getParent();
            if (pObjectNode != null) {
                return this.getPCAbilityCategoryFromObject(pObjectNode);
            }
        }
        return null;
    }

    public abstract ViewMode getDefaultViewMode();

    public void setViewMode(int n) {
        this.theViewMode = ViewMode.values()[n];
        if (this.theModel != null) {
            this.theModel.setViewMode(this.theViewMode);
        }
        SettingsHandler.setPCGenOption(this.getFullOptionKey() + ".viewmode", n);
    }

    @Override
    public void clearQFilter() {
        this.theModel.clearQFilter();
        if (this.theSavedViewMode != null) {
            this.theViewMode = this.theSavedViewMode;
            this.theSavedViewMode = null;
        }
        this.theModel.resetModel(this.thePC, this.theViewMode, false);
        this.theTable.updateUI();
    }

    @Override
    public int getInitialChoice() {
        return this.theViewMode.ordinal();
    }

    @Override
    public List<String> getViewChoices() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add(PropertyFactory.getString("in_typeName"));
        arrayList.add(PropertyFactory.getString("in_nameLabel"));
        arrayList.add(PropertyFactory.getString("in_preReqTree"));
        arrayList.add(PropertyFactory.getString("in_sourceName"));
        return arrayList;
    }

    @Override
    public void setQFilter(String string) {
        this.theModel.setQFilter(string);
        if (this.theSavedViewMode == null) {
            this.theSavedViewMode = this.theViewMode;
        }
        this.theViewMode = ViewMode.NAMEONLY;
        this.theModel.resetModel(this.thePC, this.theViewMode, false);
        this.theTable.updateUI();
    }

    @Override
    public void viewChanged(int n) {
        this.setViewMode(n);
        this.rebuildView();
    }

    public void rebuildView() {
        if (this.theTable != null) {
            List<String> list = this.theTable.getExpandedPaths();
            this.theModel.resetModel(this.thePC, this.theViewMode, false);
            if (this.theSorter != null) {
                this.theSorter.sortNodeOnColumn();
            }
            this.theTable.updateUI();
            this.theTable.expandPathList(list);
        }
    }

    public void update() {
        if (this.theTable != null) {
            List<String> list = this.theTable.getExpandedPaths();
            int n = this.theTable.getSelectedRow();
            Object object = null;
            if (n >= 0) {
                object = this.theTable.getValueAt(n, 0);
            }
            this.theModel.setAbilityList(this.getAbilityList(), this.thePC);
            if (this.theSorter != null) {
                this.theSorter.setRoot((PObjectNode)this.theModel.getRoot());
                this.theSorter.sortNodeOnColumn();
            }
            this.theTable.updateUI();
            this.theTable.expandPathList(list);
            this.removeListSelectionListener();
            if (object != null && n < this.theTable.getRowCount()) {
                this.theTable.addRowSelectionInterval(n, n);
            }
            this.addListSelectionListener();
        }
    }

    public void addFilterer(Filterable filterable) {
        this.theFilter = filterable;
    }

    @Override
    public boolean accept(ViewMode viewMode, Ability ability) {
        if (ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT && ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DISPLAY_ONLY) {
            return false;
        }
        return this.theFilter == null || this.theFilter.accept(this.getPC(), ability);
    }

    String getFullOptionKey() {
        return this.theOptionsRoot + "." + this.getOptionKey();
    }

    public void setCategory(AbilityCategory abilityCategory) {
        this.theCategoryList = new ArrayList<AbilityCategory>();
        this.theCategoryList.add(abilityCategory);
        if (this.theModel != null) {
            this.theModel.setCurrentAbilityCategory(abilityCategory);
        }
    }

    public void setCategories(List<AbilityCategory> list) {
        this.theCategoryList = new ArrayList<AbilityCategory>();
        this.theCategoryList.addAll(list);
        if (this.theModel != null) {
            this.theModel.setAbilityCategories(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewMode {
        TYPENAME,
        NAMEONLY,
        PREREQTREE,
        SOURCENAME;

    }
}

