/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.DescriptionFormatting;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.tabs.ability.AbilitySelectionPanel;
import pcgen.gui.tabs.ability.IAbilityListFilter;
import pcgen.gui.tabs.ability.PCAbilityCategory;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityModel
extends AbstractTreeTableModel
implements TableColumnManagerModel {
    private AbilitySelectionPanel.ViewMode theViewMode = AbilitySelectionPanel.ViewMode.TYPENAME;
    private PlayerCharacter thePC = null;
    private Map<AbilityCategory, List<Ability>> theAbilityList;
    private List<AbilityCategory> theCategoryList;
    private AbilityCategory currAbilityCat;
    private boolean useCategoryRoot;
    private IAbilityListFilter theFilter = null;
    private String theOptionsRoot = "InfoAbility.";
    private PObjectNode typeRoot = null;
    private PObjectNode sourceRoot = null;
    private PObjectNode categoryRoot = null;

    public AbilityModel(PlayerCharacter playerCharacter, List<Ability> list, AbilityCategory abilityCategory, AbilitySelectionPanel.ViewMode viewMode, String string) {
        super(null);
        this.thePC = playerCharacter;
        this.theAbilityList = new HashMap<AbilityCategory, List<Ability>>();
        this.theAbilityList.put(abilityCategory, list);
        this.theOptionsRoot = string;
        this.theViewMode = viewMode;
        this.theCategoryList = new ArrayList<AbilityCategory>();
        this.theCategoryList.add(abilityCategory);
        this.currAbilityCat = abilityCategory;
        this.useCategoryRoot = false;
        this.setPanelSpecificDefaults();
        for (Column column : Column.values()) {
            column.setVisible(SettingsHandler.getPCGenOption(this.theOptionsRoot + ".viewcol." + column.toString(), column.isVisible()));
        }
        this.resetModel(this.thePC, viewMode, false);
    }

    public AbilityModel(PlayerCharacter playerCharacter, Map<AbilityCategory, List<Ability>> map, List<AbilityCategory> list, AbilitySelectionPanel.ViewMode viewMode, String string, boolean bl) {
        super(null);
        this.thePC = playerCharacter;
        this.theAbilityList = map;
        this.theOptionsRoot = string;
        this.theViewMode = viewMode;
        this.theCategoryList = list;
        this.useCategoryRoot = bl;
        this.currAbilityCat = this.theCategoryList.get(0);
        this.setPanelSpecificDefaults();
        for (Column column : Column.values()) {
            column.setVisible(SettingsHandler.getPCGenOption(this.theOptionsRoot + ".viewcol." + column.toString(), column.isVisible()));
        }
        this.resetModel(this.thePC, viewMode, false);
    }

    private void setPanelSpecificDefaults() {
        if (this.theOptionsRoot.indexOf("selected") >= 0) {
            Column.CHOICES.setVisible(true);
        }
    }

    private void buildDefaultRoots() {
        this.categoryRoot = this.buildCategoryRoot();
        if (this.typeRoot != null) {
            return;
        }
        this.typeRoot = new PObjectNode();
        this.sourceRoot = new PObjectNode();
        this.addTypeNodes(this.typeRoot, Globals.getAbilityList(this.currAbilityCat));
        this.addSourceNodes(this.sourceRoot, Globals.getAbilityList(this.currAbilityCat));
    }

    private void addTypeNodes(PObjectNode pObjectNode, List<Ability> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Ability ability : list) {
            if (ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT && ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DISPLAY_ONLY) continue;
            for (Type object : ability.getTrueTypeList(true)) {
                treeSet.add(object.toString());
            }
        }
        PObjectNode[] pObjectNodeArray = new PObjectNode[treeSet.size()];
        int n = 0;
        for (String string : treeSet) {
            pObjectNodeArray[n] = new PObjectNode();
            pObjectNodeArray[n].setItem(string);
            pObjectNodeArray[n].setParent(pObjectNode);
            ++n;
        }
        pObjectNode.setChildren(pObjectNodeArray);
    }

    private void addSourceNodes(PObjectNode pObjectNode, List<Ability> list) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (Ability ability : list) {
            Object object;
            if (ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT && ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DISPLAY_ONLY || ((String)(object = SourceFormat.getFormattedString(ability, SourceFormat.MEDIUM, false))).length() == 0) continue;
            treeSet.add(object);
        }
        PObjectNode[] pObjectNodeArray = new PObjectNode[treeSet.size()];
        int n = 0;
        for (String string : treeSet) {
            pObjectNodeArray[n] = new PObjectNode();
            pObjectNodeArray[n].setItem(string);
            pObjectNodeArray[n].setParent(pObjectNode);
            ++n;
        }
        pObjectNode.setChildren(pObjectNodeArray);
    }

    private PObjectNode buildCategoryRoot() {
        PObjectNode pObjectNode = new PObjectNode();
        ArrayList<PObjectNode> arrayList = new ArrayList<PObjectNode>();
        for (AbilityCategory abilityCategory : this.theCategoryList) {
            if (!abilityCategory.isVisible(this.thePC)) continue;
            PCAbilityCategory pCAbilityCategory = new PCAbilityCategory(abilityCategory, this.thePC);
            PObjectNode pObjectNode2 = new PObjectNode();
            pObjectNode2.setItem(pCAbilityCategory);
            pObjectNode2.setParent(pObjectNode);
            arrayList.add(pObjectNode2);
        }
        pObjectNode.setChildren(arrayList);
        return pObjectNode;
    }

    public void setViewMode(AbilitySelectionPanel.ViewMode viewMode) {
        this.theViewMode = viewMode;
    }

    public void setAbilityFilter(IAbilityListFilter iAbilityListFilter) {
        this.theFilter = iAbilityListFilter;
        this.resetModel(this.thePC, this.theViewMode, false);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == Column.NAME.ordinal()) {
            return TreeTableModel.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int n) {
        return Column.values()[n].getName();
    }

    @Override
    public Object getRoot() {
        return super.getRoot();
    }

    @Override
    public Object getValueAt(Object object, int n) {
        PObjectNode pObjectNode = (PObjectNode)object;
        Object object2 = null;
        Ability ability = null;
        Object object3 = pObjectNode.getItem();
        if (object3 instanceof Ability) {
            ability = (Ability)object3;
        }
        Column column = Column.values()[n];
        switch (column) {
            case NAME: {
                object2 = pObjectNode.toString();
                break;
            }
            case TYPE: {
                if (ability == null) break;
                object2 = StringUtil.join(ability.getTrueTypeList(true), ". ");
                break;
            }
            case COST: {
                if (ability == null) break;
                object2 = ability.getSafe(ObjectKey.SELECTION_COST);
                break;
            }
            case MULTIPLES: {
                if (ability == null) break;
                if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                    object2 = PropertyFactory.getString("in_yes");
                    break;
                }
                object2 = PropertyFactory.getString("in_no");
                break;
            }
            case STACKS: {
                if (ability == null) break;
                if (ability.getSafe(ObjectKey.STACKS).booleanValue()) {
                    object2 = PropertyFactory.getString("in_yes");
                    break;
                }
                object2 = PropertyFactory.getString("in_no");
                break;
            }
            case REQUIREMENTS: {
                if (ability == null) break;
                object2 = PrereqHandler.toHtmlString(ability.getPrerequisiteList());
                break;
            }
            case DESCRIPTION: {
                if (ability == null) break;
                object2 = DescriptionFormatting.piDescSubString(this.thePC, ability);
                break;
            }
            case CHOICES: {
                object2 = pObjectNode.getChoices();
                break;
            }
            case SOURCE: {
                object2 = pObjectNode.getSource();
            }
        }
        return object2;
    }

    private void setRoot(PObjectNode pObjectNode) {
        super.setRoot(pObjectNode.clone());
    }

    private void buildTreeNameOnly(boolean bl) {
        super.setRoot(new PObjectNode());
        this.buildSubTreeNameOnly(bl, (PObjectNode)super.getRoot(), this.theAbilityList.get(this.currAbilityCat));
    }

    private void buildSubTreeNameOnly(boolean bl, PObjectNode pObjectNode, List<Ability> list) {
        String string = this.getQFilter();
        for (Ability ability : list) {
            if (!bl && this.theFilter != null && !this.theFilter.accept(this.theViewMode, ability)) continue;
            PObjectNode pObjectNode2 = new PObjectNode();
            pObjectNode2.setParent(pObjectNode);
            switch (ability.getAbilityNature()) {
                case AUTOMATIC: {
                    pObjectNode2.setColor(SettingsHandler.getFeatAutoColor());
                    break;
                }
                case VIRTUAL: {
                    pObjectNode2.setColor(SettingsHandler.getFeatVirtualColor());
                }
            }
            pObjectNode2.setItem(ability);
            if (string != null && ability.getDisplayName().toLowerCase().indexOf(string) < 0 && ability.getType().toLowerCase().indexOf(string) < 0) continue;
            pObjectNode.addChild(pObjectNode2);
        }
    }

    private void buildTreePrereqTree(boolean bl) {
        this.setRoot(new PObjectNode());
        this.buildSubTreePrereqTree(bl, (PObjectNode)super.getRoot(), this.theAbilityList.get(this.currAbilityCat));
    }

    private void buildSubTreePrereqTree(boolean bl, PObjectNode pObjectNode, List<Ability> list) {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (Ability ability : list) {
            if (!bl && this.theFilter != null && !this.theFilter.accept(this.theViewMode, ability)) continue;
            arrayList.add(ability);
        }
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Ability ability = (Ability)arrayList.get(i);
            if (ability.hasPreReqTypeOf("FEAT") || ability.hasPreReqTypeOf("ABILITY")) continue;
            arrayList.remove(ability);
            arrayList2.add(ability);
            --i;
        }
        if (pObjectNode == null) {
            return;
        }
        PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            pObjectNodeArray[i] = this.createAbilityPObjectNode(pObjectNode, (Ability)arrayList2.get(i));
        }
        pObjectNode.setChildren(pObjectNodeArray);
        ArrayList arrayList3 = new ArrayList(arrayList);
        int n = 6;
        while (arrayList.size() > 0 && n-- > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Ability ability = (Ability)arrayList.get(i);
                boolean bl2 = false;
                ArrayList<Prerequisite> arrayList4 = new ArrayList<Prerequisite>();
                for (Cloneable cloneable : ability.getPrerequisiteList()) {
                    if (!PrerequisiteUtilities.hasPreReqKindOf(cloneable, "FEAT") && !PrerequisiteUtilities.hasPreReqKindOf(cloneable, "ABILITY")) continue;
                    arrayList4.add((Prerequisite)cloneable);
                }
                for (int j = 0; j < pObjectNode.getChildCount(); ++j) {
                    Cloneable cloneable;
                    cloneable = pObjectNode.getChild(j);
                    bl2 |= this.placedThisFeatInThisTree(ability, (PObjectNode)cloneable, arrayList4);
                }
                if (!bl2) continue;
                arrayList3.remove(ability);
            }
        }
        this.pruneDuplicatesFromTree(pObjectNode);
        if (arrayList3.size() > 0) {
            PObjectNode[] pObjectNodeArray2 = new PObjectNode[arrayList3.size()];
            for (int i = 0; i < arrayList3.size(); ++i) {
                pObjectNodeArray2[i] = this.createAbilityPObjectNode(pObjectNode, (Ability)arrayList3.get(i));
                pObjectNode.addChild(pObjectNodeArray2[i], true);
            }
        }
    }

    private void pruneDuplicatesFromTree(PObjectNode pObjectNode) {
        if (pObjectNode == null || pObjectNode.getChildCount() == 0) {
            return;
        }
        ArrayList<PObjectNode> arrayList = new ArrayList<PObjectNode>();
        for (PObjectNode pObjectNode2 : pObjectNode.getChildren()) {
            for (PObjectNode pObjectNode3 : pObjectNode.getChildren()) {
                if (pObjectNode3 == pObjectNode2 || !this.hasChild(pObjectNode3, pObjectNode2.getItem())) continue;
                arrayList.add(pObjectNode2);
                break;
            }
            this.pruneDuplicatesFromTree(pObjectNode2);
        }
        for (PObjectNode pObjectNode2 : arrayList) {
            pObjectNode.getChildren().remove(pObjectNode2);
        }
    }

    private boolean hasChild(PObjectNode pObjectNode, Object object) {
        if (pObjectNode == null || pObjectNode.getChildCount() == 0) {
            return false;
        }
        for (PObjectNode pObjectNode2 : pObjectNode.getChildren()) {
            if (object == pObjectNode2.getItem()) {
                return true;
            }
            if (!this.hasChild(pObjectNode2, object)) continue;
            return true;
        }
        return false;
    }

    private PObjectNode createAbilityPObjectNode(PObjectNode pObjectNode, Ability ability) {
        PObjectNode pObjectNode2 = new PObjectNode();
        pObjectNode2.setItem(ability);
        pObjectNode2.setParent(pObjectNode);
        switch (ability.getAbilityNature()) {
            case AUTOMATIC: {
                pObjectNode2.setColor(SettingsHandler.getFeatAutoColor());
                break;
            }
            case VIRTUAL: {
                pObjectNode2.setColor(SettingsHandler.getFeatVirtualColor());
            }
        }
        return pObjectNode2;
    }

    private void buildTreeTypeName(boolean bl) {
        if (this.typeRoot == null) {
            return;
        }
        this.setRoot(this.typeRoot);
        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
        if (pObjectNode == null) {
            return;
        }
        this.buildSubTreeTypeName(bl, pObjectNode, this.theAbilityList.get(this.currAbilityCat));
    }

    private void buildSubTreeTypeName(boolean bl, PObjectNode pObjectNode, List<Ability> list) {
        for (Ability ability : list) {
            if (!bl && this.theFilter != null && !this.theFilter.accept(this.theViewMode, ability)) continue;
            for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                if (!ability.isType(pObjectNode.getChild(i).toString())) continue;
                PObjectNode pObjectNode2 = new PObjectNode();
                switch (ability.getAbilityNature()) {
                    case AUTOMATIC: {
                        pObjectNode2.setColor(SettingsHandler.getFeatAutoColor());
                        break;
                    }
                    case VIRTUAL: {
                        pObjectNode2.setColor(SettingsHandler.getFeatVirtualColor());
                    }
                }
                pObjectNode2.setParent(pObjectNode.getChild(i));
                pObjectNode2.setItem(ability);
                pObjectNode.getChild(i).addChild(pObjectNode2);
            }
        }
    }

    private void buildTreeSourceName(boolean bl) {
        if (this.sourceRoot == null) {
            return;
        }
        this.setRoot(this.sourceRoot);
        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
        if (pObjectNode == null) {
            return;
        }
        this.buildSubTreeSourceName(bl, pObjectNode, this.theAbilityList.get(this.currAbilityCat));
    }

    private void buildSubTreeSourceName(boolean bl, PObjectNode pObjectNode, List<Ability> list) {
        HashMap<String, PObjectNode> hashMap = new HashMap<String, PObjectNode>();
        for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
            PObjectNode cloneable = pObjectNode.getChild(i);
            hashMap.put(cloneable.toString(), cloneable);
        }
        for (Ability ability : list) {
            PObjectNode pObjectNode2;
            if (!bl && this.theFilter != null && !this.theFilter.accept(this.theViewMode, ability)) continue;
            String string = SourceFormat.getFormattedString(ability, SourceFormat.MEDIUM, false);
            if (string == null || string.trim().length() == 0) {
                string = "None";
            }
            if ((pObjectNode2 = (PObjectNode)hashMap.get(string)) == null) {
                pObjectNode.addChild(this.createAbilityPObjectNode(pObjectNode, ability), true);
                continue;
            }
            pObjectNode2.addChild(this.createAbilityPObjectNode(pObjectNode2, ability));
        }
    }

    private boolean placedThisFeatInThisTree(Ability ability, PObjectNode pObjectNode, List<Prerequisite> list) {
        Ability ability2 = (Ability)pObjectNode.getItem();
        boolean bl = false;
        for (Prerequisite prerequisite : list) {
            int n;
            if (PrerequisiteUtilities.hasPreReqMatching(prerequisite, "FEAT", ability2.getKeyName()) || PrerequisiteUtilities.hasPreReqMatching(prerequisite, "ABILITY", ability2.getKeyName())) {
                n = ability.equals(ability2);
                if (pObjectNode.getChildCount() > 0) {
                    for (PObjectNode pObjectNode2 : pObjectNode.getChildren()) {
                        if (!ability.equals(pObjectNode2.getItem())) continue;
                        n = 1;
                        break;
                    }
                }
                if (n == 0) {
                    PObjectNode pObjectNode3 = this.createAbilityPObjectNode(pObjectNode, ability);
                    pObjectNode.addChild(pObjectNode3);
                    bl = true;
                }
            }
            for (n = 0; n < pObjectNode.getChildCount(); ++n) {
                boolean bl2 = this.placedThisFeatInThisTree(ability, pObjectNode.getChild(n), list);
                if (!bl2) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void setCurrentAbilityCategory(AbilityCategory abilityCategory) {
        this.currAbilityCat = abilityCategory;
        this.typeRoot = null;
        this.sourceRoot = null;
    }

    public void setAbilityCategories(List<AbilityCategory> list) {
        this.theCategoryList = list;
        this.currAbilityCat = this.theCategoryList.get(0);
        this.typeRoot = null;
        this.sourceRoot = null;
    }

    public void setAbilityList(Map<AbilityCategory, List<Ability>> map, PlayerCharacter playerCharacter) {
        this.theAbilityList = map;
        this.resetModel(playerCharacter, this.theViewMode, false);
    }

    public void resetModel(PlayerCharacter playerCharacter, AbilitySelectionPanel.ViewMode viewMode, boolean bl) {
        this.thePC = playerCharacter;
        this.buildDefaultRoots();
        if (this.useCategoryRoot) {
            this.buildTreeCategory(bl, viewMode);
        } else {
            switch (viewMode) {
                case TYPENAME: {
                    this.buildTreeTypeName(bl);
                    break;
                }
                case NAMEONLY: {
                    this.buildTreeNameOnly(bl);
                    break;
                }
                case PREREQTREE: {
                    this.buildTreePrereqTree(bl);
                    break;
                }
                case SOURCENAME: {
                    this.buildTreeSourceName(bl);
                }
            }
        }
        if (super.getRoot() != null) {
            this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
        }
    }

    private void buildTreeCategory(boolean bl, AbilitySelectionPanel.ViewMode viewMode) {
        if (this.categoryRoot == null) {
            return;
        }
        this.setRoot(this.categoryRoot);
        PObjectNode pObjectNode = (PObjectNode)super.getRoot();
        for (PObjectNode pObjectNode2 : pObjectNode.getChildren()) {
            PCAbilityCategory pCAbilityCategory = (PCAbilityCategory)pObjectNode2.getItem();
            List<Ability> list = this.theAbilityList.get(pCAbilityCategory.getCategory());
            if (list == null) {
                list = new ArrayList<Ability>();
            }
            switch (viewMode) {
                case TYPENAME: {
                    this.addTypeNodes(pObjectNode2, list);
                    this.buildSubTreeTypeName(bl, pObjectNode2, list);
                    break;
                }
                case NAMEONLY: {
                    this.buildSubTreeNameOnly(bl, pObjectNode2, list);
                    break;
                }
                case PREREQTREE: {
                    this.buildSubTreePrereqTree(bl, pObjectNode2, list);
                    break;
                }
                case SOURCENAME: {
                    this.addSourceNodes(pObjectNode2, list);
                    this.buildSubTreeSourceName(bl, pObjectNode2, list);
                }
            }
        }
    }

    @Override
    public List<String> getMColumnList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Column[] columnArray = Column.values();
        for (int i = 1; i < columnArray.length; ++i) {
            arrayList.add(columnArray[i].getName());
        }
        return arrayList;
    }

    @Override
    public boolean isMColumnDisplayed(int n) {
        return Column.values()[n].isVisible();
    }

    private void setColumnOption(Column column, String string, String string2) {
        SettingsHandler.setPCGenOption(this.theOptionsRoot + "." + string + "." + column.toString(), string2);
    }

    private int getColumnOption(Column column, String string, int n) {
        return SettingsHandler.getPCGenOption(this.theOptionsRoot + "." + string + "." + column.toString(), n);
    }

    @Override
    public void setMColumnDisplayed(int n, boolean bl) {
        Column.values()[n].setVisible(bl);
        this.setColumnOption(Column.values()[n], "viewcol", String.valueOf(bl));
    }

    @Override
    public int getMColumnOffset() {
        return 1;
    }

    @Override
    public int getMColumnDefaultWidth(int n) {
        return this.getColumnOption(Column.values()[n], "sizecol", Column.values()[n].getWidth());
    }

    @Override
    public void setMColumnDefaultWidth(int n, int n2) {
        Column.values()[n].setWidth(n2);
        this.setColumnOption(Column.values()[n], "sizecol", String.valueOf(n2));
    }

    @Override
    public void resetMColumn(int n, TableColumn tableColumn) {
        Column column = Column.values()[n];
        switch (column) {
            case COST: 
            case MULTIPLES: 
            case STACKS: {
                tableColumn.setCellRenderer(new JTableEx.AlignCellRenderer(0));
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Column {
        NAME("AbilityModel.Columns.Name", 100, true),
        TYPE("AbilityModel.Columns.Type", 100, false),
        COST("AbilityModel.Columns.Cost", 100, false),
        MULTIPLES("AbilityModel.Columns.Multiples", 100, false),
        STACKS("AbilityModel.Columns.Stacks", 100, false),
        REQUIREMENTS("AbilityModel.Columns.Requirements", 100, false),
        DESCRIPTION("AbilityModel.Columns.Description", 100, false),
        CHOICES("AbilityModel.Columns.Choices", 100, false),
        SOURCE("AbilityModel.Columns.Source", 100, false);

        private String theName;
        private int theWidth;
        private boolean theVisibleFlag;

        private Column(String string2, int n2, boolean bl) {
            this.theName = PropertyFactory.getString(string2);
            this.theWidth = n2;
            this.theVisibleFlag = bl;
        }

        public void setWidth(int n) {
            this.theWidth = n;
        }

        public int getWidth() {
            return this.theWidth;
        }

        public String getName() {
            return this.theName;
        }

        public void setVisible(boolean bl) {
            this.theVisibleFlag = bl;
        }

        public boolean isVisible() {
            return this.theVisibleFlag;
        }

        public static Column get(int n) {
            return Column.values()[n];
        }
    }
}

