/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.prefs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.table.AbstractTableModel;
import pcgen.core.CustomData;
import pcgen.core.Globals;
import pcgen.core.PointBuyMethod;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.prefs.NewPurchaseMethodDialog;
import pcgen.gui.utils.JComboBoxEx;

public final class PurchaseModeFrame
extends JDialog {
    static final long serialVersionUID = -5244500546425680322L;
    private static String s_TITLE = "Purchase Mode Configuration";
    private static final int STANDARD_MIN_PURCHASE_SCORE = 8;
    private static final int STANDARD_MAX_PURCHASE_SCORE = 18;
    private JButton addMethodButton = null;
    private JButton cancelButton;
    private JButton okButton;
    private JButton purchaseScoreMaxDecreaseButton;
    private JButton purchaseScoreMaxIncreaseButton;
    private JButton purchaseScoreMinDecreaseButton;
    private JButton purchaseScoreMinIncreaseButton;
    private JButton removeMethodButton = null;
    private JButton resetButton;
    private JComboBoxEx currentPurchaseMethods = null;
    private JLabel methodPointsLabel = null;
    private JLabel purchaseScoreMaxLabel;
    private JLabel purchaseScoreMinLabel;
    private JLabel savedMethodLabel = null;
    private JLabel statusBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel purchaseMethodButtonPanel;
    private JPanel purchaseMethodNamePanel;
    private JPanel purchaseMethodPanel;
    private JPanel purchaseMethodPointsPanel;
    private JScrollPane jScrollPane1;
    private JTable abilityScoreCostTable;
    private JTextField purchaseMethodPointsEdit;
    private JTextField purchaseScoreMaxEdit;
    private JTextField purchaseScoreMinEdit;
    private PurchaseModel purchaseModel = null;

    public PurchaseModeFrame() {
        this.initComponents();
    }

    public PurchaseModeFrame(JDialog jDialog) {
        super(jDialog);
        this.initComponents();
    }

    public static void main(String[] stringArray) {
        new PurchaseModeFrame().setVisible(true);
    }

    private void addMethodButtonActionPerformed() {
        NewPurchaseMethodDialog newPurchaseMethodDialog = new NewPurchaseMethodDialog(this, true);
        newPurchaseMethodDialog.setVisible(true);
        if (!newPurchaseMethodDialog.getWasCancelled()) {
            String string = newPurchaseMethodDialog.getEnteredName();
            if (SettingsHandler.getGame().getPurchaseMethodByName(string) == null) {
                PointBuyMethod pointBuyMethod = new PointBuyMethod(string, Integer.toString(newPurchaseMethodDialog.getEnteredPoints()));
                this.currentPurchaseMethods.addItem(pointBuyMethod);
                this.currentPurchaseMethods.setSelectedItem(pointBuyMethod);
            } else {
                ShowMessageDelegate.showMessageDialog("Cannot add method. Name already exists.", "PCGen", MessageType.ERROR);
            }
        }
    }

    private void cancelButtonActionPerformed() {
        this.dispose();
    }

    private int convertStringToInt(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    private void currentPurchaseMethodsActionPerformed() {
        PointBuyMethod pointBuyMethod = (PointBuyMethod)this.currentPurchaseMethods.getSelectedItem();
        if (pointBuyMethod == null) {
            this.removeMethodButton.setEnabled(false);
            this.purchaseMethodPointsEdit.setText("");
        } else {
            this.purchaseMethodPointsEdit.setText(pointBuyMethod.getPointFormula());
            this.removeMethodButton.setEnabled(true);
        }
    }

    private void exitForm() {
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.purchaseScoreMinIncreaseButton = new JButton();
        this.purchaseScoreMinDecreaseButton = new JButton();
        this.purchaseScoreMaxIncreaseButton = new JButton();
        this.purchaseScoreMaxDecreaseButton = new JButton();
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.purchaseScoreMinLabel = new JLabel();
        this.purchaseScoreMinEdit = new JTextField();
        this.purchaseScoreMaxLabel = new JLabel();
        this.purchaseScoreMaxEdit = new JTextField();
        this.statusBar = new JLabel();
        this.jPanel2 = new JPanel();
        this.currentPurchaseMethods = new JComboBoxEx();
        this.currentPurchaseMethods.setAutoSort(true);
        this.savedMethodLabel = new JLabel();
        this.methodPointsLabel = new JLabel();
        this.purchaseMethodPointsEdit = new JTextField();
        this.purchaseMethodPanel = new JPanel();
        this.purchaseMethodNamePanel = new JPanel();
        this.purchaseMethodPointsPanel = new JPanel();
        this.purchaseMethodButtonPanel = new JPanel();
        this.addMethodButton = new JButton();
        this.removeMethodButton = new JButton();
        this.jPanel3 = new JPanel();
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomData.writePurchaseModeConfiguration();
            }
        });
        this.jScrollPane1 = new JScrollPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle(s_TITLE);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PurchaseModeFrame.this.exitForm();
            }
        });
        this.jPanel1.setLayout(new FlowLayout(0, 2, 5));
        this.purchaseScoreMinLabel.setText("Purchase Score Min:");
        this.purchaseScoreMinLabel.setToolTipText("The ability score can not go below this value");
        this.purchaseScoreMinLabel.setPreferredSize(new Dimension(140, 15));
        this.jPanel1.add(this.purchaseScoreMinLabel);
        this.purchaseScoreMinEdit.setHorizontalAlignment(4);
        this.purchaseScoreMinEdit.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMinEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.purchaseScoreMinValueActionPerformed();
            }
        });
        this.purchaseScoreMinEdit.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PurchaseModeFrame.this.purchaseScoreMinValueActionPerformed();
            }
        });
        this.jPanel1.add(this.purchaseScoreMinEdit);
        this.purchaseScoreMinIncreaseButton.setText("+");
        this.purchaseScoreMinIncreaseButton.setToolTipText("Increase score minimum");
        this.purchaseScoreMinIncreaseButton.setMargin(new Insets(2, 2, 2, 2));
        this.purchaseScoreMinIncreaseButton.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMinIncreaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.purchaseScoreMinIncreaseButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.purchaseScoreMinIncreaseButton);
        this.purchaseScoreMinDecreaseButton.setText("-");
        this.purchaseScoreMinDecreaseButton.setToolTipText("Decrease score minimum");
        this.purchaseScoreMinDecreaseButton.setMargin(new Insets(2, 2, 2, 2));
        this.purchaseScoreMinDecreaseButton.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMinDecreaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.purchaseScoreMinDecreaseButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.purchaseScoreMinDecreaseButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new FlowLayout(0, 2, 5));
        this.purchaseScoreMaxLabel.setText("Purchase Score Max:");
        this.purchaseScoreMaxLabel.setToolTipText("The ability score can not go above this value");
        this.purchaseScoreMaxLabel.setPreferredSize(new Dimension(140, 15));
        this.jPanel2.add(this.purchaseScoreMaxLabel);
        this.purchaseScoreMaxEdit.setHorizontalAlignment(4);
        this.purchaseScoreMaxEdit.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMaxEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.purchaseScoreMaxValueActionPerformed();
            }
        });
        this.purchaseScoreMaxEdit.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PurchaseModeFrame.this.purchaseScoreMaxValueActionPerformed();
            }
        });
        this.jPanel2.add(this.purchaseScoreMaxEdit);
        this.purchaseScoreMaxIncreaseButton.setText("+");
        this.purchaseScoreMaxIncreaseButton.setToolTipText("Increase score maximum");
        this.purchaseScoreMaxIncreaseButton.setMargin(new Insets(2, 2, 2, 2));
        this.purchaseScoreMaxIncreaseButton.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMaxIncreaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.purchaseScoreMaxIncreaseButtonActionPerformed();
            }
        });
        this.jPanel2.add(this.purchaseScoreMaxIncreaseButton);
        this.purchaseScoreMaxDecreaseButton.setText("-");
        this.purchaseScoreMaxDecreaseButton.setToolTipText("Decrease score maximum");
        this.purchaseScoreMaxDecreaseButton.setMargin(new Insets(2, 2, 2, 2));
        this.purchaseScoreMaxDecreaseButton.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMaxDecreaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.purchaseScoreMaxDecreaseButtonActionPerformed();
            }
        });
        this.jPanel2.add(this.purchaseScoreMaxDecreaseButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.purchaseMethodPanel.setLayout(new GridBagLayout());
        this.purchaseMethodPanel.setBorder(BorderFactory.createTitledBorder("Allowed Points"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.purchaseMethodPanel, gridBagConstraints);
        this.purchaseMethodNamePanel.setLayout(new FlowLayout(0, 2, 5));
        this.savedMethodLabel.setText("Saved Methods:");
        this.savedMethodLabel.setPreferredSize(new Dimension(140, 15));
        this.purchaseMethodNamePanel.add(this.savedMethodLabel);
        this.purchaseMethodNamePanel.add(this.currentPurchaseMethods);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.purchaseMethodNamePanel, gridBagConstraints);
        this.purchaseMethodPanel.add((Component)this.purchaseMethodNamePanel, gridBagConstraints);
        this.purchaseMethodPointsPanel.setLayout(new FlowLayout(0, 2, 5));
        this.methodPointsLabel.setText("Points:");
        this.methodPointsLabel.setPreferredSize(new Dimension(140, 15));
        this.purchaseMethodPointsPanel.add(this.methodPointsLabel);
        this.purchaseMethodPointsEdit.setHorizontalAlignment(4);
        this.purchaseMethodPointsEdit.setEditable(false);
        this.purchaseMethodPointsEdit.setPreferredSize(new Dimension(90, 20));
        this.purchaseMethodPointsPanel.add(this.purchaseMethodPointsEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.purchaseMethodPanel.add((Component)this.purchaseMethodPointsPanel, gridBagConstraints);
        this.currentPurchaseMethods.setPreferredSize(new Dimension(140, 21));
        this.currentPurchaseMethods.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PurchaseModeFrame.this.currentPurchaseMethodsActionPerformed();
            }
        });
        this.purchaseMethodButtonPanel.setLayout(new FlowLayout(2));
        this.addMethodButton.setText("New");
        this.addMethodButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.addMethodButtonActionPerformed();
            }
        });
        this.purchaseMethodButtonPanel.add(this.addMethodButton);
        this.removeMethodButton.setText("Remove");
        this.removeMethodButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.removeMethodButtonActionPerformed();
            }
        });
        this.purchaseMethodButtonPanel.add(this.removeMethodButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.purchaseMethodPanel.add((Component)this.purchaseMethodButtonPanel, gridBagConstraints);
        this.statusBar.setText("Set the cost for each ability score");
        this.statusBar.setBorder(new BevelBorder(1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.statusBar, gridBagConstraints);
        this.jPanel3.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.setToolTipText("Accept these values");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.okButtonActionPerformed();
            }
        });
        this.jPanel3.add(this.okButton);
        this.resetButton.setText("Reset");
        this.resetButton.setToolTipText("Reset to saved values");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.resetButtonActionPerformed();
            }
        });
        this.jPanel3.add(this.resetButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel Purchase Mode Configuration");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PurchaseModeFrame.this.cancelButtonActionPerformed();
            }
        });
        this.jPanel3.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jScrollPane1.setViewportBorder(new BevelBorder(1));
        this.jScrollPane1.setPreferredSize(new Dimension(100, 200));
        this.purchaseModel = new PurchaseModel();
        this.renewAbilityScoreCostTable();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.pack();
        this.initializeCurrentPurchaseMethods();
    }

    private void initializeCurrentPurchaseMethods() {
        int n = SettingsHandler.getGame().getPurchaseMethodCount();
        if (n > 0) {
            PointBuyMethod[] pointBuyMethodArray = new PointBuyMethod[n];
            for (int i = 0; i < n; ++i) {
                pointBuyMethodArray[i] = SettingsHandler.getGame().getPurchaseMethod(i);
            }
            this.currentPurchaseMethods.setModel(new DefaultComboBoxModel<PointBuyMethod>(pointBuyMethodArray));
        }
        this.currentPurchaseMethodsActionPerformed();
    }

    private void okButtonActionPerformed() {
        this.purchaseModel.keepNewValues();
        this.dispose();
    }

    private void purchaseScoreMaxDecreaseButtonActionPerformed() {
        int n = this.purchaseModel.getPurchaseScoreMax();
        String string = this.purchaseScoreMaxEdit.getText();
        int n2 = this.convertStringToInt(string);
        if (n2 == -1) {
            this.statusBar.setText("Bad value for purchase maximum score, fixing...");
        } else if (!this.purchaseModel.setPurchaseScoreMax(n2 - 1)) {
            this.statusBar.setText("Purchase Score Maximum value can no go below Purchase Score Minimum!");
        }
        this.updatePurchaseScoreMax(n);
    }

    private void purchaseScoreMaxIncreaseButtonActionPerformed() {
        int n = this.purchaseModel.getPurchaseScoreMax();
        String string = this.purchaseScoreMaxEdit.getText();
        int n2 = this.convertStringToInt(string);
        boolean bl = false;
        if (!Globals.checkRule("ABILRANGE") && n2 >= 18) {
            this.statusBar.setText("May not increase score past 18 in standard mode");
            return;
        }
        if (n2 == -1) {
            this.statusBar.setText("Bad value for purchase maximum score, fixing...");
        } else {
            bl = this.purchaseModel.setPurchaseScoreMax(n2 + 1);
        }
        this.updatePurchaseScoreMax(n);
        if (bl) {
            this.purchaseModel.setValueAt(this.purchaseModel.predictNextPurchaseCostMax(), this.purchaseModel.getRowCount() - 1, 1);
        }
    }

    private void purchaseScoreMaxValueActionPerformed() {
        int n = this.purchaseModel.getPurchaseScoreMax();
        String string = this.purchaseScoreMaxEdit.getText();
        int n2 = this.convertStringToInt(string);
        boolean bl = false;
        if (!Globals.checkRule("ABILRANGE") && n2 > 18) {
            this.statusBar.setText("May not increase score past 18 in standard mode");
            return;
        }
        if (n2 == -1) {
            this.statusBar.setText("Bad value for purchase maximum score, fixing...");
        } else {
            bl = this.purchaseModel.setPurchaseScoreMax(n2);
        }
        this.updatePurchaseScoreMax(n);
        if (bl) {
            this.purchaseModel.setValueAt(this.purchaseModel.predictNextPurchaseCostMax(), this.purchaseModel.getRowCount() - 1, 1);
        }
    }

    private void purchaseScoreMinDecreaseButtonActionPerformed() {
        int n = this.purchaseModel.getPurchaseScoreMin();
        String string = this.purchaseScoreMinEdit.getText();
        int n2 = this.convertStringToInt(string);
        boolean bl = false;
        if (!Globals.checkRule("ABILRANGE") && n2 == 8) {
            this.statusBar.setText("May not decrease score past 8 in standard mode");
            return;
        }
        if (n2 == -1) {
            this.statusBar.setText("Bad value for purchase minimum score, fixing...");
        } else {
            bl = this.purchaseModel.setPurchaseScoreMin(n2 - 1);
            if (!bl) {
                this.statusBar.setText("Purchase Score Minimum value is 0!");
            }
        }
        this.updatePurchaseScoreMin(n);
        if (bl) {
            this.purchaseModel.setValueAt(this.purchaseModel.predictNextPurchaseCostMin(), 0, 1);
        }
    }

    private void purchaseScoreMinIncreaseButtonActionPerformed() {
        int n = this.purchaseModel.getPurchaseScoreMin();
        String string = this.purchaseScoreMinEdit.getText();
        int n2 = this.convertStringToInt(string);
        if (n2 == -1) {
            this.statusBar.setText("Bad value for purchase minimum score, fixing...");
        } else if (!this.purchaseModel.setPurchaseScoreMin(n2 + 1)) {
            this.statusBar.setText("Purchase Score Minimum value can not exceed Purchase Score Maximum Value!");
        }
        this.updatePurchaseScoreMin(n);
    }

    private void purchaseScoreMinValueActionPerformed() {
        int n = this.purchaseModel.getPurchaseScoreMin();
        String string = this.purchaseScoreMinEdit.getText();
        int n2 = this.convertStringToInt(string);
        if (n2 == -1) {
            this.statusBar.setText("Bad value for purchase minimum score, fixing...");
        } else if (!this.purchaseModel.setPurchaseScoreMin(n2)) {
            this.statusBar.setText("Purchase Score Minimum value can not exceed Purchase Score Maximum Value!");
        }
        this.updatePurchaseScoreMin(n);
    }

    private void removeMethodButtonActionPerformed() {
        PointBuyMethod pointBuyMethod = (PointBuyMethod)this.currentPurchaseMethods.getSelectedItem();
        if (pointBuyMethod != null) {
            this.currentPurchaseMethods.removeItem(pointBuyMethod);
        }
    }

    private void renewAbilityScoreCostTable() {
        this.abilityScoreCostTable = new JTable();
        this.abilityScoreCostTable.setBorder(new BevelBorder(1));
        this.abilityScoreCostTable.setModel(this.purchaseModel);
        this.abilityScoreCostTable.setToolTipText("Set the cost for each ability score");
        this.jScrollPane1.setViewportView(this.abilityScoreCostTable);
    }

    private void resetButtonActionPerformed() {
        this.purchaseModel.copySavedToCurrent();
        this.updatePurchaseScoreMin(-1);
        this.updatePurchaseScoreMax(-1);
        this.purchaseModel.fireTableStructureChanged();
        this.initializeCurrentPurchaseMethods();
    }

    private void updatePurchaseScoreMax(int n) {
        int n2 = this.purchaseModel.getPurchaseScoreMax();
        this.purchaseScoreMaxEdit.setText(Integer.toString(n2));
        if (n != -1 && n != n2) {
            this.purchaseModel.appendRows(n2 - n);
            this.purchaseModel.fireTableStructureChanged();
        }
    }

    private void updatePurchaseScoreMin(int n) {
        int n2 = this.purchaseModel.getPurchaseScoreMin();
        this.purchaseScoreMinEdit.setText(Integer.toString(n2));
        if (n != -1 && n != n2) {
            this.purchaseModel.prependRows(n2 - n);
            this.purchaseModel.resetAllCosts();
            this.purchaseModel.fireTableStructureChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PurchaseModel
    extends AbstractTableModel {
        private boolean[] canEdit = new boolean[]{false, true};
        private String[] columnHeaders = new String[]{"Ability Score", "Cost"};
        private Object[][] currentValues = null;
        private Object[][] savedValues = null;
        private Class<?>[] types = new Class[]{Integer.class, Integer.class};
        private int currentPurchaseScoreMax = 10;
        private int currentPurchaseScoreMin = 10;
        private int savedPurchaseScoreMax = 0;
        private int savedPurchaseScoreMin = 0;

        PurchaseModel() {
            this.initValues();
            this.copySavedToCurrent();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.canEdit[n2];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.types[n];
        }

        @Override
        public int getColumnCount() {
            return this.columnHeaders.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnHeaders[n];
        }

        @Override
        public int getRowCount() {
            return this.currentValues.length;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n < 0 || n >= this.currentValues.length) {
                throw new ArrayIndexOutOfBoundsException("Row index out of bounds: " + n);
            }
            if (n2 != 0 && n2 != 1) {
                throw new ArrayIndexOutOfBoundsException("Column index out of bounds: " + n2);
            }
            this.currentValues[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n < 0 || n >= this.currentValues.length) {
                throw new ArrayIndexOutOfBoundsException("Row index out of bounds: " + n);
            }
            if (n2 == 0 || n2 == 1) {
                return this.currentValues[n][n2];
            }
            throw new ArrayIndexOutOfBoundsException("Column index out of bounds: " + n2);
        }

        public void copySavedToCurrent() {
            if (this.savedValues != null) {
                this.currentPurchaseScoreMin = this.savedPurchaseScoreMin;
                this.currentPurchaseScoreMax = this.savedPurchaseScoreMax;
                int n = this.currentPurchaseScoreMax - this.currentPurchaseScoreMin + 1;
                this.currentValues = new Object[n][2];
                for (int i = 0; i < n; ++i) {
                    this.currentValues[i][0] = this.savedValues[i][0];
                    this.currentValues[i][1] = this.savedValues[i][1];
                }
            }
        }

        public void initValues() {
            int[] nArray = SettingsHandler.getGame().getAbilityScoreCost();
            if (nArray != null) {
                this.savedPurchaseScoreMin = SettingsHandler.getGame().getPurchaseScoreMin();
                this.savedPurchaseScoreMax = SettingsHandler.getGame().getPurchaseScoreMax();
                this.savedValues = new Object[nArray.length][2];
                for (int i = this.savedPurchaseScoreMin; i <= this.savedPurchaseScoreMax; ++i) {
                    int n = i - this.savedPurchaseScoreMin;
                    this.savedValues[n][0] = i;
                    this.savedValues[n][1] = nArray[n];
                }
            } else {
                this.savedPurchaseScoreMin = 10;
                this.savedPurchaseScoreMax = 10;
                nArray = new int[]{0};
                this.savedValues = new Object[1][2];
                this.savedValues[0][0] = 10;
                this.savedValues[0][1] = 0;
            }
            PurchaseModeFrame.this.purchaseScoreMinEdit.setText(Integer.toString(this.savedPurchaseScoreMin));
            PurchaseModeFrame.this.purchaseScoreMaxEdit.setText(Integer.toString(this.savedPurchaseScoreMax));
        }

        public int predictNextPurchaseCostMax() {
            int n = this.getRowCount() - 2;
            int n2 = (Integer)this.getValueAt(n, 1);
            if (this.getRowCount() == 2) {
                return n2 + 1;
            }
            int n3 = (Integer)this.getValueAt(n - 1, 1);
            return n2 + (n2 - n3);
        }

        public int predictNextPurchaseCostMin() {
            int n = 1;
            int n2 = (Integer)this.getValueAt(n, 1);
            if (this.getRowCount() == 2) {
                return n2 - 1;
            }
            int n3 = (Integer)this.getValueAt(n + 1, 1);
            return n2 - (n3 - n2);
        }

        boolean setPurchaseScoreMax(int n) {
            if (n >= 0 && n >= this.currentPurchaseScoreMin) {
                this.currentPurchaseScoreMax = n;
                return true;
            }
            return false;
        }

        int getPurchaseScoreMax() {
            return this.currentPurchaseScoreMax;
        }

        boolean setPurchaseScoreMin(int n) {
            if (n >= 0 && n <= this.currentPurchaseScoreMax) {
                this.currentPurchaseScoreMin = n;
                return true;
            }
            return false;
        }

        int getPurchaseScoreMin() {
            return this.currentPurchaseScoreMin;
        }

        void appendRows(int n) {
            int n2 = this.currentPurchaseScoreMax - this.currentPurchaseScoreMin + 1;
            Object[][] objectArray = new Object[n2][2];
            if (n < 0) {
                System.arraycopy(this.currentValues, 0, objectArray, 0, n2);
            } else {
                System.arraycopy(this.currentValues, 0, objectArray, 0, this.currentValues.length);
                int n3 = this.currentValues.length;
                for (int i = 0; i < n; ++i) {
                    int n4 = i + this.currentPurchaseScoreMax - n + 1;
                    int n5 = -1;
                    objectArray[i + n3][0] = n4;
                    if (i + n3 != 0) {
                        n5 = (Integer)objectArray[i + n3 - 1][1];
                    }
                    objectArray[i + n3][1] = n5 + 1;
                }
            }
            this.currentValues = objectArray;
        }

        void keepNewValues() {
            int n;
            SettingsHandler.getGame().clearPointBuyStatCosts();
            for (n = this.currentPurchaseScoreMin; n <= this.currentPurchaseScoreMax; ++n) {
                SettingsHandler.getGame().addPointBuyStatCost(n, (Integer)this.currentValues[n - this.currentPurchaseScoreMin][1]);
            }
            SettingsHandler.getGame().clearPurchaseModeMethods();
            int n2 = PurchaseModeFrame.this.currentPurchaseMethods.getItemCount();
            for (n = 0; n < n2; ++n) {
                PointBuyMethod pointBuyMethod = (PointBuyMethod)PurchaseModeFrame.this.currentPurchaseMethods.getItemAt(n);
                SettingsHandler.getGame().addPurchaseModeMethod(pointBuyMethod.getMethodName(), pointBuyMethod.getPointFormula());
            }
        }

        void prependRows(int n) {
            int n2 = this.currentPurchaseScoreMax - this.currentPurchaseScoreMin + 1;
            Object[][] objectArray = new Object[n2][2];
            if (n > 0) {
                System.arraycopy(this.currentValues, n, objectArray, 0, n2);
            } else {
                n = Math.abs(n);
                System.arraycopy(this.currentValues, 0, objectArray, n, this.currentValues.length);
                for (int i = 0; i < n; ++i) {
                    int n3 = i + this.currentPurchaseScoreMin;
                    objectArray[i][0] = n3;
                }
            }
            this.currentValues = objectArray;
        }

        void resetAllCosts() {
            int n = 0;
            for (int i = 0; i < this.currentValues.length; ++i) {
                this.currentValues[i][1] = n++;
            }
        }
    }
}

