/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.prefs.PCGenPrefsPanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public class CopySettingsPanel
extends PCGenPrefsPanel {
    private static String in_copy_settings = PropertyFactory.getString("in_Prefs_copy");
    private JComboBoxEx gameModeSelect = new JComboBoxEx();
    private JButton copyButton = new JButton(PropertyFactory.getString("in_copy"));
    private List<PCGenPrefsPanel> affectedPanels = new ArrayList<PCGenPrefsPanel>();

    public CopySettingsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, in_copy_settings);
        titledBorder.setTitleJustification(1);
        this.setBorder(titledBorder);
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.gameModeSelect.setAllItems(SystemCollections.getUnmodifiableGameModeList().toArray());
        this.gameModeSelect.sortItems();
        Utility.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0.0, 0.0);
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_Prefs_copyFrom"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.gameModeSelect, gridBagConstraints);
        this.add(this.gameModeSelect);
        Utility.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getFormattedString("in_Prefs_copyTo", SettingsHandler.getGame().getName()));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 4, 1, 1, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(this.copyButton, gridBagConstraints);
        this.add(this.copyButton);
        this.copyButton.addActionListener(new CopyButtonListener());
        Utility.buildConstraints(gridBagConstraints, 0, 2, 4, 1, 0.0, 0.0);
        jLabel = new JLabel(PropertyFactory.getString("in_Prefs_copyDesc"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 5, 20, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
    }

    public String getTitle() {
        return in_copy_settings;
    }

    public void setOptionsBasedOnControls() {
    }

    public void applyOptionValuesToControls() {
    }

    public void registerAffectedPanel(PCGenPrefsPanel pCGenPrefsPanel) {
        this.affectedPanels.add(pCGenPrefsPanel);
    }

    private final class CopyButtonListener
    implements ActionListener {
        private CopyButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GameMode gameMode = (GameMode)CopySettingsPanel.this.gameModeSelect.getSelectedItem();
            GameMode gameMode2 = SettingsHandler.getGame();
            gameMode2.setAllStatsValue(gameMode.getAllStatsValue());
            gameMode2.setRollMethodExpressionByName(gameMode.getRollMethodExpressionName());
            if (gameMode2.getPurchaseMethodByName(gameMode.getPurchaseModeMethodName()) != null) {
                gameMode2.setPurchaseMethodName(gameMode.getPurchaseModeMethodName());
            }
            gameMode2.setRollMethod(gameMode.getRollMethod());
            gameMode2.selectUnitSet(gameMode.getUnitSet().getName());
            if (gameMode2.getAvailXpTableNames().contains(gameMode.getXpTableName())) {
                gameMode2.setXpTableName(gameMode.getXpTableName());
            }
            String string = SettingsHandler.getPCGenOption("InfoCharacterSheet." + gameMode2.getName() + ".CurrentSheet", "");
            String string2 = SettingsHandler.getPCGenOption("InfoCharacterSheet." + gameMode.getName() + ".CurrentSheet", string);
            SettingsHandler.setPCGenOption("InfoCharacterSheet." + gameMode2.getName() + ".CurrentSheet", string2);
            for (PCGenPrefsPanel pCGenPrefsPanel : CopySettingsPanel.this.affectedPanels) {
                pCGenPrefsPanel.applyOptionValuesToControls();
            }
            CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
            if (characterInfo != null) {
                characterInfo.setPaneForUpdate(characterInfo.infoSummary());
                characterInfo.setPaneForUpdate(characterInfo.infoCharacterSheet());
                characterInfo.setRefresh(true);
                characterInfo.refresh();
            }
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_Prefs_copyDone"), PropertyFactory.getString("in_Prefs_pcgen"), MessageType.INFORMATION);
        }
    }
}

