/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class SubschoolFilter
extends AbstractPObjectFilter {
    private String school;

    SubschoolFilter(String string) {
        this.school = SubschoolFilter.normalizeSubschool(string);
        this.setCategory(PropertyFactory.getString("in_subschool"));
        this.setName(this.school);
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Spell) {
            return SubschoolFilter.normalizeSubschool(((Spell)pObject).getSubschool()).equals(this.school);
        }
        return true;
    }

    private static String normalizeSubschool(String string) {
        String string2 = string.trim().toUpperCase();
        if ("NO".equals(string2) || "NONE".equals(string2)) {
            return "None";
        }
        return string.trim();
    }
}

