/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class PCSizeFilter
extends AbstractPObjectFilter {
    PCSizeFilter() {
        super(PropertyFactory.getString("in_size"), PropertyFactory.getString("PC"));
    }

    public String getName(PlayerCharacter playerCharacter) {
        String string = super.getName(playerCharacter);
        if (playerCharacter != null) {
            string = string + " (";
            SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(playerCharacter.sizeInt());
            if (sizeAdjustment != null) {
                string = string + sizeAdjustment.getDisplayName();
            }
            string = string + ')';
        }
        return string;
    }

    public boolean accept(PlayerCharacter playerCharacter, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Equipment) {
            return ((Equipment)pObject).getSafe(ObjectKey.SIZE).equals(SettingsHandler.getGame().getSizeAdjustmentAtIndex(playerCharacter.sizeInt()));
        }
        return true;
    }
}

