/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

final class SourceFilesPanel
extends JPanel {
    static final long serialVersionUID = 2833296242093657468L;
    private Campaign theCampaign = null;
    private JComboBoxEx fileType;
    private JScrollPane scrollPane;
    private JTableEx fileTable;
    private SourceFileModel fileModel;

    public SourceFilesPanel() {
        this.initComponents();
        this.intComponentContents();
    }

    public void updateData(PObject pObject) {
        List<String> list = this.fileModel.getFileList();
        List<String> list2 = this.fileModel.getLocationList();
        Iterator<String> iterator = list2.iterator();
        this.theCampaign.removeListFor(ListKey.FILE_ABILITY_CATEGORY);
        this.theCampaign.removeListFor(ListKey.FILE_ABILITY);
        this.theCampaign.removeListFor(ListKey.FILE_ARMOR_PROF);
        this.theCampaign.removeListFor(ListKey.FILE_BIO_SET);
        this.theCampaign.removeListFor(ListKey.FILE_CLASS);
        this.theCampaign.removeListFor(ListKey.FILE_COMPANION_MOD);
        this.theCampaign.removeListFor(ListKey.FILE_COVER);
        this.theCampaign.removeListFor(ListKey.FILE_DEITY);
        this.theCampaign.removeListFor(ListKey.FILE_DOMAIN);
        this.theCampaign.removeListFor(ListKey.FILE_EQUIP);
        this.theCampaign.removeListFor(ListKey.FILE_EQUIP_MOD);
        this.theCampaign.removeListFor(ListKey.FILE_FEAT);
        this.theCampaign.removeListFor(ListKey.FILE_KIT);
        this.theCampaign.removeListFor(ListKey.FILE_LANGUAGE);
        this.theCampaign.removeListFor(ListKey.FILE_LOGO);
        this.theCampaign.removeListFor(ListKey.FILE_LST_EXCLUDE);
        this.theCampaign.removeListFor(ListKey.FILE_RACE);
        this.theCampaign.removeListFor(ListKey.FILE_SHIELD_PROF);
        this.theCampaign.removeListFor(ListKey.FILE_SPELL);
        this.theCampaign.removeListFor(ListKey.FILE_SPELL);
        this.theCampaign.removeListFor(ListKey.FILE_TEMPLATE);
        this.theCampaign.removeListFor(ListKey.FILE_WEAPON_PROF);
        this.theCampaign.removeListFor(ListKey.COMMENT);
        LoadContext loadContext = Globals.getContext();
        for (String string : list) {
            String string2 = iterator.next();
            if (string.equals("COMMENT")) {
                this.theCampaign.addToListFor(ListKey.COMMENT, string2);
                continue;
            }
            loadContext.unconditionallyProcess(this.theCampaign, string, string2);
        }
    }

    public void updateView(PObject pObject) {
        if (!(pObject instanceof Campaign)) {
            return;
        }
        this.theCampaign = (Campaign)pObject;
        Collection<String> collection = Globals.getContext().unparse(this.theCampaign);
        if (collection != null) {
            for (String string : collection) {
                if (string.startsWith("#")) {
                    this.fileModel.addFileAndLocation("COMMENT", string.substring(1));
                    continue;
                }
                String string2 = string.substring(0, string.indexOf(":"));
                this.fileModel.addFileAndLocation(string2, string.substring(string2.length() + 1));
            }
        }
        this.fileTable.updateUI();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.fileTable = new JTableEx();
        this.fileModel = new SourceFileModel();
        this.fileType = new JComboBoxEx();
        this.fileType.addItem("BIOSET");
        this.fileType.addItem("CLASS");
        this.fileType.addItem("COMPANIONMOD");
        this.fileType.addItem("COMMENT");
        this.fileType.addItem("DEITY");
        this.fileType.addItem("DOMAIN");
        this.fileType.addItem("EQUIPMENT");
        this.fileType.addItem("EQUIPMOD");
        this.fileType.addItem("FEAT");
        this.fileType.addItem("LANGUAGE");
        this.fileType.addItem("LSTEXCLUDE");
        this.fileType.addItem("KIT");
        this.fileType.addItem("PCC");
        this.fileType.addItem("RACE");
        this.fileType.addItem("REGION");
        this.fileType.addItem("SKILL");
        this.fileType.addItem("SPELL");
        this.fileType.addItem("TEMPLATE");
        this.fileType.addItem("WEAPONPROF");
        this.fileType.setSelectedIndex(0);
        JPanel jPanel = new JPanel();
        jPanel.add(this.fileType);
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                String string = "";
                String string2 = null;
                if (SourceFilesPanel.this.theCampaign != null) {
                    string2 = SourceFilesPanel.this.theCampaign.getSafe(StringKey.DESTINATION);
                }
                if ((string2 == null || string2.equals("")) && (serializable = SourceFilesPanel.this.theCampaign.getSourceURI()) != null) {
                    string2 = ((URI)serializable).getPath();
                }
                if (string2 == null || string2.equals("")) {
                    string2 = SettingsHandler.getPccFilesLocation().toString();
                }
                if (!SourceFilesPanel.this.fileType.getSelectedItem().toString().equals("COMMENT")) {
                    serializable = new JFileChooser();
                    File file = ((JFileChooser)serializable).getCurrentDirectory();
                    ((JFileChooser)serializable).setDialogTitle("" + file.getAbsolutePath());
                    ((Container)serializable).addPropertyChangeListener(new PropertyChangeListener((JFileChooser)serializable){
                        final /* synthetic */ JFileChooser val$fc;
                        {
                            this.val$fc = jFileChooser;
                        }

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if ("directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
                                File file = this.val$fc.getCurrentDirectory();
                                this.val$fc.setDialogTitle("" + file.getAbsolutePath());
                            }
                        }
                    });
                    ((JFileChooser)serializable).setCurrentDirectory(new File(string2));
                    int n = ((JFileChooser)serializable).showOpenDialog(SourceFilesPanel.this);
                    if (n == 0) {
                        string = ((JFileChooser)serializable).getSelectedFile().toString();
                        if (string.startsWith(SettingsHandler.getPccFilesLocation().toString())) {
                            string = string.substring(SettingsHandler.getPccFilesLocation().toString().length() + 1);
                        } else if (string.startsWith(SourceFilesPanel.this.theCampaign.getSourceURI().toString())) {
                            string = string.substring(SourceFilesPanel.this.theCampaign.getSourceURI().toString().length() + 1);
                        }
                        if (string.indexOf(92) >= 0) {
                            string = "@".concat(string);
                        }
                    }
                }
                SourceFilesPanel.this.fileModel.addFileAndLocation(SourceFilesPanel.this.fileType.getSelectedItem().toString(), string);
                SourceFilesPanel.this.fileTable.updateUI();
            }
        });
        jPanel.add(jButton);
        jButton = new JButton("Remove");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SourceFilesPanel.this.fileTable.getSelectedRow();
                SourceFilesPanel.this.fileModel.removeItemsAtIndex(n);
                SourceFilesPanel.this.fileTable.updateUI();
            }
        });
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
        this.fileTable.setModel(this.fileModel);
        this.fileTable.setSelectionMode(0);
        this.fileTable.setDoubleBuffered(false);
        this.scrollPane.setViewportView(this.fileTable);
        this.add((Component)this.scrollPane, "Center");
    }

    private void intComponentContents() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SourceFileModel
    extends AbstractTableModel {
        List<String> fileList = new ArrayList<String>();
        List<String> locationList = new ArrayList<String>();

        SourceFileModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Class<String> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public List<String> getFileList() {
            return this.fileList;
        }

        public List<String> getLocationList() {
            return this.locationList;
        }

        @Override
        public int getRowCount() {
            return this.fileList.size();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1 && n < this.locationList.size()) {
                String string = (String)object;
                this.locationList.set(n, string);
            }
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "File Type";
                }
                case 1: {
                    return "File Name/Location";
                }
            }
            return "Out Of Bounds";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            switch (n2) {
                case 0: {
                    if (n < this.fileList.size()) {
                        string = this.fileList.get(n);
                        break;
                    }
                    string = "";
                    break;
                }
                case 1: {
                    if (n < this.locationList.size()) {
                        string = this.locationList.get(n);
                        break;
                    }
                    string = "";
                    break;
                }
                default: {
                    Logging.errorPrint("Unhandled column " + n2 + " at SourceFilesPanel.getValueAt");
                }
            }
            return string;
        }

        public void addFileAndLocation(String string, String string2) {
            int n = SourceFilesPanel.this.fileTable.getSelectedRow();
            if (this.fileList.size() == 0) {
                n = 0;
            } else if (n < 0) {
                n = this.fileList.size() - 1;
            }
            this.fileList.add(n, string);
            this.locationList.add(n, string2);
        }

        public void removeItemsAtIndex(int n) {
            if (n >= 0 && n < this.fileList.size()) {
                this.fileList.remove(n);
                this.locationList.remove(n);
            }
        }
    }
}

