/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillArmorCheck;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SkillBasePanel
extends BasePanel {
    private static final String[] acheckValues = new String[]{"No", "Yes", "Non-proficiency", "Weight"};
    private JCheckBox chkExclusive;
    private JCheckBox chkUntrained;
    private JComboBoxEx cmbArmorCheck;
    private JComboBoxEx cmbKeyStat;
    private JLabel lblArmorCheck;
    private JLabel lblKeyStat;
    private JPanel pnlSkillMisc;
    private TypePanel pnlSkillType;

    public SkillBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setArmorCheck(int n) {
        if (n >= 0 && n < acheckValues.length) {
            this.cmbArmorCheck.setSelectedItem(acheckValues[n]);
        }
    }

    public int getArmorCheck() {
        return this.cmbArmorCheck.getSelectedIndex();
    }

    public void setIsExclusive(boolean bl) {
        this.chkExclusive.setSelected(bl);
    }

    public boolean getIsExclusive() {
        return this.chkExclusive.isSelected();
    }

    public void setIsUntrained(boolean bl) {
        this.chkUntrained.setSelected(bl);
    }

    public boolean getIsUntrained() {
        return this.chkUntrained.isSelected();
    }

    public void setKeyStat(String string) {
        if (string.length() == 0) {
            this.cmbKeyStat.setSelectedItem("None");
        } else {
            for (int i = SettingsHandler.getGame().getUnmodifiableStatList().size() - 1; i >= 0; --i) {
                PCStat pCStat = SettingsHandler.getGame().getUnmodifiableStatList().get(i);
                if (!pCStat.getAbb().equals(string)) continue;
                this.cmbKeyStat.setSelectedItem(pCStat.getKeyName());
                break;
            }
        }
    }

    public PCStat getKeyStat() {
        int n = this.cmbKeyStat.getSelectedIndex() - 1;
        if (n < 0) {
            return null;
        }
        return SettingsHandler.getGame().getUnmodifiableStatList().get(n);
    }

    public void setTypesAvailableList(List<Type> list, boolean bl) {
        this.pnlSkillType.setAvailableList(list, bl);
    }

    public void setTypesSelectedList(List<Type> list, boolean bl) {
        this.pnlSkillType.setSelectedList(list, bl);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlSkillType.getSelectedList();
    }

    @Override
    public void updateData(PObject pObject) {
        pObject.removeListFor(ListKey.TYPE);
        for (Object object : this.getTypesSelectedList()) {
            pObject.addToListFor(ListKey.TYPE, Type.getConstant(object.toString()));
        }
        pObject.put(ObjectKey.USE_UNTRAINED, this.getIsUntrained());
        pObject.put(ObjectKey.EXCLUSIVE, this.getIsExclusive());
        pObject.put(ObjectKey.KEY_STAT, this.getKeyStat());
        pObject.put(ObjectKey.ARMOR_CHECK, SkillArmorCheck.values()[this.getArmorCheck()]);
    }

    @Override
    public void updateView(PObject pObject) {
        Skill skill = (Skill)pObject;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        ArrayList<Type> arrayList2 = new ArrayList<Type>();
        for (Skill comparable : Globals.getContext().ref.getConstructedCDOMObjects(Skill.class)) {
            for (Type type : comparable.getTrueTypeList(false)) {
                if (type.equals(Type.CUSTOM) || arrayList.contains(type)) continue;
                arrayList.add(type);
            }
        }
        for (Type type : skill.getTrueTypeList(false)) {
            if (type.equals(Type.CUSTOM)) continue;
            arrayList2.add(type);
            arrayList.remove(type);
        }
        this.setTypesAvailableList(arrayList, true);
        this.setTypesSelectedList(arrayList2, true);
        this.setKeyStat(skill.getKeyStatAbb());
        this.setArmorCheck(skill.getSafe(ObjectKey.ARMOR_CHECK).ordinal());
        this.setIsExclusive(skill.getSafe(ObjectKey.EXCLUSIVE));
        Boolean bl = skill.get(ObjectKey.USE_UNTRAINED);
        if (bl != null) {
            this.setIsUntrained(bl);
        }
    }

    private void initComponentContents() {
        ArrayList<String> arrayList = new ArrayList<String>(SettingsHandler.getGame().getUnmodifiableStatList().size() + 1);
        arrayList.add("None");
        for (PCStat pCStat : SettingsHandler.getGame().getUnmodifiableStatList()) {
            arrayList.add(pCStat.getKeyName());
        }
        this.cmbKeyStat.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.cmbArmorCheck.setModel(new DefaultComboBoxModel<String>(acheckValues));
    }

    private void initComponents() {
        this.pnlSkillMisc = new JPanel();
        this.lblKeyStat = new JLabel();
        this.cmbKeyStat = new JComboBoxEx();
        this.lblArmorCheck = new JLabel();
        this.cmbArmorCheck = new JComboBoxEx();
        this.chkUntrained = new JCheckBox();
        this.chkExclusive = new JCheckBox();
        this.pnlSkillType = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        this.pnlSkillMisc.setLayout(new GridBagLayout());
        this.lblKeyStat.setText("Key Stat");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlSkillMisc.add((Component)this.lblKeyStat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlSkillMisc.add((Component)this.cmbKeyStat, gridBagConstraints);
        this.lblArmorCheck.setText("Armor Check");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlSkillMisc.add((Component)this.lblArmorCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlSkillMisc.add((Component)this.cmbArmorCheck, gridBagConstraints);
        this.chkUntrained.setText("Use Untrained");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlSkillMisc.add((Component)this.chkUntrained, gridBagConstraints);
        this.chkExclusive.setText("Exclusive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlSkillMisc.add((Component)this.chkExclusive, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlSkillMisc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSkillType, gridBagConstraints);
    }
}

