/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.gui.converter.event.TaskStrategyMessage;
import pcgen.gui.converter.panel.ConvertSubPanel;

public class WriteDirectoryPanel
extends ConvertSubPanel {
    private File path = null;
    private SpringLayout layout = new SpringLayout();
    private final JLabel fileLabel = new JLabel();

    public String getPath() {
        return this.path.getAbsolutePath();
    }

    public boolean performAnalysis(CDOMObject cDOMObject) {
        TaskStrategyMessage.sendStatus(this, "Finding Data Directories");
        this.path = cDOMObject.get(ObjectKey.WRITE_DIRECTORY);
        if (this.path != null) {
            this.fileLabel.setText(this.path.getAbsolutePath());
        } else {
            this.path = new File(".");
        }
        cDOMObject.put(ObjectKey.WRITE_DIRECTORY, this.path);
        this.fireProgressEvent(0);
        return true;
    }

    public boolean autoAdvance(CDOMObject cDOMObject) {
        return false;
    }

    public boolean returnAllowed() {
        return true;
    }

    public void setupDisplay(JPanel jPanel, final CDOMObject cDOMObject) {
        jPanel.setLayout(this.layout);
        JLabel jLabel = new JLabel("Please select the Directory where Converted files should be written: ");
        JButton jButton = new JButton("Browse...");
        jButton.setMnemonic('r');
        jButton.addActionListener(new ActionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setDialogType(0);
                jFileChooser.setSelectedFile(WriteDirectoryPanel.this.path);
                while (true) {
                    int n;
                    if ((n = jFileChooser.showOpenDialog(null)) == 0) {
                        File file = jFileChooser.getSelectedFile();
                        if (file.isDirectory() && file.canRead() && file.canWrite()) {
                            WriteDirectoryPanel.this.path = file;
                            cDOMObject.put(ObjectKey.WRITE_DIRECTORY, WriteDirectoryPanel.this.path);
                            WriteDirectoryPanel.this.fileLabel.setText(WriteDirectoryPanel.this.path.getAbsolutePath());
                            return;
                        }
                        JOptionPane.showMessageDialog(null, "Selection must be a valid (readable & writeable) Directory");
                        jFileChooser.setSelectedFile(WriteDirectoryPanel.this.path);
                        continue;
                    }
                    if (n == 1) return;
                }
            }
        });
        jPanel.add(jLabel);
        jPanel.add(this.fileLabel);
        jPanel.add(jButton);
        this.layout.putConstraint("North", (Component)jLabel, 50, "North", (Component)jPanel);
        this.layout.putConstraint("North", (Component)this.fileLabel, 75 + jLabel.getPreferredSize().height, "North", (Component)jPanel);
        this.layout.putConstraint("North", (Component)jButton, 75 + jLabel.getPreferredSize().height, "North", (Component)jPanel);
        this.layout.putConstraint("West", (Component)jLabel, 25, "West", (Component)jPanel);
        this.layout.putConstraint("West", (Component)this.fileLabel, 25, "West", (Component)jPanel);
        this.layout.putConstraint("East", (Component)jButton, -50, "East", (Component)jPanel);
        this.fileLabel.setText(this.path.getAbsolutePath());
    }
}

