/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.gui.converter.panel.ConvertSubPanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstSystemLoader;

public class GameModePanel
extends ConvertSubPanel {
    JComboBoxEx gameModeCombo;
    private SpringLayout layout = new SpringLayout();
    private final LstSystemLoader loader;

    public GameModePanel(LstSystemLoader lstSystemLoader) {
        this.loader = lstSystemLoader;
    }

    public boolean autoAdvance(CDOMObject cDOMObject) {
        return false;
    }

    public boolean returnAllowed() {
        return true;
    }

    public boolean performAnalysis(CDOMObject cDOMObject) {
        this.loader.loadPCCFilesInDirectory(cDOMObject.get(ObjectKey.DIRECTORY));
        try {
            this.loader.initRecursivePccFiles();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            persistenceLayerException.printStackTrace();
            return false;
        }
        Globals.sortPObjectListByName(Globals.getCampaignList());
        Globals.createEmptyRace();
        SettingsHandler.initGameModes();
        return this.saveGameMode(cDOMObject);
    }

    private boolean saveGameMode(CDOMObject cDOMObject) {
        boolean bl;
        boolean bl2 = bl = cDOMObject.get(ObjectKey.GAME_MODE) != null;
        if (bl) {
            this.fireProgressEvent(0);
        } else {
            this.fireProgressEvent(1);
        }
        return bl;
    }

    private void getSelection(CDOMObject cDOMObject) {
        cDOMObject.put(ObjectKey.GAME_MODE, (GameMode)this.gameModeCombo.getSelectedItem());
    }

    public void setupDisplay(JPanel jPanel, final CDOMObject cDOMObject) {
        jPanel.setLayout(this.layout);
        JLabel jLabel = new JLabel("Please select the Game Mode to Convert:");
        jPanel.add(jLabel);
        this.layout.putConstraint("North", (Component)jLabel, 50, "North", (Component)jPanel);
        this.layout.putConstraint("West", (Component)jLabel, 25, "West", (Component)jPanel);
        List<GameMode> list = SystemCollections.getUnmodifiableGameModeList();
        this.gameModeCombo = new JComboBoxEx(list.toArray());
        this.gameModeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameModePanel.this.getSelection(cDOMObject);
                GameModePanel.this.saveGameMode(cDOMObject);
            }
        });
        this.gameModeCombo.setSelectedItem(SettingsHandler.getGame().getDisplayName());
        this.getSelection(cDOMObject);
        this.saveGameMode(cDOMObject);
        jPanel.add(this.gameModeCombo);
        this.layout.putConstraint("North", (Component)this.gameModeCombo, 20, "South", (Component)jLabel);
        this.layout.putConstraint("West", (Component)this.gameModeCombo, 25, "West", (Component)jPanel);
    }
}

