/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter.loader;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Campaign;
import pcgen.core.PCClass;
import pcgen.core.SubClass;
import pcgen.core.SubstitutionClass;
import pcgen.gui.converter.ConversionDecider;
import pcgen.gui.converter.Loader;
import pcgen.gui.converter.TokenConverter;
import pcgen.gui.converter.event.TokenProcessEvent;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.EditorLoadContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoader
implements Loader {
    public static final String FIELD_SEPARATOR = "\t";
    private final EditorLoadContext context;

    public ClassLoader(EditorLoadContext editorLoadContext) {
        this.context = editorLoadContext;
    }

    @Override
    public List<CDOMObject> process(StringBuilder stringBuilder, int n, String string, ConversionDecider conversionDecider) throws PersistenceLayerException, InterruptedException {
        Class clazz;
        String[] stringArray = string.split(FIELD_SEPARATOR);
        String string2 = stringArray[0];
        stringBuilder.append(string2);
        Class clazz2 = null;
        if (string2.startsWith("SUBCLASS:")) {
            clazz = SubClass.class;
        } else if (string2.startsWith("SUBCLASSLEVEL:")) {
            clazz = PCClassLevel.class;
            clazz2 = SubClass.class;
        } else if (string2.startsWith("SUBSTITUTIONCLASS:")) {
            clazz = SubstitutionClass.class;
        } else if (string2.startsWith("SUBSTITUTIONLEVEL:")) {
            clazz = PCClassLevel.class;
            clazz2 = SubstitutionClass.class;
        } else if (string2.startsWith("CLASS:")) {
            clazz = PCClass.class;
        } else {
            clazz = PCClassLevel.class;
            clazz2 = PCClass.class;
        }
        ArrayList<CDOMObject> arrayList = new ArrayList<CDOMObject>();
        for (int i = 1; i < stringArray.length; ++i) {
            List<CDOMObject> list;
            String string3 = stringArray[i];
            stringBuilder.append(FIELD_SEPARATOR);
            if (string3.length() == 0) continue;
            SubClass subClass = this.context.ref.constructCDOMObject(clazz, n + "Test" + i);
            SubClass subClass2 = null;
            if (subClass instanceof PCClassLevel) {
                subClass.put(IntegerKey.LEVEL, 1);
                subClass2 = this.context.ref.constructCDOMObject(clazz2, n + "Test" + i);
                subClass.put(ObjectKey.PARENT, subClass2);
                subClass.put(ObjectKey.TOKEN_PARENT, subClass2);
            }
            if ((list = this.processToken(stringBuilder, subClass, subClass2, string3, conversionDecider)) != null) {
                arrayList.addAll(list);
            }
            this.context.purge(subClass);
            if (subClass2 != null) {
                this.context.purge(subClass2);
            }
            TokenConverter.clearConstants();
        }
        return arrayList;
    }

    private List<CDOMObject> processToken(StringBuilder stringBuilder, CDOMObject cDOMObject, CDOMObject cDOMObject2, String string, ConversionDecider conversionDecider) throws PersistenceLayerException, InterruptedException {
        int n = string.indexOf(58);
        if (n == -1) {
            Logging.errorPrint("Invalid Token - does not contain a colon: " + string);
            return null;
        }
        if (n == 0) {
            Logging.errorPrint("Invalid Token - starts with a colon: " + string);
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = n == string.length() - 1 ? null : string.substring(n + 1);
        TokenProcessEvent tokenProcessEvent = new TokenProcessEvent(this.context, conversionDecider, string2, string3, cDOMObject);
        String string4 = TokenConverter.process(tokenProcessEvent);
        if (!tokenProcessEvent.isConsumed() && cDOMObject2 != null) {
            tokenProcessEvent = new TokenProcessEvent(this.context, conversionDecider, string2, string3, cDOMObject2);
            string4 = string4 + TokenConverter.process(tokenProcessEvent);
        }
        if (tokenProcessEvent.isConsumed()) {
            stringBuilder.append(tokenProcessEvent.getResult());
        } else {
            Logging.errorPrint(string4);
        }
        return tokenProcessEvent.getInjected();
    }

    @Override
    public List<CampaignSourceEntry> getFiles(Campaign campaign) {
        return campaign.getSafeListFor(ListKey.FILE_CLASS);
    }

    public String getLoadName() {
        return "Class";
    }
}

