/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter;

import java.util.Collection;
import pcgen.cdom.base.CDOMObject;
import pcgen.gui.converter.event.TokenProcessEvent;
import pcgen.gui.converter.event.TokenProcessor;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.EditorLoadContext;
import pcgen.util.Logging;

public class DefaultTokenProcessor
implements TokenProcessor {
    public String process(TokenProcessEvent tokenProcessEvent) {
        try {
            EditorLoadContext editorLoadContext = tokenProcessEvent.getContext();
            CDOMObject cDOMObject = tokenProcessEvent.getPrimary();
            if (editorLoadContext.processToken(cDOMObject, tokenProcessEvent.getKey(), tokenProcessEvent.getValue())) {
                editorLoadContext.commit();
            } else {
                editorLoadContext.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
            Collection<String> collection = editorLoadContext.unparse(cDOMObject);
            if (collection == null || collection.isEmpty()) {
                return "Unable to unparse: " + tokenProcessEvent.getKey() + ":" + tokenProcessEvent.getValue();
            }
            boolean bl = false;
            for (String string : collection) {
                if (bl) {
                    tokenProcessEvent.append('\t');
                }
                bl = true;
                tokenProcessEvent.append(string);
            }
            tokenProcessEvent.consume();
        }
        catch (PersistenceLayerException persistenceLayerException) {
            persistenceLayerException.printStackTrace();
        }
        return null;
    }
}

