/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pcgen.gui.TableColumnManagerModel;

public class TableColumnManager
implements MouseListener {
    private JPopupMenu tablePopup;
    private List<JCheckBoxMenuItem> checkBoxList;
    private JTable table;
    private JComponent tableButton;
    private TableColumnManagerModel model;

    public TableColumnManager(JTable jTable, JComponent jComponent, TableColumnManagerModel tableColumnManagerModel) {
        this.table = jTable;
        this.tableButton = jComponent;
        this.model = tableColumnManagerModel;
        this.initContents();
    }

    private void initContents() {
        this.tablePopup = new JPopupMenu();
        this.checkBoxList = new ArrayList<JCheckBoxMenuItem>();
        this.tablePopup = new JPopupMenu();
        for (int i = 0; i < this.model.getMColumnList().size(); ++i) {
            String string = this.model.getMColumnList().get(i);
            boolean bl = this.model.isMColumnDisplayed(i + this.model.getMColumnOffset());
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            this.tablePopup.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem.setText(string);
            jCheckBoxMenuItem.setSelected(bl);
            jCheckBoxMenuItem.addActionListener(new PopupActionListener(jCheckBoxMenuItem, i + this.model.getMColumnOffset()));
            this.checkBoxList.add(jCheckBoxMenuItem);
        }
        this.tableButton.addMouseListener(this);
        this.TablePopupActionPerformed();
    }

    public void tableDisplay(MouseEvent mouseEvent) {
        this.tablePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void TablePopupActionPerformed() {
        Serializable serializable;
        int n;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n2 = this.table.convertColumnIndexToView(0);
        if (n2 < 0) {
            n2 = 0;
        }
        for (n = tableColumnModel.getColumnCount() - 1; n >= 0; --n) {
            if (n == n2) continue;
            serializable = tableColumnModel.getColumn(n);
            tableColumnModel.removeColumn((TableColumn)serializable);
        }
        for (n = 0; n < this.checkBoxList.size(); ++n) {
            serializable = this.checkBoxList.get(n);
            this.model.setMColumnDisplayed(n + this.model.getMColumnOffset(), ((AbstractButton)serializable).isSelected());
            if (!this.model.isMColumnDisplayed(n + this.model.getMColumnOffset())) continue;
            TableColumn tableColumn = new TableColumn(n + this.model.getMColumnOffset());
            tableColumn.setHeaderValue(((AbstractButton)serializable).getText());
            tableColumn.setWidth(this.model.getMColumnDefaultWidth(n + this.model.getMColumnOffset()));
            tableColumn.setPreferredWidth(this.model.getMColumnDefaultWidth(n + this.model.getMColumnOffset()));
            tableColumn.addPropertyChangeListener(new ColumnChangeListener(n + this.model.getMColumnOffset()));
            this.model.resetMColumn(n + this.model.getMColumnOffset(), tableColumn);
            tableColumnModel.addColumn(tableColumn);
        }
        for (n = 0; n < this.model.getMColumnOffset(); ++n) {
            serializable = tableColumnModel.getColumn(n);
            ((TableColumn)serializable).setWidth(this.model.getMColumnDefaultWidth(n));
            ((TableColumn)serializable).setPreferredWidth(this.model.getMColumnDefaultWidth(n));
            ((TableColumn)serializable).addPropertyChangeListener(new ColumnChangeListener(n));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.tableDisplay(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.tableDisplay(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.tableDisplay(mouseEvent);
    }

    private class ColumnChangeListener
    implements PropertyChangeListener {
        int col = 0;

        public ColumnChangeListener(int n) {
            this.col = n;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
            TableColumnManager.this.model.setMColumnDefaultWidth(this.col, tableColumn.getWidth());
        }
    }

    private class PopupActionListener
    implements ActionListener {
        JCheckBoxMenuItem popupCb;
        int colNo = 0;

        public PopupActionListener(JCheckBoxMenuItem jCheckBoxMenuItem, int n) {
            this.popupCb = jCheckBoxMenuItem;
            this.colNo = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableColumnManager.this.TablePopupActionPerformed();
        }
    }
}

